/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.variable.types;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ballerinalang.debugadapter.SuspendedContext;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.RuntimeInstanceMethod;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.RuntimeStaticMethod;
import org.ballerinalang.debugadapter.evaluation.utils.EvaluationUtils;
import org.ballerinalang.debugadapter.evaluation.utils.VMUtils;
import org.ballerinalang.debugadapter.variable.BVariableType;
import org.ballerinalang.debugadapter.variable.IndexedCompoundVariable;
import org.ballerinalang.debugadapter.variable.JVMValueType;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class BXmlSequence
extends IndexedCompoundVariable {
    private int childrenCount = -1;
    private static final String GET_CHILDREN_LIST_METHOD = "getChildrenList";
    private static final String GET_XML_CHILD_METHOD = "getXmlChildrenInRange";
    private static final String SIZE_METHOD = "size";

    public BXmlSequence(SuspendedContext context, String name, Value value) {
        super(context, name, BVariableType.XML, value);
    }

    @Override
    public String computeValue() {
        try {
            return String.format("XMLSequence (size = %d)", this.getChildrenCount());
        }
        catch (Exception ignored) {
            return "unknown";
        }
    }

    @Override
    public Either<Map<String, Value>, List<Value>> computeChildVariables(int start, int count) {
        List<Object> childValues = new ArrayList();
        try {
            ArrayList<String> argTypeNames = new ArrayList<String>();
            argTypeNames.add("io.ballerina.runtime.api.values.BXmlSequence");
            argTypeNames.add(JVMValueType.INT.getString());
            argTypeNames.add(JVMValueType.INT.getString());
            RuntimeStaticMethod getXmlChildrenInRange = EvaluationUtils.getRuntimeMethod(this.context, "org.ballerinalang.debugadapter.runtime.DebuggerRuntime", GET_XML_CHILD_METHOD, argTypeNames);
            ArrayList<Value> argValues = new ArrayList<Value>();
            argValues.add(this.jvmValue);
            argValues.add(VMUtils.make(this.context, start).getJdiValue());
            argValues.add(VMUtils.make(this.context, count).getJdiValue());
            getXmlChildrenInRange.setArgValues(argValues);
            Value childArray = getXmlChildrenInRange.invokeSafely();
            if (childArray instanceof ArrayReference) {
                ArrayReference arrayReference = (ArrayReference)childArray;
                childValues = arrayReference.getValues();
            }
            return Either.forRight(childValues);
        }
        catch (Exception e) {
            return Either.forRight(childValues);
        }
    }

    @Override
    public int getChildrenCount() {
        if (this.childrenCount < 0) {
            this.populateChildrenCount();
        }
        return this.childrenCount;
    }

    private void populateChildrenCount() {
        try {
            List<Method> methods = ((ObjectReference)this.jvmValue).referenceType().methodsByName(GET_CHILDREN_LIST_METHOD);
            RuntimeInstanceMethod getChildListMethod = new RuntimeInstanceMethod(this.context, this.jvmValue, methods.get(0));
            getChildListMethod.setArgValues(new ArrayList<Value>());
            Value childList = getChildListMethod.invokeSafely();
            methods = ((ObjectReference)childList).referenceType().methodsByName(SIZE_METHOD);
            RuntimeInstanceMethod getSizeMethod = new RuntimeInstanceMethod(this.context, childList, methods.get(0));
            getSizeMethod.setArgValues(new ArrayList<Value>());
            Value getSizeResult = getSizeMethod.invokeSafely();
            if (getSizeResult instanceof IntegerValue) {
                IntegerValue integerValue = (IntegerValue)getSizeResult;
                this.childrenCount = integerValue.intValue();
            } else if (getSizeResult instanceof LongValue) {
                LongValue longValue = (LongValue)getSizeResult;
                this.childrenCount = longValue.intValue();
            } else {
                this.childrenCount = 0;
            }
        }
        catch (Exception e) {
            this.childrenCount = 0;
        }
    }
}

