/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.jwt;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.crypto.nativeimpl.Decode;
import io.ballerina.stdlib.jwt.JwtConstants;
import io.ballerina.stdlib.jwt.ModuleUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.UUID;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class JwksClient {
    private JwksClient() {
    }

    public static Object getJwksResponse(BString url, BMap<BString, Object> clientConfig) {
        String httpVersion = JwksClient.getBStringValueIfPresent(clientConfig, JwtConstants.HTTP_VERSION).getValue();
        BMap<BString, ?> secureSocket = JwksClient.getBMapValueIfPresent(clientConfig, JwtConstants.SECURE_SOCKET);
        URI uri = JwksClient.buildUri(url.getValue(), secureSocket);
        HttpRequest request = JwksClient.buildHttpRequest(uri);
        if (secureSocket != null) {
            try {
                SSLContext sslContext = JwksClient.getSslContext(secureSocket);
                HttpClient client = JwksClient.buildHttpClient(httpVersion, sslContext);
                return JwksClient.callEndpoint(client, request);
            }
            catch (Exception e) {
                return JwksClient.createError("Failed to init SSL context. " + e.getMessage());
            }
        }
        HttpClient client = JwksClient.buildHttpClient(httpVersion);
        return JwksClient.callEndpoint(client, request);
    }

    private static URI buildUri(String url, BMap<BString, Object> secureSocket) {
        String[] urlParts = ((String)url).split("://", 2);
        if (urlParts.length == 1) {
            urlParts = secureSocket != null ? new String[]{"https", urlParts[0]} : new String[]{"http", urlParts[0]};
        } else if (urlParts[0].equals("http") && secureSocket != null) {
            System.err.println("warning: [ballerina/jwt] HTTPS is recommended but using HTTP");
        }
        urlParts[1] = urlParts[1].replaceAll("//", "/");
        url = urlParts[0] + "://" + urlParts[1];
        return URI.create((String)url);
    }

    private static SSLContext getSslContext(BMap<BString, ?> secureSocket) throws Exception {
        boolean disable = secureSocket.getBooleanValue(JwtConstants.DISABLE);
        if (disable) {
            return JwksClient.initSslContext();
        }
        BMap<BString, ?> key = JwksClient.getBMapValueIfPresent(secureSocket, JwtConstants.KEY);
        Object cert = secureSocket.get((Object)JwtConstants.CERT);
        if (cert == null) {
            throw new Exception("Need to configure 'crypto:TrustStore' or 'cert' with client SSL certificates file.");
        }
        if (cert instanceof BString) {
            if (key != null) {
                KeyManagerFactory kmf;
                if (key.containsKey((Object)JwtConstants.CERT_FILE)) {
                    BString certFile = (BString)key.get((Object)JwtConstants.CERT_FILE);
                    BString keyFile = (BString)key.get((Object)JwtConstants.KEY_FILE);
                    BString keyPassword = JwksClient.getBStringValueIfPresent(key, JwtConstants.KEY_PASSWORD);
                    kmf = JwksClient.getKeyManagerFactory(certFile, keyFile, keyPassword);
                } else {
                    kmf = JwksClient.getKeyManagerFactory(key);
                }
                TrustManagerFactory tmf = JwksClient.getTrustManagerFactory((BString)cert);
                return JwksClient.buildSslContext(kmf.getKeyManagers(), tmf.getTrustManagers());
            }
            TrustManagerFactory tmf = JwksClient.getTrustManagerFactory((BString)cert);
            return JwksClient.buildSslContext(null, tmf.getTrustManagers());
        }
        if (cert instanceof BMap) {
            BMap trustStore = (BMap)cert;
            if (key != null) {
                KeyManagerFactory kmf;
                if (key.containsKey((Object)JwtConstants.CERT_FILE)) {
                    BString certFile = (BString)key.get((Object)JwtConstants.CERT_FILE);
                    BString keyFile = (BString)key.get((Object)JwtConstants.KEY_FILE);
                    BString keyPassword = JwksClient.getBStringValueIfPresent(key, JwtConstants.KEY_PASSWORD);
                    kmf = JwksClient.getKeyManagerFactory(certFile, keyFile, keyPassword);
                } else {
                    kmf = JwksClient.getKeyManagerFactory(key);
                }
                TrustManagerFactory tmf = JwksClient.getTrustManagerFactory((BMap<BString, BString>)trustStore);
                return JwksClient.buildSslContext(kmf.getKeyManagers(), tmf.getTrustManagers());
            }
            TrustManagerFactory tmf = JwksClient.getTrustManagerFactory((BMap<BString, BString>)trustStore);
            return JwksClient.buildSslContext(null, tmf.getTrustManagers());
        }
        return null;
    }

    private static HttpClient.Version getHttpVersion(String httpVersion) {
        if ("HTTP_2".equals(httpVersion)) {
            return HttpClient.Version.HTTP_2;
        }
        return HttpClient.Version.HTTP_1_1;
    }

    private static SSLContext initSslContext() throws Exception {
        TrustManager[] trustManagers = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        return JwksClient.buildSslContext(null, trustManagers);
    }

    private static TrustManagerFactory getTrustManagerFactory(BString cert) throws Exception {
        Object publicKeyMap = Decode.decodeRsaPublicKeyFromCertFile((BString)cert);
        if (publicKeyMap instanceof BMap) {
            X509Certificate x509Certificate = (X509Certificate)((BMap)publicKeyMap).getNativeData("NATIVE_DATA_PUBLIC_KEY_CERTIFICATE");
            KeyStore ts = KeyStore.getInstance("PKCS12");
            ts.load(null, "".toCharArray());
            ts.setCertificateEntry(UUID.randomUUID().toString(), x509Certificate);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ts);
            return tmf;
        }
        throw new Exception("Failed to get the public key from Crypto API. " + ((BError)publicKeyMap).getErrorMessage().getValue());
    }

    private static TrustManagerFactory getTrustManagerFactory(BMap<BString, BString> trustStore) throws Exception {
        BString trustStorePath = trustStore.getStringValue(JwtConstants.PATH);
        BString trustStorePassword = trustStore.getStringValue(JwtConstants.PASSWORD);
        KeyStore ts = JwksClient.getKeyStore(trustStorePath, trustStorePassword);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        tmf.init(ts);
        return tmf;
    }

    private static KeyManagerFactory getKeyManagerFactory(BMap<BString, BString> keyStore) throws Exception {
        BString keyStorePath = keyStore.getStringValue(JwtConstants.PATH);
        BString keyStorePassword = keyStore.getStringValue(JwtConstants.PASSWORD);
        KeyStore ks = JwksClient.getKeyStore(keyStorePath, keyStorePassword);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(ks, keyStorePassword.getValue().toCharArray());
        return kmf;
    }

    private static KeyManagerFactory getKeyManagerFactory(BString certFile, BString keyFile, BString keyPassword) throws Exception {
        Object publicKey = Decode.decodeRsaPublicKeyFromCertFile((BString)certFile);
        if (publicKey instanceof BMap) {
            X509Certificate publicCert = (X509Certificate)((BMap)publicKey).getNativeData("NATIVE_DATA_PUBLIC_KEY_CERTIFICATE");
            Object privateKeyMap = Decode.decodeRsaPrivateKeyFromKeyFile((BString)keyFile, (Object)keyPassword);
            if (privateKeyMap instanceof BMap) {
                PrivateKey privateKey = (PrivateKey)((BMap)privateKeyMap).getNativeData("NATIVE_DATA_PRIVATE_KEY");
                KeyStore ks = KeyStore.getInstance("PKCS12");
                ks.load(null, "".toCharArray());
                ks.setKeyEntry(UUID.randomUUID().toString(), privateKey, "".toCharArray(), new X509Certificate[]{publicCert});
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(ks, "".toCharArray());
                return kmf;
            }
            throw new Exception("Failed to get the private key from Crypto API. " + ((BError)privateKeyMap).getErrorMessage().getValue());
        }
        throw new Exception("Failed to get the public key from Crypto API. " + ((BError)publicKey).getErrorMessage().getValue());
    }

    private static KeyStore getKeyStore(BString path, BString password) throws Exception {
        try (FileInputStream is = new FileInputStream(path.getValue());){
            char[] passphrase = password.getValue().toCharArray();
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(is, passphrase);
            KeyStore keyStore = ks;
            return keyStore;
        }
    }

    private static SSLContext buildSslContext(KeyManager[] keyManagers, TrustManager[] trustManagers) throws Exception {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, trustManagers, new SecureRandom());
        return sslContext;
    }

    private static HttpClient buildHttpClient(String httpVersion) {
        return HttpClient.newBuilder().version(JwksClient.getHttpVersion(httpVersion)).build();
    }

    private static HttpClient buildHttpClient(String httpVersion, SSLContext sslContext) {
        return HttpClient.newBuilder().version(JwksClient.getHttpVersion(httpVersion)).sslContext(sslContext).build();
    }

    private static HttpRequest buildHttpRequest(URI uri) {
        return HttpRequest.newBuilder().uri(uri).build();
    }

    private static Object callEndpoint(HttpClient client, HttpRequest request) {
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 200) {
                return StringUtils.fromString((String)response.body());
            }
            return JwksClient.createError("Failed to get a success response from the endpoint. Response code: '" + response.statusCode() + "'. Response body: '" + response.body() + "'");
        }
        catch (IOException | InterruptedException e) {
            return JwksClient.createError("Failed to send the request to the endpoint. " + e.getMessage());
        }
    }

    private static BMap<BString, ?> getBMapValueIfPresent(BMap<BString, ?> config, BString key) {
        return config.containsKey((Object)key) ? config.getMapValue(key) : null;
    }

    private static BString getBStringValueIfPresent(BMap<BString, ?> config, BString key) {
        return config.containsKey((Object)key) ? config.getStringValue(key) : null;
    }

    private static BError createError(String errMsg) {
        return ErrorCreator.createDistinctError((String)"Error", (Module)ModuleUtils.getModule(), (BString)StringUtils.fromString((String)errMsg));
    }
}

