/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.jwt;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.jwt.ModuleUtils;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class JwtUtils {
    private JwtUtils() {
    }

    public static BString encodeBase64Url(BArray input) {
        byte[] encodedValue = Base64.getUrlEncoder().withoutPadding().encode(input.getBytes());
        return StringUtils.fromString((String)new String(encodedValue, StandardCharsets.ISO_8859_1));
    }

    public static Object decodeBase64Url(BString input) {
        try {
            byte[] output = Base64.getUrlDecoder().decode(input.getValue());
            return ValueCreator.createArrayValue((byte[])output);
        }
        catch (IllegalArgumentException e) {
            return JwtUtils.createError("Input is not a valid Base64 URL encoded value. " + e.getMessage());
        }
    }

    public static BError createError(String errMsg) {
        return ErrorCreator.createDistinctError((String)"Error", (Module)ModuleUtils.getModule(), (BString)StringUtils.fromString((String)errMsg));
    }
}

