/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina;

import io.ballerina.UrlFinder;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Qualifiable;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.BinaryExpressionNode;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ForEachStatementNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.IfElseStatementNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.NamedWorkerDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.RemoteMethodCallActionNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.WaitActionNode;
import io.ballerina.compiler.syntax.tree.WhileStatementNode;
import io.ballerina.component.ActionInvocationNode;
import io.ballerina.component.EndPointNode;
import io.ballerina.component.ForStatementNode;
import io.ballerina.component.IfStatementNode;
import io.ballerina.component.ReturningActionInvocationNode;
import io.ballerina.component.ReturningIfStatementNode;
import io.ballerina.projects.Document;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.utils.ParserUtil;
import io.ballerina.utils.ReturnFinder;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.lsp4j.Range;

public class PerformanceAnalyzerNodeVisitor
extends NodeVisitor {
    static final String ENDPOINTS_KEY = "endpoints";
    static final String ACTION_INVOCATION_KEY = "actionInvocations";
    private static final long DEFAULT_LOOP_SIZE = 2L;
    private final HashMap<LineRange, Object> variableMap = new HashMap();
    private final HashMap<LineRange, String> referenceMap = new HashMap();
    private final HashMap<String, EndPointNode> endPointDeclarationMap = new HashMap();
    private final HashMap<String, io.ballerina.component.Node> workers = new HashMap();
    private final io.ballerina.component.Node startNode;
    private final SemanticModel model;
    private final String file;
    private final Range range;
    private io.ballerina.component.Node currentNode = this.startNode = new io.ballerina.component.Node();
    private io.ballerina.component.Node currentWorkerNode;
    private Document document;
    private boolean withinRange = false;
    private int uuid;
    private boolean withinWorker = false;
    private boolean addReturnNode = false;
    private boolean isWorkerExists = false;
    private boolean isWorkerWaiting = false;
    private boolean isWorkersHaveConnectorCalls = false;
    private boolean hasReturn = false;

    public PerformanceAnalyzerNodeVisitor(SemanticModel model, String file, Range range) {
        this.model = model;
        this.file = file;
        this.range = range;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public void visit(ModulePartNode modulePartNode) {
        modulePartNode.members().forEach(moduleMemberDeclarationNode -> moduleMemberDeclarationNode.accept((NodeVisitor)this));
    }

    public void visit(ModuleVariableDeclarationNode moduleVariableDeclarationNode) {
        SyntaxKind initializerKind;
        Optional symbol = this.model.symbol((Node)moduleVariableDeclarationNode);
        if (symbol.isEmpty() || moduleVariableDeclarationNode.initializer().isEmpty()) {
            return;
        }
        boolean clientObject = this.isClientObject((Symbol)symbol.get());
        if (clientObject) {
            this.resolveEndPoint((Symbol)symbol.get(), (ExpressionNode)moduleVariableDeclarationNode.initializer().get());
        }
        LineRange lineRange = moduleVariableDeclarationNode.typedBindingPattern().bindingPattern().location().lineRange();
        if (clientObject || this.isRecordObject((Symbol)symbol.get())) {
            Optional expressionNode = moduleVariableDeclarationNode.initializer();
            if (expressionNode.isPresent() && ((ExpressionNode)expressionNode.get()).kind() != SyntaxKind.SIMPLE_NAME_REFERENCE) {
                this.registerVariableRef(lineRange, moduleVariableDeclarationNode);
            }
        } else if (((Symbol)symbol.get()).kind() == SymbolKind.VARIABLE && ((ExpressionNode)moduleVariableDeclarationNode.initializer().get()).kind() == SyntaxKind.REMOTE_METHOD_CALL_ACTION) {
            this.registerVariableRef(lineRange, moduleVariableDeclarationNode);
        }
        if (moduleVariableDeclarationNode.typedBindingPattern().bindingPattern().kind() == SyntaxKind.CAPTURE_BINDING_PATTERN && ((initializerKind = ((ExpressionNode)moduleVariableDeclarationNode.initializer().get()).kind()) == SyntaxKind.NUMERIC_LITERAL || initializerKind == SyntaxKind.STRING_LITERAL)) {
            this.registerVariableRef(lineRange, moduleVariableDeclarationNode);
        }
        moduleVariableDeclarationNode.typedBindingPattern().accept((NodeVisitor)this);
        moduleVariableDeclarationNode.initializer().ifPresent(initializer -> initializer.accept((NodeVisitor)this));
    }

    public void visit(FunctionDefinitionNode functionDefinitionNode) {
        LineRange lineRange = functionDefinitionNode.lineRange();
        this.withinRange = functionDefinitionNode.syntaxTree().filePath().equals(this.file) && this.range.getStart().getLine() == lineRange.startLine().line() && this.range.getStart().getCharacter() == lineRange.startLine().offset() && this.range.getEnd().getLine() == lineRange.endLine().line() && this.range.getEnd().getCharacter() == lineRange.endLine().offset();
        functionDefinitionNode.functionBody().accept((NodeVisitor)this);
        this.withinRange = false;
    }

    public void visit(VariableDeclarationNode variableDeclarationNode) {
        SyntaxKind initializerKind;
        Optional symbol = this.model.symbol((Node)variableDeclarationNode);
        if (variableDeclarationNode.initializer().isEmpty() || symbol.isEmpty()) {
            return;
        }
        boolean clientObject = this.isClientObject((Symbol)symbol.get());
        if (clientObject) {
            this.resolveEndPoint((Symbol)symbol.get(), (ExpressionNode)variableDeclarationNode.initializer().get());
        }
        LineRange lineRange = variableDeclarationNode.typedBindingPattern().bindingPattern().location().lineRange();
        if (clientObject || this.isRecordObject((Symbol)symbol.get())) {
            Optional expressionNode = variableDeclarationNode.initializer();
            if (expressionNode.isPresent() && ((ExpressionNode)expressionNode.get()).kind() != SyntaxKind.SIMPLE_NAME_REFERENCE) {
                this.registerVariableRef(lineRange, variableDeclarationNode);
            }
        } else if (((Symbol)symbol.get()).kind() == SymbolKind.VARIABLE && ((ExpressionNode)variableDeclarationNode.initializer().get()).kind() == SyntaxKind.REMOTE_METHOD_CALL_ACTION) {
            this.registerVariableRef(lineRange, variableDeclarationNode);
        }
        if (variableDeclarationNode.typedBindingPattern().bindingPattern().kind() == SyntaxKind.CAPTURE_BINDING_PATTERN && ((initializerKind = ((ExpressionNode)variableDeclarationNode.initializer().get()).kind()) == SyntaxKind.NUMERIC_LITERAL || initializerKind == SyntaxKind.STRING_LITERAL)) {
            this.registerVariableRef(lineRange, variableDeclarationNode);
        }
        variableDeclarationNode.initializer().ifPresent(initializer -> initializer.accept((NodeVisitor)this));
    }

    /*
     * Unable to fully structure code
     */
    public void visit(IfElseStatementNode ifElseStatementNode) {
        this.addReturnNode = this.withinRange;
        ifStatementNode = new IfStatementNode();
        currentParentNode = this.currentNode;
        this.currentNode = ifBodyNode = new io.ballerina.component.Node();
        returnFinder = new ReturnFinder();
        ifElseStatementNode.ifBody().accept((NodeVisitor)returnFinder);
        this.hasReturn = returnFinder.isHasReturn() != false && this.withinRange != false;
        ifElseStatementNode.ifBody().accept((NodeVisitor)this);
        if (!returnFinder.isHasReturn()) {
            ifElseStatementNode.elseBody().ifPresent((Consumer<Node>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$visit$3(io.ballerina.utils.ReturnFinder io.ballerina.compiler.syntax.tree.Node ), (Lio/ballerina/compiler/syntax/tree/Node;)V)((ReturnFinder)returnFinder));
        }
        if (!((ifBodyNodeNextNode = ifBodyNode.getNextNode()) instanceof IfStatementNode)) ** GOTO lbl-1000
        ifBodyNextNode = (IfStatementNode)ifBodyNodeNextNode;
        if (returnFinder.isHasReturn() && returnFinder.isHasNestedIfElse() && this.withinRange) {
            returningIfStatementNode = new ReturningIfStatementNode(ifBodyNextNode.getIfBody(), ifBodyNextNode.getElseBody(), true);
            ifStatementNode.setIfBody(returningIfStatementNode);
        } else lbl-1000:
        // 2 sources

        {
            ifStatementNode.setIfBody(ifBodyNodeNextNode);
        }
        this.hasReturn = false;
        this.currentNode = elseBodyNode = new io.ballerina.component.Node();
        returnFinder.setHasReturn(false);
        returnFinder.setHasNestedIfElse(false);
        ifElseStatementNode.elseBody().ifPresent((Consumer<Node>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$visit$4(io.ballerina.utils.ReturnFinder io.ballerina.component.IfStatementNode io.ballerina.component.Node io.ballerina.compiler.syntax.tree.Node ), (Lio/ballerina/compiler/syntax/tree/Node;)V)((PerformanceAnalyzerNodeVisitor)this, (ReturnFinder)returnFinder, (IfStatementNode)ifStatementNode, (io.ballerina.component.Node)elseBodyNode));
        this.hasReturn = false;
        this.addReturnNode = false;
        this.currentNode = currentParentNode;
        if (ifStatementNode.getIfBody() != null || ifStatementNode.getElseBody() != null || ifStatementNode.getNextNode() != null) {
            this.setChildNode(ifStatementNode);
        }
    }

    public void visit(ForEachStatementNode forEachStatementNode) {
        io.ballerina.component.Node forBodyNode;
        Node node = forEachStatementNode.actionOrExpressionNode();
        long iterationsCount = 2L;
        if (node.kind() == SyntaxKind.BINARY_EXPRESSION) {
            BinaryExpressionNode binaryExpressionNode = (BinaryExpressionNode)node;
            Node rhsExpr = binaryExpressionNode.rhsExpr();
            Node lhsExpr = binaryExpressionNode.lhsExpr();
            if (rhsExpr.kind() == SyntaxKind.NUMERIC_LITERAL && lhsExpr.kind() == SyntaxKind.NUMERIC_LITERAL) {
                long rhsValue = Long.parseLong(rhsExpr.toSourceCode().trim());
                long lhsValue = Long.parseLong(lhsExpr.toSourceCode().trim());
                iterationsCount = rhsValue - lhsValue + (long)(binaryExpressionNode.operator().kind() == SyntaxKind.ELLIPSIS_TOKEN ? 1 : 0);
            }
        }
        ForStatementNode forStatementNode = new ForStatementNode(iterationsCount);
        io.ballerina.component.Node currentParentNode = this.currentNode;
        this.currentNode = forBodyNode = new io.ballerina.component.Node();
        forEachStatementNode.blockStatement().accept((NodeVisitor)this);
        forStatementNode.setForBody(forBodyNode.getNextNode());
        this.currentNode = currentParentNode;
        if (forEachStatementNode.blockStatement() != null && forBodyNode.hasNext()) {
            this.setChildNode(forStatementNode);
        }
    }

    public void visit(WhileStatementNode whileStatementNode) {
        io.ballerina.component.Node forBodyNode;
        ForStatementNode forStatementNode = new ForStatementNode(2L);
        io.ballerina.component.Node currentParentNode = this.currentNode;
        this.currentNode = forBodyNode = new io.ballerina.component.Node();
        whileStatementNode.whileBody().accept((NodeVisitor)this);
        forStatementNode.setForBody(forBodyNode.getNextNode());
        this.currentNode = currentParentNode;
        if (forStatementNode.getForBody() != null) {
            this.setChildNode(forStatementNode);
        }
    }

    public void visit(RemoteMethodCallActionNode remoteMethodCallActionNode) {
        this.resolveActionInvocation(remoteMethodCallActionNode);
        remoteMethodCallActionNode.expression().accept((NodeVisitor)this);
    }

    public void visit(AssignmentStatementNode assignmentStatementNode) {
        if (assignmentStatementNode.varRef().kind() == SyntaxKind.SIMPLE_NAME_REFERENCE && assignmentStatementNode.expression().kind() == SyntaxKind.SIMPLE_NAME_REFERENCE) {
            Optional referenceSymbol = this.model.symbol(assignmentStatementNode.varRef());
            Optional expressionSymbol = this.model.symbol((Node)assignmentStatementNode.expression());
            if (referenceSymbol.isEmpty() || expressionSymbol.isEmpty()) {
                return;
            }
        }
        assignmentStatementNode.varRef().accept((NodeVisitor)this);
        assignmentStatementNode.expression().accept((NodeVisitor)this);
    }

    public void visit(NamedWorkerDeclarationNode namedWorkerDeclarationNode) {
        if (this.withinRange) {
            this.withinWorker = true;
            if (!this.isWorkerExists) {
                boolean bl = this.isWorkerExists = namedWorkerDeclarationNode != null;
            }
            if (namedWorkerDeclarationNode != null) {
                io.ballerina.component.Node workerNode = this.currentWorkerNode = new io.ballerina.component.Node();
                namedWorkerDeclarationNode.workerBody().accept((NodeVisitor)this);
                ParserUtil.getReducedTree(workerNode);
                this.workers.put(namedWorkerDeclarationNode.workerName().text(), workerNode);
            }
            this.withinWorker = false;
        }
    }

    public void visit(WaitActionNode waitActionNode) {
        waitActionNode.waitFutureExpr().accept((NodeVisitor)this);
    }

    public void visit(SimpleNameReferenceNode simpleNameReferenceNode) {
        if (this.withinRange) {
            Optional waitNode = this.model.symbol((Node)simpleNameReferenceNode);
            if (waitNode.isEmpty() || ((Symbol)waitNode.get()).getLocation().isEmpty()) {
                return;
            }
            if (!this.isWorkerWaiting) {
                this.isWorkerWaiting = ((Symbol)waitNode.get()).kind() == SymbolKind.WORKER;
            }
        }
    }

    private void setChildNode(io.ballerina.component.Node node) {
        if (this.withinWorker) {
            this.currentWorkerNode.setNextNode(node);
            this.currentWorkerNode = node;
        } else {
            this.currentNode.setNextNode(node);
            this.currentNode = node;
        }
    }

    private void registerVariableRef(LineRange key, Object value) {
        this.variableMap.put(key, value);
    }

    private void resolveActionInvocation(RemoteMethodCallActionNode remoteMethodCallActionNode) {
        SeparatedNodeList arguments;
        FunctionArgumentNode functionArgumentNode;
        String actionName = remoteMethodCallActionNode.methodName().toString();
        String actionPath = null;
        if (!remoteMethodCallActionNode.arguments().isEmpty() && (functionArgumentNode = (FunctionArgumentNode)(arguments = remoteMethodCallActionNode.arguments()).get(0)).kind() == SyntaxKind.POSITIONAL_ARG) {
            Optional expressionSymbol;
            SyntaxKind parameterKind = ((PositionalArgumentNode)functionArgumentNode).expression().kind();
            if (parameterKind == SyntaxKind.STRING_LITERAL) {
                actionPath = ((FunctionArgumentNode)remoteMethodCallActionNode.arguments().get(0)).toString();
                if (actionPath.startsWith("\"") && actionPath.endsWith("\"")) {
                    actionPath = actionPath.substring(1, actionPath.length() - 1);
                }
            } else if (parameterKind == SyntaxKind.SIMPLE_NAME_REFERENCE && (expressionSymbol = this.model.symbol((Node)remoteMethodCallActionNode.expression())).isPresent()) {
                ExpressionNode token;
                Optional location = ((Symbol)expressionSymbol.get()).getLocation();
                if (location.isEmpty()) {
                    return;
                }
                LineRange lineRange = ((Location)location.get()).lineRange();
                VariableDeclarationNode variableDeclarationNode = (VariableDeclarationNode)this.variableMap.get(lineRange);
                if (variableDeclarationNode != null && variableDeclarationNode.initializer().isPresent() && (token = (ExpressionNode)variableDeclarationNode.initializer().get()).kind() == SyntaxKind.STRING_LITERAL) {
                    actionPath = ((BasicLiteralNode)token).literalToken().text();
                    actionPath = actionPath.substring(1, actionPath.length() - 1);
                }
            }
        }
        LineRange actionPos = remoteMethodCallActionNode.lineRange();
        LineRange actionExpRange = remoteMethodCallActionNode.expression().lineRange();
        LinePosition actionStartPos = actionExpRange.startLine();
        LinePosition actionEndPos = actionExpRange.endLine();
        LinePosition actionExpPos = LinePosition.from((int)actionStartPos.line(), (int)((actionStartPos.offset() + actionEndPos.offset()) / 2));
        Optional symbol = this.model.symbol(this.document, actionExpPos);
        if (symbol.isPresent()) {
            Optional location = ((Symbol)symbol.get()).getLocation();
            if (location.isEmpty()) {
                return;
            }
            LineRange lineRange = ((Location)location.get()).lineRange();
            if (this.withinRange) {
                ActionInvocationNode actionNode;
                if (this.withinWorker) {
                    this.isWorkersHaveConnectorCalls = true;
                }
                String pos = actionPos.fileName() + "/" + String.valueOf(actionPos);
                if (this.addReturnNode) {
                    actionNode = new ReturningActionInvocationNode(this.getUUID(lineRange), actionName, actionPath, pos, this.hasReturn);
                    this.addReturnNode = false;
                } else {
                    actionNode = new ActionInvocationNode(this.getUUID(lineRange), actionName, actionPath, pos);
                }
                this.setChildNode(actionNode);
            }
        }
    }

    private void resolveEndPoint(Symbol symbol, ExpressionNode expressionNode) {
        String url = null;
        if (expressionNode.kind() == SyntaxKind.IMPLICIT_NEW_EXPRESSION) {
            node = (ImplicitNewExpressionNode)expressionNode;
            if (node.parenthesizedArgList().isPresent() && !((ParenthesizedArgList)node.parenthesizedArgList().get()).arguments().isEmpty()) {
                SeparatedNodeList arguments = ((ParenthesizedArgList)node.parenthesizedArgList().get()).arguments();
                url = this.findBaseUrl((SeparatedNodeList<FunctionArgumentNode>)arguments);
            }
        } else if (expressionNode.kind() == SyntaxKind.EXPLICIT_NEW_EXPRESSION) {
            node = (ExplicitNewExpressionNode)expressionNode;
            if (!node.parenthesizedArgList().arguments().isEmpty()) {
                UrlFinder urlFinder = new UrlFinder();
                node.accept((NodeVisitor)urlFinder);
                url = this.extractURL(urlFinder.getToken());
            }
        } else {
            if (expressionNode.kind() == SyntaxKind.CHECK_EXPRESSION) {
                ExpressionNode expNode = ((CheckExpressionNode)expressionNode).expression();
                this.resolveEndPoint(symbol, expNode);
                return;
            }
            return;
        }
        TypeSymbol typeSymbol = this.getTypeDescriptor(((VariableSymbol)symbol).typeDescriptor());
        String signature = typeSymbol.signature();
        Optional typeSymbolModule = typeSymbol.getModule();
        if (typeSymbolModule.isEmpty() || symbol.getLocation().isEmpty()) {
            return;
        }
        LineRange lineRange = ((Location)symbol.getLocation().get()).lineRange();
        EndPointNode endpoint = new EndPointNode(((ModuleSymbol)typeSymbolModule.get()).id().orgName() + "/" + ((ModuleSymbol)typeSymbolModule.get()).id().moduleName(), signature.substring(signature.lastIndexOf(":") + 1), url, lineRange);
        this.endPointDeclarationMap.put(this.getUUID(lineRange), endpoint);
    }

    private String getUUID(LineRange lineRange) {
        if (this.referenceMap.containsKey(lineRange)) {
            return this.referenceMap.get(lineRange);
        }
        String uuid = String.valueOf(this.uuid++);
        this.referenceMap.put(lineRange, uuid);
        return uuid;
    }

    private String findBaseUrl(SeparatedNodeList<FunctionArgumentNode> arguments) {
        for (FunctionArgumentNode argumentNode : arguments) {
            UrlFinder urlFinder = new UrlFinder();
            argumentNode.accept((NodeVisitor)urlFinder);
            String url = urlFinder.getToken();
            if (url.isEmpty()) continue;
            if (argumentNode.kind() == SyntaxKind.POSITIONAL_ARG && ((PositionalArgumentNode)argumentNode).expression().kind() == SyntaxKind.STRING_LITERAL) {
                argumentNode.accept((NodeVisitor)this);
                return this.extractURL(url);
            }
            if (argumentNode.kind() != SyntaxKind.NAMED_ARG || ((NamedArgumentNode)argumentNode).expression().kind() != SyntaxKind.STRING_LITERAL) continue;
            argumentNode.accept((NodeVisitor)this);
            return this.extractURL(url);
        }
        return "";
    }

    private String extractURL(String arg) {
        if (arg.startsWith("\"") && arg.endsWith("\"")) {
            return arg.substring(1, arg.length() - 1);
        }
        return arg;
    }

    private boolean isClientObject(Symbol symbol) {
        if (symbol.kind() != SymbolKind.VARIABLE) {
            return false;
        }
        TypeSymbol typeSymbol = this.getTypeDescriptor(((VariableSymbol)symbol).typeDescriptor());
        return typeSymbol instanceof Qualifiable && ((Qualifiable)typeSymbol).qualifiers().contains(Qualifier.CLIENT);
    }

    private boolean isRecordObject(Symbol symbol) {
        if (symbol.kind() != SymbolKind.VARIABLE) {
            return false;
        }
        TypeSymbol typeSymbol = ((VariableSymbol)symbol).typeDescriptor();
        TypeDescKind kind = typeSymbol.typeKind();
        if (kind == null) {
            return false;
        }
        return this.getTypeKind(kind, typeSymbol) == TypeDescKind.RECORD;
    }

    private TypeDescKind getTypeKind(TypeDescKind kind, TypeSymbol typeSymbol) {
        if (kind == TypeDescKind.TYPE_REFERENCE) {
            return ((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor().typeKind();
        }
        return typeSymbol.typeKind();
    }

    private TypeSymbol getTypeDescriptor(TypeSymbol typeSymbol) {
        TypeDescKind kind = typeSymbol.typeKind();
        if (kind == null) {
            return typeSymbol;
        }
        if (kind == TypeDescKind.TYPE_REFERENCE) {
            return ((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor();
        }
        return typeSymbol;
    }

    public HashMap<String, Object> getActionInvocations() {
        ParserUtil.getReducedTree(this.startNode);
        HashMap<String, Object> invocationInfo = new HashMap<String, Object>();
        invocationInfo.put(ENDPOINTS_KEY, this.endPointDeclarationMap);
        invocationInfo.put(ACTION_INVOCATION_KEY, this.startNode);
        return invocationInfo;
    }

    public HashMap<String, Object> getWorkers() {
        this.workers.values().forEach(ParserUtil::getReducedTree);
        ParserUtil.getReducedTree(this.startNode);
        if (this.startNode.getNextNode() != null) {
            this.workers.put("mainWorker", this.startNode);
        }
        HashMap<String, Object> invocationInfo = new HashMap<String, Object>();
        invocationInfo.put(ENDPOINTS_KEY, this.endPointDeclarationMap);
        invocationInfo.put(ACTION_INVOCATION_KEY, this.workers);
        return invocationInfo;
    }

    public boolean canGivePrediction() {
        return !this.isWorkerExists || !this.isWorkerWaiting || !this.isWorkersHaveConnectorCalls;
    }

    private /* synthetic */ void lambda$visit$4(ReturnFinder returnFinder, IfStatementNode ifStatementNode, io.ballerina.component.Node elseBodyNode, Node elseBody) {
        elseBody.accept((NodeVisitor)returnFinder);
        this.hasReturn = returnFinder.isHasReturn();
        this.addReturnNode = this.withinRange;
        elseBody.accept((NodeVisitor)this);
        ifStatementNode.setElseBody(elseBodyNode.getNextNode());
    }

    private static /* synthetic */ void lambda$visit$3(ReturnFinder returnFinder, Node elseBody) {
        elseBody.accept((NodeVisitor)returnFinder);
    }
}

