/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ballerina.EndpointsFinder;
import io.ballerina.PerformanceAnalyzerGraphRequest;
import io.ballerina.PerformanceAnalyzerRequest;
import io.ballerina.PerformanceAnalyzerResponse;
import io.ballerina.Resource;
import io.ballerina.ResourceFinder;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.Document;
import io.ballerina.tools.text.LineRange;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.langserver.commons.service.spi.ExtendedLanguageServerService;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.services.JsonNotification;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;
import org.eclipse.lsp4j.services.LanguageServer;

@JsonSegment(value="performanceAnalyzer")
public class PerformanceAnalyzerService
implements ExtendedLanguageServerService {
    private WorkspaceManager workspaceManager;

    public Class<?> getRemoteInterface() {
        return this.getClass();
    }

    public void init(LanguageServer langServer, WorkspaceManager workspaceManager) {
        this.workspaceManager = workspaceManager;
    }

    @Deprecated
    @JsonNotification
    public CompletableFuture<JsonObject> getEndpoints(PerformanceAnalyzerGraphRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            String fileUri = request.getDocumentIdentifier().getUri();
            JsonObject response = new JsonObject();
            PerformanceAnalyzerResponse data = EndpointsFinder.getEndpoints(fileUri, this.workspaceManager, request.getRange(), false);
            response.addProperty("type", data.getType());
            response.addProperty("message", data.getMessage());
            response.add("actionInvocations", (JsonElement)data.getActionInvocations());
            response.add("endpoints", (JsonElement)data.getEndpoints());
            return response;
        });
    }

    @JsonNotification
    public CompletableFuture<List<PerformanceAnalyzerResponse>> getResourcesWithEndpoints(PerformanceAnalyzerRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<PerformanceAnalyzerResponse> resourcesWithEndpoints = new ArrayList<PerformanceAnalyzerResponse>();
            String fileUri = request.getDocumentIdentifier().getUri();
            Path path = Path.of(fileUri, new String[0]);
            Optional semanticModel = this.workspaceManager.semanticModel(path);
            Optional module = this.workspaceManager.module(path);
            if (semanticModel.isEmpty() || module.isEmpty()) {
                return resourcesWithEndpoints;
            }
            ResourceFinder nodeVisitor = new ResourceFinder();
            Optional document = this.workspaceManager.document(path);
            if (document.isEmpty()) {
                return resourcesWithEndpoints;
            }
            SyntaxTree syntaxTree = ((Document)document.get()).syntaxTree();
            syntaxTree.rootNode().accept((NodeVisitor)nodeVisitor);
            List<Resource> resourceRanges = nodeVisitor.getResources();
            for (Resource resource : resourceRanges) {
                LineRange range = resource.getLineRange();
                Range lineRange = new Range(new Position(range.startLine().line(), range.startLine().offset()), new Position(range.endLine().line(), range.endLine().offset()));
                boolean workerSupported = request.isWorkerSupported();
                PerformanceAnalyzerResponse response = EndpointsFinder.getEndpoints(fileUri, this.workspaceManager, lineRange, workerSupported);
                response.setName(resource.getName());
                response.setResourcePos(lineRange);
                resourcesWithEndpoints.add(response);
            }
            return resourcesWithEndpoints;
        });
    }
}

