/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.utils;

import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.component.ForStatementNode;
import io.ballerina.component.IfStatementNode;
import io.ballerina.component.Node;
import java.util.List;
import java.util.Locale;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;

public final class ParserUtil {
    public static final String TEST_DIR = "tests";
    public static final String MAIN_FUNC_NAME = "main";
    public static final String CONFIG_URL_KEY = "url";
    public static final String CLIENT_URL_ATTR_NAME = "url";
    public static final String ACTION_PATH_ATTR_NAME = "path";

    private ParserUtil() {
    }

    public static boolean isSourceUnit(BLangCompilationUnit compilationUnit) {
        return !TEST_DIR.equals(compilationUnit.getName().split("/")[0]);
    }

    public static boolean isRecordObject(BSymbol bSymbol) {
        return bSymbol.type != null && bSymbol.type.tsymbol != null && (bSymbol.type.tsymbol.tag & 0xCL) == 12L;
    }

    public static boolean isReturnClient(BInvokableSymbol bSymbol) {
        BType bType;
        if (bSymbol != null && bSymbol.getReturnType() != null && (bType = ParserUtil.isClientType(bSymbol.getReturnType())) != null) {
            bSymbol.retType = bType;
            return true;
        }
        return false;
    }

    public static boolean isMainMethod(FunctionDefinitionNode funcNode) {
        return MAIN_FUNC_NAME.equals(funcNode.functionName().text());
    }

    public static boolean isActionInvocation(BLangExpression expression) {
        return expression instanceof BLangInvocation.BLangActionInvocation;
    }

    public static boolean isURLAttrFromConfig(RecordLiteralNode.RecordField recordField) {
        if (recordField instanceof BLangRecordLiteral.BLangRecordKeyValueField) {
            BLangRecordLiteral.BLangRecordKeyValueField recordKeyValue = (BLangRecordLiteral.BLangRecordKeyValueField)recordField;
            BLangExpression bLangExpression = recordKeyValue.key.expr;
            if (bLangExpression instanceof BLangSimpleVarRef) {
                BLangSimpleVarRef simpleVarRef = (BLangSimpleVarRef)bLangExpression;
                String recordValue = simpleVarRef.variableName.value;
                return recordValue != null && recordValue.toLowerCase(Locale.ENGLISH).contains("url");
            }
        }
        return false;
    }

    public static boolean isClientObject(BSymbol bSymbol) {
        BType bType;
        if (bSymbol != null && bSymbol.type != null && (bType = ParserUtil.isClientType(bSymbol.type)) != null) {
            bSymbol.type = bType;
            return true;
        }
        return false;
    }

    private static BType isClientType(BType type) {
        if (type instanceof BUnionType) {
            BUnionType bUnionType = (BUnionType)type;
            for (BType bType : bUnionType.getMemberTypes()) {
                if (bType.tsymbol == null || !SymbolKind.OBJECT.equals((Object)bType.tsymbol.kind) || (bType.tsymbol.flags & 0x10000L) != 65536L) continue;
                return bType;
            }
        } else if (type.tsymbol != null && SymbolKind.OBJECT.equals((Object)type.tsymbol.kind) && (type.tsymbol.flags & 0x10000L) == 65536L) {
            return type;
        }
        return null;
    }

    public static BLangExpression getURLExpressionFromArgs(BLangTypeInit connectorInitExpr) {
        BSymbol bSymbol = ((BLangInvocation)connectorInitExpr.initInvocation).symbol;
        if (bSymbol instanceof BInvokableSymbol) {
            BInvokableSymbol bInvokableSymbol = (BInvokableSymbol)bSymbol;
            List params = bInvokableSymbol.getParameters();
            for (int i = 0; i < params.size(); ++i) {
                if (connectorInitExpr.argsExpr.size() <= i || !"url".equals(((BVarSymbol)params.get((int)i)).name.value.toLowerCase(Locale.ENGLISH)) && !ParserUtil.isRecordObject((BSymbol)((BVarSymbol)params.get((int)i)).type.tsymbol)) continue;
                return (BLangExpression)connectorInitExpr.argsExpr.get(i);
            }
        }
        return null;
    }

    public static BLangExpression getPathExpressionFromArgs(BLangInvocation actionInvocation) {
        BSymbol bSymbol = actionInvocation.symbol;
        if (bSymbol != null && bSymbol instanceof BInvokableSymbol) {
            BInvokableSymbol bInvokableSymbol = (BInvokableSymbol)bSymbol;
            List params = bInvokableSymbol.getParameters();
            for (int i = 0; i < params.size(); ++i) {
                if (actionInvocation.argExprs.size() <= i || !ACTION_PATH_ATTR_NAME.equals(((BVarSymbol)params.get((int)i)).name.value.toLowerCase(Locale.ENGLISH))) continue;
                return (BLangExpression)actionInvocation.argExprs.get(i);
            }
        }
        return null;
    }

    public static void getReducedTree(Node parentNode) {
        ForStatementNode forStatementNode;
        IfStatementNode ifStatementNode;
        Node currentNode = parentNode.getNextNode();
        if (currentNode == null) {
            return;
        }
        ParserUtil.getReducedTree(currentNode);
        if (currentNode instanceof IfStatementNode) {
            ifStatementNode = (IfStatementNode)currentNode;
            Node ifBody = ifStatementNode.getIfBody();
            Node elseBody = ifStatementNode.getElseBody();
            if (ifBody != null) {
                ParserUtil.getReducedTree(ifBody);
            }
            if (elseBody != null) {
                ParserUtil.getReducedTree(elseBody);
            }
        }
        if (currentNode instanceof IfStatementNode) {
            ifStatementNode = (IfStatementNode)currentNode;
            if (ifStatementNode.getIfBody() == null && ifStatementNode.getElseBody() == null) {
                if (ifStatementNode.hasNext()) {
                    parentNode.setNextNode(ifStatementNode.getNextNode());
                } else {
                    parentNode.setNextNode(null);
                }
            }
        } else if (currentNode instanceof ForStatementNode && (forStatementNode = (ForStatementNode)currentNode).getForBody() == null) {
            if (forStatementNode.hasNext()) {
                parentNode.setNextNode(forStatementNode.getNextNode());
            } else {
                parentNode.setNextNode(null);
            }
        }
    }
}

