/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.mime.util;

import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.mime.util.MimeConstants;
import java.util.List;
import java.util.Locale;
import org.jvnet.mimepull.Header;

public class EntityHeaderHandler {
    private static MapType mapType = TypeCreator.createMapType((Type)TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_STRING));

    public static BMap<BString, Object> getEntityHeaderMap(BObject entity) {
        BMap<BString, Object> httpHeaders = (BMap<BString, Object>)entity.get(MimeConstants.HEADERS_MAP_FIELD);
        if (httpHeaders == null) {
            httpHeaders = EntityHeaderHandler.getNewHeaderMap();
            entity.set(MimeConstants.HEADERS_MAP_FIELD, httpHeaders);
        }
        return httpHeaders;
    }

    private static BArray getEntityHeaderNameArray(BObject entity) {
        BArray headerNames = (BArray)entity.get(MimeConstants.HEADER_NAMES_ARRAY_FIELD);
        if (headerNames == null) {
            headerNames = EntityHeaderHandler.getNewHeaderNamesArray();
            entity.set(MimeConstants.HEADER_NAMES_ARRAY_FIELD, (Object)headerNames);
        }
        return headerNames;
    }

    static void populateBodyPartHeaders(BObject partStruct, List<? extends Header> bodyPartHeaders) {
        BMap<BString, Object> httpHeaders = EntityHeaderHandler.getNewHeaderMap();
        BArray headerNames = EntityHeaderHandler.getNewHeaderNamesArray();
        int index = 0;
        for (Header header : bodyPartHeaders) {
            httpHeaders.put((Object)StringUtils.fromString((String)header.getName().toLowerCase(Locale.getDefault())), (Object)ValueCreator.createArrayValue((BString[])new BString[]{StringUtils.fromString((String)header.getValue())}));
            headerNames.add((long)index++, StringUtils.fromString((String)header.getName()));
        }
        partStruct.set(MimeConstants.HEADERS_MAP_FIELD, httpHeaders);
        partStruct.set(MimeConstants.HEADER_NAMES_ARRAY_FIELD, (Object)headerNames);
    }

    public static String getHeaderValue(BObject entity, String headerName) {
        BMap headerMap = (BMap)entity.get(MimeConstants.HEADERS_MAP_FIELD);
        if (headerMap == null) {
            return null;
        }
        BArray headerValues = (BArray)headerMap.get((Object)StringUtils.fromString((String)headerName));
        if (headerValues == null || headerValues.size() < 1) {
            return null;
        }
        return headerValues.getBString(0L).getValue();
    }

    public static void addHeader(BObject entity, BMap<BString, Object> headers, String key, String value) {
        headers.put((Object)StringUtils.fromString((String)key.toLowerCase(Locale.getDefault())), (Object)ValueCreator.createArrayValue((BString[])new BString[]{StringUtils.fromString((String)value)}));
        BArray headerNames = EntityHeaderHandler.getEntityHeaderNameArray(entity);
        headerNames.add((long)headerNames.size(), StringUtils.fromString((String)key));
    }

    public static BMap<BString, Object> getNewHeaderMap() {
        return ValueCreator.createMapValue((MapType)mapType);
    }

    private static BArray getNewHeaderNamesArray() {
        return ValueCreator.createArrayValue((BString[])new BString[0]);
    }

    private EntityHeaderHandler() {
    }
}

