/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.mime.util;

import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.mime.util.EntityHeaderHandler;
import io.ballerina.stdlib.mime.util.MimeUtil;
import jakarta.activation.MimeType;
import jakarta.activation.MimeTypeParseException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class HeaderUtil {
    private static final MapType stringMapType = TypeCreator.createMapType((Type)PredefinedTypes.TYPE_STRING);

    public static BMap<BString, Object> getParamMap(String headerValue) {
        BMap<BString, Object> paramMap = null;
        if (headerValue.contains(";")) {
            HeaderUtil.extractValue(headerValue);
            List<String> paramList = Arrays.stream(headerValue.substring(headerValue.indexOf(";") + 1).split(";")).map(String::trim).collect(Collectors.toList());
            paramMap = HeaderUtil.validateParams(paramList) ? HeaderUtil.getHeaderParamMap(paramList) : HeaderUtil.getEmptyMap();
        } else {
            paramMap = HeaderUtil.getEmptyMap();
        }
        return paramMap;
    }

    public static String getHeaderValue(String headerValue) {
        return HeaderUtil.extractValue(headerValue.trim());
    }

    private static String extractValue(String headerValue) {
        int semicolonIndex = headerValue.indexOf(";");
        if (semicolonIndex < 0) {
            return headerValue.trim();
        }
        String value = headerValue.substring(0, semicolonIndex).trim();
        if (value.isEmpty()) {
            throw MimeUtil.createError("InvalidHeaderValueError", "invalid header value: " + headerValue);
        }
        return value;
    }

    private static boolean validateParams(List<String> paramList) {
        return paramList.size() != 1 || !paramList.get(0).isEmpty();
    }

    private static BMap<BString, Object> getHeaderParamMap(List<String> paramList) {
        BMap<BString, Object> paramMap = HeaderUtil.getEmptyMap();
        for (String param : paramList) {
            if (param.contains("=")) {
                String[] keyValuePair = param.split("=", 2);
                if (keyValuePair.length != 2 || keyValuePair[0].isEmpty() || keyValuePair[1].isEmpty()) {
                    throw MimeUtil.createError("InvalidHeaderParamError", "invalid header parameter: " + param);
                }
                paramMap.put((Object)StringUtils.fromString((String)keyValuePair[0].trim()), (Object)StringUtils.fromString((String)keyValuePair[1].trim()));
                continue;
            }
            paramMap.put((Object)StringUtils.fromString((String)param.trim()), null);
        }
        return paramMap;
    }

    static boolean isHeaderExist(List<String> headers) {
        return headers != null && headers.get(0) != null && !headers.get(0).isEmpty();
    }

    public static String appendHeaderParams(StringBuilder headerValue, BMap<BString, Object> map) {
        BString[] keys;
        int index = 0;
        if (map != null && !map.isEmpty() && (keys = (BString[])map.getKeys()).length != 0) {
            for (BString key : keys) {
                String paramValue = ((BString)map.get((Object)key)).getValue();
                if (index == keys.length - 1) {
                    headerValue.append(key).append("=").append(paramValue);
                    continue;
                }
                headerValue.append(key).append("=").append(paramValue).append(";");
                ++index;
            }
        }
        return headerValue.toString();
    }

    public static boolean isMultipart(String contentType) {
        return contentType != null && contentType.startsWith("multipart/");
    }

    public static String extractBoundaryParameter(String contentType) {
        BMap<BString, Object> paramMap = HeaderUtil.getParamMap(contentType);
        return paramMap.get((Object)StringUtils.fromString((String)"boundary")) != null ? ((BString)paramMap.get((Object)StringUtils.fromString((String)"boundary"))).getValue() : null;
    }

    public static void setHeaderToEntity(BObject entity, String key, String value) {
        BMap<BString, Object> httpHeaders = EntityHeaderHandler.getEntityHeaderMap(entity);
        EntityHeaderHandler.addHeader(entity, httpHeaders, key, value);
    }

    public static String getBaseType(BObject entityStruct) throws MimeTypeParseException {
        String contentType = EntityHeaderHandler.getHeaderValue(entityStruct, "content-type");
        if (contentType != null) {
            return new MimeType(contentType).getBaseType();
        }
        return null;
    }

    private static BMap<BString, Object> getEmptyMap() {
        return ValueCreator.createMapValue((MapType)stringMapType);
    }

    private HeaderUtil() {
    }
}

