/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.testerina.core;

import com.github.difflib.DiffUtils;
import com.github.difflib.UnifiedDiffUtils;
import com.github.difflib.algorithm.DiffException;
import com.github.difflib.patch.Patch;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class AssertionDiffEvaluator {
    private static final String PARTITION_REGEX = "(?<=\\G.{80})";
    private static final int MAX_ARG_LENGTH = 80;

    private AssertionDiffEvaluator() {
    }

    private static List<String> getValueList(String value) {
        ArrayList<String> valueList = new ArrayList<String>();
        if (value.contains("\n")) {
            String[] valueArray;
            for (String item : valueArray = value.split("\n")) {
                if (item.length() > 80) {
                    String[] partitions = item.split(PARTITION_REGEX);
                    valueList.addAll(Arrays.asList(partitions));
                    continue;
                }
                valueList.add(item);
            }
        } else if (value.length() > 80) {
            String[] partitions = value.split(PARTITION_REGEX);
            valueList.addAll(Arrays.asList(partitions));
        } else {
            valueList.add(value);
        }
        return valueList;
    }

    public static BString getStringDiff(BString actual, BString expected) {
        List<String> actualValueList = AssertionDiffEvaluator.getValueList(actual.toString());
        List difference = null;
        String output = "\n";
        try {
            Patch patch = DiffUtils.diff(actualValueList, AssertionDiffEvaluator.getValueList(expected.toString()));
            difference = UnifiedDiffUtils.generateUnifiedDiff((String)"actual", (String)"expected", actualValueList, (Patch)patch, (int)80);
        }
        catch (DiffException e) {
            output = "\nWarning: Could not generate diff.";
        }
        if (difference != null) {
            for (String line : difference) {
                if (line.startsWith("+") || line.startsWith("-")) {
                    if (output.endsWith("\n")) {
                        output = output.concat(line + "\n");
                        continue;
                    }
                    output = output.concat("\n" + line + "\n");
                    continue;
                }
                if (line.startsWith("@@ -")) {
                    output = output.concat("\n" + line + "\n\n");
                    continue;
                }
                output = output.concat(line + "\n");
            }
        }
        output = output.replace("\n\n", " \n \n ");
        return StringUtils.fromString((String)output);
    }

    public static BString getKeysDiff(BArray actualKeys, BArray expectedKeys) {
        String keyDiff = "";
        List<String> actualKeyList = AssertionDiffEvaluator.convertToList(actualKeys);
        List<String> expectedKeyList = AssertionDiffEvaluator.convertToList(expectedKeys);
        List<String> actualKeyDiff = AssertionDiffEvaluator.comparisonDiffList(actualKeyList, expectedKeyList);
        List<String> expectedKeyDiff = AssertionDiffEvaluator.comparisonDiffList(expectedKeyList, actualKeyList);
        if (!expectedKeyDiff.isEmpty()) {
            keyDiff = keyDiff.concat("\nexpected keys\t:" + AssertionDiffEvaluator.convertToString(expectedKeyDiff) + "\n");
        }
        if (!actualKeyDiff.isEmpty()) {
            keyDiff = keyDiff.concat("actual keys\t:" + AssertionDiffEvaluator.convertToString(actualKeyDiff));
        }
        return StringUtils.fromString((String)keyDiff);
    }

    private static String convertToString(List<String> keyDiffList) {
        String keyDiff = "";
        for (int i = 0; i < keyDiffList.size(); ++i) {
            keyDiff = keyDiff.concat(" " + keyDiffList.get(i));
            if (i == keyDiffList.size() - 1) continue;
            keyDiff = keyDiff.concat(",");
        }
        return keyDiff;
    }

    private static List<String> convertToList(BArray keys) {
        ArrayList<String> keyList = new ArrayList<String>();
        for (int i = 0; i < keys.size(); ++i) {
            keyList.add(keys.getBString((long)i).toString());
        }
        return keyList;
    }

    private static List<String> comparisonDiffList(List<String> keyList, List<String> compareToKeyList) {
        ArrayList<String> diffList = new ArrayList<String>();
        for (String key : keyList) {
            if (compareToKeyList.contains(key)) continue;
            diffList.add(key);
        }
        return diffList;
    }
}

