/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.testerina.core;

import io.ballerina.projects.JarResolver;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.util.List;
import java.util.Map;
import org.ballerinalang.compiler.plugins.AbstractCompilerPlugin;
import org.ballerinalang.compiler.plugins.SupportedAnnotationPackages;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.FunctionNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.PackageNode;
import org.ballerinalang.model.tree.SimpleVariableNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.testerina.core.TesterinaRegistry;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTestablePackage;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;

@SupportedAnnotationPackages(value={"ballerina/test"})
public class MockAnnotationProcessor
extends AbstractCompilerPlugin {
    private static final String MOCK_ANNOTATION_NAME = "Mock";
    private static final String MODULE = "moduleName";
    private static final String FUNCTION = "functionName";
    private static final String MOCK_FN_DELIMITER = "#";
    private static final String MOCK_LEGACY_DELIMITER = "~";
    private static final String MODULE_DELIMITER = "\u00a7";
    private static final String SINGLE_FILE_PACKAGE_NAME = ".";
    private CompilerContext compilerContext;
    private DiagnosticLog diagnosticLog;
    private PackageCache packageCache;
    private Map<BPackageSymbol, SymbolEnv> packageEnvironmentMap;
    private SymbolResolver symbolResolver;
    private Types typeChecker;
    private final TesterinaRegistry registry = TesterinaRegistry.getInstance();

    public void init(DiagnosticLog diagnosticLog) {
        this.diagnosticLog = diagnosticLog;
        this.packageEnvironmentMap = SymbolTable.getInstance((CompilerContext)this.compilerContext).pkgEnvMap;
        this.packageCache = PackageCache.getInstance((CompilerContext)this.compilerContext);
        this.symbolResolver = SymbolResolver.getInstance((CompilerContext)this.compilerContext);
        this.typeChecker = Types.getInstance((CompilerContext)this.compilerContext);
    }

    public void setCompilerContext(CompilerContext context) {
        this.compilerContext = context;
    }

    public void process(SimpleVariableNode simpleVariableNode, List<AnnotationAttachmentNode> annotations) {
        BLangPackage parent = (BLangPackage)((BLangSimpleVariable)simpleVariableNode).parent;
        String packageName = this.getPackageName((PackageNode)parent);
        annotations = annotations.stream().distinct().toList();
        for (AnnotationAttachmentNode annotationAttachmentNode : annotations) {
            if (SINGLE_FILE_PACKAGE_NAME.equals(packageName)) {
                this.diagnosticLog.logDiagnostic(DiagnosticSeverity.ERROR, (ModuleDescriptor)null, annotationAttachmentNode.getPosition(), (CharSequence)"function mocking is not supported with standalone Ballerina files");
                return;
            }
            String annotationName = annotationAttachmentNode.getAnnotationName().getValue();
            if (!MOCK_ANNOTATION_NAME.equals(annotationName)) continue;
            String type = ((BLangUserDefinedType)((BLangSimpleVariable)simpleVariableNode).typeNode).typeName.getValue();
            if (type.equals("MockFunction")) {
                String mockFnObjectName = simpleVariableNode.getName().getValue();
                String[] annotationValues = new String[2];
                annotationValues[0] = packageName;
                if (null == annotationAttachmentNode.getExpression() || annotationAttachmentNode.getExpression().getKind() != NodeKind.RECORD_LITERAL_EXPR) {
                    this.diagnosticLog.logDiagnostic(DiagnosticSeverity.ERROR, annotationAttachmentNode.getPosition(), (CharSequence)"missing required 'functionName' field");
                    continue;
                }
                List fields = ((BLangRecordLiteral)annotationAttachmentNode.getExpression()).getFields();
                this.setAnnotationValues(fields, annotationValues, annotationAttachmentNode, parent);
                PackageID functionToMockID = this.getPackageID(annotationValues[0]);
                boolean validFunctionName = this.isValidFunctionName(annotationValues[1], annotationValues[0], functionToMockID, annotationAttachmentNode);
                if (!validFunctionName) {
                    return;
                }
                BLangTestablePackage bLangTestablePackage = (BLangTestablePackage)((BLangSimpleVariable)simpleVariableNode).parent;
                bLangTestablePackage.addMockFunction(String.valueOf(functionToMockID) + MOCK_FN_DELIMITER + annotationValues[1], mockFnObjectName);
                bLangTestablePackage.addIsLegacyMockingMap(String.valueOf(functionToMockID) + MOCK_FN_DELIMITER + annotationValues[1], Boolean.valueOf(false));
                if (functionToMockID == null) continue;
                String className = this.getQualifiedClassName(bLangTestablePackage, functionToMockID.toString(), annotationValues[1]);
                this.registry.addMockFunctionsSourceMap(bLangTestablePackage.packageID.getName().toString() + MODULE_DELIMITER + className + MOCK_FN_DELIMITER + annotationValues[1], mockFnObjectName);
                continue;
            }
            this.diagnosticLog.logDiagnostic(DiagnosticSeverity.ERROR, annotationAttachmentNode.getPosition(), (CharSequence)"Annotation can only be attached to a test:MockFunction object");
        }
    }

    public void process(FunctionNode functionNode, List<AnnotationAttachmentNode> annotations) {
        BLangPackage parent = (BLangPackage)((BLangFunction)functionNode).parent;
        String packageName = this.getPackageName((PackageNode)parent);
        annotations = annotations.stream().distinct().toList();
        for (AnnotationAttachmentNode annotationAttachmentNode : annotations) {
            String annotationName = annotationAttachmentNode.getAnnotationName().getValue();
            String functionName = functionNode.getName().getValue();
            if (!MOCK_ANNOTATION_NAME.equals(annotationName)) continue;
            if (SINGLE_FILE_PACKAGE_NAME.equals(packageName)) {
                this.diagnosticLog.logDiagnostic(DiagnosticSeverity.ERROR, (ModuleDescriptor)null, annotationAttachmentNode.getPosition(), (CharSequence)"function mocking is not supported with standalone Ballerina files");
                return;
            }
            String[] vals = new String[]{packageName, ""};
            if (annotationAttachmentNode.getExpression() instanceof BLangRecordLiteral) {
                List attributes = ((BLangRecordLiteral)annotationAttachmentNode.getExpression()).getFields();
                attributes.forEach(field -> {
                    BLangRecordLiteral.BLangRecordVarNameField valueExpr;
                    String name;
                    if (field.isKeyValueField()) {
                        BLangRecordLiteral.BLangRecordKeyValueField attributeNode = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                        name = attributeNode.getKey().toString();
                        valueExpr = attributeNode.getValue();
                    } else {
                        BLangRecordLiteral.BLangRecordVarNameField varNameField = (BLangRecordLiteral.BLangRecordVarNameField)field;
                        name = varNameField.variableName.value;
                        valueExpr = varNameField;
                    }
                    String value = valueExpr.toString();
                    if (MODULE.equals(name)) {
                        vals[0] = value = this.formatPackageName(value, parent);
                    } else if (FUNCTION.equals(name)) {
                        vals[1] = value;
                    }
                });
                if (vals[1].isEmpty()) {
                    this.diagnosticLog.logDiagnostic(DiagnosticSeverity.ERROR, annotationAttachmentNode.getPosition(), (CharSequence)"function name cannot be empty");
                    break;
                }
                PackageID functionToMockID = this.getPackageID(vals[0]);
                if (functionToMockID == null) {
                    this.diagnosticLog.logDiagnostic(DiagnosticSeverity.ERROR, annotationAttachmentNode.getPosition(), (CharSequence)("could not find specified module '" + vals[0] + "'"));
                    break;
                }
                BType functionToMockType = this.getFunctionType(this.packageEnvironmentMap, functionToMockID, vals[1]);
                BType mockFunctionType = this.getFunctionType(this.packageEnvironmentMap, parent.packageID, ((BLangFunction)functionNode).name.toString());
                if (functionToMockType != null && mockFunctionType != null) {
                    if (!this.typeChecker.isAssignable(mockFunctionType, functionToMockType)) {
                        this.diagnosticLog.logDiagnostic(DiagnosticSeverity.ERROR, ((BLangFunction)functionNode).pos, (CharSequence)("incompatible types: expected " + String.valueOf(functionToMockType) + " but found " + String.valueOf(mockFunctionType)));
                        break;
                    }
                } else {
                    this.diagnosticLog.logDiagnostic(DiagnosticSeverity.ERROR, annotationAttachmentNode.getPosition(), (CharSequence)("could not find function '" + vals[1] + "' in module '" + vals[0] + "'"));
                    break;
                }
                BLangTestablePackage bLangTestablePackage = (BLangTestablePackage)((BLangFunction)functionNode).parent;
                bLangTestablePackage.addMockFunction(String.valueOf(functionToMockID) + MOCK_LEGACY_DELIMITER + vals[1], functionName);
                bLangTestablePackage.addIsLegacyMockingMap(String.valueOf(functionToMockID) + MOCK_LEGACY_DELIMITER + vals[1], Boolean.valueOf(true));
                String className = this.getQualifiedClassName(bLangTestablePackage, functionToMockID.toString(), vals[1]);
                vals[1] = vals[1].replace("\\", "");
                this.registry.addMockFunctionsSourceMap(bLangTestablePackage.packageID.getName().toString() + MODULE_DELIMITER + className + MOCK_LEGACY_DELIMITER + vals[1], functionName);
                continue;
            }
            this.diagnosticLog.logDiagnostic(DiagnosticSeverity.ERROR, annotationAttachmentNode.getPosition(), (CharSequence)"missing required 'functionName' field");
        }
    }

    private void setAnnotationValues(List<RecordLiteralNode.RecordField> fields, String[] annotationValues, AnnotationAttachmentNode attachmentNode, BLangPackage parent) {
        fields.forEach(field -> {
            if (field.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKeyValueField attributeNode = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                String name = attributeNode.getKey().toString();
                BLangExpression valueExpr = attributeNode.getValue();
                String value = valueExpr.toString();
                if (MODULE.equals(name)) {
                    annotationValues[0] = value = this.formatPackageName(value, parent);
                } else if (FUNCTION.equals(name)) {
                    annotationValues[1] = value;
                }
            } else {
                this.diagnosticLog.logDiagnostic(DiagnosticSeverity.ERROR, attachmentNode.getPosition(), (CharSequence)"Annotation fields must be key-value pairs");
            }
        });
    }

    private PackageID getPackageID(String moduleName) {
        if (this.packageCache.getSymbol(moduleName) != null) {
            return this.packageCache.getSymbol((String)moduleName).pkgID;
        }
        return null;
    }

    private String formatPackageName(String value, BLangPackage parent) {
        if (value.isEmpty() || value.equals(Names.DOT.value)) {
            value = parent.packageID.toString();
        } else if (!value.contains(Names.ORG_NAME_SEPARATOR.value) && !value.contains(Names.VERSION_SEPARATOR.value)) {
            value = new PackageID(parent.packageID.orgName, new Name(value), parent.packageID.version).toString();
        }
        return value;
    }

    private boolean isValidFunctionName(String functionName, String moduleName, PackageID functionToMockID, AnnotationAttachmentNode attachmentNode) {
        if (functionToMockID == null) {
            this.diagnosticLog.logDiagnostic(DiagnosticSeverity.ERROR, attachmentNode.getPosition(), (CharSequence)("could not find specified module '" + moduleName + "'"));
        } else if (functionName == null) {
            this.diagnosticLog.logDiagnostic(DiagnosticSeverity.ERROR, attachmentNode.getPosition(), (CharSequence)"function name cannot be empty");
        } else {
            for (Map.Entry<BPackageSymbol, SymbolEnv> entry : this.packageEnvironmentMap.entrySet()) {
                if (!entry.getKey().pkgID.equals((Object)functionToMockID) || !entry.getValue().scope.entries.containsKey(new Name(functionName))) continue;
                return true;
            }
            this.diagnosticLog.logDiagnostic(DiagnosticSeverity.ERROR, attachmentNode.getPosition(), (CharSequence)("could not find function '" + functionName + "' in module '" + moduleName + "'"));
        }
        return false;
    }

    private String getPackageName(PackageNode packageNode) {
        BLangPackage bLangPackage = (BLangPackage)packageNode;
        return bLangPackage.packageID.toString();
    }

    private BType getFunctionType(Map<BPackageSymbol, SymbolEnv> pkgEnvMap, PackageID packageID, String functionName) {
        for (Map.Entry<BPackageSymbol, SymbolEnv> entry : pkgEnvMap.entrySet()) {
            BSymbol symbol;
            if (!entry.getKey().pkgID.equals((Object)packageID) || (symbol = this.symbolResolver.lookupSymbolInMainSpace(entry.getValue(), new Name(functionName))).getType().toString().equals("other")) continue;
            return symbol.getType();
        }
        return null;
    }

    private String getQualifiedClassName(BLangTestablePackage bLangTestablePackage, String pkgId, String functionName) {
        String className;
        if (bLangTestablePackage.packageID.toString().equals(pkgId)) {
            if (bLangTestablePackage.symbol.scope.entries.containsKey(new Name(functionName))) {
                BSymbol symbol = ((Scope.ScopeEntry)bLangTestablePackage.symbol.scope.entries.get((Object)new Name((String)functionName))).symbol;
                className = this.getClassName(bLangTestablePackage.symbol, symbol.getPosition());
            } else {
                BLangPackage parentPkg = bLangTestablePackage.parent;
                BSymbol symbol = ((Scope.ScopeEntry)parentPkg.symbol.scope.entries.get((Object)new Name((String)functionName))).symbol;
                className = this.getClassName(parentPkg.symbol, symbol.getPosition());
            }
        } else {
            className = this.getImportedFunctionClassName(bLangTestablePackage, pkgId, functionName);
        }
        return className;
    }

    private String getImportedFunctionClassName(BLangTestablePackage bLangTestablePackage, String pkgId, String functionName) {
        String className = this.getClassName(bLangTestablePackage.getImports(), pkgId, functionName);
        if (className == null) {
            className = this.getClassName(bLangTestablePackage.parent.getImports(), pkgId, functionName);
        }
        return className;
    }

    private String getClassName(List<BLangImportPackage> imports, String pkgId, String functionName) {
        for (BLangImportPackage importPackage : imports) {
            if (!importPackage.symbol.pkgID.toString().equals(pkgId)) continue;
            BSymbol bInvokableSymbol = ((Scope.ScopeEntry)importPackage.symbol.scope.entries.get((Object)new Name((String)functionName))).symbol;
            return this.getClassName(importPackage.symbol, bInvokableSymbol.getPosition());
        }
        return null;
    }

    private String getClassName(BPackageSymbol bPackageSymbol, Location pos) {
        return JarResolver.getQualifiedClassName((String)bPackageSymbol.pkgID.orgName.getValue(), (String)bPackageSymbol.pkgID.name.getValue(), (String)bPackageSymbol.pkgID.version.getValue(), (String)pos.lineRange().fileName().replace(".bal", "").replace(SINGLE_FILE_PACKAGE_NAME, "$$$").replace("/", SINGLE_FILE_PACKAGE_NAME));
    }
}

