/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.testerina.natives.io;

import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IllegalFormatConversionException;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class StringUtils {
    private static final String CHAR_PREFIX = "$";
    private static final List<String> SPECIAL_CHARACTERS = new ArrayList<String>(Arrays.asList(",", "\\n", "\\r", "\\t", "\n", "\r", "\t", "\"", "\\", "!", "`"));
    private static final List<String> BRACKET_CHARACTERS = new ArrayList<String>(Arrays.asList("{", "}", "[", "]", "(", ")"));
    private static final List<String> REGEX_SPECIAL_CHARACTERS = new ArrayList<String>(Arrays.asList("{", "}", "[", "]", "(", ")", "+", "^", "|"));

    private StringUtils() {
    }

    public static Object matchWildcard(BString functionName, BString functionPattern) {
        Object encodedFunctionPattern = StringUtils.encode(functionPattern.getValue(), REGEX_SPECIAL_CHARACTERS);
        Object encodedFunctionName = StringUtils.encode(functionName.getValue(), REGEX_SPECIAL_CHARACTERS);
        if (encodedFunctionPattern instanceof BError) {
            return encodedFunctionPattern;
        }
        if (encodedFunctionName instanceof BError) {
            return encodedFunctionName;
        }
        try {
            return Pattern.matches(((String)encodedFunctionPattern).replace("*", ".*"), (String)encodedFunctionName);
        }
        catch (PatternSyntaxException e) {
            return ErrorHelper.getRuntimeException((ErrorCodes)ErrorCodes.OPERATION_NOT_SUPPORTED_ERROR, (Object[])new Object[]{"Invalid wildcard pattern: " + e.getMessage()});
        }
    }

    public static Object escapeSpecialCharacters(BString key) {
        Object updatedKeyOrError = key.getValue();
        if (!StringUtils.isBalanced((String)updatedKeyOrError)) {
            updatedKeyOrError = StringUtils.encode((String)updatedKeyOrError, BRACKET_CHARACTERS);
        }
        if (updatedKeyOrError instanceof BError) {
            return updatedKeyOrError;
        }
        if ((updatedKeyOrError = StringUtils.encode((String)updatedKeyOrError, SPECIAL_CHARACTERS)) instanceof BError) {
            return updatedKeyOrError;
        }
        return io.ballerina.runtime.api.utils.StringUtils.fromString((String)((String)updatedKeyOrError));
    }

    private static boolean isBalanced(String expr) {
        ArrayDeque<Character> stack = new ArrayDeque<Character>();
        block5: for (int i = 0; i < expr.length(); ++i) {
            char val = expr.charAt(i);
            if (val == '(' || val == '[' || val == '{') {
                stack.push(Character.valueOf(val));
                continue;
            }
            if (val != ')' && val != ']' && val != '}') continue;
            if (stack.isEmpty()) {
                return false;
            }
            switch (val) {
                case ')': {
                    char topElement = ((Character)stack.pop()).charValue();
                    if (topElement != '{' && topElement != '[') continue block5;
                    return false;
                }
                case '}': {
                    char topElement = ((Character)stack.pop()).charValue();
                    if (topElement != '(' && topElement != '[') continue block5;
                    return false;
                }
                case ']': {
                    char topElement = ((Character)stack.pop()).charValue();
                    if (topElement != '(' && topElement != '{') continue block5;
                    return false;
                }
            }
        }
        return stack.isEmpty();
    }

    private static Object encode(String key, List<String> specialCharacters) {
        String encodedKey = key;
        for (String character : specialCharacters) {
            if (!encodedKey.contains(character)) continue;
            String encodedValue = URLEncoder.encode(character, StandardCharsets.UTF_8);
            encodedKey = encodedKey.replace(character, encodedValue);
        }
        return encodedKey;
    }

    public static Object decode(BString str, BString charset) {
        try {
            String javaStr = str.getValue();
            javaStr = javaStr.replaceAll("%(?![0-9a-fA-F]{2})", "%25");
            javaStr = javaStr.replace("+", "%2B");
            return io.ballerina.runtime.api.utils.StringUtils.fromString((String)URLDecoder.decode(javaStr, charset.getValue()));
        }
        catch (UnsupportedEncodingException | IllegalArgumentException e) {
            return ErrorHelper.getRuntimeException((ErrorCodes)ErrorCodes.INCOMPATIBLE_ARGUMENTS, (Object[])new Object[]{"Error while decoding: " + e.getMessage()});
        }
    }

    public static BString sprintf(BString format, Object ... args) {
        StringBuilder result = new StringBuilder();
        int k = 0;
        for (int i = 0; i < format.length(); ++i) {
            if (format.getValue().charAt(i) == '%' && i + 1 < format.length()) {
                int j = i + 1;
                if (k >= args.length) {
                    throw ErrorHelper.getRuntimeException((ErrorCodes)ErrorCodes.NOT_ENOUGH_FORMAT_ARGUMENTS, (Object[])new Object[0]);
                }
                StringBuilder padding = new StringBuilder();
                while (Character.isDigit(format.getValue().charAt(j)) || format.getValue().charAt(j) == '.') {
                    padding.append(format.getValue().charAt(j));
                    ++j;
                }
                try {
                    char formatSpecifier = format.getValue().charAt(j);
                    Object ref = args[k];
                    switch (formatSpecifier) {
                        case 'B': 
                        case 'b': 
                        case 'd': 
                        case 'f': {
                            if (ref == null) {
                                throw ErrorHelper.getRuntimeException((ErrorCodes)ErrorCodes.ILLEGAL_FORMAT_CONVERSION, (Object[])new Object[]{format.getValue().charAt(j) + " != ()"});
                            }
                            result.append(String.format("%" + String.valueOf(padding) + formatSpecifier, ref));
                            break;
                        }
                        case 'X': 
                        case 'x': {
                            if (ref == null) {
                                throw ErrorHelper.getRuntimeException((ErrorCodes)ErrorCodes.ILLEGAL_FORMAT_CONVERSION, (Object[])new Object[]{format.getValue().charAt(j) + " != ()"});
                            }
                            StringUtils.formatHexString(result, k, padding, formatSpecifier, args);
                            break;
                        }
                        case 's': {
                            if (ref != null) {
                                result.append(String.format("%" + String.valueOf(padding) + "s", io.ballerina.runtime.api.utils.StringUtils.getStringValue((Object)ref)));
                            }
                            break;
                        }
                        case '%': {
                            result.append("%");
                            break;
                        }
                        default: {
                            throw ErrorHelper.getRuntimeException((ErrorCodes)ErrorCodes.INVALID_FORMAT_SPECIFIER, (Object[])new Object[]{Character.valueOf(format.getValue().charAt(j))});
                        }
                    }
                }
                catch (IllegalFormatConversionException e) {
                    throw ErrorHelper.getRuntimeException((ErrorCodes)ErrorCodes.ILLEGAL_FORMAT_CONVERSION, (Object[])new Object[]{format.getValue().charAt(j) + " != " + String.valueOf(TypeChecker.getType((Object)args[k]))});
                }
                if (format.getValue().charAt(j) == '%') {
                    ++i;
                    continue;
                }
                ++k;
                i = j;
                continue;
            }
            result.append(format.getValue().charAt(i));
        }
        return io.ballerina.runtime.api.utils.StringUtils.fromString((String)result.toString());
    }

    private static void formatHexString(StringBuilder result, int k, StringBuilder padding, char x, Object ... args) {
        Object argsValues = args[k];
        Type type = TypeUtils.getImpliedType((Type)TypeChecker.getType((Object)argsValues));
        if (32 == type.getTag() && 2 == ((ArrayType)type).getElementType().getTag()) {
            BArray byteArray = (BArray)argsValues;
            for (int i = 0; i < byteArray.size(); ++i) {
                result.append(String.format("%" + String.valueOf(padding) + x, byteArray.getByte((long)i)));
            }
        } else {
            result.append(String.format("%" + String.valueOf(padding) + x, argsValues));
        }
    }

    public static boolean isSystemConsole() {
        return System.console() != null;
    }
}

