/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.testerina.natives.mock;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.scheduling.Scheduler;
import io.ballerina.runtime.internal.scheduling.Strand;
import io.ballerina.runtime.internal.values.MapValueImpl;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.ballerinalang.test.runtime.BTestMain;
import org.ballerinalang.test.runtime.util.TesterinaUtils;
import org.ballerinalang.testerina.natives.Executor;
import org.ballerinalang.testerina.natives.mock.MockConstants;
import org.ballerinalang.testerina.natives.mock.MockRegistry;

public final class FunctionMock {
    private FunctionMock() {
    }

    public static BError thenReturn(BObject caseObj) {
        BObject mockFunctionObj = caseObj.getObjectValue(StringUtils.fromString((String)"mockFuncObj"));
        BArray args = caseObj.getArrayValue(StringUtils.fromString((String)"args"));
        Object returnVal = caseObj.get(StringUtils.fromString((String)"returnValue"));
        MockRegistry.getInstance().registerCase(mockFunctionObj, null, args, returnVal);
        return null;
    }

    public static Object mockHandler(BObject mockFuncObj, Object ... args) {
        List<String> caseIds = FunctionMock.getCaseIds(mockFuncObj, args);
        String originalFunction = mockFuncObj.getStringValue(StringUtils.fromString((String)"functionToMock")).toString();
        String originalFunctionPackage = mockFuncObj.getStringValue(StringUtils.fromString((String)"functionToMockPackage")).toString();
        String[] mockFunctionClasses = mockFuncObj.getArrayValue(StringUtils.fromString((String)"mockFunctionClasses")).getStringArray();
        String[] splitInfo = originalFunctionPackage.split(Pattern.quote("/"));
        String originalOrg = splitInfo[0];
        String originalPackage = splitInfo[1].split(Pattern.quote(":"))[0];
        String originalVersion = splitInfo[1].split(Pattern.quote(":"))[1];
        String originalClass = splitInfo[2];
        originalFunctionPackage = TesterinaUtils.getQualifiedClassName((String)originalOrg, (String)originalPackage, (String)originalVersion, (String)originalClass);
        for (String caseId : caseIds) {
            if (!MockRegistry.getInstance().hasCase(caseId)) continue;
            Object returnVal = MockRegistry.getInstance().getReturnValue(caseId);
            if (returnVal instanceof BString) {
                if (returnVal.toString().contains("__CALL__")) {
                    return FunctionMock.callMockFunction(originalFunction.replaceAll("\\\\(.)", "$1"), originalFunctionPackage, mockFunctionClasses, returnVal.toString(), args);
                }
                if (returnVal.toString().equals("__ORIGINAL__")) {
                    return FunctionMock.callOriginalFunction("$ORIG_" + originalFunction, originalFunctionPackage, args);
                }
            }
            return returnVal;
        }
        String message = "no return value or action registered for function";
        throw ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"FunctionCallError", (BString)StringUtils.fromString((String)message), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
    }

    private static Object callOriginalFunction(String originalFunction, String originalClassName, Object ... args) {
        Strand strand = Scheduler.getStrand();
        List<Object> argsList = Arrays.asList(args);
        return Executor.executeFunction(strand, BTestMain.getClassLoader(), originalClassName, originalFunction, argsList.toArray());
    }

    private static Object callMockFunction(String originalFunction, String originalClassName, String[] mockFunctionClasses, String returnVal, Object ... args) {
        int prefixPos = returnVal.indexOf("__CALL__");
        String mockFunctionName = returnVal.substring(prefixPos + "__CALL__".length());
        Strand strand = Scheduler.getStrand();
        if (Thread.currentThread().getStackTrace().length >= 5) {
            Object className;
            String classname = Thread.currentThread().getStackTrace()[4].getClassName();
            if (classname.contains("/")) {
                classname = classname.replace("/", ".");
            }
            String[] projectInfo = classname.split(Pattern.quote("."));
            try {
                String orgName = projectInfo[0];
                String packageName = projectInfo[1];
                String version = projectInfo[2];
                className = "tests." + FunctionMock.getMockClassName(orgName, packageName, version, originalFunction, originalClassName, mockFunctionName, mockFunctionClasses, BTestMain.getClassLoader());
                className = TesterinaUtils.getQualifiedClassName((String)orgName, (String)packageName, (String)version, (String)className);
            }
            catch (ClassNotFoundException e) {
                return ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"FunctionCallError", (BString)StringUtils.fromString((String)e.getMessage()), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
            }
            List<Object> argsList = Arrays.asList(args);
            return Executor.executeFunction(strand, BTestMain.getClassLoader(), (String)className, mockFunctionName, argsList.toArray());
        }
        return null;
    }

    private static String getMockClassName(String orgName, String packageName, String version, String originalMethodName, String originalPackageName, String mockMethodName, String[] mockFunctionClasses, ClassLoader classLoader) throws ClassNotFoundException {
        Method mockMethod = FunctionMock.getMockMethod(orgName, packageName, version, mockMethodName, mockFunctionClasses, classLoader);
        Method originalMethod = FunctionMock.getClassDeclaredMethod(originalPackageName, originalMethodName, classLoader);
        FunctionMock.validateFunctionSignature(mockMethod, originalMethod, mockMethodName);
        return mockMethod.getDeclaringClass().getSimpleName();
    }

    private static Method getMockMethod(String orgName, String packageName, String version, String mockMethodName, String[] mockFunctionClasses, ClassLoader classLoader) throws ClassNotFoundException {
        Method classDeclaredMethod;
        Method mockMethod = null;
        String resolvedMockClass = FunctionMock.resolveMockClass(mockMethodName, mockFunctionClasses, orgName, packageName, version, classLoader);
        if (resolvedMockClass != null && (classDeclaredMethod = FunctionMock.getClassDeclaredMethod(resolvedMockClass, mockMethodName, classLoader)) != null) {
            mockMethod = classDeclaredMethod;
        }
        return mockMethod;
    }

    private static String resolveMockClass(String mockMethodName, String[] mockFunctionClasses, String orgName, String packageName, String version, ClassLoader classLoader) throws ClassNotFoundException {
        String mockClass = null;
        for (String string : mockFunctionClasses) {
            String string2 = orgName + "." + packageName + "." + version + "." + string;
            Class<?> resolvedClass = classLoader.loadClass(string2);
            for (Method method : resolvedClass.getDeclaredMethods()) {
                if (!mockMethodName.equals(method.getName())) continue;
                mockClass = string2;
            }
        }
        return mockClass;
    }

    private static void validateFunctionSignature(Method mockMethod, Method originalMethod, String mockMethodName) {
        if (mockMethod != null && originalMethod != null) {
            Class<?> mockMethodType = mockMethod.getReturnType();
            Class<?>[] mockMethodParameters = mockMethod.getParameterTypes();
            Class<?> originalMethodType = originalMethod.getReturnType();
            Class<?>[] originalMethodParameters = originalMethod.getParameterTypes();
            if (mockMethodType != originalMethodType) {
                throw ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"FunctionSignatureMismatchError", (BString)StringUtils.fromString((String)("Return type of function " + mockMethod.getName() + " does not match function " + originalMethod.getName())), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
            }
            if (mockMethodParameters.length != originalMethodParameters.length) {
                throw ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"FunctionSignatureMismatchError", (BString)StringUtils.fromString((String)("Parameter types of function " + mockMethod.getName() + " does not match function " + originalMethod.getName())), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
            }
            for (int i = 0; i < mockMethodParameters.length; ++i) {
                if (mockMethodParameters[i] == originalMethodParameters[i]) continue;
                throw ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"FunctionSignatureMismatchError", (BString)StringUtils.fromString((String)("Parameter types of function " + mockMethod.getName() + "does not match function " + originalMethod.getName())), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
            }
        } else {
            throw ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"FunctionSignatureMismatchError", (BString)StringUtils.fromString((String)("Mock function '" + mockMethodName + "' cannot be found")), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
        }
    }

    private static Method getClassDeclaredMethod(String className, String methodName, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> clazz = classLoader.loadClass(className);
        for (Method method : clazz.getDeclaredMethods()) {
            if (!methodName.equals(TesterinaUtils.decodeIdentifier((String)method.getName()))) continue;
            return method;
        }
        return null;
    }

    private static List<String> getCaseIds(BObject mockObj, Object ... args) {
        ArrayList<String> caseIdList = new ArrayList<String>();
        StringBuilder caseId = new StringBuilder();
        caseId.append(mockObj.hashCode());
        caseIdList.add(caseId.toString());
        for (Object arg : args) {
            caseId.append("-");
            if (arg instanceof BObject || arg instanceof RecordType) {
                caseId.append("__ANY__");
                continue;
            }
            caseId.append(arg);
        }
        if (!caseIdList.contains(caseId.toString())) {
            caseIdList.add(caseId.toString());
        }
        Collections.reverse(caseIdList);
        return caseIdList;
    }
}

