/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.testerina.natives.mock;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BFuture;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.internal.scheduling.Strand;
import io.ballerina.runtime.internal.values.ObjectValue;
import io.ballerina.runtime.internal.values.TypedescValueImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.testerina.natives.mock.MockRegistry;

public class GenericMockObjectValue
implements ObjectValue {
    private static final BasicTypeBitSet BASIC_TYPE = Builder.getObjectType();
    private final ObjectValue mockObj;
    private final ObjectType type;
    private final BTypedesc typedesc;

    public GenericMockObjectValue(ObjectType type, ObjectValue mockObj) {
        this.type = type;
        this.mockObj = mockObj;
        this.typedesc = new TypedescValueImpl((Type)type);
    }

    public Object call(Strand strand, String funcName, Object ... args) {
        if (!this.mockObj.getType().getName().contains("$anonType$")) {
            return this.mockObj.call(strand, funcName, args);
        }
        List<String> caseIds = this.getCaseIds((BObject)this.mockObj, funcName, args);
        for (String caseId : caseIds) {
            if (!MockRegistry.getInstance().hasCase(caseId)) continue;
            String hitId = this.mockObj.hashCode() + "-" + funcName;
            if (MockRegistry.getInstance().hasHitCount(hitId)) {
                int currentHit = MockRegistry.getInstance().getMemberFuncHitsMap().get(hitId);
                MockRegistry.getInstance().getMemberFuncHitsMap().put(hitId, currentHit + 1);
            }
            return MockRegistry.getInstance().getReturnValue(caseId);
        }
        throw ErrorCreator.createError((BString)StringUtils.fromString((String)("no cases registered for member function '" + funcName + "' of object type '" + this.mockObj.getType().getName() + "'.")));
    }

    public Object get(BString fieldName) {
        if (!this.mockObj.getType().getName().contains("$anonType$")) {
            return this.mockObj.get(fieldName);
        }
        String caseId = this.getCaseIds((BObject)this.mockObj, fieldName.toString());
        if (MockRegistry.getInstance().hasCase(caseId)) {
            return MockRegistry.getInstance().getReturnValue(caseId);
        }
        throw ErrorCreator.createError((BString)StringUtils.fromString((String)("no cases registered for member field '" + String.valueOf(fieldName) + "' of object type '" + this.mockObj.getType().getName() + "'.")));
    }

    public long getIntValue(BString fieldName) {
        return 0L;
    }

    public double getFloatValue(BString fieldName) {
        return 0.0;
    }

    public BString getStringValue(BString fieldName) {
        return null;
    }

    public boolean getBooleanValue(BString fieldName) {
        return false;
    }

    public BMap getMapValue(BString fieldName) {
        return null;
    }

    public BObject getObjectValue(BString fieldName) {
        return null;
    }

    public BArray getArrayValue(BString fieldName) {
        return null;
    }

    public void addNativeData(String key, Object data) {
    }

    public Object getNativeData(String key) {
        return null;
    }

    public HashMap<String, Object> getNativeData() {
        return null;
    }

    public void set(BString fieldName, Object value) {
    }

    public BFuture start(Strand strand, String funcName, Object ... args) {
        return null;
    }

    public String stringValue(BLink parent) {
        return null;
    }

    public String expressionStringValue(BLink parent) {
        return null;
    }

    public ObjectType getType() {
        return this.type;
    }

    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE;
    }

    public Type getOriginalType() {
        return this.type;
    }

    public BObject getMockObj() {
        return this.mockObj;
    }

    private String getCaseIds(BObject mockObj, String fieldName) {
        return mockObj.hashCode() + "-" + fieldName;
    }

    private List<String> getCaseIds(BObject mockObj, String funcName, Object[] args) {
        String funcNameOriginal = funcName;
        ArrayList<String> caseIdList = new ArrayList<String>();
        StringBuilder caseId = new StringBuilder();
        ArrayList<String> functionNames = new ArrayList<String>();
        functionNames.add(funcNameOriginal);
        args = this.removeUnnecessaryArgs(args);
        if (funcName.startsWith("$")) {
            int numOfPathSeparators = (int)funcName.chars().filter(ch -> ch == "^".charAt(0)).count();
            int pathSegmentCount = numOfPathSeparators - (funcName.contains("^^") ? 1 : 0);
            funcName = this.replacePathPlaceHolders(funcName, args, numOfPathSeparators);
            functionNames.add(funcName);
            args = Arrays.copyOfRange(args, pathSegmentCount, args.length);
        }
        for (String function : functionNames) {
            caseId.append(mockObj.hashCode()).append("-").append(function);
            caseIdList.add(caseId.toString());
            for (Object arg : args) {
                caseId.append("-");
                if (arg instanceof BObject || arg instanceof RecordType) {
                    caseId.append("__ANY__");
                    continue;
                }
                caseId.append(arg);
            }
            caseIdList.add(caseId.toString());
            caseId.setLength(0);
            caseId.append(mockObj.hashCode()).append("-").append(function);
            for (Object arg : args) {
                caseId.append("-");
                if (arg instanceof BObject) {
                    caseId.append("__ANY__");
                    continue;
                }
                caseId.append(arg);
            }
            if (!caseIdList.contains(caseId.toString())) {
                caseIdList.add(caseId.toString());
            }
            caseId.setLength(0);
        }
        if (funcNameOriginal.startsWith("$")) {
            funcName = funcNameOriginal;
        }
        caseId.append(mockObj.hashCode()).append("-").append(funcName);
        if (MockRegistry.getInstance().hasHitCount(caseId.toString())) {
            int hittingCount = MockRegistry.getInstance().getMemberFuncHitsMap().get(caseId.toString());
            caseId.append("-").append(hittingCount);
            caseIdList.add(caseId.toString());
        }
        Collections.reverse(caseIdList);
        return caseIdList;
    }

    private String replacePathPlaceHolders(String funcName, Object[] args, int caretCount) {
        StringBuilder newFuncName = new StringBuilder(funcName);
        BArray restArgs = null;
        if (funcName.endsWith("^^")) {
            restArgs = (BArray)args[caretCount - 2];
        }
        if (restArgs != null) {
            newFuncName.setLength(0);
            String substring = funcName.substring(0, funcName.length() - 2);
            newFuncName.append(substring);
            for (int i = 0; i < restArgs.size(); ++i) {
                Object arg = restArgs.get((long)i);
                if (arg == null) continue;
                newFuncName.append(arg).append("$");
            }
            newFuncName.setLength(newFuncName.length() - 1);
            caretCount -= 2;
        }
        for (int i = 0; i < caretCount; ++i) {
            if (args[i] == null) continue;
            newFuncName.replace(newFuncName.indexOf("^"), newFuncName.indexOf("^") + 1, args[i].toString());
        }
        return newFuncName.toString();
    }

    private Object[] removeUnnecessaryArgs(Object[] args) {
        ArrayList<Object> newArgs = new ArrayList<Object>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null || TypeUtils.getImpliedType((Type)TypeUtils.getType((Object)args[i])).getTag() == 25) continue;
            newArgs.add(args[i]);
        }
        return newArgs.toArray();
    }

    public Object copy(Map<Object, Object> refs) {
        return null;
    }

    public Object frozenCopy(Map<Object, Object> refs) {
        return null;
    }

    public BTypedesc getTypedesc() {
        return this.typedesc;
    }
}

