/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.testerina.natives.mock;

import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BIterator;
import io.ballerina.runtime.api.values.BObject;
import java.util.HashMap;
import java.util.Map;

public class MockRegistry {
    public static final String ANY = "__ANY__";
    private static final MockRegistry INSTANCE = new MockRegistry();
    private final Map<String, Object> casesMap = new HashMap<String, Object>();
    private final Map<String, Integer> memberFuncHitsMap = new HashMap<String, Integer>();

    public static MockRegistry getInstance() {
        return INSTANCE;
    }

    public void registerCase(BObject mockObject, String functionName, BArray argsList, Object returnVal, int hittingCount) {
        Object caseId = this.constructCaseId(mockObject, functionName, argsList);
        if (!this.hasHitCount((String)caseId)) {
            this.memberFuncHitsMap.put((String)caseId, 1);
        }
        caseId = (String)caseId + "-" + hittingCount;
        this.casesMap.put((String)caseId, returnVal);
    }

    public void registerCase(BObject mockObject, String functionName, BArray argsList, Object returnVal) {
        String caseId = this.constructCaseId(mockObject, functionName, argsList);
        this.casesMap.put(caseId, returnVal);
    }

    private String constructCaseId(BObject mockObject, String functionName, BArray argsList) {
        StringBuilder caseIdBuilder = new StringBuilder();
        if (mockObject != null) {
            caseIdBuilder.append(mockObject.hashCode());
            if (functionName != null) {
                caseIdBuilder.append("-").append(functionName);
            }
            if (argsList != null && !argsList.isEmpty()) {
                BIterator argIterator = argsList.getIterator();
                while (argIterator.hasNext()) {
                    caseIdBuilder.append("-").append(argIterator.next().toString());
                }
            }
        }
        return caseIdBuilder.toString();
    }

    public Object getReturnValue(String caseId) {
        return this.casesMap.get(caseId);
    }

    public boolean hasCase(String caseId) {
        return this.casesMap.containsKey(caseId);
    }

    public Map<String, Integer> getMemberFuncHitsMap() {
        return this.memberFuncHitsMap;
    }

    public boolean hasHitCount(String caseId) {
        return this.memberFuncHitsMap.containsKey(caseId);
    }
}

