/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.testerina.natives.mock;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Parameter;
import io.ballerina.runtime.api.types.ParameterizedType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.ResourceMethodType;
import io.ballerina.runtime.api.types.StreamType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BIterator;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.types.BClientType;
import io.ballerina.runtime.internal.values.MapValueImpl;
import io.ballerina.runtime.internal.values.ObjectValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ballerinalang.testerina.natives.mock.GenericMockObjectValue;
import org.ballerinalang.testerina.natives.mock.MockConstants;
import org.ballerinalang.testerina.natives.mock.MockRegistry;

public final class ObjectMock {
    private ObjectMock() {
    }

    public static BObject mock(BTypedesc bTypedesc, ObjectValue objectValue) {
        ObjectType objectValueType = (ObjectType)TypeUtils.getImpliedType((Type)objectValue.getType());
        if (!objectValueType.getName().contains("$anonType$")) {
            BClientType bClientType;
            if (objectValueType.getMethods().length == 0 && objectValueType.getFields().isEmpty() && objectValueType instanceof BClientType && (bClientType = (BClientType)objectValueType).getResourceMethods().length == 0) {
                String detail = "mock object type '" + objectValueType.getName() + "' should have at least one member function or field declared.";
                throw ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"InvalidObjectError", (BString)StringUtils.fromString((String)detail), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
            }
            for (MethodType attachedFunction : objectValueType.getMethods()) {
                BError error = ObjectMock.validateFunctionSignatures(attachedFunction, ((ObjectType)bTypedesc.getDescribingType()).getMethods());
                if (error == null) continue;
                throw error;
            }
            if (objectValueType instanceof BClientType) {
                BClientType bClientType2 = (BClientType)objectValueType;
                for (ResourceMethodType attachedFunction : bClientType2.getResourceMethods()) {
                    BError error = ObjectMock.validateFunctionSignatures((MethodType)attachedFunction, (MethodType[])((BClientType)bTypedesc.getDescribingType()).getResourceMethods());
                    if (error == null) continue;
                    throw error;
                }
            }
            for (Map.Entry<String, Field> entry : objectValueType.getFields().entrySet()) {
                BError error = ObjectMock.validateField(entry, ((ObjectType)bTypedesc.getDescribingType()).getFields());
                if (error == null) continue;
                throw error;
            }
        }
        ObjectType bObjectType = (ObjectType)bTypedesc.getDescribingType();
        return new GenericMockObjectValue(bObjectType, objectValue);
    }

    public static BError validatePreparedObj(BObject caseObj) {
        GenericMockObjectValue genericMock = (GenericMockObjectValue)caseObj;
        BObject mockObj = genericMock.getMockObj();
        String objectType = mockObj.getType().getName();
        if (!objectType.contains("$anonType$")) {
            String detail = "cases cannot be registered to user-defined object type '" + genericMock.getType().getName() + "'";
            return ErrorCreator.createDistinctError((String)"InvalidObjectError", (Module)MockConstants.TEST_PACKAGE_ID, (BString)StringUtils.fromString((String)detail));
        }
        return null;
    }

    public static BError validateFunctionName(String functionName, BObject mockObject) {
        GenericMockObjectValue genericMock = (GenericMockObjectValue)mockObject;
        if (!ObjectMock.validateFunctionName(functionName, ((ObjectType)TypeUtils.getImpliedType((Type)genericMock.getType())).getMethods())) {
            String detail = "invalid function name '" + functionName + " ' provided";
            throw ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"FunctionNotFoundError", (BString)StringUtils.fromString((String)detail), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
        }
        return null;
    }

    private static void validateClientObject(GenericMockObjectValue genericMock) {
        if (!(genericMock.getType() instanceof BClientType)) {
            String detail = "mock object type should be a client type";
            throw ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"InvalidObjectError", (BString)StringUtils.fromString((String)detail), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
        }
    }

    public static BError validateResourcePath(String pathName, BObject mockObject) {
        GenericMockObjectValue genericMock = (GenericMockObjectValue)mockObject;
        if (!ObjectMock.validateResourcePath(pathName, ((BClientType)genericMock.getType()).getResourceMethods())) {
            String detail = "invalid resource path '" + pathName + "' provided";
            throw ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"FunctionNotFoundError", (BString)StringUtils.fromString((String)detail), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
        }
        return null;
    }

    public static BError validateResourceMethod(BObject caseObj) {
        String accessor;
        GenericMockObjectValue genericMock = (GenericMockObjectValue)caseObj.getObjectValue(StringUtils.fromString((String)"mockObject"));
        String functionName = caseObj.getStringValue(StringUtils.fromString((String)"functionName")).toString();
        if (!ObjectMock.validateAccessor(functionName, accessor = caseObj.getStringValue(StringUtils.fromString((String)"accessor")).toString(), ((BClientType)genericMock.getType()).getResourceMethods())) {
            String detail = "invalid accessor method '" + accessor + "' provided";
            throw ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"FunctionNotFoundError", (BString)StringUtils.fromString((String)detail), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
        }
        return null;
    }

    private static boolean validateAccessor(String resourcePath, String accessor, ResourceMethodType[] resourceMethods) {
        String functionPattern = ObjectMock.getFunctionNameForResourcePath(resourcePath);
        for (ResourceMethodType attachedFunction : resourceMethods) {
            if (!attachedFunction.getName().endsWith(functionPattern) || !attachedFunction.getAccessor().equals(accessor)) continue;
            return true;
        }
        return false;
    }

    public static BError validatePathParams(BObject caseObj, BMap<?, ?> pathParams) {
        String functionName = caseObj.getStringValue(StringUtils.fromString((String)"functionName")).toString();
        String[] pathSegments = functionName.split("/");
        for (int i = 0; i < pathSegments.length; ++i) {
            String pathSegment;
            if (pathSegments[i].startsWith("::")) {
                if (i != pathSegments.length - 1) {
                    String detail = "rest parameter '" + pathSegments[i] + "' should be the last segment of the path";
                    throw ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"FunctionSignatureMismatchError", (BString)StringUtils.fromString((String)detail), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
                }
                String restSegment = pathSegments[i].substring(2);
                if (pathParams.get((Object)StringUtils.fromString((String)restSegment)) != null) continue;
                String detail = "required rest parameter '" + restSegment + "' is not provided";
                throw ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"FunctionSignatureMismatchError", (BString)StringUtils.fromString((String)detail), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
            }
            if (!pathSegments[i].startsWith(":") || pathParams.get((Object)StringUtils.fromString((String)(pathSegment = pathSegments[i].substring(1)))) != null) continue;
            String detail = "required path parameter '" + pathSegment + "' is not provided";
            throw ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"FunctionSignatureMismatchError", (BString)StringUtils.fromString((String)detail), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
        }
        return null;
    }

    public static BError validateFieldName(String fieldName, BObject mockObject) {
        GenericMockObjectValue genericMock = (GenericMockObjectValue)mockObject;
        if (!ObjectMock.validateFieldName(fieldName, ((ObjectType)TypeUtils.getImpliedType((Type)genericMock.getType())).getFields())) {
            String detail = "invalid field name '" + fieldName + "' provided";
            throw ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"InvalidMemberFieldError", (BString)StringUtils.fromString((String)detail), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
        }
        return null;
    }

    public static BError validateArguments(BObject caseObj) {
        String mockType = caseObj.getOriginalType().getName();
        GenericMockObjectValue genericMock = (GenericMockObjectValue)caseObj.getObjectValue(StringUtils.fromString((String)"mockObject"));
        String functionName = caseObj.getStringValue(StringUtils.fromString((String)"functionName")).toString();
        BArray argsList = caseObj.getArrayValue(StringUtils.fromString((String)"args"));
        for (MethodType attachedFunction : ((ObjectType)TypeUtils.getImpliedType((Type)genericMock.getType())).getMethods()) {
            if (!attachedFunction.getName().equals(functionName)) continue;
            if (argsList.size() > attachedFunction.getType().getParameters().length) {
                String detail = "too many argument provided to mock the function '" + functionName + "()'";
                return ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"FunctionSignatureMismatchError", (BString)StringUtils.fromString((String)detail), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
            }
            int i = 0;
            BIterator it = argsList.getIterator();
            while (it.hasNext()) {
                Type paramType = TypeUtils.getImpliedType((Type)attachedFunction.getType().getParameters()[i].type);
                if (paramType instanceof UnionType) {
                    UnionType unionType = (UnionType)paramType;
                    Object arg = it.next();
                    boolean isTypeAvailable = false;
                    List memberTypes = unionType.getMemberTypes();
                    for (Type memberType : memberTypes) {
                        if (!TypeChecker.checkIsType((Object)arg, (Type)memberType)) continue;
                        isTypeAvailable = true;
                        break;
                    }
                    if (!isTypeAvailable) {
                        String detail = "incorrect type of argument provided at position '" + (i + 1) + "' to mock the function '" + functionName + "()'";
                        return ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"FunctionSignatureMismatchError", (BString)StringUtils.fromString((String)detail), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
                    }
                } else if (!TypeChecker.checkIsType((Object)it.next(), (Type)paramType)) {
                    String detail = "incorrect type of argument provided at position '" + (i + 1) + "' to mock the function '" + functionName + "()'";
                    return ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"FunctionSignatureMismatchError", (BString)StringUtils.fromString((String)detail), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
                }
                ++i;
            }
            break;
        }
        return null;
    }

    public static BError validatePathArgs(BObject caseObj) {
        GenericMockObjectValue genericMock = (GenericMockObjectValue)caseObj.getObjectValue(StringUtils.fromString((String)"mockObject"));
        String functionName = caseObj.getStringValue(StringUtils.fromString((String)"functionName")).toString();
        String[] pathParamPlaceHolder = ObjectMock.getPathParamPlaceHolders(functionName);
        BArray argsList = caseObj.getArrayValue(StringUtils.fromString((String)"pathArgs"));
        Object functionPattern = ObjectMock.getFunctionNameForResourcePath(functionName);
        String accessor = caseObj.getStringValue(StringUtils.fromString((String)"accessor")).toString();
        functionPattern = "$" + accessor + "$" + (String)functionPattern;
        for (ResourceMethodType attachedFunction : ((BClientType)genericMock.getType()).getResourceMethods()) {
            if (!attachedFunction.getName().endsWith((String)functionPattern)) continue;
            int pathSegmentCount = (int)((String)functionPattern).chars().filter(ch -> ch == "^".charAt(0)).count() - (((String)functionPattern).endsWith("^^") ? 1 : 0);
            if (argsList.size() > pathSegmentCount) {
                String detail = "too many argument provided to mock the function '" + functionName + "()'";
                return ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"FunctionSignatureMismatchError", (BString)StringUtils.fromString((String)detail), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
            }
            int counter = 0;
            BIterator bIterator = argsList.getIterator();
            while (bIterator.hasNext()) {
                Object arg;
                String detail = "incorrect type of path provided for '" + pathParamPlaceHolder[counter] + "' to mock the function '" + functionName;
                Type paramType = TypeUtils.getImpliedType((Type)attachedFunction.getType().getParameters()[counter].type);
                if (paramType instanceof UnionType) {
                    UnionType unionType = (UnionType)paramType;
                    arg = bIterator.next();
                    boolean isTypeAvailable = false;
                    List memberTypes = unionType.getMemberTypes();
                    for (Type memberType : memberTypes) {
                        if (!TypeChecker.checkIsType((Object)arg, (Type)memberType)) continue;
                        isTypeAvailable = true;
                        break;
                    }
                    if (!isTypeAvailable) {
                        return ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"FunctionSignatureMismatchError", (BString)StringUtils.fromString((String)detail), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
                    }
                } else if (paramType instanceof ArrayType ? !(TypeChecker.getType((Object)(arg = bIterator.next())) instanceof ArrayType) : !TypeChecker.checkIsType((Object)bIterator.next(), (Type)paramType)) {
                    return ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"FunctionSignatureMismatchError", (BString)StringUtils.fromString((String)detail), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
                }
                ++counter;
            }
            break;
        }
        return null;
    }

    public static BError validateResourceArguments(BObject caseObj) {
        GenericMockObjectValue genericMock = (GenericMockObjectValue)caseObj.getObjectValue(StringUtils.fromString((String)"mockObject"));
        String functionName = caseObj.getStringValue(StringUtils.fromString((String)"functionName")).toString();
        BArray argsList = caseObj.getArrayValue(StringUtils.fromString((String)"args"));
        Object functionPattern = ObjectMock.getFunctionNameForResourcePath(functionName);
        String accessor = caseObj.getStringValue(StringUtils.fromString((String)"accessor")).toString();
        functionPattern = "$" + accessor + "$" + (String)functionPattern;
        for (ResourceMethodType attachedFunction : ((BClientType)genericMock.getType()).getResourceMethods()) {
            if (!attachedFunction.getName().endsWith((String)functionPattern)) continue;
            int pathSegmentCount = (int)((String)functionPattern).chars().filter(ch -> ch == "^".charAt(0)).count() - (((String)functionPattern).endsWith("^^") ? 1 : 0);
            if (argsList.size() > attachedFunction.getType().getParameters().length - pathSegmentCount) {
                String detail = "too many argument provided to mock the function '" + functionName + "()'";
                return ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"FunctionSignatureMismatchError", (BString)StringUtils.fromString((String)detail), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
            }
            int counter = 0;
            BIterator bIterator = argsList.getIterator();
            while (bIterator.hasNext()) {
                String detail = "incorrect type of argument provided at position '" + (counter + 1) + "' to mock the function '" + functionName;
                Type paramType = TypeUtils.getImpliedType((Type)attachedFunction.getType().getParameters()[counter + pathSegmentCount].type);
                if (paramType instanceof UnionType) {
                    UnionType unionType = (UnionType)paramType;
                    Object arg = bIterator.next();
                    boolean isTypeAvailable = false;
                    List memberTypes = unionType.getMemberTypes();
                    for (Type memberType : memberTypes) {
                        if (!TypeChecker.checkIsType((Object)arg, (Type)memberType)) continue;
                        isTypeAvailable = true;
                        break;
                    }
                    if (!isTypeAvailable) {
                        return ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"FunctionSignatureMismatchError", (BString)StringUtils.fromString((String)detail), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
                    }
                } else if (!TypeChecker.checkIsType((Object)bIterator.next(), (Type)paramType)) {
                    return ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"FunctionSignatureMismatchError", (BString)StringUtils.fromString((String)detail), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
                }
                ++counter;
            }
            break;
        }
        return null;
    }

    public static BError thenReturn(BObject caseObj) {
        String functionName;
        GenericMockObjectValue genericMock = (GenericMockObjectValue)caseObj.get(StringUtils.fromString((String)"mockObject"));
        BObject mockObj = genericMock.getMockObj();
        Object returnVal = caseObj.get(StringUtils.fromString((String)"returnValue"));
        String mockType = caseObj.getOriginalType().getName();
        try {
            functionName = caseObj.getStringValue(StringUtils.fromString((String)"functionName")).toString();
        }
        catch (Exception e) {
            if (!e.getMessage().contains("No such field: functionName")) {
                throw e;
            }
            functionName = null;
        }
        ObjectType objectType = (ObjectType)TypeUtils.getImpliedType((Type)genericMock.getType());
        if (functionName != null) {
            BArray args = caseObj.getArrayValue(StringUtils.fromString((String)"args"));
            if ("MemberResourceFunctionStub".equals(mockType)) {
                BArray pathArgs = caseObj.getArrayValue(StringUtils.fromString((String)"pathArgs"));
                String functionPattern = ObjectMock.getFunctionNameForResourcePath(functionName);
                String accessor = caseObj.getStringValue(StringUtils.fromString((String)"accessor")).toString();
                Object resourceFunctionPattern = "$" + accessor + "$" + functionPattern;
                if (!ObjectMock.validateReturnValueForResourcePath((String)resourceFunctionPattern, returnVal, (MethodType[])((BClientType)objectType).getResourceMethods())) {
                    String detail = "return value provided does not match the return type of the resource path '" + functionName + "'";
                    return ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"FunctionSignatureMismatchError", (BString)StringUtils.fromString((String)detail), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
                }
                resourceFunctionPattern = ObjectMock.replacePathPlaceHolders((String)resourceFunctionPattern, pathArgs);
                MockRegistry.getInstance().registerCase(mockObj, (String)resourceFunctionPattern, args, returnVal);
            } else {
                if (!ObjectMock.validateReturnValue(functionName, returnVal, objectType.getMethods())) {
                    String detail = "return value provided does not match the return type of function '" + functionName + "()'";
                    return ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"FunctionSignatureMismatchError", (BString)StringUtils.fromString((String)detail), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
                }
                MockRegistry.getInstance().registerCase(mockObj, functionName, args, returnVal);
            }
        } else {
            String fieldName = caseObj.getStringValue(StringUtils.fromString((String)"fieldName")).toString();
            if (!ObjectMock.validateFieldAccessIsPublic(objectType, fieldName)) {
                String detail = "member field should be public to be mocked. The provided field '" + fieldName + "' is not public";
                return ErrorCreator.createError((BString)StringUtils.fromString((String)"NonPublicMemberFieldError"), (BString)StringUtils.fromString((String)detail));
            }
            if (!ObjectMock.validateFieldValue(returnVal, ((Field)objectType.getFields().get(fieldName)).getFieldType())) {
                String detail = "return value provided does not match the type of '" + fieldName + "'";
                return ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"InvalidMemberFieldError", (BString)StringUtils.fromString((String)detail), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
            }
            MockRegistry.getInstance().registerCase(mockObj, fieldName, null, returnVal);
        }
        return null;
    }

    private static String replacePathPlaceHolders(String functionPattern, BArray pathArgs) {
        int caretCount = (int)functionPattern.chars().filter(ch -> ch == "^".charAt(0)).count();
        Object[] args = pathArgs.getValues();
        BArray restArgs = null;
        StringBuilder newFuncName = new StringBuilder(functionPattern);
        if (functionPattern.endsWith("^^")) {
            restArgs = (BArray)args[caretCount - 2];
        }
        if (restArgs != null) {
            newFuncName.setLength(0);
            String substring = functionPattern.substring(0, functionPattern.length() - 2);
            newFuncName.append(substring);
            for (int i = 0; i < restArgs.size(); ++i) {
                Object arg = restArgs.get((long)i);
                if (arg == null) continue;
                newFuncName.append(arg).append("$");
            }
            newFuncName.setLength(newFuncName.length() - 1);
            caretCount -= 2;
        }
        for (int i = 0; i < caretCount; ++i) {
            if (args[i] == null) continue;
            newFuncName.replace(newFuncName.indexOf("^"), newFuncName.indexOf("^") + 1, args[i].toString());
        }
        return newFuncName.toString();
    }

    private static boolean validateFieldAccessIsPublic(ObjectType objectType, String fieldName) {
        return SymbolFlags.isFlagOn((long)((Field)objectType.getFields().get(fieldName)).getFlags(), (long)1L);
    }

    public static BError thenReturnSequence(BObject caseObj) {
        Object returnValue;
        String mockType = caseObj.getOriginalType().getName();
        GenericMockObjectValue genericMock = (GenericMockObjectValue)caseObj.get(StringUtils.fromString((String)"mockObject"));
        ObjectType objectType = (ObjectType)TypeUtils.getImpliedType((Type)genericMock.getType());
        BObject mockObj = genericMock.getMockObj();
        String functionName = caseObj.getStringValue(StringUtils.fromString((String)"functionName")).toString();
        BArray returnValueSequence = caseObj.getArrayValue(StringUtils.fromString((String)"returnValueSeq"));
        for (int i = 0; i < returnValueSequence.getValues().length && (returnValue = returnValueSequence.getValues()[i]) != null; ++i) {
            if ("MemberResourceFunctionStub".equals(mockType)) {
                String functionPattern = ObjectMock.getFunctionNameForResourcePath(functionName);
                String accessor = caseObj.getStringValue(StringUtils.fromString((String)"accessor")).toString();
                String resourceFunctionPattern = "$" + accessor + "$" + functionPattern;
                if (!ObjectMock.validateReturnValueForResourcePath(resourceFunctionPattern, returnValue, (MethodType[])((BClientType)objectType).getResourceMethods())) {
                    String detail = "return value provided at position '" + i + "' does not match the return type of the resource path '" + functionName + "'";
                    return ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"FunctionSignatureMismatchError", (BString)StringUtils.fromString((String)detail), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
                }
                MockRegistry.getInstance().registerCase(mockObj, resourceFunctionPattern, null, returnValue, i + 1);
                continue;
            }
            if (!ObjectMock.validateReturnValue(functionName, returnValue, ((ObjectType)TypeUtils.getImpliedType((Type)genericMock.getType())).getMethods())) {
                String detail = "return value provided at position '" + i + "' does not match the return type of function '" + functionName + "()'";
                return ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"FunctionSignatureMismatchError", (BString)StringUtils.fromString((String)detail), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
            }
            MockRegistry.getInstance().registerCase(mockObj, functionName, null, returnValue, i + 1);
        }
        return null;
    }

    private static boolean validateFunctionName(String functionName, MethodType[] attachedFunctions) {
        for (MethodType attachedFunction : attachedFunctions) {
            if (!attachedFunction.getName().equals(functionName)) continue;
            return true;
        }
        return false;
    }

    private static boolean validateResourcePath(String resourcePath, ResourceMethodType[] attachedFunctions) {
        String functionPattern = ObjectMock.getFunctionNameForResourcePath(resourcePath);
        for (ResourceMethodType attachedFunction : attachedFunctions) {
            if (!attachedFunction.getName().endsWith(functionPattern)) continue;
            return true;
        }
        return false;
    }

    private static String getFunctionNameForResourcePath(String path) {
        CharSequence[] components = path.split("/");
        for (int i = 0; i < components.length; ++i) {
            if (components[i].startsWith("::")) {
                components[i] = "^^";
                continue;
            }
            if (!((String)components[i]).startsWith(":")) continue;
            components[i] = "^";
        }
        return String.join((CharSequence)"$", components);
    }

    private static String[] getPathParamPlaceHolders(String path) {
        String[] components;
        ArrayList<String> placeHolderList = new ArrayList<String>();
        for (String component : components = path.split("/")) {
            if (component.startsWith("::")) {
                placeHolderList.add(component.substring(2));
                continue;
            }
            if (!component.startsWith(":")) continue;
            placeHolderList.add(component.substring(1));
        }
        return placeHolderList.toArray(new String[0]);
    }

    private static boolean validateFieldName(String fieldName, Map<String, Field> fieldMap) {
        for (Map.Entry<String, Field> field : fieldMap.entrySet()) {
            if (!field.getKey().equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    private static boolean validateParameterizedValue(Object returnVal, ParameterizedType functionReturnType) {
        return TypeChecker.checkIsType((Object)returnVal, (Type)functionReturnType.getParamValueType());
    }

    private static boolean validateUnionValue(Object returnVal, UnionType functionReturnType) {
        List memberTypes = functionReturnType.getMemberTypes();
        for (Type memberType : memberTypes) {
            if (!(TypeUtils.getImpliedType((Type)memberType).getTag() == 52 ? ObjectMock.validateParameterizedValue(returnVal, (ParameterizedType)memberType) : TypeChecker.checkIsType((Object)returnVal, (Type)memberType))) continue;
            return true;
        }
        return false;
    }

    private static boolean validateStreamValue(Object returnVal, StreamType streamType) {
        Type sourceType = TypeUtils.getImpliedType((Type)TypeChecker.getType((Object)returnVal));
        if (sourceType.getTag() == 26) {
            Type targetConstrainedType = TypeUtils.getImpliedType((Type)streamType.getConstrainedType());
            Type targetCompletionType = TypeUtils.getImpliedType((Type)streamType.getCompletionType());
            if (targetConstrainedType.getTag() == 52) {
                targetConstrainedType = ((ParameterizedType)targetConstrainedType).getParamValueType();
            }
            if (targetCompletionType.getTag() == 52) {
                targetCompletionType = ((ParameterizedType)targetCompletionType).getParamValueType();
            }
            return TypeChecker.checkIsType((Type)((StreamType)sourceType).getConstrainedType(), (Type)targetConstrainedType) && TypeChecker.checkIsType((Type)((StreamType)sourceType).getCompletionType(), (Type)targetCompletionType);
        }
        return false;
    }

    private static boolean validateReturnValue(String functionName, Object returnVal, MethodType[] attachedFunctions) {
        for (MethodType attachedFunction : attachedFunctions) {
            if (!attachedFunction.getName().equals(functionName)) continue;
            return ObjectMock.isValidReturnValue(returnVal, attachedFunction);
        }
        return false;
    }

    private static boolean validateReturnValueForResourcePath(String functionPattern, Object returnVal, MethodType[] attachedFunctions) {
        for (MethodType attachedFunction : attachedFunctions) {
            if (!attachedFunction.getName().endsWith(functionPattern)) continue;
            return ObjectMock.isValidReturnValue(returnVal, attachedFunction);
        }
        return false;
    }

    private static boolean isValidReturnValue(Object returnVal, MethodType attachedFunction) {
        Type functionReturnType = TypeUtils.getImpliedType((Type)attachedFunction.getType().getReturnParameterType());
        return switch (functionReturnType.getTag()) {
            case 33 -> ObjectMock.validateUnionValue(returnVal, (UnionType)functionReturnType);
            case 26 -> ObjectMock.validateStreamValue(returnVal, (StreamType)functionReturnType);
            case 52 -> ObjectMock.validateParameterizedValue(returnVal, (ParameterizedType)functionReturnType);
            default -> TypeChecker.checkIsType((Object)returnVal, (Type)functionReturnType);
        };
    }

    private static boolean validateFieldValue(Object returnVal, Type fieldType) {
        return TypeChecker.checkIsType((Object)returnVal, (Type)fieldType);
    }

    private static BError validateFunctionSignatures(MethodType func, MethodType[] attachedFunctions) {
        String functionName = func.getName();
        Parameter[] parameters = func.getParameters();
        Type returnType = func.getType().getReturnParameterType();
        for (MethodType attachedFunction : attachedFunctions) {
            if (!attachedFunction.getName().equals(functionName)) continue;
            if (parameters.length != attachedFunction.getParameters().length) {
                String detail = "incorrect number of parameters provided for function '" + functionName + "()'";
                return ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"FunctionSignatureMismatchError", (BString)StringUtils.fromString((String)detail), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
            }
            for (int i = 0; i < parameters.length; ++i) {
                Type paramTypeAttachedFunc = TypeUtils.getImpliedType((Type)attachedFunction.getType().getParameters()[i].type);
                Type paramType = TypeUtils.getImpliedType((Type)parameters[i].type);
                if (paramTypeAttachedFunc instanceof UnionType) {
                    UnionType unionParamTypeAttachedFunc = (UnionType)paramTypeAttachedFunc;
                    if (!(paramType instanceof UnionType)) {
                        String detail = "incompatible parameter type provided at position " + (i + 1) + " in function '" + functionName + "()'. parameter should be of union type ";
                        return ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"FunctionSignatureMismatchError", (BString)StringUtils.fromString((String)detail), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
                    }
                    UnionType unionParamType = (UnionType)paramType;
                    Type[] memberTypes = unionParamTypeAttachedFunc.getMemberTypes().toArray(new Type[0]);
                    Type[] providedTypes = unionParamType.getMemberTypes().toArray(new Type[0]);
                    for (int j = 0; j < memberTypes.length; ++j) {
                        if (TypeChecker.checkIsType((Type)providedTypes[j], (Type)memberTypes[j])) continue;
                        BString detail = StringUtils.fromString((String)("incompatible parameter type provided at position " + (i + 1) + " in function '" + functionName + "()'"));
                        return ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"FunctionSignatureMismatchError", (BString)detail, null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
                    }
                    continue;
                }
                if (TypeChecker.checkIsType((Type)paramType, (Type)paramTypeAttachedFunc)) continue;
                BString detail = StringUtils.fromString((String)("incompatible parameter type provided at position " + (i + 1) + " in function '" + functionName + "()'"));
                return ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"FunctionSignatureMismatchError", (BString)detail, null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
            }
            if (!TypeChecker.checkIsType((Type)attachedFunction.getType().getReturnParameterType(), (Type)returnType)) {
                String detail = "incompatible return type provided for function '" + functionName + "()'";
                return ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"FunctionSignatureMismatchError", (BString)StringUtils.fromString((String)detail), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
            }
            return null;
        }
        String detail = "invalid function '" + functionName + "' provided";
        return ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"FunctionSignatureMismatchError", (BString)StringUtils.fromString((String)detail), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
    }

    private static BError validateField(Map.Entry<String, Field> mockField, Map<String, Field> fieldMap) {
        for (Map.Entry<String, Field> field : fieldMap.entrySet()) {
            if (!field.getKey().equals(mockField.getKey())) continue;
            if (SymbolFlags.isFlagOn((long)field.getValue().getFlags(), (long)1024L) || TypeChecker.checkIsType((Type)field.getValue().getFieldType(), (Type)mockField.getValue().getFieldType())) {
                return null;
            }
            String detail = "incompatible field type '" + String.valueOf(mockField.getValue().getFieldType()) + "' provided for field " + mockField.getKey();
            return ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"InvalidMemberFieldError", (BString)StringUtils.fromString((String)detail), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
        }
        String detail = "invalid field '" + mockField.getKey() + "' provided";
        return ErrorCreator.createError((Module)MockConstants.TEST_PACKAGE_ID, (String)"InvalidMemberFieldError", (BString)StringUtils.fromString((String)detail), null, (BMap)new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
    }
}

