/*
 * Decompiled with CFR 0.152.
 */
package com.github.difflib.patch;

import com.github.difflib.patch.PatchFailedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class Chunk<T> {
    private final int position;
    private List<T> lines;

    public Chunk(int position, List<T> lines) {
        this.position = position;
        this.lines = new ArrayList<T>(lines);
    }

    public Chunk(int position, T[] lines) {
        this.position = position;
        this.lines = Arrays.asList(lines);
    }

    public void verify(List<T> target) throws PatchFailedException {
        if (this.position > target.size() || this.last() > target.size()) {
            throw new PatchFailedException("Incorrect Chunk: the position of chunk > target size");
        }
        for (int i = 0; i < this.size(); ++i) {
            if (target.get(this.position + i).equals(this.lines.get(i))) continue;
            throw new PatchFailedException("Incorrect Chunk: the chunk content doesn't match the target");
        }
    }

    public int getPosition() {
        return this.position;
    }

    public void setLines(List<T> lines) {
        this.lines = lines;
    }

    public List<T> getLines() {
        return this.lines;
    }

    public int size() {
        return this.lines.size();
    }

    public int last() {
        return this.getPosition() + this.size() - 1;
    }

    public int hashCode() {
        return Objects.hash(this.lines, this.position, this.size());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Chunk other = (Chunk)obj;
        if (this.lines == null ? other.lines != null : !this.lines.equals(other.lines)) {
            return false;
        }
        return this.position == other.position;
    }

    public String toString() {
        return "[position: " + this.position + ", size: " + this.size() + ", lines: " + this.lines + "]";
    }
}

