/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.os.compiler.staticcodeanalyzer;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeLocation;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.projects.Document;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.scan.Reporter;
import io.ballerina.stdlib.os.compiler.staticcodeanalyzer.OSRule;
import io.ballerina.tools.diagnostics.Location;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class OSCommandInjectionAnalyzer
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    private final Reporter reporter;

    public OSCommandInjectionAnalyzer(Reporter reporter) {
        this.reporter = reporter;
    }

    public void perform(SyntaxNodeAnalysisContext context) {
        Node node = context.node();
        if (!(node instanceof FunctionCallExpressionNode)) {
            return;
        }
        FunctionCallExpressionNode functionCall = (FunctionCallExpressionNode)node;
        Document document = OSCommandInjectionAnalyzer.getDocument(context);
        List<String> importPrefix = new ArrayList<String>();
        Node node2 = document.syntaxTree().rootNode();
        if (node2 instanceof ModulePartNode) {
            ModulePartNode modulePartNode = (ModulePartNode)node2;
            importPrefix = modulePartNode.imports().stream().filter(importDeclarationNode -> {
                ImportOrgNameNode importOrgNameNode = importDeclarationNode.orgName().orElse(null);
                return importOrgNameNode != null && "ballerina".equals(importOrgNameNode.orgName().text());
            }).filter(importDeclarationNode -> importDeclarationNode.moduleName().stream().anyMatch(moduleNameNode -> "os".equals(moduleNameNode.text()))).map(importDeclarationNode -> {
                ImportPrefixNode importPrefixNode = importDeclarationNode.prefix().orElse(null);
                return importPrefixNode != null ? importPrefixNode.prefix().text() : "os";
            }).toList();
        }
        if (!OSCommandInjectionAnalyzer.isOsExecCall(functionCall, importPrefix)) {
            return;
        }
        if (this.containsUserControlledInput((SeparatedNodeList<FunctionArgumentNode>)functionCall.arguments(), context)) {
            NodeLocation location = functionCall.location();
            this.reporter.reportIssue(document, (Location)location, OSRule.AVOID_UNSANITIZED_CMD_ARGS.getId());
        }
    }

    public static boolean isOsExecCall(FunctionCallExpressionNode functionCall, List<String> importPrefix) {
        NameReferenceNode nameReferenceNode = functionCall.functionName();
        if (!(nameReferenceNode instanceof QualifiedNameReferenceNode)) {
            return false;
        }
        QualifiedNameReferenceNode qNode = (QualifiedNameReferenceNode)nameReferenceNode;
        return importPrefix.contains(qNode.modulePrefix().text()) && qNode.identifier().text().equals("exec");
    }

    public static Document getDocument(SyntaxNodeAnalysisContext context) {
        return context.currentPackage().module(context.moduleId()).document(context.documentId());
    }

    private boolean containsUserControlledInput(SeparatedNodeList<FunctionArgumentNode> arguments, SyntaxNodeAnalysisContext context) {
        for (FunctionArgumentNode arg : arguments) {
            ExpressionNode expr = this.extractExpression(arg);
            if (expr == null || !this.isMappingConstructorWithUserControlledInput(expr, context)) continue;
            return true;
        }
        return false;
    }

    private ExpressionNode extractExpression(FunctionArgumentNode arg) {
        FunctionArgumentNode functionArgumentNode = arg;
        Objects.requireNonNull(functionArgumentNode);
        FunctionArgumentNode functionArgumentNode2 = functionArgumentNode;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PositionalArgumentNode.class, NamedArgumentNode.class}, (Object)functionArgumentNode2, n)) {
            case 0 -> {
                PositionalArgumentNode posArg = (PositionalArgumentNode)functionArgumentNode2;
                yield posArg.expression();
            }
            case 1 -> {
                NamedArgumentNode namedArg = (NamedArgumentNode)functionArgumentNode2;
                yield namedArg.expression();
            }
            default -> null;
        };
    }

    private boolean isMappingConstructorWithUserControlledInput(ExpressionNode expr, SyntaxNodeAnalysisContext context) {
        if (!(expr instanceof MappingConstructorExpressionNode)) {
            return false;
        }
        MappingConstructorExpressionNode mappingNode = (MappingConstructorExpressionNode)expr;
        return mappingNode.fields().stream().filter(field -> {
            boolean bl;
            if (field instanceof SpecificFieldNode) {
                SpecificFieldNode specificField = (SpecificFieldNode)field;
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).map(field -> (SpecificFieldNode)field).anyMatch(specificField -> this.isUserControlledField((SpecificFieldNode)specificField, context));
    }

    private boolean isUserControlledField(SpecificFieldNode specificField, SyntaxNodeAnalysisContext context) {
        String fieldName = specificField.fieldName().toString().trim();
        if (!fieldName.equals("arguments")) {
            return false;
        }
        ExpressionNode valueExpr = specificField.valueExpr().orElse(null);
        return valueExpr != null && this.containsUserControlledInput(valueExpr, context);
    }

    private boolean containsUserControlledInput(ExpressionNode valueExpr, SyntaxNodeAnalysisContext context) {
        SimpleNameReferenceNode refNode;
        if (valueExpr instanceof ListConstructorExpressionNode) {
            ListConstructorExpressionNode listNode = (ListConstructorExpressionNode)valueExpr;
            return listNode.expressions().stream().anyMatch(item -> this.isUserControlledInput((Node)item, context));
        }
        return valueExpr instanceof SimpleNameReferenceNode && this.isUserControlledInput((Node)(refNode = (SimpleNameReferenceNode)valueExpr), context);
    }

    private boolean isUserControlledInput(Node node, SyntaxNodeAnalysisContext context) {
        SemanticModel semanticModel = context.semanticModel();
        if (!semanticModel.symbol(node).isPresent()) {
            return false;
        }
        Symbol symbol = (Symbol)semanticModel.symbol(node).get();
        if (symbol.kind() == SymbolKind.PARAMETER && this.isInsidePublicFunction(node)) {
            return true;
        }
        if (symbol.kind() == SymbolKind.VARIABLE) {
            return this.isAssignedUserControlledInput(node);
        }
        return false;
    }

    private boolean isInsidePublicFunction(Node node) {
        Node parent = node;
        while (parent != null) {
            if (parent instanceof FunctionDefinitionNode) {
                FunctionDefinitionNode functionNode = (FunctionDefinitionNode)parent;
                return functionNode.qualifierList().stream().anyMatch(q -> q.text().equals("public"));
            }
            parent = node.parent();
        }
        return false;
    }

    private boolean isAssignedUserControlledInput(Node node) {
        for (NonTerminalNode parent = node.parent(); parent != null; parent = parent.parent()) {
            FunctionDefinitionNode functionNode;
            if (!(parent instanceof FunctionDefinitionNode) || !this.isInsidePublicFunction((Node)(functionNode = (FunctionDefinitionNode)parent))) continue;
            for (ParameterNode param : functionNode.functionSignature().parameters()) {
                String paramName = ((Token)((RequiredParameterNode)param).paramName().get()).text();
                if (!this.isVariableAssignedFrom(node, paramName, functionNode)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isVariableAssignedFrom(Node variable, String paramName, FunctionDefinitionNode functionNode) {
        FunctionBodyNode body = functionNode.functionBody();
        if (body instanceof FunctionBodyBlockNode) {
            FunctionBodyBlockNode blockBody = (FunctionBodyBlockNode)body;
            for (StatementNode statement : blockBody.statements()) {
                if (this.isVariableDeclaredWithParam(statement, paramName)) {
                    return true;
                }
                if (!this.isVariableAssignedWithParam(statement, variable, paramName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isVariableDeclaredWithParam(StatementNode statement, String paramName) {
        if (!(statement instanceof VariableDeclarationNode)) {
            return false;
        }
        VariableDeclarationNode varDecl = (VariableDeclarationNode)statement;
        return varDecl.initializer().map(initializer -> this.isExpressionMatchingParam((ExpressionNode)initializer, paramName)).orElse(false);
    }

    private boolean isVariableAssignedWithParam(StatementNode statement, Node variable, String paramName) {
        if (!(statement instanceof AssignmentStatementNode)) {
            return false;
        }
        AssignmentStatementNode assignment = (AssignmentStatementNode)statement;
        String assignedVar = assignment.varRef().toSourceCode();
        ExpressionNode assignedValue = assignment.expression();
        if (!assignedVar.equals(variable.toSourceCode())) {
            return false;
        }
        return this.isExpressionMatchingParam(assignedValue, paramName);
    }

    private boolean isExpressionMatchingParam(ExpressionNode expression, String paramName) {
        if (expression.toSourceCode().equals(paramName)) {
            return true;
        }
        if (expression instanceof ListConstructorExpressionNode) {
            ListConstructorExpressionNode listExpr = (ListConstructorExpressionNode)expression;
            return listExpr.expressions().stream().anyMatch(item -> item.toSourceCode().equals(paramName));
        }
        return false;
    }
}

