/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class BallerinaKeywordsProvider {
    public static final List<String> BALLERINA_KEYWORDS = BallerinaKeywordsProvider.getBallerinaKeywords();

    private BallerinaKeywordsProvider() {
    }

    private static List<String> getBallerinaKeywords() {
        try {
            Class<?> aClass = Class.forName("io.ballerina.compiler.internal.parser.LexerTerminals");
            return Arrays.stream(aClass.getDeclaredFields()).filter(field -> field.getModifiers() == 25 && field.getType() == String.class).map(field -> {
                try {
                    return field.get(null).toString();
                }
                catch (IllegalAccessException e) {
                    return null;
                }
            }).filter(Objects::nonNull).toList();
        }
        catch (ClassNotFoundException e) {
            return Collections.emptyList();
        }
    }
}

