/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.TypeBuilder;
import io.ballerina.compiler.api.Types;
import io.ballerina.compiler.api.impl.LangLibFunctionBinder;
import io.ballerina.compiler.api.impl.LangLibrary;
import io.ballerina.compiler.api.impl.NodeFinder;
import io.ballerina.compiler.api.impl.PositionUtil;
import io.ballerina.compiler.api.impl.TypeParamFinder;
import io.ballerina.compiler.api.impl.symbols.BallerinaArrayTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.impl.util.SymbolUtils;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.StreamTypeSymbol;
import io.ballerina.compiler.api.symbols.StringTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.BinaryExpressionNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.ClientResourceAccessActionNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.ErrorConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.ExplicitAnonymousFunctionExpressionNode;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionFunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.FromClauseNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.IfElseStatementNode;
import io.ballerina.compiler.syntax.tree.ImplicitAnonymousFunctionExpressionNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.IndexedExpressionNode;
import io.ballerina.compiler.syntax.tree.KeySpecifierNode;
import io.ballerina.compiler.syntax.tree.LetVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.ListenerDeclarationNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingMatchPatternNode;
import io.ballerina.compiler.syntax.tree.MatchClauseNode;
import io.ballerina.compiler.syntax.tree.MatchStatementNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.RecordFieldWithDefaultValueNode;
import io.ballerina.compiler.syntax.tree.RemoteMethodCallActionNode;
import io.ballerina.compiler.syntax.tree.SelectClauseNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TableConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.WaitActionNode;
import io.ballerina.compiler.syntax.tree.WhileStatementNode;
import io.ballerina.projects.Document;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeReferenceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLType;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangSelectClause;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangArrowFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangFieldBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIndexBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNumericLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitExpr;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class ExpectedTypeFinder
extends NodeTransformer<Optional<TypeSymbol>> {
    private final SemanticModel semanticModel;
    private final BLangCompilationUnit bLangCompilationUnit;
    private final List<Node> visitedNodes = new ArrayList<Node>();
    private final TypesFactory typesFactory;
    private final LinePosition linePosition;
    private final NodeFinder nodeFinder = new NodeFinder(true);
    private final Document document;
    private final LangLibrary langLibrary;
    private final LangLibFunctionBinder langLibFunctionBinder;
    private FunctionArgumentNode functionArgNodeAtCursor;

    public ExpectedTypeFinder(SemanticModel semanticModel, BLangCompilationUnit bLangCompilationUnit, CompilerContext context, LinePosition linePosition, Document srcDocument) {
        this.semanticModel = semanticModel;
        this.bLangCompilationUnit = bLangCompilationUnit;
        this.typesFactory = TypesFactory.getInstance(context);
        this.linePosition = linePosition;
        this.document = srcDocument;
        this.langLibrary = LangLibrary.getInstance(context);
        this.langLibFunctionBinder = new LangLibFunctionBinder(context);
    }

    public Optional<TypeSymbol> transform(SimpleNameReferenceNode node) {
        Optional expectedType;
        BLangNode bLangNode = this.nodeFinder.lookup(this.bLangCompilationUnit, node.lineRange());
        if (bLangNode == null) {
            Optional<Symbol> symbol = this.findSymbolByName(node.name().text());
            if (symbol.isEmpty()) {
                return Optional.empty();
            }
            return SymbolUtils.getTypeDescriptor(symbol.get());
        }
        if ((node.parent().kind() == SyntaxKind.POSITIONAL_ARG || node.parent().kind() == SyntaxKind.NAMED_ARG) && (expectedType = (Optional)node.parent().apply((NodeTransformer)this)).isPresent()) {
            return expectedType;
        }
        return this.getExpectedType(bLangNode);
    }

    public Optional<TypeSymbol> transform(AnnotationNode node) {
        Optional<Symbol> annotationSymbol;
        Node annotationRef = node.annotReference();
        Predicate<Symbol> predicate = symbol -> symbol.getName().isPresent() && symbol.kind() == io.ballerina.compiler.api.symbols.SymbolKind.ANNOTATION;
        if (annotationRef.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)annotationRef;
            Predicate<Symbol> qNamePredicate = predicate.and(symbol -> symbol.getName().get().equals(qNameRef.identifier().text()));
            annotationSymbol = this.getQNameReferenceSymbol(qNameRef, qNamePredicate);
        } else if (annotationRef.kind() == SyntaxKind.SIMPLE_NAME_REFERENCE) {
            annotationSymbol = this.findSymbolByName(((SimpleNameReferenceNode)annotationRef).name().text(), predicate);
        } else {
            return Optional.empty();
        }
        if (annotationSymbol.isEmpty()) {
            return Optional.empty();
        }
        return ((AnnotationSymbol)annotationSymbol.get()).typeDescriptor();
    }

    public Optional<TypeSymbol> transform(SpecificFieldNode node) {
        BLangNode bLangNode = this.nodeFinder.lookup(this.bLangCompilationUnit, node.lineRange());
        if (bLangNode == null) {
            return Optional.empty();
        }
        if (bLangNode instanceof BLangRecordLiteral.BLangRecordVarNameField) {
            BLangRecordLiteral.BLangRecordVarNameField bLangNodeRecLiteral = (BLangRecordLiteral.BLangRecordVarNameField)bLangNode;
            if (bLangNodeRecLiteral.symbol != null && node.parent().kind() == SyntaxKind.MAPPING_CONSTRUCTOR) {
                BLangTypeConversionExpr bLangExpression = bLangNodeRecLiteral.impConversionExpr;
                if (bLangExpression != null && bLangExpression.getBType().getKind() == TypeKind.ANY) {
                    BType bType = bLangExpression.getBType();
                    return this.getTypeFromBType(bType);
                }
                Optional<TypeSymbol> elementType = this.getTypeFromBType(bLangNodeRecLiteral.symbol.getType());
                if (elementType.isPresent()) {
                    return elementType;
                }
            }
        }
        return this.getExpectedType(bLangNode);
    }

    public Optional<TypeSymbol> transform(ObjectFieldNode node) {
        BLangNode bLangNode = this.nodeFinder.lookup(this.bLangCompilationUnit, node.lineRange());
        return this.getExpectedType(bLangNode);
    }

    public Optional<TypeSymbol> transform(BasicLiteralNode node) {
        BLangNode bLangNode = this.nodeFinder.lookup(this.bLangCompilationUnit, node.lineRange());
        return this.getTypeFromBType(bLangNode.getBType());
    }

    public Optional<TypeSymbol> transform(AssignmentStatementNode node) {
        return this.visit(node.varRef());
    }

    public Optional<TypeSymbol> transform(FieldAccessExpressionNode node) {
        BLangNode bLangNode = this.nodeFinder.lookup(this.bLangCompilationUnit, node.lineRange());
        return this.getExpectedType(bLangNode);
    }

    public Optional<TypeSymbol> transform(LetVariableDeclarationNode node) {
        return this.visit((Node)node.typedBindingPattern().bindingPattern());
    }

    public Optional<TypeSymbol> transform(ListenerDeclarationNode node) {
        Optional typeDesc = node.typeDescriptor();
        return typeDesc.isEmpty() ? Optional.empty() : (Optional)((TypeDescriptorNode)typeDesc.get()).apply((NodeTransformer)this);
    }

    public Optional<TypeSymbol> transform(ModuleVariableDeclarationNode node) {
        return this.visit((Node)node.typedBindingPattern().bindingPattern());
    }

    public Optional<TypeSymbol> transform(VariableDeclarationNode node) {
        if (node.typedBindingPattern().typeDescriptor().kind() == SyntaxKind.VAR_TYPE_DESC) {
            Types types = this.semanticModel.types();
            TypeBuilder builder = types.builder();
            UnionTypeSymbol unionTypeSymbol = builder.UNION_TYPE.withMemberTypes(types.ANY, types.ERROR).build();
            return Optional.of(unionTypeSymbol);
        }
        return this.visit((Node)node.typedBindingPattern().bindingPattern());
    }

    public Optional<TypeSymbol> transform(BinaryExpressionNode node) {
        if (!node.operator().isMissing() && node.operator().kind() == SyntaxKind.ASTERISK_TOKEN || node.operator().kind() == SyntaxKind.SLASH_TOKEN) {
            return Optional.empty();
        }
        BLangNode bLangNode = this.nodeFinder.lookup(this.bLangCompilationUnit, node.lineRange());
        if (!(bLangNode instanceof BLangBinaryExpr)) {
            return Optional.empty();
        }
        BLangBinaryExpr bLangBinaryExpr = (BLangBinaryExpr)bLangNode;
        BLangExpression rhs = bLangBinaryExpr.rhsExpr;
        BLangExpression lhs = bLangBinaryExpr.lhsExpr;
        BType rhsExpType = rhs.expectedType;
        if (rhsExpType == null || lhs.expectedType == null) {
            return Optional.empty();
        }
        if (rhsExpType.getKind() != TypeKind.OTHER) {
            return this.getExpectedType(rhs);
        }
        return this.getExpectedType(lhs);
    }

    public Optional<TypeSymbol> transform(FunctionCallExpressionNode node) {
        BLangNode bLangNode = this.nodeFinder.lookup(this.bLangCompilationUnit, node.lineRange());
        if (!(bLangNode instanceof BLangInvocation)) {
            return Optional.empty();
        }
        BLangInvocation bLangInvocation = (BLangInvocation)bLangNode;
        return bLangInvocation.symbol instanceof BInvokableSymbol && !bLangInvocation.getRequiredArgs().isEmpty() ? this.transformFunctionOrMethod(bLangNode, ((BLangNode)((Object)bLangInvocation.getRequiredArgs().get(0))).getBType(), (BInvokableSymbol)bLangInvocation.symbol, (SeparatedNodeList<FunctionArgumentNode>)node.arguments(), node.openParenToken(), node.closeParenToken(), true) : this.getExpectedTypeFromFunction(bLangNode, node.openParenToken(), node.closeParenToken());
    }

    public Optional<TypeSymbol> transform(MethodCallExpressionNode node) {
        BLangNode bLangNode = this.nodeFinder.lookup(this.bLangCompilationUnit, node.lineRange());
        if (!(bLangNode instanceof BLangInvocation)) {
            return Optional.empty();
        }
        BLangNode bLangFunctionCall = this.nodeFinder.lookup(this.bLangCompilationUnit, node.expression().lineRange());
        BInvokableSymbol bLangOriginalLangLib = this.langLibrary.getLangLibMethod(bLangFunctionCall.getBType(), SymbolUtils.unescapeUnicode(node.methodName().toString()));
        return this.transformFunctionOrMethod(bLangNode, bLangFunctionCall.getBType(), bLangOriginalLangLib, (SeparatedNodeList<FunctionArgumentNode>)node.arguments(), node.openParenToken(), node.closeParenToken(), false);
    }

    public Optional<TypeSymbol> transform(QualifiedNameReferenceNode node) {
        if (node.identifier().isMissing()) {
            return Optional.empty();
        }
        BLangNode bLangNode = this.nodeFinder.lookup(this.bLangCompilationUnit, node.lineRange());
        if (bLangNode == null) {
            return Optional.empty();
        }
        if (bLangNode instanceof BLangSimpleVarRef) {
            BLangSimpleVarRef simpleVarRef = (BLangSimpleVarRef)bLangNode;
            if (((BLangSimpleVarRef)bLangNode).symbol != null) {
                return this.getTypeFromBType(simpleVarRef.symbol.getType());
            }
        }
        if (bLangNode instanceof BLangUserDefinedType) {
            BLangUserDefinedType userDefinedType = (BLangUserDefinedType)bLangNode;
            if (userDefinedType.symbol != null) {
                return this.getTypeFromBType(userDefinedType.symbol.getType());
            }
        }
        return Optional.empty();
    }

    public Optional<TypeSymbol> transform(ExplicitAnonymousFunctionExpressionNode node) {
        BLangNode bLangNode = this.nodeFinder.lookup(this.bLangCompilationUnit, node.lineRange());
        if (!(bLangNode instanceof BLangFunction)) {
            return Optional.empty();
        }
        return Optional.of(this.typesFactory.getTypeDescriptor(((BLangFunction)this.nodeFinder.lookup((BLangCompilationUnit)this.bLangCompilationUnit, (LineRange)node.lineRange())).returnTypeNode.getBType()));
    }

    public Optional<TypeSymbol> transform(ImplicitAnonymousFunctionExpressionNode node) {
        BLangNode bLangNode = this.nodeFinder.lookup(this.bLangCompilationUnit, node.lineRange());
        if (!(bLangNode instanceof BLangArrowFunction)) {
            return Optional.empty();
        }
        BLangArrowFunction arrowFunction = (BLangArrowFunction)bLangNode;
        if (!node.rightDoubleArrow().isMissing() && node.rightDoubleArrow().lineRange().endLine().offset() <= this.linePosition.offset()) {
            BType funcType = arrowFunction.funcType;
            if (funcType == null) {
                return Optional.empty();
            }
            return Optional.of(this.typesFactory.getTypeDescriptor(funcType.getReturnType()));
        }
        return Optional.empty();
    }

    public Optional<TypeSymbol> transform(PositionalArgumentNode node) {
        BLangNode bLangNode;
        if (node.parent().kind() == SyntaxKind.METHOD_CALL || node.parent().kind() == SyntaxKind.FUNCTION_CALL) {
            this.functionArgNodeAtCursor = node;
            Optional expectedType = (Optional)node.parent().apply((NodeTransformer)this);
            if (expectedType.isPresent()) {
                return expectedType;
            }
        }
        if (!((bLangNode = this.nodeFinder.lookup(this.bLangCompilationUnit, node.lineRange())) instanceof BLangRecordLiteral)) {
            return Optional.empty();
        }
        return this.getExpectedType(bLangNode);
    }

    public Optional<TypeSymbol> transform(FunctionDefinitionNode node) {
        Optional returnTypeDesc = node.functionSignature().returnTypeDesc();
        if (returnTypeDesc.isEmpty()) {
            return Optional.empty();
        }
        Optional<Symbol> functionSymbol = this.semanticModel.symbol((Node)node);
        if (functionSymbol.isEmpty() || !(functionSymbol.get() instanceof FunctionSymbol)) {
            return Optional.empty();
        }
        return ((FunctionSymbol)functionSymbol.get()).typeDescriptor().returnTypeDescriptor();
    }

    public Optional<TypeSymbol> transform(MatchClauseNode node) {
        return (Optional)node.parent().apply((NodeTransformer)this);
    }

    public Optional<TypeSymbol> transform(MatchStatementNode node) {
        return this.semanticModel.typeOf((Node)node.condition());
    }

    public Optional<TypeSymbol> transform(MappingMatchPatternNode mappingMatchPatternNode) {
        return (Optional)mappingMatchPatternNode.parent().apply((NodeTransformer)this);
    }

    public Optional<TypeSymbol> transform(ExplicitNewExpressionNode node) {
        Token closeParen;
        BLangNode bLangNode = this.nodeFinder.lookup(this.bLangCompilationUnit, node.lineRange());
        if (bLangNode == null) {
            return Optional.empty();
        }
        ParenthesizedArgList parenthesizedArgList = node.parenthesizedArgList();
        Token openParen = parenthesizedArgList.openParenToken();
        if (this.isWithinParenthesis(openParen, closeParen = parenthesizedArgList.closeParenToken()) && bLangNode instanceof BLangTypeInit && ((BLangTypeInit)bLangNode).initInvocation instanceof BLangInvocation && ((BLangInvocation)((BLangTypeInit)bLangNode).initInvocation).symbol instanceof BInvokableSymbol) {
            List<BVarSymbol> params = ((BInvokableSymbol)((BLangInvocation)((BLangTypeInit)bLangNode).initInvocation).symbol).params;
            if (params.isEmpty()) {
                throw new IllegalStateException();
            }
            int argIndex = 0;
            List<BLangExpression> argsExpr = ((BLangTypeInit)bLangNode).argsExpr;
            if (argsExpr.isEmpty()) {
                return this.getTypeFromBType(params.get(0).getType());
            }
            for (BLangExpression bLangExpression : argsExpr) {
                if (PositionUtil.isPosWithinRange(this.linePosition, bLangExpression.getPosition().lineRange()) && argIndex < params.size()) {
                    return this.getTypeFromBType(params.get(argIndex).getType());
                }
                ++argIndex;
            }
        }
        return this.getExpectedType(bLangNode);
    }

    public Optional<TypeSymbol> transform(ImplicitNewExpressionNode node) {
        Token closeParen;
        BLangNode bLangNode = this.nodeFinder.lookup(this.bLangCompilationUnit, node.lineRange());
        if (bLangNode == null) {
            return Optional.empty();
        }
        Optional parenthesizedArgList = node.parenthesizedArgList();
        if (parenthesizedArgList.isEmpty()) {
            return this.getExpectedType(bLangNode);
        }
        Token openParen = ((ParenthesizedArgList)parenthesizedArgList.get()).openParenToken();
        if (this.isWithinParenthesis(openParen, closeParen = ((ParenthesizedArgList)parenthesizedArgList.get()).closeParenToken())) {
            if (!(bLangNode instanceof BLangTypeInit)) {
                return this.getExpectedType(bLangNode);
            }
            BLangTypeInit bLangTypeInit = (BLangTypeInit)bLangNode;
            BLangExpression bLangExpression = bLangTypeInit.initInvocation;
            if (!(bLangExpression instanceof BLangInvocation)) {
                return this.getExpectedType(bLangNode);
            }
            BLangInvocation initInvocation = (BLangInvocation)bLangExpression;
            if (initInvocation.symbol == null) {
                throw new IllegalStateException();
            }
            List<BVarSymbol> params = ((BInvokableSymbol)initInvocation.symbol).params;
            if (params.isEmpty()) {
                throw new IllegalStateException();
            }
            if (initInvocation.argExprs.isEmpty()) {
                return this.getParamType(initInvocation, 0, Collections.emptyList());
            }
            int argIndex = 0;
            for (BLangExpression bLangExpression2 : ((BLangTypeInit)bLangNode).argsExpr) {
                if (PositionUtil.isPosWithinRange(this.linePosition, bLangExpression2.getPosition().lineRange()) && argIndex < params.size()) {
                    return this.getTypeFromBType(params.get(argIndex).getType());
                }
                if (params.size() >= ++argIndex) continue;
                throw new IllegalStateException();
            }
        }
        return this.getExpectedType(bLangNode);
    }

    public Optional<TypeSymbol> transform(IfElseStatementNode node) {
        BLangNode bLangNode = this.nodeFinder.lookup(this.bLangCompilationUnit, node.lineRange());
        if (bLangNode == null) {
            return Optional.empty();
        }
        if (PositionUtil.isPosWithinRange(this.linePosition, node.condition().lineRange()) && bLangNode instanceof BLangIf) {
            BLangIf bLangIf = (BLangIf)bLangNode;
            return this.getExpectedType(bLangIf.expr);
        }
        return Optional.empty();
    }

    public Optional<TypeSymbol> transform(WhileStatementNode node) {
        BLangNode bLangNode = this.nodeFinder.lookup(this.bLangCompilationUnit, node.lineRange());
        if (bLangNode == null) {
            return Optional.empty();
        }
        if (PositionUtil.isPosWithinRange(this.linePosition, node.condition().lineRange()) && bLangNode instanceof BLangWhile) {
            BLangWhile bLangWhile = (BLangWhile)bLangNode;
            return this.getExpectedType(bLangWhile.expr);
        }
        return Optional.empty();
    }

    public Optional<TypeSymbol> transform(DefaultableParameterNode node) {
        BLangNode bLangNode = this.nodeFinder.lookup(this.bLangCompilationUnit, node.lineRange());
        return this.getExpectedType(bLangNode);
    }

    public Optional<TypeSymbol> transform(ExpressionFunctionBodyNode node) {
        BLangNode bLangNode = this.nodeFinder.lookup(this.bLangCompilationUnit, node.expression().lineRange());
        return this.getExpectedType(bLangNode);
    }

    protected Optional<TypeSymbol> transformSyntaxNode(Node node) {
        return this.visit((Node)node.parent());
    }

    public Optional<TypeSymbol> transform(IndexedExpressionNode node) {
        BLangNode bLangNode = this.nodeFinder.lookup(this.bLangCompilationUnit, node.lineRange());
        return this.getExpectedType(bLangNode);
    }

    public Optional<TypeSymbol> transform(RemoteMethodCallActionNode node) {
        BLangNode bLangNode = this.nodeFinder.lookup(this.bLangCompilationUnit, node.lineRange());
        if (bLangNode == null) {
            return Optional.empty();
        }
        if (bLangNode instanceof BLangInvocation.BLangActionInvocation) {
            Token closeParen;
            BLangInvocation.BLangActionInvocation bLangActionInvocation = (BLangInvocation.BLangActionInvocation)this.nodeFinder.lookup(this.bLangCompilationUnit, node.lineRange());
            Token openParen = node.openParenToken();
            if (this.isWithinParenthesis(openParen, closeParen = node.closeParenToken())) {
                if (bLangActionInvocation.argExprs.isEmpty()) {
                    return this.getTypeFromBType(((BInvokableSymbol)bLangActionInvocation.symbol).getParameters().get(0).getType());
                }
                Optional<BLangExpression> argument = bLangActionInvocation.argExprs.stream().filter(argumentNode -> PositionUtil.isPosWithinRange(this.linePosition, argumentNode.getPosition().lineRange())).findFirst();
                if (argument.isPresent()) {
                    return this.getExpectedType(argument.get());
                }
            }
            return this.getExpectedType(bLangNode);
        }
        return Optional.empty();
    }

    public Optional<TypeSymbol> transform(ListConstructorExpressionNode node) {
        Token closeBracket;
        BLangNode bLangNode = this.nodeFinder.lookup(this.bLangCompilationUnit, node.lineRange());
        if (bLangNode == null) {
            return Optional.empty();
        }
        Optional<TypeSymbol> extractedType = this.getExpectedType(bLangNode);
        if (extractedType.isEmpty()) {
            return Optional.empty();
        }
        if (extractedType.get().typeKind() != TypeDescKind.ARRAY) {
            throw new IllegalStateException();
        }
        BArrayType bArrayType = (BArrayType)((BallerinaArrayTypeSymbol)extractedType.get()).getBType();
        Token openBracket = node.openBracket();
        if (this.isWithinParenthesis(openBracket, closeBracket = node.closeBracket()) && bArrayType.eType != null && bArrayType.eType.getKind() != TypeKind.OTHER) {
            return Optional.of(this.typesFactory.getTypeDescriptor(bArrayType.eType));
        }
        return Optional.empty();
    }

    public Optional<TypeSymbol> transform(CaptureBindingPatternNode node) {
        if (this.findSymbolByName(node.variableName().text()).isEmpty()) {
            return Optional.empty();
        }
        BLangNode bLangNode = this.nodeFinder.lookup(this.bLangCompilationUnit, node.lineRange());
        if (bLangNode == null) {
            return Optional.empty();
        }
        BType bType = bLangNode.getBType();
        if (bLangNode.getBType().getKind() == TypeKind.MAP) {
            return this.getTypeFromBType(bLangNode.getBType());
        }
        if (bType.getKind() == TypeKind.OTHER) {
            return Optional.empty();
        }
        return Optional.of(this.typesFactory.getTypeDescriptor(bType));
    }

    public Optional<TypeSymbol> transform(MappingConstructorExpressionNode node) {
        return (Optional)node.parent().apply((NodeTransformer)this);
    }

    public Optional<TypeSymbol> transform(WaitActionNode node) {
        BLangNode bLangNode = this.nodeFinder.lookup(this.bLangCompilationUnit, node.lineRange());
        if (!(bLangNode instanceof BLangWaitExpr)) {
            return Optional.empty();
        }
        BLangWaitExpr waitExpr = (BLangWaitExpr)bLangNode;
        for (BLangExpression bLangExpression : waitExpr.exprList) {
            if (!PositionUtil.isPosWithinRange(this.linePosition, bLangExpression.getPosition().lineRange())) continue;
            return this.getExpectedType(bLangExpression);
        }
        return this.getExpectedType(waitExpr);
    }

    public Optional<TypeSymbol> transform(ErrorConstructorExpressionNode node) {
        BLangNode bLangNode = this.nodeFinder.lookup(this.bLangCompilationUnit, node.lineRange());
        if (bLangNode == null) {
            return Optional.empty();
        }
        if (bLangNode.getKind() == NodeKind.ERROR_CONSTRUCTOR_EXPRESSION) {
            Token closeParen;
            Token openParen = node.openParenToken();
            if (this.isWithinParenthesis(openParen, closeParen = node.closeParenToken())) {
                return Optional.of(this.typesFactory.getTypeDescriptor(((BErrorType)((BLangErrorConstructorExpr)bLangNode).expectedType).detailType));
            }
            return Optional.of(this.typesFactory.getTypeDescriptor(((BLangErrorConstructorExpr)bLangNode).expectedType));
        }
        return Optional.empty();
    }

    public Optional<TypeSymbol> transform(NamedArgumentNode node) {
        if (node.parent().kind() == SyntaxKind.METHOD_CALL || node.parent().kind() == SyntaxKind.FUNCTION_CALL) {
            this.functionArgNodeAtCursor = node;
            Optional expectedType = (Optional)node.parent().apply((NodeTransformer)this);
            if (expectedType.isPresent()) {
                return expectedType;
            }
        }
        BLangNode bLangNode = this.nodeFinder.lookup(this.bLangCompilationUnit, node.lineRange());
        return this.getExpectedType(bLangNode);
    }

    public Optional<TypeSymbol> transform(TableConstructorExpressionNode node) {
        Token closeBracket;
        Token openBracket;
        BLangNode bLangNode = this.nodeFinder.lookup(this.bLangCompilationUnit, node.lineRange());
        if (!(bLangNode instanceof BLangTableConstructorExpr)) {
            return Optional.empty();
        }
        BLangTableConstructorExpr bLangTableConstructorExpr = (BLangTableConstructorExpr)bLangNode;
        if (node.keySpecifier().isPresent() && this.isWithinParenthesis(((KeySpecifierNode)node.keySpecifier().get()).openParenToken(), ((KeySpecifierNode)node.keySpecifier().get()).closeParenToken())) {
            BType expectedType = bLangTableConstructorExpr.expectedType;
            if (expectedType instanceof BTableType) {
                BTableType tableType = (BTableType)expectedType;
                return Optional.of(this.typesFactory.getTypeDescriptor(Objects.requireNonNullElse(tableType.constraint, expectedType)));
            }
            if (expectedType instanceof BTypeReferenceType) {
                BTypeReferenceType referenceType = (BTypeReferenceType)expectedType;
                BType referredType = referenceType.referredType;
                return Optional.of(this.typesFactory.getTypeDescriptor(Objects.requireNonNullElse(((BTableType)referredType).constraint, expectedType)));
            }
        }
        if (this.isWithinParenthesis(openBracket = node.openBracket(), closeBracket = node.closeBracket())) {
            if (!(bLangTableConstructorExpr.expectedType instanceof BTypeReferenceType)) {
                BType constraint = ((BTableType)bLangTableConstructorExpr.expectedType).constraint;
                return this.getTypeFromBType(constraint);
            }
            BType rowType = ((BTableType)((BTypeReferenceType)bLangTableConstructorExpr.expectedType).referredType).constraint;
            return Optional.of(this.typesFactory.getTypeDescriptor(rowType));
        }
        return this.getExpectedType(bLangNode);
    }

    public Optional<TypeSymbol> transform(RecordFieldWithDefaultValueNode node) {
        BLangNode bLangNode = this.nodeFinder.lookup(this.bLangCompilationUnit, node.lineRange());
        return bLangNode == null ? Optional.empty() : this.getExpectedType(bLangNode);
    }

    public Optional<TypeSymbol> transform(SelectClauseNode node) {
        BLangNode bLangNode = this.nodeFinder.lookup(this.bLangCompilationUnit, node.lineRange());
        if (!(bLangNode instanceof BLangSelectClause)) {
            return Optional.empty();
        }
        BLangSelectClause selectClause = (BLangSelectClause)bLangNode;
        BType expectedType = ((BLangExpression)selectClause.getExpression()).expectedType;
        return this.getTypeFromBType(expectedType);
    }

    private Optional<TypeSymbol> visit(Node node) {
        if (node == null || this.visitedNodes.contains(node)) {
            return Optional.empty();
        }
        this.visitedNodes.add(node);
        return (Optional)node.apply((NodeTransformer)this);
    }

    public Optional<TypeSymbol> transform(FromClauseNode node) {
        Optional<TypeSymbol> typeSymbol;
        BLangNode expressionNode;
        if (PositionUtil.isPosWithinRange(this.linePosition, node.fromKeyword().lineRange()) || PositionUtil.isPosWithinRange(this.linePosition, node.inKeyword().lineRange())) {
            return Optional.empty();
        }
        if ((node.inKeyword().lineRange().endLine().line() > this.linePosition.line() || node.inKeyword().lineRange().endLine().offset() > this.linePosition.offset()) && (expressionNode = this.nodeFinder.lookup(this.bLangCompilationUnit, node.expression().lineRange())) != null) {
            BType bType = expressionNode.getBType();
            switch (bType.getKind()) {
                case ARRAY: {
                    return Optional.of(this.typesFactory.getTypeDescriptor(((BArrayType)expressionNode.getBType()).eType));
                }
                case STRING: {
                    return Optional.of(this.semanticModel.types().STRING);
                }
                case TABLE: {
                    return Optional.of(this.typesFactory.getTypeDescriptor(((BTableType)expressionNode.getBType()).constraint));
                }
                case STREAM: {
                    return Optional.of(this.typesFactory.getTypeDescriptor(((BStreamType)expressionNode.getBType()).constraint));
                }
                case XML: {
                    return Optional.of(this.typesFactory.getTypeDescriptor(((BXMLType)expressionNode.getBType()).constraint));
                }
                case MAP: {
                    return Optional.of(this.typesFactory.getTypeDescriptor(((BMapType)expressionNode.getBType()).constraint));
                }
            }
        }
        if ((typeSymbol = this.semanticModel.typeOf((Node)node.expression())).isPresent()) {
            return typeSymbol;
        }
        Optional<Symbol> optionalSymbol = this.semanticModel.symbol((Node)node.typedBindingPattern().bindingPattern());
        if (optionalSymbol.isEmpty()) {
            return Optional.empty();
        }
        typeSymbol = SymbolUtils.getTypeDescriptor(optionalSymbol.get());
        if (typeSymbol.isEmpty() || typeSymbol.get().typeKind() == TypeDescKind.COMPILATION_ERROR) {
            return Optional.empty();
        }
        return Optional.of(this.buildUnionOfIterables(typeSymbol.get(), this.semanticModel));
    }

    public Optional<TypeSymbol> transform(ClientResourceAccessActionNode clientResourceAccessActionNode) {
        BLangNode bLangNode = this.nodeFinder.lookup(this.bLangCompilationUnit, clientResourceAccessActionNode.lineRange());
        Optional arguments = clientResourceAccessActionNode.arguments();
        if (arguments.isPresent() && this.isWithinParenthesis(((ParenthesizedArgList)arguments.get()).openParenToken(), ((ParenthesizedArgList)arguments.get()).closeParenToken())) {
            Optional<TypeSymbol> restParamType;
            if (!(bLangNode instanceof BLangInvocation)) {
                return this.getExpectedType(bLangNode);
            }
            BLangInvocation bLangInvocation = (BLangInvocation)bLangNode;
            if (bLangInvocation.symbol == null) {
                return Optional.empty();
            }
            BInvokableSymbol symbol = (BInvokableSymbol)bLangInvocation.symbol;
            List<BVarSymbol> params = symbol.params.stream().filter(param -> param.getKind() != SymbolKind.PATH_PARAMETER && param.getKind() != SymbolKind.PATH_REST_PARAMETER).toList();
            BVarSymbol restPram = ((BInvokableSymbol)bLangInvocation.symbol).restParam;
            TypeSymbol restParamMemberType = null;
            if (restPram != null && (restParamType = this.getTypeFromBType(restPram.type)).isPresent() && restParamType.get().typeKind() == TypeDescKind.ARRAY) {
                restParamMemberType = ((ArrayTypeSymbol)restParamType.get()).memberTypeDescriptor();
            }
            if (params.isEmpty()) {
                if (restParamMemberType == null) {
                    throw new IllegalStateException();
                }
                return Optional.of(restParamMemberType);
            }
            if (bLangInvocation.argExprs.isEmpty()) {
                return this.getParamType(bLangInvocation, 0, Collections.emptyList());
            }
            int argIndex = 0;
            for (BLangExpression bLangExpression : bLangInvocation.argExprs) {
                if (PositionUtil.isPosWithinRange(this.linePosition, bLangExpression.getPosition().lineRange()) && argIndex < params.size()) {
                    return this.getTypeFromBType(params.get(argIndex).getType());
                }
                if (params.size() >= ++argIndex) continue;
                if (restParamMemberType != null) {
                    return Optional.of(restParamMemberType);
                }
                throw new IllegalStateException();
            }
        }
        return Optional.empty();
    }

    private Optional<TypeSymbol> getExpectedType(BLangNode node) {
        if (node == null) {
            return Optional.empty();
        }
        BType bType = null;
        switch (node.getKind()) {
            case RECORD_LITERAL_KEY_VALUE: {
                BLangRecordLiteral.BLangRecordKeyValueField field = (BLangRecordLiteral.BLangRecordKeyValueField)node;
                bType = field.getValue().expectedType;
                break;
            }
            case USER_DEFINED_TYPE: {
                bType = node.getBType();
                break;
            }
            case VARIABLE: {
                if (((BLangSimpleVariable)node).expr == null) break;
                bType = ((BLangSimpleVariable)node).expr.expectedType;
                break;
            }
            case TABLE_CONSTRUCTOR_EXPR: {
                bType = ((BLangTableConstructorExpr)node).expectedType;
                break;
            }
            case RECORD_LITERAL_EXPR: {
                bType = ((BLangRecordLiteral)node).expectedType;
                break;
            }
            case SIMPLE_VARIABLE_REF: {
                if (node instanceof BLangRecordLiteral) {
                    BLangRecordLiteral recordLiteral = (BLangRecordLiteral)node;
                    BLangTypeConversionExpr bLangExpression = recordLiteral.impConversionExpr;
                    if (bLangExpression != null && bLangExpression.getBType().getKind() == TypeKind.ANY) {
                        bType = bLangExpression.getBType();
                        break;
                    }
                }
                bType = ((BLangSimpleVarRef)node).expectedType;
                break;
            }
            case NAMED_ARGS_EXPR: {
                bType = ((BLangNamedArgsExpression)node).expectedType;
                break;
            }
            case LIST_CONSTRUCTOR_EXPR: {
                bType = ((BLangListConstructorExpr)node).expectedType;
                break;
            }
            case LITERAL: {
                bType = ((BLangLiteral)node).expectedType;
                break;
            }
            case NUMERIC_LITERAL: {
                bType = ((BLangNumericLiteral)node).expectedType;
                break;
            }
            case FIELD_BASED_ACCESS_EXPR: {
                bType = ((BLangFieldBasedAccess)node).expectedType;
                break;
            }
            case TYPE_INIT_EXPR: {
                bType = ((BLangTypeInit)node).expectedType;
                break;
            }
            case INDEX_BASED_ACCESS_EXPR: {
                bType = ((BLangIndexBasedAccess)node).expectedType;
                break;
            }
            case INVOCATION: {
                bType = ((BLangInvocation)node).expectedType;
                if (bType.getKind() != TypeKind.OTHER || ((BLangInvocation)node).symbol == null) break;
                bType = ((BInvokableSymbol)((BLangInvocation)node).symbol).retType;
                break;
            }
        }
        if (bType != null && bType.getKind() != TypeKind.OTHER) {
            return Optional.of(this.typesFactory.getTypeDescriptor(bType));
        }
        return Optional.empty();
    }

    private Optional<TypeSymbol> getTypeFromBType(BType type) {
        BType bType = type;
        if (type.getKind() == TypeKind.MAP) {
            bType = ((BMapType)type).constraint;
        }
        if (type instanceof BTypeReferenceType && ((BTypeReferenceType)type).referredType.getKind() == TypeKind.RECORD) {
            return Optional.of(this.typesFactory.getTypeDescriptor(((BTypeReferenceType)type).referredType));
        }
        if (bType.getKind() != TypeKind.OTHER) {
            return Optional.of(this.typesFactory.getTypeDescriptor(bType));
        }
        return Optional.empty();
    }

    private Optional<TypeSymbol> getSymbolType(BSymbol symbol) {
        BType bType = null;
        if (symbol.getKind() == SymbolKind.VARIABLE || symbol.getKind() == SymbolKind.FUNCTION) {
            bType = symbol.getType();
        }
        if (bType != null && bType.getKind() != TypeKind.OTHER) {
            return Optional.of(this.typesFactory.getTypeDescriptor(bType));
        }
        return Optional.empty();
    }

    private Optional<Symbol> findSymbol(Predicate<Symbol> predicate) {
        return this.semanticModel.visibleSymbols(this.document, this.linePosition).stream().filter(predicate).findFirst();
    }

    private Optional<Symbol> findSymbolByName(String name) {
        Predicate<Symbol> namePredicate = symbol -> symbol.getName().orElse("").equals(name);
        return this.findSymbol(namePredicate);
    }

    private Optional<Symbol> findSymbolByName(String name, Predicate<Symbol> predicate) {
        Predicate<Symbol> namePredicate = symbol -> symbol.getName().orElse("").equals(name);
        return this.findSymbol(namePredicate.and(predicate));
    }

    private Optional<ModuleSymbol> searchModuleForAlias(String alias) {
        List<Symbol> visibleSymbols = this.semanticModel.visibleSymbols(this.document, this.linePosition);
        for (Symbol symbol : visibleSymbols) {
            if (symbol.kind() != io.ballerina.compiler.api.symbols.SymbolKind.MODULE || !Objects.equals(symbol.getName().orElse(null), alias)) continue;
            return Optional.of((ModuleSymbol)symbol);
        }
        return Optional.empty();
    }

    private List<Symbol> getModuleSymbols(QualifiedNameReferenceNode qNameRef, Predicate<Symbol> predicate) {
        String modulePrefix = qNameRef.modulePrefix().text();
        String alias = modulePrefix.startsWith("'") ? modulePrefix.substring(1) : modulePrefix;
        Optional<ModuleSymbol> module = this.searchModuleForAlias(alias);
        return module.map(moduleSymbol -> moduleSymbol.allSymbols().stream().filter(predicate).toList()).orElseGet(ArrayList::new);
    }

    private Optional<Symbol> getQNameReferenceSymbol(QualifiedNameReferenceNode node, Predicate<Symbol> predicate) {
        List<Symbol> moduleSymbols = this.getModuleSymbols(node, predicate);
        if (moduleSymbols.size() != 1) {
            return Optional.empty();
        }
        return Optional.ofNullable(moduleSymbols.get(0));
    }

    private Optional<TypeSymbol> getParamType(BLangInvocation bLangNode, int argumentIndex, List<String> namedArgs) {
        BSymbol symbol = bLangNode.symbol;
        if (symbol == null) {
            return Optional.empty();
        }
        BInvokableSymbol invokableSymbol = (BInvokableSymbol)symbol;
        int paramsSize = invokableSymbol.params.size();
        if (!invokableSymbol.params.isEmpty() && argumentIndex < paramsSize) {
            if (namedArgs.isEmpty()) {
                return this.getSymbolType(invokableSymbol.params.get(argumentIndex));
            }
            int numOfPositionalArgs = argumentIndex - namedArgs.size();
            return invokableSymbol.params.subList(numOfPositionalArgs, paramsSize).stream().filter(param -> !namedArgs.contains(param.name.value)).findFirst().flatMap(this::getSymbolType);
        }
        if (invokableSymbol.restParam != null) {
            return this.getSymbolType(invokableSymbol.restParam).filter(type -> type.typeKind() == TypeDescKind.ARRAY).map(typeSymbol -> ((ArrayTypeSymbol)typeSymbol).memberTypeDescriptor());
        }
        return Optional.empty();
    }

    private UnionTypeSymbol buildUnionOfIterables(TypeSymbol typeSymbol, SemanticModel semanticModel) {
        Types types = semanticModel.types();
        TypeBuilder builder = types.builder();
        ArrayList<StreamTypeSymbol> unionTypeMembers = new ArrayList<StreamTypeSymbol>(List.of(builder.ARRAY_TYPE.withType(typeSymbol).build(), builder.MAP_TYPE.withTypeParam(typeSymbol).build(), builder.STREAM_TYPE.withValueType(typeSymbol).build()));
        if (ExpectedTypeFinder.getRawType(typeSymbol).typeKind() == TypeDescKind.RECORD) {
            try {
                unionTypeMembers.add((StreamTypeSymbol)((Object)builder.TABLE_TYPE.withRowType(ExpectedTypeFinder.getRawType(typeSymbol)).build()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (typeSymbol instanceof StringTypeSymbol) {
            unionTypeMembers.add((StreamTypeSymbol)types.STRING);
        }
        if (typeSymbol.typeKind() == TypeDescKind.XML) {
            unionTypeMembers.add((StreamTypeSymbol)types.XML);
        }
        return builder.UNION_TYPE.withMemberTypes((TypeSymbol[])unionTypeMembers.toArray(TypeSymbol[]::new)).build();
    }

    private static TypeSymbol getRawType(TypeSymbol typeDescriptor) {
        if (typeDescriptor.typeKind() == TypeDescKind.INTERSECTION) {
            return ExpectedTypeFinder.getRawType(((IntersectionTypeSymbol)typeDescriptor).effectiveTypeDescriptor());
        }
        if (typeDescriptor.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            TypeReferenceTypeSymbol typeRef = (TypeReferenceTypeSymbol)typeDescriptor;
            if (typeRef.typeDescriptor().typeKind() == TypeDescKind.INTERSECTION) {
                return ExpectedTypeFinder.getRawType(((IntersectionTypeSymbol)typeRef.typeDescriptor()).effectiveTypeDescriptor());
            }
            return typeRef.typeDescriptor();
        }
        return typeDescriptor;
    }

    private Optional<TypeSymbol> getExpectedTypeFromFunction(BLangNode bLangNode, Token openParen, Token closeParen) {
        if (!this.isWithinParenthesis(openParen, closeParen)) {
            return this.getExpectedType(bLangNode);
        }
        BLangInvocation bLangInvocation = (BLangInvocation)bLangNode;
        int size = bLangInvocation.argExprs.size();
        boolean langLibInvocation = bLangInvocation.langLibInvocation;
        if (size == 0 && !langLibInvocation) {
            return this.getParamType(bLangInvocation, 0, Collections.emptyList());
        }
        int argumentIndex = 0;
        ArrayList<String> namedArgs = new ArrayList<String>();
        for (BLangNode bLangNode2 : bLangInvocation.argExprs) {
            if (bLangNode2.getPosition().lineRange().endLine().offset() >= this.linePosition.offset()) continue;
            if (bLangNode2.getKind() == NodeKind.NAMED_ARGS_EXPR) {
                namedArgs.add(((BLangNamedArgsExpression)bLangNode2).name.value);
            }
            ++argumentIndex;
        }
        if (langLibInvocation) {
            if (bLangInvocation.expr.getBType().getKind() == TypeKind.ARRAY) {
                return Optional.ofNullable(this.typesFactory.getTypeDescriptor(((BArrayType)bLangInvocation.expr.expectedType).eType));
            }
            return this.getParamType(bLangInvocation, argumentIndex, namedArgs);
        }
        if (argumentIndex >= bLangInvocation.argExprs.size()) {
            return this.getExpectedType(this.nodeFinder.lookup(this.bLangCompilationUnit, this.functionArgNodeAtCursor.lineRange()));
        }
        BLangExpression bLangExpression = bLangInvocation.argExprs.get(argumentIndex);
        if (bLangExpression.toString().startsWith("$missingNode$")) {
            return this.getParamType(bLangInvocation, argumentIndex, namedArgs);
        }
        return this.getExpectedType(bLangExpression);
    }

    private boolean isParenthesisMissing(Token openParen, Token closeParen) {
        return openParen.isMissing() || closeParen.isMissing();
    }

    private boolean isWithinParenthesis(Token openParen, Token closeParen) {
        return !this.isParenthesisMissing(openParen, closeParen) && PositionUtil.isPosWithinOpenCloseLineRanges(this.linePosition, openParen.lineRange(), closeParen.lineRange());
    }

    private Optional<TypeSymbol> transformFunctionOrMethod(BLangNode bLangNode, BType parameterType, BInvokableSymbol originalInvokable, SeparatedNodeList<FunctionArgumentNode> arguments, Token openParenToken, Token closeParenToken, boolean hasFirstArg) {
        int position;
        if (originalInvokable == null || originalInvokable.params.isEmpty()) {
            return this.getExpectedTypeFromFunction(bLangNode, openParenToken, closeParenToken);
        }
        BVarSymbol firstParam = originalInvokable.params.get(0);
        BType typeParam = new TypeParamFinder().find(firstParam.getType());
        if (typeParam == null) {
            return this.getExpectedTypeFromFunction(bLangNode, openParenToken, closeParenToken);
        }
        BInvokableSymbol langLibMethod = this.langLibFunctionBinder.cloneAndBind(originalInvokable, parameterType, SymbolUtils.getTypeParamBoundType(parameterType));
        if (langLibMethod.getParameters().size() < 2) {
            return this.getExpectedTypeFromFunction(bLangNode, openParenToken, closeParenToken);
        }
        int n = position = hasFirstArg ? 0 : 1;
        if (this.functionArgNodeAtCursor != null) {
            FunctionArgumentNode argNode;
            Iterator iterator = arguments.iterator();
            while (iterator.hasNext() && !(argNode = (FunctionArgumentNode)iterator.next()).equals(this.functionArgNodeAtCursor)) {
                ++position;
            }
        }
        return Optional.of(this.typesFactory.getTypeDescriptor(langLibMethod.getType().getParameterTypes().get(position)));
    }
}

