/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl;

import io.ballerina.compiler.api.impl.LangLibFunctionBinder;
import io.ballerina.compiler.api.impl.SymbolFactory;
import io.ballerina.compiler.api.impl.symbols.BallerinaFunctionSymbol;
import io.ballerina.compiler.api.impl.util.SymbolUtils;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;

public class LangLibrary {
    private static final CompilerContext.Key<LangLibrary> LANG_LIB_KEY = new CompilerContext.Key();
    private static final String LANG_VALUE = "value";
    private final Map<String, Map<String, BInvokableSymbol>> langLibMethods;
    private final SymbolFactory symbolFactory;
    private final LangLibFunctionBinder methodBinder;
    private final Types types;

    private LangLibrary(CompilerContext context) {
        context.put(LANG_LIB_KEY, this);
        this.symbolFactory = SymbolFactory.getInstance(context);
        this.langLibMethods = new HashMap<String, Map<String, BInvokableSymbol>>();
        this.types = Types.getInstance(context);
        this.methodBinder = new LangLibFunctionBinder(this.types, context);
        SymbolTable symbolTable = SymbolTable.getInstance(context);
        for (Map.Entry<BPackageSymbol, SymbolEnv> entry : symbolTable.pkgEnvMap.entrySet()) {
            BPackageSymbol module = entry.getKey();
            PackageID moduleID = module.pkgID;
            if (!LangLibrary.isLangLibModule(moduleID)) continue;
            if (!LANG_VALUE.equals(moduleID.nameComps.get((int)1).value)) {
                LangLibrary.addLangLibMethods(moduleID.nameComps.get((int)1).value, module, this.langLibMethods, this.types);
                continue;
            }
            LangLibrary.populateLangValueLibrary(module, this.langLibMethods);
        }
    }

    public static LangLibrary getInstance(CompilerContext context) {
        LangLibrary langLib = context.get(LANG_LIB_KEY);
        if (langLib == null) {
            langLib = new LangLibrary(context);
        }
        return langLib;
    }

    public BInvokableSymbol getLangLibMethod(BType type, String methodName) {
        return this.langLibMethods.get(this.getLangLibName(type)).get(methodName);
    }

    public List<FunctionSymbol> getMethods(BType type) {
        return this.getMethods(this.getLangLibName(type), type);
    }

    private List<FunctionSymbol> getMethods(String langLibName, BType type) {
        Map<String, BInvokableSymbol> methods = this.langLibMethods.get(langLibName);
        BType boundType = SymbolUtils.getTypeParamBoundType(type);
        ArrayList<FunctionSymbol> wrappedMethods = new ArrayList<FunctionSymbol>();
        this.populateMethodList(wrappedMethods, methods, type, boundType);
        if (!LANG_VALUE.equals(langLibName)) {
            this.populateMethodList(wrappedMethods, this.langLibMethods.get(LANG_VALUE), type, null);
        }
        return wrappedMethods;
    }

    private String getLangLibName(BType type) {
        if (type.getKind() == TypeKind.UNION && this.types.isAllErrorMembers((BUnionType)type)) {
            return TypeKind.ERROR.typeName();
        }
        return this.getAssociatedLangLibName(type.getKind());
    }

    private void populateMethodList(List<FunctionSymbol> list, Map<String, BInvokableSymbol> langLib, BType type, BType boundTypeParam) {
        for (BInvokableSymbol symbol : langLib.values()) {
            String name = symbol.getOriginalName().getValue();
            BInvokableSymbol duplicate = this.methodBinder.cloneAndBind(symbol, type, boundTypeParam);
            BallerinaFunctionSymbol method = this.symbolFactory.createFunctionSymbol(duplicate, name);
            list.add(method);
        }
    }

    private String getAssociatedLangLibName(TypeKind typeKind) {
        return switch (typeKind) {
            case TypeKind.INT, TypeKind.BYTE -> TypeKind.INT.typeName();
            case TypeKind.ARRAY, TypeKind.TUPLE -> "array";
            case TypeKind.RECORD, TypeKind.MAP -> TypeKind.MAP.typeName();
            case TypeKind.FLOAT, TypeKind.DECIMAL, TypeKind.STRING, TypeKind.BOOLEAN, TypeKind.STREAM, TypeKind.OBJECT, TypeKind.ERROR, TypeKind.FUTURE, TypeKind.TYPEDESC, TypeKind.XML, TypeKind.TABLE, TypeKind.REGEXP -> typeKind.typeName();
            default -> LANG_VALUE;
        };
    }

    private static void addLangLibMethods(String basicType, BPackageSymbol langLibModule, Map<String, Map<String, BInvokableSymbol>> langLibMethods, Types types) {
        HashMap<String, BInvokableSymbol> methods = new HashMap<String, BInvokableSymbol>();
        for (Map.Entry<Name, Scope.ScopeEntry> nameScopeEntry : langLibModule.scope.entries.entrySet()) {
            BSymbol symbol = nameScopeEntry.getValue().symbol;
            if (symbol.kind != SymbolKind.FUNCTION || symbol.getOrigin() == SymbolOrigin.VIRTUAL) continue;
            BInvokableSymbol invSymbol = (BInvokableSymbol)symbol;
            if (!Symbols.isFlagOn(invSymbol.flags, 1L) || (invSymbol.params.isEmpty() || !LangLibrary.equalsToBasicType(invSymbol.params.get((int)0).type, basicType)) && (invSymbol.restParam == null || !LangLibrary.equalsToBasicType(((BArrayType)invSymbol.restParam.type).eType, basicType))) continue;
            methods.put(invSymbol.name.value, invSymbol);
        }
        langLibMethods.put(basicType, methods);
    }

    private static void populateLangValueLibrary(BPackageSymbol langValue, Map<String, Map<String, BInvokableSymbol>> langLibMethods) {
        HashMap<String, BInvokableSymbol> methods = new HashMap<String, BInvokableSymbol>();
        for (Map.Entry<Name, Scope.ScopeEntry> nameScopeEntry : langValue.scope.entries.entrySet()) {
            BSymbol symbol = nameScopeEntry.getValue().symbol;
            if (symbol.kind != SymbolKind.FUNCTION || !Symbols.isFlagOn(symbol.flags, 0x400000L)) continue;
            methods.put(symbol.name.value, (BInvokableSymbol)symbol);
        }
        langLibMethods.put(LANG_VALUE, methods);
    }

    private static boolean isLangLibModule(PackageID moduleID) {
        return Names.BALLERINA_ORG.equals(moduleID.orgName) && moduleID.nameComps.size() == 2 && Names.LANG.equals(moduleID.nameComps.get(0));
    }

    private static boolean equalsToBasicType(BType type, String basicType) {
        if (type.getKind() == TypeKind.UNION) {
            Set memberTypes = ((BUnionType)type).getMemberTypes();
            for (BType memberType : memberTypes) {
                if (basicType.compareToIgnoreCase(Types.getImpliedType(memberType).getKind().name()) == 0) continue;
                return false;
            }
            return true;
        }
        return basicType.compareToIgnoreCase(Types.getImpliedType(type).getKind().name()) == 0;
    }
}

