/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl;

import io.ballerina.compiler.api.impl.symbols.BallerinaAbsResourcePathAttachPoint;
import io.ballerina.compiler.api.impl.symbols.BallerinaAnnotationAttachmentSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaAnnotationSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaClassFieldSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaClassSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaConstantSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaEnumSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaFunctionSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaLiteralAttachPoint;
import io.ballerina.compiler.api.impl.symbols.BallerinaMemberTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaMethodSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaModule;
import io.ballerina.compiler.api.impl.symbols.BallerinaObjectFieldSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaParameterSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaPathParameterSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaRecordFieldSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaResourceMethodSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaServiceDeclarationSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaTypeDefinitionSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaVariableSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaWorkerSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaXMLNSSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.impl.symbols.resourcepath.util.BallerinaNamedPathSegment;
import io.ballerina.compiler.api.impl.values.BallerinaConstantValue;
import io.ballerina.compiler.api.symbols.AnnotationAttachmentSymbol;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ConstantSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.ParameterKind;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.PathParameterSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.resourcepath.util.PathSegment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationAttachmentSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BClassSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BEnumSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BResourceFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BResourcePathSegmentSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BServiceSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeDefinitionSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BWorkerSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BXMLNSSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStructureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangConstantValue;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;

public class SymbolFactory {
    private static final CompilerContext.Key<SymbolFactory> SYMBOL_FACTORY_KEY = new CompilerContext.Key();
    private final CompilerContext context;
    private final TypesFactory typesFactory;
    private final Types types;
    private final SymbolTable symTable;
    private final SymbolResolver symResolver;

    private SymbolFactory(CompilerContext context) {
        context.put(SYMBOL_FACTORY_KEY, this);
        this.context = context;
        this.typesFactory = TypesFactory.getInstance(context);
        this.types = Types.getInstance(context);
        this.symTable = SymbolTable.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
    }

    public static SymbolFactory getInstance(CompilerContext context) {
        SymbolFactory symbolFactory = context.get(SYMBOL_FACTORY_KEY);
        if (symbolFactory == null) {
            symbolFactory = new SymbolFactory(context);
        }
        return symbolFactory;
    }

    public Symbol getBCompiledSymbol(BSymbol symbol, String name) {
        if (symbol == null) {
            throw new IllegalArgumentException("Symbol is 'null'");
        }
        if (symbol instanceof BVarSymbol) {
            BVarSymbol varSymbol = (BVarSymbol)symbol;
            if (symbol.kind == SymbolKind.FUNCTION && !this.isFunctionPointer(symbol)) {
                if (Symbols.isFlagOn(symbol.flags, 8L)) {
                    if (Symbols.isFlagOn(symbol.flags, 131072L)) {
                        return this.createResourceMethodSymbol((BInvokableSymbol)symbol);
                    }
                    return this.createMethodSymbol((BInvokableSymbol)symbol, name);
                }
                return this.createFunctionSymbol((BInvokableSymbol)symbol, name);
            }
            if (symbol instanceof BConstantSymbol) {
                BConstantSymbol constantSymbol = (BConstantSymbol)symbol;
                return this.createConstantSymbol(constantSymbol, name);
            }
            if (symbol.kind == SymbolKind.WORKER) {
                return this.createWorkerSymbol((BWorkerSymbol)symbol, name);
            }
            if (symbol.owner instanceof BRecordTypeSymbol) {
                return this.createRecordFieldSymbol(varSymbol);
            }
            if (symbol.owner instanceof BClassSymbol) {
                return this.createClassFieldSymbol(varSymbol);
            }
            if (symbol.owner instanceof BObjectTypeSymbol) {
                return this.createObjectFieldSymbol(varSymbol);
            }
            if (Symbols.isFlagOn(symbol.flags, 0x800000000L)) {
                return this.createBallerinaParameter(varSymbol, ParameterKind.REQUIRED);
            }
            if (Symbols.isFlagOn(symbol.flags, 0x1000000000L)) {
                return this.createBallerinaParameter(varSymbol, ParameterKind.DEFAULTABLE);
            }
            if (Symbols.isFlagOn(symbol.flags, 0x400000000L)) {
                return this.createBallerinaParameter(varSymbol, ParameterKind.INCLUDED_RECORD);
            }
            if (Symbols.isFlagOn(symbol.flags, 0x2000000000L)) {
                return this.createBallerinaParameter(varSymbol, ParameterKind.REST);
            }
            if (symbol.kind == SymbolKind.PATH_PARAMETER) {
                return this.createPathParamSymbol(name, symbol, PathSegment.Kind.PATH_PARAMETER);
            }
            if (symbol.kind == SymbolKind.PATH_REST_PARAMETER) {
                return this.createPathParamSymbol(name, symbol, PathSegment.Kind.PATH_REST_PARAMETER);
            }
            if (varSymbol.isWildcard) {
                return null;
            }
            return this.createVariableSymbol(varSymbol, name);
        }
        if (symbol instanceof BTypeSymbol) {
            if (symbol.kind == SymbolKind.ANNOTATION) {
                return this.createAnnotationSymbol((BAnnotationSymbol)symbol);
            }
            if (symbol instanceof BPackageSymbol) {
                BPackageSymbol packageSymbol = (BPackageSymbol)symbol;
                return this.createModuleSymbol(packageSymbol, name);
            }
            if (symbol instanceof BClassSymbol) {
                BClassSymbol classSymbol = (BClassSymbol)symbol;
                return this.createClassSymbol(classSymbol, name);
            }
            if (symbol instanceof BEnumSymbol) {
                BEnumSymbol enumSymbol = (BEnumSymbol)symbol;
                return this.createEnumSymbol(enumSymbol, name);
            }
            return this.createTypeDefinition(symbol, name);
        }
        if (symbol.kind == SymbolKind.TYPE_DEF) {
            return this.createTypeDefinition(symbol, name);
        }
        if (symbol.kind == SymbolKind.SERVICE) {
            return this.createServiceDeclSymbol((BServiceSymbol)symbol);
        }
        if (symbol.kind == SymbolKind.XMLNS) {
            return this.createXMLNamespaceSymbol((BXMLNSSymbol)symbol);
        }
        if (symbol.kind == SymbolKind.RESOURCE_PATH_IDENTIFIER_SEGMENT) {
            return this.createPathNameSymbol((BResourcePathSegmentSymbol)symbol);
        }
        if (symbol.kind == SymbolKind.RESOURCE_PATH_PARAM_SEGMENT) {
            return this.createPathParamSymbol(name, symbol, PathSegment.Kind.PATH_PARAMETER);
        }
        if (symbol.kind == SymbolKind.RESOURCE_PATH_REST_PARAM_SEGMENT) {
            return this.createPathParamSymbol(name, symbol, PathSegment.Kind.PATH_REST_PARAMETER);
        }
        throw new IllegalArgumentException("Unsupported symbol type: " + symbol.getClass().getName());
    }

    public BallerinaFunctionSymbol createFunctionSymbol(BInvokableSymbol invokableSymbol, String name) {
        BallerinaFunctionSymbol.FunctionSymbolBuilder builder = new BallerinaFunctionSymbol.FunctionSymbolBuilder(name, invokableSymbol, this.context);
        boolean isResourceMethod = Symbols.isFlagOn(invokableSymbol.flags, 131072L);
        boolean isRemoteMethod = Symbols.isFlagOn(invokableSymbol.flags, 32768L);
        if (Symbols.isFlagOn(invokableSymbol.flags, 1L) && !isResourceMethod && !isRemoteMethod) {
            builder.withQualifier(Qualifier.PUBLIC);
        }
        if (Symbols.isFlagOn(invokableSymbol.flags, 1024L)) {
            builder.withQualifier(Qualifier.PRIVATE);
        }
        if (Symbols.isFlagOn(invokableSymbol.flags, 0x20000000L)) {
            builder.withQualifier(Qualifier.ISOLATED);
        }
        if (isRemoteMethod) {
            builder.withQualifier(Qualifier.REMOTE);
        }
        if (isResourceMethod) {
            builder.withQualifier(Qualifier.RESOURCE);
        }
        if (Symbols.isFlagOn(invokableSymbol.flags, 0x2000000L)) {
            builder.withQualifier(Qualifier.TRANSACTIONAL);
        }
        for (org.ballerinalang.model.symbols.AnnotationAttachmentSymbol annotationAttachmentSymbol : invokableSymbol.getAnnotations()) {
            BallerinaAnnotationAttachmentSymbol ballerinaAnnotationAttachmentSymbol = this.createAnnotAttachment((BAnnotationAttachmentSymbol)annotationAttachmentSymbol);
            builder.withAnnotationAttachment(ballerinaAnnotationAttachmentSymbol);
            builder.withAnnotation(ballerinaAnnotationAttachmentSymbol.typeDescriptor());
        }
        List<? extends org.ballerinalang.model.symbols.AnnotationAttachmentSymbol> annotationAttachmentsOnExternal = invokableSymbol.getAnnotationAttachmentsOnExternal();
        if (annotationAttachmentsOnExternal != null) {
            for (org.ballerinalang.model.symbols.AnnotationAttachmentSymbol annotationAttachmentSymbol : annotationAttachmentsOnExternal) {
                builder.withAnnotationAttachmentOnExternal(this.createAnnotAttachment((BAnnotationAttachmentSymbol)annotationAttachmentSymbol));
            }
        }
        return builder.withTypeDescriptor((FunctionTypeSymbol)this.typesFactory.getTypeDescriptor(invokableSymbol.type, invokableSymbol.type.tsymbol, true)).build();
    }

    public BallerinaMethodSymbol createMethodSymbol(BInvokableSymbol invokableSymbol, String name) {
        TypeSymbol typeDescriptor = this.typesFactory.getTypeDescriptor(invokableSymbol.type);
        BallerinaFunctionSymbol functionSymbol = this.createFunctionSymbol(invokableSymbol, name);
        if (typeDescriptor.typeKind() == TypeDescKind.FUNCTION) {
            return new BallerinaMethodSymbol(functionSymbol, invokableSymbol, this.context);
        }
        throw new AssertionError((Object)"Invalid type descriptor found");
    }

    public BallerinaResourceMethodSymbol createResourceMethodSymbol(BInvokableSymbol invokableSymbol) {
        String name = this.getMethodName(invokableSymbol, (BObjectTypeSymbol)invokableSymbol.owner);
        TypeSymbol typeDescriptor = this.typesFactory.getTypeDescriptor(invokableSymbol.type);
        BallerinaFunctionSymbol functionSymbol = this.createFunctionSymbol(invokableSymbol, name);
        if (typeDescriptor.typeKind() == TypeDescKind.FUNCTION) {
            return new BallerinaResourceMethodSymbol(functionSymbol, invokableSymbol, this.context);
        }
        throw new AssertionError((Object)"Invalid type descriptor found");
    }

    public BallerinaVariableSymbol createVariableSymbol(BVarSymbol symbol, String name) {
        BallerinaVariableSymbol.VariableSymbolBuilder symbolBuilder = new BallerinaVariableSymbol.VariableSymbolBuilder(name, symbol, this.context);
        if (Symbols.isFlagOn(symbol.flags, 4L) || Symbols.isFlagOn(symbol.flags, 64L)) {
            symbolBuilder.withQualifier(Qualifier.FINAL);
        }
        if (Symbols.isFlagOn(symbol.flags, 524288L)) {
            symbolBuilder.withQualifier(Qualifier.LISTENER);
        }
        if (Symbols.isFlagOn(symbol.flags, 32L)) {
            symbolBuilder.withQualifier(Qualifier.READONLY);
        }
        if (Symbols.isFlagOn(symbol.flags, 1L)) {
            symbolBuilder.withQualifier(Qualifier.PUBLIC);
        }
        if (Symbols.isFlagOn(symbol.flags, 0x80000000L)) {
            symbolBuilder.withQualifier(Qualifier.CONFIGURABLE);
        }
        if (Symbols.isFlagOn(symbol.flags, 0x20000000L)) {
            symbolBuilder.withQualifier(Qualifier.ISOLATED);
        }
        for (org.ballerinalang.model.symbols.AnnotationAttachmentSymbol annotationAttachmentSymbol : symbol.getAnnotations()) {
            BallerinaAnnotationAttachmentSymbol annotAttachment = this.createAnnotAttachment((BAnnotationAttachmentSymbol)annotationAttachmentSymbol);
            symbolBuilder.withAnnotationAttachment(annotAttachment);
            symbolBuilder.withAnnotation(annotAttachment.typeDescriptor());
        }
        TypeSymbol typeDescriptor = this.isReadonlyIntersectionArrayType(symbol.type) ? this.typesFactory.getTypeDescriptor(symbol.type, symbol.type.tsymbol, true) : this.typesFactory.getTypeDescriptor(symbol.type);
        return symbolBuilder.withTypeDescriptor(typeDescriptor).build();
    }

    public BallerinaMemberTypeSymbol createTupleMember(BVarSymbol symbol) {
        TypeSymbol type = this.typesFactory.getTypeDescriptor(symbol.getType());
        return new BallerinaMemberTypeSymbol(this.context, symbol, type);
    }

    public BallerinaNamedPathSegment createPathNameSymbol(BResourcePathSegmentSymbol symbol) {
        return new BallerinaNamedPathSegment(symbol, this.context);
    }

    private boolean isReadonlyIntersectionArrayType(BType type) {
        type = Types.getReferredType(type);
        if (type.tag == 22 && type.tsymbol != null && type.tsymbol.getOrigin() == SymbolOrigin.VIRTUAL && Symbols.isFlagOn(type.getFlags(), 32L)) {
            return true;
        }
        if (type.tag == 20) {
            return this.isReadonlyIntersectionArrayType(((BArrayType)type).getElementType());
        }
        return false;
    }

    public BallerinaRecordFieldSymbol createRecordFieldSymbol(BVarSymbol symbol) {
        BField bField = this.getBField(symbol);
        return bField != null ? new BallerinaRecordFieldSymbol(this.context, bField) : null;
    }

    public BallerinaObjectFieldSymbol createObjectFieldSymbol(BVarSymbol symbol) {
        BField bField = this.getBField(symbol);
        return bField != null ? new BallerinaObjectFieldSymbol(this.context, bField) : null;
    }

    public BallerinaClassFieldSymbol createClassFieldSymbol(BVarSymbol symbol) {
        BField bField = this.getBField(symbol);
        return bField != null ? new BallerinaClassFieldSymbol(this.context, bField) : null;
    }

    public BallerinaWorkerSymbol createWorkerSymbol(BWorkerSymbol symbol, String name) {
        BallerinaWorkerSymbol.WorkerSymbolBuilder builder = new BallerinaWorkerSymbol.WorkerSymbolBuilder(name, symbol, this.context);
        for (org.ballerinalang.model.symbols.AnnotationAttachmentSymbol annotationAttachmentSymbol : symbol.getAssociatedFuncSymbol().getAnnotations()) {
            BallerinaAnnotationAttachmentSymbol annotAttachment = this.createAnnotAttachment((BAnnotationAttachmentSymbol)annotationAttachmentSymbol);
            builder.withAnnotationAttachment(annotAttachment);
            builder.withAnnotation(annotAttachment.typeDescriptor());
        }
        return builder.withReturnType(this.typesFactory.getTypeDescriptor(((BFutureType)symbol.type).constraint)).build();
    }

    public ParameterSymbol createBallerinaParameter(BVarSymbol symbol, ParameterKind kind) {
        if (symbol == null) {
            return null;
        }
        String name = symbol.getOriginalName().getValue().isBlank() ? null : symbol.getOriginalName().getValue();
        TypeSymbol typeDescriptor = this.typesFactory.getTypeDescriptor(symbol.type);
        ArrayList<Qualifier> qualifiers = new ArrayList<Qualifier>();
        if ((symbol.flags & 1L) == 1L) {
            qualifiers.add(Qualifier.PUBLIC);
        }
        ArrayList<AnnotationSymbol> annotSymbols = new ArrayList<AnnotationSymbol>();
        ArrayList<AnnotationAttachmentSymbol> annotAttachments = new ArrayList<AnnotationAttachmentSymbol>();
        for (org.ballerinalang.model.symbols.AnnotationAttachmentSymbol annotationAttachmentSymbol : symbol.getAnnotations()) {
            BallerinaAnnotationAttachmentSymbol annotAttachment = this.createAnnotAttachment((BAnnotationAttachmentSymbol)annotationAttachmentSymbol);
            annotAttachments.add(annotAttachment);
            annotSymbols.add(annotAttachment.typeDescriptor());
        }
        return new BallerinaParameterSymbol(name, typeDescriptor, qualifiers, annotSymbols, annotAttachments, kind, symbol, this.context);
    }

    public PathParameterSymbol createPathParamSymbol(String name, BSymbol symbol, PathSegment.Kind pathKind) {
        return new BallerinaPathParameterSymbol(name, pathKind, symbol, this.context);
    }

    public BallerinaTypeDefinitionSymbol createTypeDefinition(BSymbol typeSymbol, String name) {
        BallerinaTypeDefinitionSymbol.TypeDefSymbolBuilder symbolBuilder = new BallerinaTypeDefinitionSymbol.TypeDefSymbolBuilder(name, typeSymbol, this.context);
        if (Symbols.isFlagOn(typeSymbol.flags, 1L)) {
            symbolBuilder.withQualifier(Qualifier.PUBLIC);
        }
        if (typeSymbol.kind == SymbolKind.TYPE_DEF) {
            for (org.ballerinalang.model.symbols.AnnotationAttachmentSymbol annotationAttachmentSymbol : ((BTypeDefinitionSymbol)typeSymbol).getAnnotations()) {
                BallerinaAnnotationAttachmentSymbol annotAttachment = this.createAnnotAttachment((BAnnotationAttachmentSymbol)annotationAttachmentSymbol);
                symbolBuilder.withAnnotation(annotAttachment.typeDescriptor());
                symbolBuilder.withAnnotationAttachment(annotAttachment);
            }
        }
        return symbolBuilder.withTypeDescriptor(this.typesFactory.getTypeDescriptor(typeSymbol.type, typeSymbol, true)).build();
    }

    public BallerinaEnumSymbol createEnumSymbol(BEnumSymbol enumSymbol, String name) {
        BallerinaEnumSymbol.EnumSymbolBuilder symbolBuilder = new BallerinaEnumSymbol.EnumSymbolBuilder(name, enumSymbol, this.context);
        if (Symbols.isFlagOn(enumSymbol.flags, 1L)) {
            symbolBuilder.withQualifier(Qualifier.PUBLIC);
        }
        ArrayList<ConstantSymbol> members = new ArrayList<ConstantSymbol>();
        for (BConstantSymbol bConstantSymbol : enumSymbol.members) {
            members.add(this.createConstantSymbol(bConstantSymbol, bConstantSymbol.name.value));
        }
        for (org.ballerinalang.model.symbols.AnnotationAttachmentSymbol annotationAttachmentSymbol : enumSymbol.getAnnotations()) {
            BallerinaAnnotationAttachmentSymbol annotAttachment = this.createAnnotAttachment((BAnnotationAttachmentSymbol)annotationAttachmentSymbol);
            symbolBuilder.withAnnotation(annotAttachment.typeDescriptor());
            symbolBuilder.withAnnotationAttachment(annotAttachment);
        }
        return symbolBuilder.withMembers(members).withTypeDescriptor(this.typesFactory.getTypeDescriptor(enumSymbol.type, enumSymbol, true)).build();
    }

    public BallerinaClassSymbol createClassSymbol(BClassSymbol classSymbol, String name) {
        TypeSymbol type = this.typesFactory.getTypeDescriptor(classSymbol.type, classSymbol, true);
        return this.createClassSymbol(classSymbol, name, type);
    }

    public BallerinaClassSymbol createClassSymbol(BClassSymbol classSymbol, String name, TypeSymbol type) {
        BallerinaClassSymbol.ClassSymbolBuilder symbolBuilder = new BallerinaClassSymbol.ClassSymbolBuilder(this.context, name, classSymbol);
        this.addIfFlagSet(symbolBuilder, classSymbol.flags, 1L, Qualifier.PUBLIC);
        this.addIfFlagSet(symbolBuilder, classSymbol.flags, 0x8000000L, Qualifier.DISTINCT);
        this.addIfFlagSet(symbolBuilder, classSymbol.flags, 32L, Qualifier.READONLY);
        this.addIfFlagSet(symbolBuilder, classSymbol.flags, 0x20000000L, Qualifier.ISOLATED);
        this.addIfFlagSet(symbolBuilder, classSymbol.flags, 65536L, Qualifier.CLIENT);
        this.addIfFlagSet(symbolBuilder, classSymbol.flags, 262144L, Qualifier.SERVICE);
        if (type.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            type = ((TypeReferenceTypeSymbol)type).typeDescriptor();
        }
        for (org.ballerinalang.model.symbols.AnnotationAttachmentSymbol annotationAttachmentSymbol : classSymbol.getAnnotations()) {
            BallerinaAnnotationAttachmentSymbol annotAttachment = this.createAnnotAttachment((BAnnotationAttachmentSymbol)annotationAttachmentSymbol);
            symbolBuilder.withAnnotation(annotAttachment.typeDescriptor());
            symbolBuilder.withAnnotationAttachment(annotAttachment);
        }
        return symbolBuilder.withTypeDescriptor((ObjectTypeSymbol)type).build();
    }

    public BallerinaServiceDeclarationSymbol createServiceDeclSymbol(BServiceSymbol serviceDeclSymbol) {
        BallerinaServiceDeclarationSymbol.ServiceDeclSymbolBuilder symbolBuilder = new BallerinaServiceDeclarationSymbol.ServiceDeclSymbolBuilder(serviceDeclSymbol, this.context);
        BClassSymbol associatedClass = serviceDeclSymbol.getAssociatedClassSymbol();
        if (Symbols.isFlagOn(serviceDeclSymbol.flags, 0x20000000L)) {
            symbolBuilder.withQualifier(Qualifier.ISOLATED);
        }
        for (org.ballerinalang.model.symbols.AnnotationAttachmentSymbol annotationAttachmentSymbol : associatedClass.getAnnotations()) {
            BallerinaAnnotationAttachmentSymbol annotAttachment = this.createAnnotAttachment((BAnnotationAttachmentSymbol)annotationAttachmentSymbol);
            symbolBuilder.withAnnotation(annotAttachment.typeDescriptor());
            symbolBuilder.withAnnotationAttachment(annotAttachment);
        }
        if (serviceDeclSymbol.getAbsResourcePath().isPresent()) {
            symbolBuilder.withAttachPoint(new BallerinaAbsResourcePathAttachPoint(serviceDeclSymbol.getAbsResourcePath().get()));
        } else if (serviceDeclSymbol.getAttachPointStringLiteral().isPresent()) {
            symbolBuilder.withAttachPoint(new BallerinaLiteralAttachPoint(serviceDeclSymbol.getAttachPointStringLiteral().get()));
        }
        return symbolBuilder.withTypeDescriptor(this.typesFactory.getTypeDescriptor(serviceDeclSymbol.type)).build();
    }

    public BallerinaConstantSymbol createConstantSymbol(BConstantSymbol constantSymbol, String name) {
        BallerinaConstantSymbol.ConstantSymbolBuilder symbolBuilder = new BallerinaConstantSymbol.ConstantSymbolBuilder(name, constantSymbol, this.context);
        symbolBuilder.withTypeDescriptor(this.typesFactory.getTypeDescriptor(constantSymbol.type)).withBroaderTypeDescriptor(this.typesFactory.getTypeDescriptor(constantSymbol.literalType));
        if (constantSymbol.getConstValue() != null) {
            symbolBuilder.withConstValue(this.createConstantValue((BLangConstantValue)constantSymbol.getConstValue()));
        }
        if ((constantSymbol.flags & 1L) == 1L) {
            symbolBuilder.withQualifier(Qualifier.PUBLIC);
        }
        for (org.ballerinalang.model.symbols.AnnotationAttachmentSymbol annotationAttachmentSymbol : constantSymbol.getAnnotations()) {
            BallerinaAnnotationAttachmentSymbol annotAttachment = this.createAnnotAttachment((BAnnotationAttachmentSymbol)annotationAttachmentSymbol);
            symbolBuilder.withAnnotation(annotAttachment.typeDescriptor());
            symbolBuilder.withAnnotationAttachment(annotAttachment);
        }
        return symbolBuilder.build();
    }

    private BallerinaConstantValue createConstantValue(BLangConstantValue constantValue) {
        if (constantValue == null) {
            return null;
        }
        Object object = constantValue.value;
        if (object instanceof BLangConstantValue) {
            BLangConstantValue bLangConstantValue = (BLangConstantValue)object;
            return this.createConstantValue(bLangConstantValue);
        }
        object = constantValue.value;
        if (object instanceof HashMap) {
            HashMap constValueMap = (HashMap)object;
            LinkedHashMap constSymbolMap = new LinkedHashMap();
            constValueMap.forEach((key, value) -> {
                if (value instanceof BLangConstantValue) {
                    BLangConstantValue bLangConstantValue = (BLangConstantValue)value;
                    BallerinaConstantValue newConstValue = this.createConstantValue(bLangConstantValue);
                    constSymbolMap.put((String)key, newConstValue);
                }
            });
            return this.createConstantValue(constSymbolMap, constantValue.type);
        }
        return this.createConstantValue(constantValue.value, constantValue.type);
    }

    private BallerinaConstantValue createConstantValue(Object value, BType bType) {
        return new BallerinaConstantValue(value, this.typesFactory.getTypeDescriptor(bType));
    }

    public BallerinaAnnotationSymbol createAnnotationSymbol(BAnnotationSymbol symbol) {
        BallerinaAnnotationSymbol.AnnotationSymbolBuilder symbolBuilder = new BallerinaAnnotationSymbol.AnnotationSymbolBuilder(symbol.getOriginalName().getValue(), symbol, this.context);
        if ((symbol.flags & 1L) == 1L) {
            symbolBuilder.withQualifier(Qualifier.PUBLIC);
        }
        if (symbol.attachedType != null && !this.types.isAssignable(symbol.attachedType, this.symTable.trueType)) {
            symbolBuilder.withTypeDescriptor(this.typesFactory.getTypeDescriptor(symbol.attachedType));
        }
        for (org.ballerinalang.model.symbols.AnnotationAttachmentSymbol annotationAttachmentSymbol : symbol.getAnnotations()) {
            BallerinaAnnotationAttachmentSymbol annotAttachment = this.createAnnotAttachment((BAnnotationAttachmentSymbol)annotationAttachmentSymbol);
            symbolBuilder.withAnnotation(annotAttachment.typeDescriptor());
            symbolBuilder.withAnnotationAttachment(annotAttachment);
        }
        return symbolBuilder.build();
    }

    public BallerinaAnnotationSymbol createAnnotationSymbol(BAnnotationAttachmentSymbol annotationAttachmentSymbol) {
        return this.createAnnotationSymbol(this.findAnnotationSymbol(annotationAttachmentSymbol));
    }

    public BallerinaXMLNSSymbol createXMLNamespaceSymbol(BXMLNSSymbol symbol) {
        BallerinaXMLNSSymbol.XmlNSSymbolBuilder symbolBuilder = new BallerinaXMLNSSymbol.XmlNSSymbolBuilder(symbol.name.getValue(), symbol, this.context);
        return symbolBuilder.build();
    }

    public BallerinaModule createModuleSymbol(BPackageSymbol symbol, String name) {
        return new BallerinaModule.ModuleSymbolBuilder(this.context, name, symbol).build();
    }

    public BallerinaAnnotationAttachmentSymbol createAnnotAttachment(BAnnotationAttachmentSymbol annotAttachment) {
        BallerinaAnnotationSymbol annotationSymbol = this.createAnnotationSymbol(this.findAnnotationSymbol(annotAttachment));
        return this.createAnnotAttachment(annotAttachment, annotationSymbol);
    }

    public BallerinaAnnotationAttachmentSymbol createAnnotAttachment(BAnnotationAttachmentSymbol annotAttachment, BallerinaAnnotationSymbol annotationSymbol) {
        if (!annotAttachment.isConstAnnotation()) {
            return new BallerinaAnnotationAttachmentSymbol(annotAttachment.getOriginalName().getValue(), annotAttachment, annotationSymbol, this.context);
        }
        BConstantSymbol attachmentValue = ((BAnnotationAttachmentSymbol.BConstAnnotationAttachmentSymbol)annotAttachment).attachmentValueSymbol;
        return new BallerinaAnnotationAttachmentSymbol(annotAttachment.getOriginalName().getValue(), (BAnnotationAttachmentSymbol.BConstAnnotationAttachmentSymbol)annotAttachment, annotationSymbol, this.createConstantValue(attachmentValue.value), this.context);
    }

    private String getMethodName(BInvokableSymbol method, BObjectTypeSymbol owner) {
        ArrayList<BAttachedFunction> methods = new ArrayList<BAttachedFunction>(owner.attachedFuncs);
        methods.add(owner.initializerFunc);
        for (BAttachedFunction mthd : methods) {
            if (method != mthd.symbol) continue;
            if (mthd instanceof BResourceFunction) {
                BResourceFunction bResourceFunction = (BResourceFunction)mthd;
                return bResourceFunction.accessor.value;
            }
            return mthd.symbol.getOriginalName().getValue();
        }
        throw new IllegalStateException(String.format("Method symbol for '%s' not found in owner symbol '%s'", method.name, owner.name));
    }

    private boolean isFunctionPointer(BSymbol symbol) {
        return Symbols.isTagOn(symbol, 52L) && !Symbols.isTagOn(symbol, 820L);
    }

    private void addIfFlagSet(BallerinaClassSymbol.ClassSymbolBuilder symbolBuilder, long mask, long flag, Qualifier qualifier) {
        if (Symbols.isFlagOn(mask, flag)) {
            symbolBuilder.withQualifier(qualifier);
        }
    }

    private BField getBField(BVarSymbol symbol) {
        String fieldName = symbol.name.value;
        BStructureType type = (BStructureType)symbol.owner.type;
        return type.fields.get(fieldName);
    }

    private BAnnotationSymbol findAnnotationSymbol(BAnnotationAttachmentSymbol annotationAttachmentSymbol) {
        PackageID annotPkgId = annotationAttachmentSymbol.annotPkgID;
        Name annotTagRef = annotationAttachmentSymbol.annotTag;
        if (this.symTable.rootPkgSymbol.pkgID.equals(annotPkgId)) {
            return (BAnnotationSymbol)this.symResolver.lookupSymbolInAnnotationSpace(this.symTable.pkgEnvMap.get(this.symTable.langAnnotationModuleSymbol), annotTagRef);
        }
        boolean testable = annotPkgId.isTestPkg;
        for (Map.Entry<BPackageSymbol, SymbolEnv> entry : this.symTable.pkgEnvMap.entrySet()) {
            BPackageSymbol pkgSymbol = entry.getKey();
            if (!pkgSymbol.pkgID.equals(annotPkgId) || testable && !pkgSymbol.pkgID.isTestPkg) continue;
            return (BAnnotationSymbol)this.symResolver.lookupSymbolInAnnotationSpace(entry.getValue(), annotTagRef);
        }
        throw new AssertionError((Object)("Cannot lookup annotation symbol: symbol environment not available for '" + String.valueOf(annotPkgId) + "'"));
    }
}

