/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl;

import io.ballerina.types.Env;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ballerinalang.model.symbols.AnnotationAttachmentSymbol;
import org.ballerinalang.model.symbols.SymbolKind;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnyType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnydataType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BJSONType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BParameterizedType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleMember;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeReferenceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class TypeParamResolver
implements BTypeVisitor<BType, BType> {
    private final Map<BType, BType> boundTypes = new HashMap<BType, BType>();
    private final BType typeParam;
    private final Types types;
    private final Env typeEnv;

    public TypeParamResolver(BType typeParam, CompilerContext context) {
        this.typeParam = typeParam;
        this.types = Types.getInstance(context);
        this.typeEnv = this.types.typeEnv();
    }

    public BType resolve(BType typeParam, BType boundType) {
        if (this.boundTypes.containsKey(typeParam)) {
            return this.boundTypes.get(typeParam);
        }
        if (this.isTypeParam(typeParam)) {
            this.boundTypes.put(typeParam, boundType);
            return boundType;
        }
        BType type = typeParam.accept(this, boundType);
        this.boundTypes.put(typeParam, type);
        return type;
    }

    @Override
    public BType visit(BType typeInSymbol, BType boundType) {
        if (Symbols.isFlagOn(0x200000L, typeInSymbol.getFlags()) && this.types.isAssignable(typeInSymbol, this.typeParam)) {
            return boundType;
        }
        return typeInSymbol;
    }

    @Override
    public BType visit(BAnyType typeInSymbol, BType boundType) {
        return typeInSymbol;
    }

    @Override
    public BType visit(BAnydataType typeInSymbol, BType boundType) {
        return typeInSymbol;
    }

    @Override
    public BType visit(BMapType typeInSymbol, BType boundType) {
        BType boundConstraintType = this.resolve(typeInSymbol.constraint, boundType);
        if (boundConstraintType == typeInSymbol) {
            return typeInSymbol;
        }
        return new BMapType(this.typeEnv, typeInSymbol.tag, boundConstraintType, typeInSymbol.tsymbol, typeInSymbol.getFlags());
    }

    @Override
    public BType visit(BXMLType typeInSymbol, BType boundType) {
        BType boundConstraintType = this.resolve(typeInSymbol.constraint, boundType);
        if (boundConstraintType == typeInSymbol) {
            return typeInSymbol;
        }
        return new BXMLType(boundConstraintType, typeInSymbol.tsymbol, typeInSymbol.getFlags());
    }

    @Override
    public BType visit(BJSONType typeInSymbol, BType boundType) {
        return typeInSymbol;
    }

    @Override
    public BType visit(BArrayType typeInSymbol, BType boundType) {
        BType boundElemType = this.resolve(typeInSymbol.eType, boundType);
        if (boundElemType == typeInSymbol) {
            return typeInSymbol;
        }
        return new BArrayType(this.typeEnv, boundElemType, typeInSymbol.tsymbol, typeInSymbol.getSize(), typeInSymbol.state, typeInSymbol.getFlags());
    }

    @Override
    public BType visit(BObjectType typeInSymbol, BType boundType) {
        BObjectTypeSymbol objectTypeSymbol = (BObjectTypeSymbol)typeInSymbol.tsymbol;
        LinkedHashMap<String, BField> newObjectFields = new LinkedHashMap<String, BField>();
        Set<Map.Entry<String, BField>> entries = typeInSymbol.getFields().entrySet();
        for (Map.Entry<String, BField> entry : entries) {
            BType newType = this.resolve(entry.getValue().type, boundType);
            BVarSymbol newVarSymbol = this.createNewVarSymbol(entry.getValue().symbol, newType);
            BField newField = new BField(newVarSymbol.getName(), newVarSymbol.getPosition(), newVarSymbol);
            newObjectFields.put(entry.getKey(), newField);
        }
        ArrayList<BAttachedFunction> newAttachedFuncs = new ArrayList<BAttachedFunction>();
        for (BAttachedFunction attachedFunc : objectTypeSymbol.attachedFuncs) {
            BType newType = this.resolve(attachedFunc.type, boundType);
            BInvokableSymbol newInvokableSymbol = this.resolveInvokableSymbol(attachedFunc.symbol, (BInvokableType)newType, boundType);
            BAttachedFunction newAttachedFunc = new BAttachedFunction(attachedFunc.funcName, newInvokableSymbol, (BInvokableType)newType, attachedFunc.pos);
            newAttachedFuncs.add(newAttachedFunc);
        }
        BObjectTypeSymbol bObjectTypeSymbol = new BObjectTypeSymbol(objectTypeSymbol.tag, objectTypeSymbol.flags, objectTypeSymbol.name, objectTypeSymbol.pkgID, objectTypeSymbol.getType(), objectTypeSymbol.owner, objectTypeSymbol.pos, objectTypeSymbol.origin);
        BObjectType newObjectType = new BObjectType(this.typeEnv, (BTypeSymbol)bObjectTypeSymbol, typeInSymbol.getFlags());
        newObjectType.fields = newObjectFields;
        bObjectTypeSymbol.attachedFuncs = newAttachedFuncs;
        bObjectTypeSymbol.type = newObjectType;
        return newObjectType;
    }

    @Override
    public BType visit(BRecordType typeInSymbol, BType boundType) {
        LinkedHashMap<String, BField> newRecordFields = new LinkedHashMap<String, BField>();
        Set entries = typeInSymbol.fields.entrySet();
        for (Map.Entry entry : entries) {
            BType newType = this.resolve(((BField)entry.getValue()).type, boundType);
            BVarSymbol newVarSymbol = this.createNewVarSymbol(((BField)entry.getValue()).symbol, newType);
            BField newField = new BField(newVarSymbol.getName(), newVarSymbol.getPosition(), newVarSymbol);
            newRecordFields.put((String)entry.getKey(), newField);
        }
        BType newRestType = this.resolve(typeInSymbol.restFieldType, boundType);
        BRecordType newRecordType = new BRecordType(this.typeEnv, typeInSymbol.tsymbol, typeInSymbol.getFlags());
        newRecordType.fields = newRecordFields;
        newRecordType.restFieldType = newRestType;
        return newRecordType;
    }

    @Override
    public BType visit(BTupleType typeInSymbol, BType boundType) {
        BType newRestType;
        ArrayList<BTupleMember> newTupleMembers = new ArrayList<BTupleMember>();
        List<BTupleMember> tupleMembers = typeInSymbol.getMembers();
        boolean areAllSameType = true;
        for (BTupleMember tupleMember : tupleMembers) {
            BType newType = this.resolve(tupleMember.type, boundType);
            areAllSameType &= newType == tupleMember.type;
            BVarSymbol varSymbol = this.createNewVarSymbol(tupleMember.symbol, newType);
            newTupleMembers.add(new BTupleMember(newType, varSymbol));
        }
        BType bType = newRestType = typeInSymbol.restType != null ? this.resolve(typeInSymbol.restType, boundType) : null;
        if (areAllSameType && newRestType == typeInSymbol.restType) {
            return typeInSymbol;
        }
        return new BTupleType(this.typeEnv, typeInSymbol.tsymbol, newTupleMembers, newRestType, typeInSymbol.getFlags(), typeInSymbol.isCyclic);
    }

    @Override
    public BType visit(BStreamType typeInSymbol, BType boundType) {
        BType boundConstraintType = this.resolve(typeInSymbol.constraint, boundType);
        if (boundConstraintType == typeInSymbol) {
            return typeInSymbol;
        }
        return new BStreamType(this.typeEnv, typeInSymbol.tag, boundConstraintType, typeInSymbol.completionType, typeInSymbol.tsymbol);
    }

    @Override
    public BType visit(BTableType typeInSymbol, BType boundType) {
        BType boundConstraintType = this.resolve(typeInSymbol.constraint, boundType);
        if (boundConstraintType == typeInSymbol) {
            return typeInSymbol;
        }
        BTableType bTableType = new BTableType(this.typeEnv, boundConstraintType, typeInSymbol.tsymbol, typeInSymbol.getFlags());
        bTableType.keyTypeConstraint = typeInSymbol.keyTypeConstraint;
        return bTableType;
    }

    @Override
    public BType visit(BInvokableType typeInSymbol, BType boundType) {
        ArrayList<BType> newParamTypes = new ArrayList<BType>();
        for (BType paramType : typeInSymbol.paramTypes) {
            BType newType = this.resolve(paramType, boundType);
            newParamTypes.add(newType);
        }
        BType newRestParamType = null;
        if (typeInSymbol.restType != null) {
            newRestParamType = this.resolve(typeInSymbol.restType, boundType);
        }
        BType newReturnType = null;
        if (typeInSymbol.retType != null) {
            newReturnType = this.resolve(typeInSymbol.retType, boundType);
        }
        BInvokableTypeSymbol invokableTypeSymbol = new BInvokableTypeSymbol(typeInSymbol.tsymbol.tag, typeInSymbol.tsymbol.flags, typeInSymbol.tsymbol.pkgID, null, typeInSymbol.tsymbol.owner, typeInSymbol.tsymbol.pos, typeInSymbol.tsymbol.origin);
        if (typeInSymbol.tsymbol.getKind() == SymbolKind.INVOKABLE_TYPE) {
            BInvokableTypeSymbol currentTypeSymbol = (BInvokableTypeSymbol)typeInSymbol.tsymbol;
            invokableTypeSymbol.params = new ArrayList<BVarSymbol>();
            for (BVarSymbol param : currentTypeSymbol.params) {
                BType resolvedSymbolParamType = this.resolve(param.type, boundType);
                BVarSymbol newVarSymbol = this.createNewVarSymbol(param, resolvedSymbolParamType);
                invokableTypeSymbol.params.add(newVarSymbol);
            }
            invokableTypeSymbol.restParam = this.createNewVarSymbol(currentTypeSymbol.restParam, newRestParamType);
        }
        invokableTypeSymbol.returnType = newReturnType;
        BInvokableType type = new BInvokableType(this.typeEnv, newParamTypes, newRestParamType, newReturnType, invokableTypeSymbol);
        invokableTypeSymbol.type = type;
        return type;
    }

    @Override
    public BType visit(BUnionType typeInSymbol, BType boundType) {
        LinkedHashSet<BType> newMembers = new LinkedHashSet<BType>();
        boolean areAllSameType = true;
        if (typeInSymbol.isCyclic) {
            return typeInSymbol;
        }
        for (BType memberType : typeInSymbol.getOriginalMemberTypes()) {
            BType newType = this.resolve(memberType, boundType);
            areAllSameType &= newType == memberType;
            newMembers.add(newType);
        }
        if (areAllSameType) {
            return typeInSymbol;
        }
        return BUnionType.create(this.typeEnv, typeInSymbol.tsymbol, newMembers);
    }

    @Override
    public BType visit(BIntersectionType typeInSymbol, BType boundType) {
        return typeInSymbol;
    }

    @Override
    public BType visit(BErrorType typeInSymbol, BType boundType) {
        return typeInSymbol;
    }

    @Override
    public BType visit(BFutureType typeInSymbol, BType boundType) {
        return typeInSymbol;
    }

    @Override
    public BType visit(BFiniteType typeInSymbol, BType boundType) {
        return typeInSymbol;
    }

    @Override
    public BType visit(BTypedescType typeInSymbol, BType boundType) {
        return typeInSymbol;
    }

    @Override
    public BType visit(BParameterizedType typeInSymbol, BType boundType) {
        return typeInSymbol;
    }

    public BType visit(BTypeReferenceType typeInSymbol, BType s) {
        return typeInSymbol;
    }

    private boolean isTypeParam(BType type) {
        return type == this.typeParam;
    }

    private BVarSymbol createNewVarSymbol(BVarSymbol symbol, BType newType) {
        if (symbol == null) {
            return null;
        }
        BType originalType = symbol.getType();
        if (originalType == newType) {
            return symbol;
        }
        BVarSymbol duplicateSymbol = this.duplicateSymbol(symbol);
        duplicateSymbol.type = newType;
        return duplicateSymbol;
    }

    private BInvokableSymbol resolveInvokableSymbol(BInvokableSymbol symbol, BInvokableType newInvokableType, BType boundType) {
        BInvokableSymbol newInvokableSymbol = this.duplicateSymbol(symbol);
        for (BVarSymbol param : symbol.params) {
            BType newParamType = this.resolve(param.type, boundType);
            BVarSymbol newVarSymbol = this.createNewVarSymbol(param, newParamType);
            newInvokableSymbol.params.add(newVarSymbol);
        }
        if (symbol.restParam != null) {
            BType newRestParam = this.resolve(symbol.restParam.type, boundType);
            newInvokableSymbol.restParam = this.createNewVarSymbol(symbol.restParam, newRestParam);
        }
        newInvokableSymbol.retType = this.resolve(symbol.retType, boundType);
        BInvokableTypeSymbol originalTSymbol = (BInvokableTypeSymbol)newInvokableType.tsymbol;
        BInvokableTypeSymbol newInvokableTypeSym = Symbols.createInvokableTypeSymbol(originalTSymbol.tag, originalTSymbol.flags, originalTSymbol.pkgID, newInvokableType, originalTSymbol.owner, originalTSymbol.pos, originalTSymbol.origin);
        newInvokableTypeSym.params = newInvokableSymbol.params;
        newInvokableTypeSym.restParam = newInvokableSymbol.restParam;
        newInvokableTypeSym.returnType = newInvokableSymbol.retType;
        newInvokableType.tsymbol = newInvokableTypeSym;
        newInvokableSymbol.type = newInvokableType;
        return newInvokableSymbol;
    }

    private BVarSymbol duplicateSymbol(BVarSymbol original) {
        BVarSymbol duplicate = new BVarSymbol(original.flags, original.isWildcard, original.name, original.originalName, original.pkgID, original.type, original.owner, original.pos, original.origin);
        duplicate.markdownDocumentation = original.markdownDocumentation;
        for (AnnotationAttachmentSymbol annotationAttachmentSymbol : original.getAnnotations()) {
            duplicate.addAnnotation(annotationAttachmentSymbol);
        }
        duplicate.isDefaultable = original.isDefaultable;
        duplicate.state = original.state;
        return duplicate;
    }

    private BInvokableSymbol duplicateSymbol(BInvokableSymbol original) {
        BInvokableSymbol duplicate = Symbols.createInvokableSymbol(original.tag, original.flags, original.name, original.originalName, original.pkgID, original.type, original.owner, original.pos, original.origin);
        duplicate.getAnnotations().addAll(original.getAnnotations());
        List<? extends AnnotationAttachmentSymbol> annotationAttachmentsOnExternal = original.getAnnotationAttachmentsOnExternal();
        if (annotationAttachmentsOnExternal != null) {
            duplicate.setAnnotationAttachmentsOnExternal(annotationAttachmentsOnExternal);
        }
        duplicate.bodyExist = original.bodyExist;
        duplicate.markdownDocumentation = original.markdownDocumentation;
        duplicate.receiverSymbol = original.receiverSymbol;
        return duplicate;
    }
}

