/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.SymbolTransformer;
import io.ballerina.compiler.api.SymbolVisitor;
import io.ballerina.compiler.api.impl.symbols.BallerinaSymbol;
import io.ballerina.compiler.api.symbols.AnnotationAttachPoint;
import io.ballerina.compiler.api.symbols.AnnotationAttachmentSymbol;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaAnnotationSymbol
extends BallerinaSymbol
implements AnnotationSymbol {
    private final List<Qualifier> qualifiers;
    private final TypeSymbol typeDescriptor;
    private final List<AnnotationAttachPoint> attachPoints;
    private final List<AnnotationSymbol> annots;
    private final List<AnnotationAttachmentSymbol> annotAttachments;
    private final Documentation docAttachment;
    private final boolean deprecated;

    private BallerinaAnnotationSymbol(String name, List<Qualifier> qualifiers, TypeSymbol typeDescriptor, List<AnnotationAttachPoint> attachPoints, List<AnnotationSymbol> annots, List<AnnotationAttachmentSymbol> annotAttachments, BSymbol bSymbol, CompilerContext context) {
        super(name, SymbolKind.ANNOTATION, bSymbol, context);
        this.qualifiers = Collections.unmodifiableList(qualifiers);
        this.typeDescriptor = typeDescriptor;
        this.attachPoints = Collections.unmodifiableList(attachPoints);
        this.annotAttachments = Collections.unmodifiableList(annotAttachments);
        this.annots = Collections.unmodifiableList(annots);
        this.docAttachment = this.getDocAttachment(bSymbol);
        this.deprecated = Symbols.isFlagOn(bSymbol.flags, 16L);
    }

    @Override
    public List<Qualifier> qualifiers() {
        return this.qualifiers;
    }

    @Override
    public Optional<TypeSymbol> typeDescriptor() {
        return Optional.ofNullable(this.typeDescriptor);
    }

    @Override
    public List<AnnotationAttachPoint> attachPoints() {
        return this.attachPoints;
    }

    @Override
    public List<AnnotationSymbol> annotations() {
        return this.annots;
    }

    @Override
    public List<AnnotationAttachmentSymbol> annotAttachments() {
        return this.annotAttachments;
    }

    @Override
    public Optional<Documentation> documentation() {
        return Optional.ofNullable(this.docAttachment);
    }

    @Override
    public boolean deprecated() {
        return this.deprecated;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(SymbolTransformer<T> transformer) {
        return transformer.transform(this);
    }

    public static class AnnotationSymbolBuilder
    extends BallerinaSymbol.SymbolBuilder<AnnotationSymbolBuilder> {
        private final List<Qualifier> qualifiers = new ArrayList<Qualifier>();
        private TypeSymbol typeDescriptor;
        private List<AnnotationAttachPoint> attachPoints;
        private final List<AnnotationSymbol> annots = new ArrayList<AnnotationSymbol>();
        private final List<AnnotationAttachmentSymbol> annotAttachments = new ArrayList<AnnotationAttachmentSymbol>();

        public AnnotationSymbolBuilder(String name, BAnnotationSymbol annotationSymbol, CompilerContext context) {
            super(name, SymbolKind.ANNOTATION, annotationSymbol, context);
            this.withAttachPoints(annotationSymbol);
        }

        @Override
        public BallerinaAnnotationSymbol build() {
            return new BallerinaAnnotationSymbol(this.name, this.qualifiers, this.typeDescriptor, this.attachPoints, this.annots, this.annotAttachments, this.bSymbol, this.context);
        }

        private void withAttachPoints(BAnnotationSymbol annotationSymbol) {
            this.attachPoints = AnnotationSymbolBuilder.getAttachPoints(annotationSymbol.maskedPoints);
        }

        public AnnotationSymbolBuilder withQualifier(Qualifier qualifier) {
            this.qualifiers.add(qualifier);
            return this;
        }

        public AnnotationSymbolBuilder withTypeDescriptor(TypeSymbol typeDescriptor) {
            this.typeDescriptor = typeDescriptor;
            return this;
        }

        public AnnotationSymbolBuilder withAnnotation(AnnotationSymbol annot) {
            this.annots.add(annot);
            return this;
        }

        public AnnotationSymbolBuilder withAnnotationAttachment(AnnotationAttachmentSymbol annotAttachment) {
            this.annotAttachments.add(annotAttachment);
            return this;
        }

        public static List<AnnotationAttachPoint> getAttachPoints(int maskedPoints) {
            ArrayList<AnnotationAttachPoint> annotationAttachPoints = new ArrayList<AnnotationAttachPoint>();
            if (Symbols.isAttachPointPresent(maskedPoints, 1)) {
                annotationAttachPoints.add(AnnotationAttachPoint.TYPE);
            }
            if (Symbols.isAttachPointPresent(maskedPoints, 2)) {
                annotationAttachPoints.add(AnnotationAttachPoint.OBJECT);
            }
            if (Symbols.isAttachPointPresent(maskedPoints, 4)) {
                annotationAttachPoints.add(AnnotationAttachPoint.FUNCTION);
            }
            if (Symbols.isAttachPointPresent(maskedPoints, 8)) {
                annotationAttachPoints.add(AnnotationAttachPoint.OBJECT_METHOD);
            }
            if (Symbols.isAttachPointPresent(maskedPoints, 16)) {
                annotationAttachPoints.add(AnnotationAttachPoint.RESOURCE);
            }
            if (Symbols.isAttachPointPresent(maskedPoints, 32)) {
                annotationAttachPoints.add(AnnotationAttachPoint.PARAMETER);
            }
            if (Symbols.isAttachPointPresent(maskedPoints, 64)) {
                annotationAttachPoints.add(AnnotationAttachPoint.RETURN);
            }
            if (Symbols.isAttachPointPresent(maskedPoints, 128)) {
                annotationAttachPoints.add(AnnotationAttachPoint.SERVICE);
            }
            if (Symbols.isAttachPointPresent(maskedPoints, 131072)) {
                annotationAttachPoints.add(AnnotationAttachPoint.CLASS);
            }
            if (Symbols.isAttachPointPresent(maskedPoints, 2048)) {
                annotationAttachPoints.add(AnnotationAttachPoint.LISTENER);
            }
            if (Symbols.isAttachPointPresent(maskedPoints, 4096)) {
                annotationAttachPoints.add(AnnotationAttachPoint.ANNOTATION);
            }
            if (Symbols.isAttachPointPresent(maskedPoints, 8192)) {
                annotationAttachPoints.add(AnnotationAttachPoint.EXTERNAL);
            }
            if (Symbols.isAttachPointPresent(maskedPoints, 16384)) {
                annotationAttachPoints.add(AnnotationAttachPoint.VAR);
            }
            if (Symbols.isAttachPointPresent(maskedPoints, 32768)) {
                annotationAttachPoints.add(AnnotationAttachPoint.CONST);
            }
            if (Symbols.isAttachPointPresent(maskedPoints, 65536)) {
                annotationAttachPoints.add(AnnotationAttachPoint.WORKER);
            }
            if (Symbols.isAttachPointPresent(maskedPoints, 256)) {
                annotationAttachPoints.add(AnnotationAttachPoint.FIELD);
            }
            if (Symbols.isAttachPointPresent(maskedPoints, 512)) {
                annotationAttachPoints.add(AnnotationAttachPoint.OBJECT_FIELD);
            }
            if (Symbols.isAttachPointPresent(maskedPoints, 1024)) {
                annotationAttachPoints.add(AnnotationAttachPoint.RECORD_FIELD);
            }
            return annotationAttachPoints;
        }
    }
}

