/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.SymbolTransformer;
import io.ballerina.compiler.api.SymbolVisitor;
import io.ballerina.compiler.api.impl.symbols.BallerinaSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaTypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.AnnotationAttachmentSymbol;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ConstantSymbol;
import io.ballerina.compiler.api.symbols.EnumSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaEnumSymbol
extends BallerinaTypeDefinitionSymbol
implements EnumSymbol {
    private final List<ConstantSymbol> members;
    private final List<AnnotationSymbol> annots;
    private final List<AnnotationAttachmentSymbol> annotAttachments;

    protected BallerinaEnumSymbol(String name, List<ConstantSymbol> members, List<Qualifier> qualifiers, List<AnnotationSymbol> annots, List<AnnotationAttachmentSymbol> annotAttachments, TypeSymbol typeDescriptor, BSymbol bSymbol, CompilerContext context) {
        super(name, qualifiers, annots, annotAttachments, typeDescriptor, bSymbol, context);
        this.members = Collections.unmodifiableList(members);
        this.annots = annots;
        this.annotAttachments = annotAttachments;
    }

    @Override
    public List<ConstantSymbol> members() {
        return this.members;
    }

    @Override
    public List<AnnotationSymbol> annotations() {
        return this.annots;
    }

    @Override
    public List<AnnotationAttachmentSymbol> annotAttachments() {
        return this.annotAttachments;
    }

    @Override
    public SymbolKind kind() {
        return SymbolKind.ENUM;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(SymbolTransformer<T> transformer) {
        return transformer.transform(this);
    }

    public static class EnumSymbolBuilder
    extends BallerinaSymbol.SymbolBuilder<EnumSymbolBuilder> {
        protected List<ConstantSymbol> members;
        protected List<Qualifier> qualifiers = new ArrayList<Qualifier>();
        protected List<AnnotationSymbol> annots = new ArrayList<AnnotationSymbol>();
        protected List<AnnotationAttachmentSymbol> annotAttachments = new ArrayList<AnnotationAttachmentSymbol>();
        protected TypeSymbol typeDescriptor;

        public EnumSymbolBuilder(String name, BSymbol symbol, CompilerContext context) {
            super(name, SymbolKind.TYPE_DEFINITION, symbol, context);
        }

        public EnumSymbolBuilder withMembers(List<ConstantSymbol> members) {
            this.members = members;
            return this;
        }

        public EnumSymbolBuilder withTypeDescriptor(TypeSymbol typeDescriptor) {
            this.typeDescriptor = typeDescriptor;
            return this;
        }

        public EnumSymbolBuilder withQualifier(Qualifier qualifier) {
            this.qualifiers.add(qualifier);
            return this;
        }

        public EnumSymbolBuilder withAnnotation(AnnotationSymbol annot) {
            this.annots.add(annot);
            return this;
        }

        public EnumSymbolBuilder withAnnotationAttachment(AnnotationAttachmentSymbol annotAttachment) {
            this.annotAttachments.add(annotAttachment);
            return this;
        }

        @Override
        public BallerinaEnumSymbol build() {
            return new BallerinaEnumSymbol(this.name, this.members, this.qualifiers, this.annots, this.annotAttachments, this.typeDescriptor, this.bSymbol, this.context);
        }
    }
}

