/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.SymbolTransformer;
import io.ballerina.compiler.api.SymbolVisitor;
import io.ballerina.compiler.api.impl.symbols.BallerinaSymbol;
import io.ballerina.compiler.api.symbols.AnnotationAttachmentSymbol;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.ExternalFunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.SymbolKind;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaFunctionSymbol
extends BallerinaSymbol
implements FunctionSymbol {
    private final FunctionTypeSymbol typeDescriptor;
    private final List<Qualifier> qualifiers;
    private final List<AnnotationSymbol> annots;
    private final List<AnnotationAttachmentSymbol> annotAttachments;
    private final Documentation docAttachment;
    private final boolean isExternal;
    private final boolean deprecated;

    protected BallerinaFunctionSymbol(String name, List<Qualifier> qualifiers, List<AnnotationSymbol> annots, List<AnnotationAttachmentSymbol> annotAttachments, FunctionTypeSymbol typeDescriptor, BInvokableSymbol invokableSymbol, CompilerContext context) {
        super(name, SymbolKind.FUNCTION, invokableSymbol, context);
        this.qualifiers = Collections.unmodifiableList(qualifiers);
        this.annots = Collections.unmodifiableList(annots);
        this.annotAttachments = Collections.unmodifiableList(annotAttachments);
        this.docAttachment = this.getDocAttachment(invokableSymbol);
        this.typeDescriptor = typeDescriptor;
        this.isExternal = Symbols.isNative(invokableSymbol);
        this.deprecated = Symbols.isFlagOn(invokableSymbol.flags, 16L);
    }

    @Override
    public List<Qualifier> qualifiers() {
        return this.qualifiers;
    }

    @Override
    public FunctionTypeSymbol typeDescriptor() {
        return this.typeDescriptor;
    }

    @Override
    public boolean external() {
        return this.isExternal;
    }

    @Override
    public boolean deprecated() {
        return this.deprecated;
    }

    @Override
    public List<AnnotationSymbol> annotations() {
        return this.annots;
    }

    @Override
    public List<AnnotationAttachmentSymbol> annotAttachments() {
        return this.annotAttachments;
    }

    @Override
    public Optional<Documentation> documentation() {
        return Optional.ofNullable(this.docAttachment);
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(SymbolTransformer<T> transformer) {
        return transformer.transform(this);
    }

    public static class FunctionSymbolBuilder
    extends BallerinaSymbol.SymbolBuilder<FunctionSymbolBuilder> {
        protected List<Qualifier> qualifiers = new ArrayList<Qualifier>();
        protected List<AnnotationSymbol> annots = new ArrayList<AnnotationSymbol>();
        protected List<AnnotationAttachmentSymbol> annotAttachments = new ArrayList<AnnotationAttachmentSymbol>();
        protected List<AnnotationAttachmentSymbol> annotAttachmentsOnExternal = new ArrayList<AnnotationAttachmentSymbol>();
        protected FunctionTypeSymbol typeDescriptor;

        public FunctionSymbolBuilder(String name, BInvokableSymbol bSymbol, CompilerContext context) {
            this(name, SymbolKind.FUNCTION, bSymbol, context);
        }

        public FunctionSymbolBuilder(String name, SymbolKind kind, BInvokableSymbol bSymbol, CompilerContext context) {
            super(name, kind, bSymbol, context);
        }

        public FunctionSymbolBuilder withTypeDescriptor(FunctionTypeSymbol typeDescriptor) {
            this.typeDescriptor = typeDescriptor;
            return this;
        }

        public FunctionSymbolBuilder withQualifier(Qualifier qualifier) {
            this.qualifiers.add(qualifier);
            return this;
        }

        public FunctionSymbolBuilder withQualifiers(List<Qualifier> qualifiers) {
            this.qualifiers.addAll(qualifiers);
            return this;
        }

        public FunctionSymbolBuilder withAnnotation(AnnotationSymbol annot) {
            this.annots.add(annot);
            return this;
        }

        public FunctionSymbolBuilder withAnnotationAttachment(AnnotationAttachmentSymbol annotationAttachment) {
            this.annotAttachments.add(annotationAttachment);
            return this;
        }

        public FunctionSymbolBuilder withAnnotationAttachmentOnExternal(AnnotationAttachmentSymbol annotationAttachment) {
            this.annotAttachmentsOnExternal.add(annotationAttachment);
            return this;
        }

        @Override
        public BallerinaFunctionSymbol build() {
            BInvokableSymbol invokableSymbol = (BInvokableSymbol)this.bSymbol;
            if (Symbols.isNative(invokableSymbol)) {
                return new BallerinaExternalFunctionSymbol(this.name, this.qualifiers, this.annots, this.annotAttachments, this.typeDescriptor, invokableSymbol, this.context, this.annotAttachmentsOnExternal);
            }
            return new BallerinaFunctionSymbol(this.name, this.qualifiers, this.annots, this.annotAttachments, this.typeDescriptor, invokableSymbol, this.context);
        }
    }

    public static class BallerinaExternalFunctionSymbol
    extends BallerinaFunctionSymbol
    implements ExternalFunctionSymbol {
        private final List<AnnotationAttachmentSymbol> annotAttachmentsOnExternal;

        protected BallerinaExternalFunctionSymbol(String name, List<Qualifier> qualifiers, List<AnnotationSymbol> annots, List<AnnotationAttachmentSymbol> annotAttachments, FunctionTypeSymbol typeDescriptor, BInvokableSymbol invokableSymbol, CompilerContext context, List<AnnotationAttachmentSymbol> annotAttachmentsOnExternal) {
            super(name, qualifiers, annots, annotAttachments, typeDescriptor, invokableSymbol, context);
            this.annotAttachmentsOnExternal = annotAttachmentsOnExternal;
        }

        @Override
        public List<AnnotationAttachmentSymbol> annotAttachmentsOnExternal() {
            return this.annotAttachmentsOnExternal;
        }
    }
}

