/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.SymbolTransformer;
import io.ballerina.compiler.api.SymbolVisitor;
import io.ballerina.compiler.api.impl.symbols.BallerinaSymbol;
import io.ballerina.compiler.api.symbols.AnnotationAttachmentSymbol;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ParameterKind;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaParameterSymbol
extends BallerinaSymbol
implements ParameterSymbol {
    private final List<Qualifier> qualifiers;
    private final List<AnnotationSymbol> annots;
    private final List<AnnotationAttachmentSymbol> annotAttachments;
    private final TypeSymbol typeDescriptor;
    private final ParameterKind paramKind;

    public BallerinaParameterSymbol(String parameterName, TypeSymbol typeDescriptor, List<Qualifier> qualifiers, List<AnnotationSymbol> annots, List<AnnotationAttachmentSymbol> annotAttachments, ParameterKind paramKind, BVarSymbol symbol, CompilerContext context) {
        super(parameterName, SymbolKind.PARAMETER, symbol, context);
        this.typeDescriptor = typeDescriptor;
        this.qualifiers = Collections.unmodifiableList(qualifiers);
        this.annots = Collections.unmodifiableList(annots);
        this.annotAttachments = Collections.unmodifiableList(annotAttachments);
        this.paramKind = paramKind;
    }

    @Override
    public TypeSymbol typeDescriptor() {
        return this.typeDescriptor;
    }

    @Override
    public List<Qualifier> qualifiers() {
        return this.qualifiers;
    }

    @Override
    public List<AnnotationSymbol> annotations() {
        return this.annots;
    }

    @Override
    public List<AnnotationAttachmentSymbol> annotAttachments() {
        return this.annotAttachments;
    }

    @Override
    public String signature() {
        Object signature;
        StringJoiner joiner = new StringJoiner(" ");
        this.qualifiers().forEach(accessModifier -> joiner.add(accessModifier.getValue()));
        if (this.paramKind() == ParameterKind.INCLUDED_RECORD) {
            signature = "*" + this.typeDescriptor().signature();
        } else if (this.paramKind() == ParameterKind.REST) {
            signature = this.typeDescriptor().signature();
            signature = ((String)signature).substring(0, ((String)signature).length() - 2) + "...";
        } else {
            signature = this.typeDescriptor().signature();
        }
        joiner.add((CharSequence)signature);
        if (this.getName().isPresent()) {
            joiner.add(this.getName().get());
        }
        return joiner.toString();
    }

    @Override
    public ParameterKind paramKind() {
        return this.paramKind;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(SymbolTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

