/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.SymbolTransformer;
import io.ballerina.compiler.api.SymbolVisitor;
import io.ballerina.compiler.api.impl.symbols.BallerinaSymbol;
import io.ballerina.compiler.api.symbols.AnnotationAttachmentSymbol;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.DiagnosticState;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaVariableSymbol
extends BallerinaSymbol
implements VariableSymbol {
    private final List<Qualifier> qualifiers;
    private final List<AnnotationSymbol> annots;
    private final Documentation docAttachment;
    private final TypeSymbol typeDescriptorImpl;
    private final boolean deprecated;
    private final List<AnnotationAttachmentSymbol> annotAttachments;

    protected BallerinaVariableSymbol(String name, SymbolKind ballerinaSymbolKind, List<Qualifier> qualifiers, List<AnnotationSymbol> annots, List<AnnotationAttachmentSymbol> annotAttachments, TypeSymbol typeDescriptorImpl, BSymbol bSymbol, CompilerContext context) {
        super(name, ballerinaSymbolKind, bSymbol, context);
        this.qualifiers = Collections.unmodifiableList(qualifiers);
        this.annots = Collections.unmodifiableList(annots);
        this.annotAttachments = Collections.unmodifiableList(annotAttachments);
        this.docAttachment = this.getDocAttachment(bSymbol);
        this.typeDescriptorImpl = typeDescriptorImpl;
        this.deprecated = Symbols.isFlagOn(bSymbol.flags, 16L);
    }

    @Override
    public List<Qualifier> qualifiers() {
        return this.qualifiers;
    }

    @Override
    public TypeSymbol typeDescriptor() {
        return this.typeDescriptorImpl;
    }

    @Override
    public DiagnosticState diagnosticState() {
        return ((BVarSymbol)this.getInternalSymbol()).state;
    }

    @Override
    public boolean deprecated() {
        return this.deprecated;
    }

    @Override
    public List<AnnotationSymbol> annotations() {
        return this.annots;
    }

    @Override
    public List<AnnotationAttachmentSymbol> annotAttachments() {
        return this.annotAttachments;
    }

    @Override
    public Optional<Documentation> documentation() {
        return Optional.ofNullable(this.docAttachment);
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(SymbolTransformer<T> transformer) {
        return transformer.transform(this);
    }

    public static class VariableSymbolBuilder
    extends BallerinaSymbol.SymbolBuilder<VariableSymbolBuilder> {
        protected List<Qualifier> qualifiers = new ArrayList<Qualifier>();
        protected List<AnnotationSymbol> annots = new ArrayList<AnnotationSymbol>();
        protected List<AnnotationAttachmentSymbol> annotAttachments = new ArrayList<AnnotationAttachmentSymbol>();
        protected TypeSymbol typeDescriptor;

        public VariableSymbolBuilder(String name, BSymbol bSymbol, CompilerContext context) {
            super(name, SymbolKind.VARIABLE, bSymbol, context);
        }

        @Override
        public BallerinaVariableSymbol build() {
            return new BallerinaVariableSymbol(this.name, this.ballerinaSymbolKind, this.qualifiers, this.annots, this.annotAttachments, this.typeDescriptor, this.bSymbol, this.context);
        }

        public VariableSymbolBuilder withTypeDescriptor(TypeSymbol typeDescriptor) {
            this.typeDescriptor = typeDescriptor;
            return this;
        }

        public VariableSymbolBuilder withQualifier(Qualifier qualifier) {
            this.qualifiers.add(qualifier);
            return this;
        }

        public VariableSymbolBuilder withAnnotation(AnnotationSymbol annot) {
            this.annots.add(annot);
            return this;
        }

        public VariableSymbolBuilder withAnnotationAttachment(AnnotationAttachmentSymbol annotAttachment) {
            this.annotAttachments.add(annotAttachment);
            return this;
        }
    }
}

