/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.SymbolTransformer;
import io.ballerina.compiler.api.SymbolVisitor;
import io.ballerina.compiler.api.impl.symbols.BallerinaSymbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.XMLNamespaceSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BXMLNSSymbol;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaXMLNSSymbol
extends BallerinaSymbol
implements XMLNamespaceSymbol {
    private final String namespaceUri;

    private BallerinaXMLNSSymbol(String name, BSymbol symbol, String namespaceUri, CompilerContext context) {
        super(name, SymbolKind.XMLNS, symbol, context);
        this.namespaceUri = namespaceUri;
    }

    @Override
    public String namespaceUri() {
        return this.namespaceUri;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(SymbolTransformer<T> transformer) {
        return transformer.transform(this);
    }

    public static class XmlNSSymbolBuilder
    extends BallerinaSymbol.SymbolBuilder<XmlNSSymbolBuilder> {
        protected String uri;

        public XmlNSSymbolBuilder(String name, BXMLNSSymbol symbol, CompilerContext context) {
            super(name, SymbolKind.XMLNS, symbol, context);
            this.uri = symbol.namespaceURI;
        }

        @Override
        public BallerinaXMLNSSymbol build() {
            return new BallerinaXMLNSSymbol(this.name, this.bSymbol, this.uri, this.context);
        }
    }
}

