/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols.resourcepath;

import io.ballerina.compiler.api.impl.SymbolFactory;
import io.ballerina.compiler.api.impl.symbols.resourcepath.util.BallerinaNamedPathSegment;
import io.ballerina.compiler.api.symbols.PathParameterSymbol;
import io.ballerina.compiler.api.symbols.resourcepath.PathSegmentList;
import io.ballerina.compiler.api.symbols.resourcepath.ResourcePath;
import io.ballerina.compiler.api.symbols.resourcepath.util.PathSegment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BResourcePathSegmentSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;

public class BallerinaPathSegmentList
implements PathSegmentList {
    private final List<BVarSymbol> internalPathParams;
    private final BVarSymbol internalPathRestParam;
    private final List<BResourcePathSegmentSymbol> internalPathSegmentSymbols;
    private final CompilerContext context;
    private List<PathParameterSymbol> pathParams;
    private PathParameterSymbol pathRestParam;
    private List<PathSegment> resourcePathSymbols;
    private String signature;

    public BallerinaPathSegmentList(List<BResourcePathSegmentSymbol> resourcePathSymbols, List<BVarSymbol> pathParams, BVarSymbol pathRestParam, CompilerContext context) {
        this.internalPathSegmentSymbols = resourcePathSymbols;
        this.internalPathParams = pathParams;
        this.internalPathRestParam = pathRestParam;
        this.context = context;
    }

    @Override
    public List<PathParameterSymbol> pathParameters() {
        if (this.pathParams != null) {
            return this.pathParams;
        }
        SymbolFactory symbolFactory = SymbolFactory.getInstance(this.context);
        ArrayList<PathParameterSymbol> pathParams = new ArrayList<PathParameterSymbol>();
        int internalPathParamCount = 0;
        List<Name> segments = this.internalPathSegmentSymbols.stream().map(s -> s.name).toList();
        block8: for (int i = 0; i < segments.size(); ++i) {
            Name internalSegment = segments.get(i);
            BResourcePathSegmentSymbol pathSegSymbol = this.internalPathSegmentSymbols.get(i);
            switch (internalSegment.value) {
                case "^": {
                    BVarSymbol paramVarSymbol = this.internalPathParams.get(internalPathParamCount++);
                    pathParams.add(symbolFactory.createPathParamSymbol(paramVarSymbol.getOriginalName().getValue(), paramVarSymbol, PathSegment.Kind.PATH_PARAMETER));
                    continue block8;
                }
                case "$^": {
                    pathParams.add(symbolFactory.createPathParamSymbol(pathSegSymbol.getOriginalName().getValue(), pathSegSymbol, PathSegment.Kind.PATH_PARAMETER));
                    continue block8;
                }
            }
        }
        this.pathParams = Collections.unmodifiableList(pathParams);
        return this.pathParams;
    }

    @Override
    public Optional<PathParameterSymbol> pathRestParameter() {
        if (this.pathRestParam != null) {
            return Optional.of(this.pathRestParam);
        }
        SymbolFactory symbolFactory = SymbolFactory.getInstance(this.context);
        BSymbol segment = null;
        for (BResourcePathSegmentSymbol internalPathSegmentSymbol : this.internalPathSegmentSymbols) {
            if (!"$^^".equals(internalPathSegmentSymbol.getOriginalName().getValue()) && !"^^".equals(internalPathSegmentSymbol.getOriginalName().getValue())) continue;
            segment = internalPathSegmentSymbol;
            break;
        }
        if (segment == null) {
            return Optional.empty();
        }
        if (this.internalPathRestParam == null) {
            this.pathRestParam = symbolFactory.createPathParamSymbol(segment.getOriginalName().getValue(), segment, PathSegment.Kind.PATH_REST_PARAMETER);
            return Optional.of(this.pathRestParam);
        }
        this.pathRestParam = symbolFactory.createPathParamSymbol(this.internalPathRestParam.getOriginalName().getValue(), this.internalPathRestParam, PathSegment.Kind.PATH_REST_PARAMETER);
        return Optional.ofNullable(this.pathRestParam);
    }

    @Override
    public List<PathSegment> list() {
        if (this.resourcePathSymbols != null) {
            return this.resourcePathSymbols;
        }
        List<PathParameterSymbol> pathParams = this.pathParameters();
        ArrayList<BallerinaNamedPathSegment> segments = new ArrayList<BallerinaNamedPathSegment>();
        SymbolFactory symbolFactory = SymbolFactory.getInstance(this.context);
        int pathParamCount = 0;
        int pathSegmentCount = this.internalPathSegmentSymbols.size();
        for (int i = 0; i < pathSegmentCount; ++i) {
            BResourcePathSegmentSymbol pathSegmentSymbol = this.internalPathSegmentSymbols.get(i);
            PathSegment segment = switch (pathSegmentSymbol.getName().getValue()) {
                case "$^", "^" -> pathParams.get(pathParamCount++);
                case "^^", "$^^" -> this.pathRestParameter().get();
                default -> symbolFactory.createPathNameSymbol(pathSegmentSymbol);
            };
            segments.add((BallerinaNamedPathSegment)segment);
        }
        this.resourcePathSymbols = Collections.unmodifiableList(segments);
        return this.resourcePathSymbols;
    }

    @Override
    public ResourcePath.Kind kind() {
        return ResourcePath.Kind.PATH_SEGMENT_LIST;
    }

    @Override
    public String signature() {
        if (this.signature != null) {
            return this.signature;
        }
        StringJoiner stringJoiner = new StringJoiner("/");
        List<PathSegment> segments = this.list();
        for (PathSegment segment : segments) {
            stringJoiner.add(segment.signature());
        }
        this.signature = stringJoiner.toString();
        return this.signature;
    }
}

