/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.type.builders;

import io.ballerina.compiler.api.TypeBuilder;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.MapTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Names;

public class BallerinaMapTypeBuilder
implements TypeBuilder.MAP {
    private final TypesFactory typesFactory;
    private final SymbolTable symTable;
    private TypeSymbol typeParam;

    public BallerinaMapTypeBuilder(CompilerContext context) {
        this.typesFactory = TypesFactory.getInstance(context);
        this.symTable = SymbolTable.getInstance(context);
    }

    @Override
    public TypeBuilder.MAP withTypeParam(TypeSymbol typeParam) {
        this.typeParam = typeParam;
        return this;
    }

    @Override
    public MapTypeSymbol build() {
        BTypeSymbol mapTSymbol = Symbols.createTypeSymbol(12L, 1L, Names.EMPTY, this.symTable.rootPkgSymbol.pkgID, null, this.symTable.rootPkgSymbol, this.symTable.builtinPos, this.symTable.rootPkgSymbol.origin);
        BMapType mapType = new BMapType(this.symTable.typeEnv(), 16, this.getBType(this.typeParam), mapTSymbol);
        mapTSymbol.type = mapType;
        MapTypeSymbol mapTypeSymbol = (MapTypeSymbol)this.typesFactory.getTypeDescriptor(mapType);
        this.typeParam = null;
        return mapTypeSymbol;
    }

    private BType getBType(TypeSymbol typeSymbol) {
        if (typeSymbol == null) {
            return null;
        }
        if (typeSymbol instanceof AbstractTypeSymbol && typeSymbol.subtypeOf(this.typesFactory.getTypeDescriptor(this.symTable.anyType))) {
            return ((AbstractTypeSymbol)typeSymbol).getBType();
        }
        throw new IllegalArgumentException("Valid type parameter of Map type should be provided");
    }
}

