/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.type.builders;

import io.ballerina.compiler.api.TypeBuilder;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.api.symbols.XMLTypeSymbol;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Names;

public class BallerinaXMLTypeBuilder
implements TypeBuilder.XML {
    private final TypesFactory typesFactory;
    private final SymbolTable symTable;
    private TypeSymbol typeParam;
    private final Map<String, Boolean> checkedTypeRefs = new HashMap<String, Boolean>();
    private final Set<String> visitedTypeRefs = new HashSet<String>();
    private final Map<String, Boolean> checkedUnionTypes = new HashMap<String, Boolean>();
    private final Set<String> visitedUnionTypes = new HashSet<String>();

    public BallerinaXMLTypeBuilder(CompilerContext context) {
        this.typesFactory = TypesFactory.getInstance(context);
        this.symTable = SymbolTable.getInstance(context);
    }

    @Override
    public TypeBuilder.XML withTypeParam(TypeSymbol typeParam) {
        this.typeParam = typeParam;
        return this;
    }

    @Override
    public XMLTypeSymbol build() {
        BTypeSymbol typeSymbol = Symbols.createTypeSymbol(8L, 1L, Names.XML, Names.EMPTY, this.symTable.rootPkgSymbol.pkgID, null, this.symTable.rootPkgSymbol, this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
        BXMLType xmlType = new BXMLType(this.getBType(this.typeParam), typeSymbol);
        typeSymbol.type = xmlType;
        XMLTypeSymbol xmlTypeSymbol = (XMLTypeSymbol)this.typesFactory.getTypeDescriptor(xmlType);
        this.typeParam = null;
        return xmlTypeSymbol;
    }

    private BType getBType(TypeSymbol typeSymbol) {
        if (typeSymbol != null) {
            if (this.isValidTypeParam(typeSymbol)) {
                return ((AbstractTypeSymbol)typeSymbol).getBType();
            }
            throw new IllegalArgumentException("Valid XML type param should be provided");
        }
        return null;
    }

    private boolean isValidTypeParam(TypeSymbol typeSymbol) {
        return this.isValidXMLSubType(typeSymbol) || typeSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE && this.isValidTypeReference((TypeReferenceTypeSymbol)typeSymbol) || typeSymbol.typeKind() == TypeDescKind.UNION && this.isValidUnionType((UnionTypeSymbol)typeSymbol);
    }

    private boolean isValidTypeReference(TypeReferenceTypeSymbol typeSymbol) {
        if (this.visitedTypeRefs.contains(typeSymbol.signature())) {
            throw new IllegalArgumentException("Type parameter " + typeSymbol.signature() + " contains cyclic dependencies");
        }
        Boolean checkedTypeRef = this.checkedTypeRefs.get(typeSymbol.signature());
        if (checkedTypeRef != null) {
            return checkedTypeRef;
        }
        this.visitedTypeRefs.add(typeSymbol.signature());
        boolean isValidTypeParam = this.isValidTypeParam(typeSymbol.typeDescriptor());
        this.visitedTypeRefs.remove(typeSymbol.signature());
        this.checkedTypeRefs.put(typeSymbol.signature(), isValidTypeParam);
        return isValidTypeParam;
    }

    private boolean isValidUnionType(UnionTypeSymbol typeSymbol) {
        if (this.visitedUnionTypes.contains(typeSymbol.signature())) {
            throw new IllegalArgumentException("Type parameter " + typeSymbol.signature() + " contains cyclic dependencies");
        }
        Boolean checkedUnionType = this.checkedUnionTypes.get(typeSymbol.signature());
        if (checkedUnionType != null) {
            return checkedUnionType;
        }
        this.visitedUnionTypes.add(typeSymbol.signature());
        boolean hasValidMembers = true;
        for (TypeSymbol memberTypeDescriptor : typeSymbol.memberTypeDescriptors()) {
            if (this.isValidTypeParam(memberTypeDescriptor)) continue;
            hasValidMembers = false;
        }
        this.visitedUnionTypes.remove(typeSymbol.signature());
        this.checkedUnionTypes.put(typeSymbol.signature(), hasValidMembers);
        return hasValidMembers;
    }

    private boolean isValidXMLSubType(TypeSymbol typeSymbol) {
        TypeDescKind typeKind = typeSymbol.typeKind();
        return typeKind == TypeDescKind.XML || typeKind == TypeDescKind.XML_ELEMENT || typeKind == TypeDescKind.XML_TEXT || typeKind == TypeDescKind.XML_PROCESSING_INSTRUCTION || typeKind == TypeDescKind.XML_COMMENT;
    }
}

