/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.util;

import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ClassFieldSymbol;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.ConstantSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.ObjectFieldSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.identifier.Utils;
import io.ballerina.projects.Document;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Stream;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLType;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangTestablePackage;

public final class SymbolUtils {
    private SymbolUtils() {
    }

    public static String unescapeUnicode(String value) {
        if (value.startsWith("'")) {
            return Utils.unescapeUnicodeCodepoints((String)value.substring(1));
        }
        return Utils.unescapeUnicodeCodepoints((String)value);
    }

    public static Optional<TypeSymbol> getTypeDescriptor(Symbol symbol) {
        if (symbol == null) {
            return Optional.empty();
        }
        return switch (symbol.kind()) {
            case SymbolKind.TYPE_DEFINITION -> Optional.ofNullable(((TypeDefinitionSymbol)symbol).typeDescriptor());
            case SymbolKind.VARIABLE -> Optional.ofNullable(((VariableSymbol)symbol).typeDescriptor());
            case SymbolKind.PARAMETER -> Optional.ofNullable(((ParameterSymbol)symbol).typeDescriptor());
            case SymbolKind.ANNOTATION -> ((AnnotationSymbol)symbol).typeDescriptor();
            case SymbolKind.FUNCTION, SymbolKind.METHOD -> Optional.ofNullable(((FunctionSymbol)symbol).typeDescriptor());
            case SymbolKind.CONSTANT, SymbolKind.ENUM_MEMBER -> Optional.ofNullable(((ConstantSymbol)symbol).typeDescriptor());
            case SymbolKind.CLASS -> Optional.of((ClassSymbol)symbol);
            case SymbolKind.RECORD_FIELD -> Optional.ofNullable(((RecordFieldSymbol)symbol).typeDescriptor());
            case SymbolKind.OBJECT_FIELD -> Optional.of(((ObjectFieldSymbol)symbol).typeDescriptor());
            case SymbolKind.CLASS_FIELD -> Optional.of(((ClassFieldSymbol)symbol).typeDescriptor());
            case SymbolKind.TYPE -> Optional.of((TypeSymbol)symbol);
            default -> Optional.empty();
        };
    }

    public static BType getTypeParamBoundType(BType type) {
        return switch (type.getKind()) {
            case TypeKind.MAP -> ((BMapType)type).constraint;
            case TypeKind.ARRAY -> ((BArrayType)type).eType;
            case TypeKind.TABLE -> ((BTableType)type).constraint;
            case TypeKind.STREAM -> ((BStreamType)type).constraint;
            case TypeKind.XML -> {
                if (type.tag == 8) {
                    yield ((BXMLType)type).constraint;
                }
                yield type;
            }
            case TypeKind.ERROR -> null;
            default -> null;
        };
    }

    public static Optional<BLangCompilationUnit> getCompilationUnit(BLangPackage bLangPackage, Document srcFile) {
        return SymbolUtils.getCompilationUnit(bLangPackage, srcFile.name());
    }

    public static Optional<BLangCompilationUnit> getCompilationUnit(BLangPackage bLangPackage, String srcFile) {
        ArrayList testSrcs = new ArrayList();
        for (BLangTestablePackage pkg : bLangPackage.testablePkgs) {
            testSrcs.addAll(pkg.compUnits);
        }
        Stream units = Stream.concat(bLangPackage.compUnits.stream(), testSrcs.stream());
        return units.filter(unit -> unit.name.equals(srcFile)).findFirst();
    }
}

