/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.symbols;

public enum TypeDescKind {
    INT("int"),
    INT_SIGNED8("Signed8"),
    INT_UNSIGNED8("Unsigned8"),
    INT_SIGNED16("Signed16"),
    INT_UNSIGNED16("Unsigned16"),
    INT_SIGNED32("Signed32"),
    INT_UNSIGNED32("Unsigned32"),
    BYTE("byte"),
    FLOAT("float"),
    DECIMAL("decimal"),
    STRING("string"),
    STRING_CHAR("Char"),
    BOOLEAN("boolean"),
    NIL("nil"),
    ANY("any"),
    ANYDATA("anydata"),
    ARRAY("array"),
    OBJECT("object"),
    RECORD("record"),
    MAP("map"),
    ERROR("error"),
    FUNCTION("function"),
    TUPLE("tuple"),
    STREAM("stream"),
    FUTURE("future"),
    TYPEDESC("typedesc"),
    TYPE_REFERENCE("typeReference"),
    UNION("union"),
    INTERSECTION("intersection"),
    JSON("json"),
    XML("xml"),
    XML_ELEMENT("Element"),
    XML_PROCESSING_INSTRUCTION("ProcessingInstruction"),
    XML_COMMENT("Comment"),
    XML_TEXT("Text"),
    HANDLE("handle"),
    TABLE("table"),
    SINGLETON("singleton"),
    READONLY("readonly"),
    NEVER("never"),
    COMPILATION_ERROR("CompilationError"),
    NONE("None"),
    REGEXP("regexp");

    private final String name;

    private TypeDescKind(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isIntegerType() {
        return switch (this.ordinal()) {
            case 0, 1, 2, 3, 4, 5, 6, 7 -> true;
            default -> false;
        };
    }

    public boolean isXMLType() {
        return switch (this.ordinal()) {
            case 30, 31, 32, 33, 34 -> true;
            default -> false;
        };
    }

    public boolean isStringType() {
        return this == STRING || this == STRING_CHAR;
    }
}

