/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import io.ballerina.projects.DependencyGraph;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentConfig;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleDependency;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageContext;
import io.ballerina.projects.PackageDependencyScope;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.ResolvedPackageDependency;
import io.ballerina.projects.environment.PackageCache;
import io.ballerina.projects.internal.bala.BalaJson;
import io.ballerina.projects.internal.bala.DependencyGraphJson;
import io.ballerina.projects.internal.bala.PackageJson;
import io.ballerina.projects.internal.bala.adaptors.JsonCollectionsAdaptor;
import io.ballerina.projects.internal.bala.adaptors.JsonStringsAdaptor;
import io.ballerina.projects.internal.model.BalToolDescriptor;
import io.ballerina.projects.internal.model.CompilerPluginDescriptor;
import io.ballerina.projects.internal.model.Dependency;
import io.ballerina.projects.util.ProjectUtils;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.ballerinalang.compiler.BLangCompilerException;
import org.wso2.ballerinalang.util.RepoUtils;

public abstract class BalaWriter {
    private static final String MODULES_ROOT = "modules";
    private static final String RESOURCE_DIR_NAME = "resources";
    private static final String BLANG_SOURCE_EXT = ".bal";
    protected static final String PLATFORM = "platform";
    protected static final String PATH = "path";
    private static final String MAIN_BAL = "main.bal";
    private static final String UNIX_FILE_SEPARATOR = "/";
    protected String target = "any";
    private static final String IMPLEMENTATION_VENDOR = "WSO2";
    private static final String BALLERINA_SHORT_VERSION = RepoUtils.getBallerinaShortVersion();
    private static final String BALLERINA_SPEC_VERSION = RepoUtils.getBallerinaSpecVersion();
    protected PackageContext packageContext;
    Optional<CompilerPluginDescriptor> compilerPluginToml;
    protected Optional<BalToolDescriptor> balToolToml;

    protected BalaWriter() {
    }

    public Path write(Path balaPath) {
        String balaName = ProjectUtils.getBalaName(this.packageContext.packageOrg().value(), this.packageContext.packageName().value(), this.packageContext.packageVersion().value().toString(), this.target);
        try (ZipOutputStream balaOutputStream = new ZipOutputStream(new FileOutputStream(String.valueOf(balaPath.resolve(balaName))));){
            this.populateBalaArchive(balaOutputStream);
        }
        catch (IOException e) {
            throw new ProjectException("Failed to create bala :" + e.getMessage(), e);
        }
        catch (BLangCompilerException be) {
            try {
                Files.delete(balaPath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw be;
        }
        return balaPath.resolve(balaName);
    }

    private void populateBalaArchive(ZipOutputStream balaOutputStream) throws IOException {
        this.addBalaJson(balaOutputStream);
        this.addPackageDoc(balaOutputStream, this.packageContext.packageManifest());
        this.addPackageSource(balaOutputStream);
        this.addResources(balaOutputStream);
        this.addIncludes(balaOutputStream);
        Optional<JsonArray> platformLibs = this.addPlatformLibs(balaOutputStream);
        this.addPackageJson(balaOutputStream, platformLibs);
        this.addCompilerPlugin(balaOutputStream);
        this.addBalTool(balaOutputStream);
        this.addDependenciesJson(balaOutputStream);
    }

    private void addBalaJson(ZipOutputStream balaOutputStream) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String balaJson = gson.toJson((Object)new BalaJson());
        try {
            this.putZipEntry(balaOutputStream, Path.of("bala.json", new String[0]), new ByteArrayInputStream(balaJson.getBytes(Charset.defaultCharset())));
        }
        catch (IOException e) {
            throw new ProjectException("Failed to write 'bala.json' file: " + e.getMessage(), e);
        }
    }

    private void addPackageJson(ZipOutputStream balaOutputStream, Optional<JsonArray> platformLibs) {
        PackageJson packageJson = new PackageJson(this.packageContext.packageOrg().toString(), this.packageContext.packageName().toString(), this.packageContext.packageVersion().toString());
        PackageManifest packageManifest = this.packageContext.packageManifest();
        packageJson.setLicenses(packageManifest.license());
        packageJson.setAuthors(packageManifest.authors());
        packageJson.setSourceRepository(packageManifest.repository());
        packageJson.setKeywords(packageManifest.keywords());
        packageJson.setExport(packageManifest.exportedModules());
        packageJson.setInclude(packageManifest.includes());
        packageJson.setVisibility(packageManifest.visibility());
        packageJson.setTemplate(packageManifest.template());
        packageJson.setDescription(packageManifest.description());
        packageJson.setPlatform(this.target);
        packageJson.setBallerinaVersion(BALLERINA_SHORT_VERSION);
        packageJson.setLanguageSpecVersion(BALLERINA_SPEC_VERSION);
        packageJson.setImplementationVendor(IMPLEMENTATION_VENDOR);
        platformLibs.ifPresent(packageJson::setPlatformDependencies);
        if (packageManifest.icon() != null && !packageManifest.icon().isEmpty()) {
            Path iconPath = this.getIconPath(packageManifest.icon());
            packageJson.setIcon("docs/" + String.valueOf(iconPath.getFileName()));
        }
        this.setGraalVMCompatibilityProperty(packageJson, packageManifest);
        this.setReadme(packageManifest, packageJson);
        this.setModules(packageJson, packageManifest);
        Gson gson = new GsonBuilder().registerTypeHierarchyAdapter(Collection.class, (Object)new JsonCollectionsAdaptor()).registerTypeHierarchyAdapter(String.class, (Object)new JsonStringsAdaptor()).setPrettyPrinting().create();
        try {
            this.putZipEntry(balaOutputStream, Path.of("package.json", new String[0]), new ByteArrayInputStream(gson.toJson((Object)packageJson).getBytes(Charset.defaultCharset())));
        }
        catch (IOException e) {
            throw new ProjectException("Failed to write 'package.json' file: " + e.getMessage(), e);
        }
    }

    private void setReadme(PackageManifest packageManifest, PackageJson packageJson) {
        if (packageManifest.readme() != null) {
            packageJson.setReadme("docs/" + String.valueOf(Paths.get(packageManifest.readme(), new String[0]).getFileName()));
        }
    }

    private void setModules(PackageJson packageJson, PackageManifest packageManifest) {
        ArrayList<PackageManifest.Module> modules = new ArrayList<PackageManifest.Module>();
        String packageDocPathPrefix = "docs/";
        List<PackageManifest.Module> moduleList = packageManifest.modules();
        for (PackageManifest.Module module : moduleList) {
            String moduleDoc = null;
            if (module.readme() != null && !module.readme().isEmpty()) {
                moduleDoc = packageDocPathPrefix + "modules/" + module.name() + UNIX_FILE_SEPARATOR + String.valueOf(Paths.get(module.readme(), new String[0]).getFileName());
            }
            modules.add(new PackageManifest.Module(module.name(), module.export(), module.description(), moduleDoc));
        }
        packageJson.setModules(modules);
    }

    private void setGraalVMCompatibilityProperty(PackageJson packageJson, PackageManifest packageManifest) {
        Map<String, PackageManifest.Platform> platforms = packageManifest.platforms();
        Boolean allPlatformDepsGraalvmCompatible = BalaWriter.isAllPlatformDepsGraalvmCompatible(packageManifest.platforms());
        PackageManifest.Platform targetPlatform = packageManifest.platform(this.target);
        if (platforms != null) {
            Boolean graalvmCompatible;
            if (targetPlatform != null && (graalvmCompatible = targetPlatform.graalvmCompatible()) != null) {
                boolean finalCompatibility = allPlatformDepsGraalvmCompatible != null ? allPlatformDepsGraalvmCompatible.booleanValue() && graalvmCompatible.booleanValue() : graalvmCompatible;
                packageJson.setGraalvmCompatible(finalCompatibility);
                return;
            }
            if (!this.otherPlatformGraalvmCompatibleVerified(this.target, packageManifest.platforms()).isEmpty()) {
                Boolean otherGraalvmCompatible = packageManifest.platform(this.otherPlatformGraalvmCompatibleVerified(this.target, packageManifest.platforms())).graalvmCompatible();
                boolean finalCompatibility = allPlatformDepsGraalvmCompatible != null ? allPlatformDepsGraalvmCompatible.booleanValue() && otherGraalvmCompatible.booleanValue() : otherGraalvmCompatible;
                packageJson.setGraalvmCompatible(finalCompatibility);
                return;
            }
            packageJson.setGraalvmCompatible(allPlatformDepsGraalvmCompatible);
        } else {
            packageJson.setGraalvmCompatible(true);
        }
    }

    private static Boolean isAllPlatformDepsGraalvmCompatible(Map<String, PackageManifest.Platform> platforms) {
        Boolean isAllDepsGraalvmCompatible = true;
        for (PackageManifest.Platform platform : platforms.values()) {
            if (platform.isPlatfromDepsGraalvmCompatible() == null) {
                isAllDepsGraalvmCompatible = null;
                continue;
            }
            if (platform.isPlatfromDepsGraalvmCompatible().booleanValue()) continue;
            return false;
        }
        return isAllDepsGraalvmCompatible;
    }

    private String otherPlatformGraalvmCompatibleVerified(String target, Map<String, PackageManifest.Platform> platforms) {
        for (Map.Entry<String, PackageManifest.Platform> platform : platforms.entrySet()) {
            if (platform.getKey().equals(target) || platform.getValue().graalvmCompatible() == null) continue;
            return platform.getKey();
        }
        return "";
    }

    private void addPackageDoc(ZipOutputStream balaOutputStream, PackageManifest packageManifest) throws IOException {
        if (packageManifest.readme() == null) {
            return;
        }
        Path sourceRoot = this.packageContext.project().sourceRoot;
        Path pkgReadme = Paths.get(packageManifest.readme(), new String[0]);
        Path docsDirInBala = Path.of("docs", new String[0]);
        Path packageMdInBala = docsDirInBala.resolve(pkgReadme.getFileName());
        this.putZipEntry(balaOutputStream, packageMdInBala, new FileInputStream(pkgReadme.toString()));
        String icon = this.packageContext.packageManifest().icon();
        if (icon != null && !icon.isEmpty()) {
            Path iconPath = this.getIconPath(icon);
            Path iconInBala = docsDirInBala.resolve(iconPath.getFileName());
            this.putZipEntry(balaOutputStream, iconInBala, new FileInputStream(String.valueOf(iconPath)));
        }
        Path modulesDirInBalaDocs = docsDirInBala.resolve(MODULES_ROOT);
        for (PackageManifest.Module module : packageManifest.modules()) {
            if (module.readme() == null || module.readme().isEmpty()) continue;
            Path otherReadmeMdInBalaDocs = modulesDirInBalaDocs.resolve(module.name()).resolve(Paths.get(module.readme(), new String[0]).getFileName());
            this.putZipEntry(balaOutputStream, otherReadmeMdInBalaDocs, new FileInputStream(sourceRoot.resolve(module.readme()).toString()));
        }
    }

    private void addPackageSource(ZipOutputStream balaOutputStream) throws IOException {
        for (ModuleId moduleId : this.packageContext.moduleIds()) {
            Module module = this.packageContext.project().currentPackage().module(moduleId);
            if (module.isDefaultModule() && this.packageContext.balToolTomlContext().isPresent() && module.documentIds().isEmpty()) {
                String emptyBalContent = "// AUTO-GENERATED FILE.\n\n// This file is auto-generated by Ballerina for packages with empty default modules. \n";
                TextDocument emptyBalTextDocument = TextDocuments.from((String)emptyBalContent);
                DocumentId documentId = DocumentId.create(MAIN_BAL, moduleId);
                DocumentConfig documentConfig = DocumentConfig.from(documentId, emptyBalTextDocument.toString(), MAIN_BAL);
                module = module.modify().addDocument(documentConfig).apply();
            }
            for (DocumentId docId : module.documentIds()) {
                Document document = module.document(docId);
                if (!document.name().endsWith(BLANG_SOURCE_EXT)) continue;
                Path documentPath = Path.of(MODULES_ROOT, module.moduleName().toString(), document.name());
                char[] documentContent = document.textDocument().toCharArray();
                this.putZipEntry(balaOutputStream, documentPath, new ByteArrayInputStream(new String(documentContent).getBytes(StandardCharsets.UTF_8)));
            }
        }
    }

    private void addResources(ZipOutputStream balaOutputStream) throws IOException {
        HashSet<String> resourceFiles = new HashSet<String>();
        for (DocumentId documentId : this.packageContext.resourceIds()) {
            String resourceFile = this.packageContext.resourceContext(documentId).name();
            Path resourcePath = Path.of(RESOURCE_DIR_NAME, new String[0]).resolve(resourceFile);
            if (!resourceFiles.add(resourcePath.toString())) continue;
            this.putZipEntry(balaOutputStream, resourcePath, new ByteArrayInputStream(this.packageContext.resourceContext(documentId).content()));
        }
        if (this.packageContext.project().kind().equals((Object)ProjectKind.BUILD_PROJECT)) {
            Map<String, byte[]> cachedResources = ProjectUtils.getAllGeneratedResources(this.packageContext.project().generatedResourcesDir());
            List<String> conflictingResourceFiles = cachedResources.keySet().stream().filter(path -> !resourceFiles.add((String)path)).collect(Collectors.toList());
            if (!conflictingResourceFiles.isEmpty()) {
                throw new ProjectException(ProjectUtils.getConflictingResourcesMsg(this.packageContext.descriptor().toString(), conflictingResourceFiles));
            }
            for (Map.Entry<String, byte[]> entry : cachedResources.entrySet()) {
                this.putZipEntry(balaOutputStream, Path.of(entry.getKey(), new String[0]), new ByteArrayInputStream(entry.getValue()));
            }
        }
    }

    private void addIncludes(ZipOutputStream balaOutputStream) throws IOException {
        List<String> includePatterns = this.packageContext.packageManifest().includes();
        List<Path> includePaths = ProjectUtils.getPathsMatchingIncludePatterns(includePatterns, this.packageContext.project().sourceRoot());
        for (Path includePath : includePaths) {
            Path includePathInPackage = this.packageContext.project().sourceRoot().resolve(includePath).toAbsolutePath();
            Path includeInBala = this.updateModuleDirectoryToMatchNamingInBala(includePath);
            try {
                if (includePathInPackage.toFile().isDirectory()) {
                    this.putDirectoryToZipFile(includePathInPackage, includeInBala, balaOutputStream);
                    continue;
                }
                this.putZipEntry(balaOutputStream, includeInBala, new FileInputStream(String.valueOf(includePathInPackage)));
            }
            catch (ZipException e) {
                if (e.getMessage().contains("duplicate entry")) continue;
                throw e;
            }
        }
    }

    private void addDependenciesJson(ZipOutputStream balaOutputStream) {
        PackageCache packageCache = this.packageContext.project().projectEnvironmentContext().getService(PackageCache.class);
        List<Dependency> packageDependencyGraph = this.getPackageDependencies(this.packageContext.getResolution().dependencyGraph());
        List<io.ballerina.projects.internal.bala.ModuleDependency> moduleDependencyGraph = this.getModuleDependencies(this.packageContext.project().currentPackage(), packageCache);
        DependencyGraphJson depGraphJson = new DependencyGraphJson(packageDependencyGraph, moduleDependencyGraph);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            this.putZipEntry(balaOutputStream, Path.of("dependency-graph.json", new String[0]), new ByteArrayInputStream(gson.toJson((Object)depGraphJson).getBytes(Charset.defaultCharset())));
        }
        catch (IOException e) {
            throw new ProjectException("Failed to write 'dependency-graph.json' file: " + e.getMessage(), e);
        }
    }

    private Path updateModuleDirectoryToMatchNamingInBala(Path relativePath) {
        Path moduleRootPath = Path.of(MODULES_ROOT, new String[0]);
        if (relativePath.startsWith(moduleRootPath)) {
            String packageName = this.packageContext.packageName().toString();
            Path modulePath = moduleRootPath.resolve(moduleRootPath.relativize(relativePath).subpath(0, 1));
            Path pathInsideModule = modulePath.relativize(relativePath);
            String moduleName = Optional.ofNullable(modulePath.getFileName()).orElse(Path.of("", new String[0])).toString();
            String updatedModuleName = packageName + "." + moduleName;
            Path updatedModulePath = moduleRootPath.resolve(updatedModuleName);
            return updatedModulePath.resolve(pathInsideModule);
        }
        return relativePath;
    }

    private List<Dependency> getPackageDependencies(DependencyGraph<ResolvedPackageDependency> dependencyGraph) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (ResolvedPackageDependency resolvedDep : dependencyGraph.getNodes()) {
            if (resolvedDep.scope() == PackageDependencyScope.TEST_ONLY) continue;
            PackageContext packageContext = resolvedDep.packageInstance().packageContext();
            Dependency dependency = new Dependency(packageContext.packageOrg().toString(), packageContext.packageName().toString(), packageContext.packageVersion().toString());
            ArrayList<Dependency> dependencyList = new ArrayList<Dependency>();
            Collection<ResolvedPackageDependency> pkgDependencies = dependencyGraph.getDirectDependencies(resolvedDep);
            for (ResolvedPackageDependency resolvedTransitiveDep : pkgDependencies) {
                if (resolvedTransitiveDep.scope() == PackageDependencyScope.TEST_ONLY) continue;
                PackageContext dependencyPkgContext = resolvedTransitiveDep.packageInstance().packageContext();
                Dependency dep = new Dependency(dependencyPkgContext.packageOrg().toString(), dependencyPkgContext.packageName().toString(), dependencyPkgContext.packageVersion().toString());
                dependencyList.add(dep);
            }
            dependency.setDependencies(dependencyList);
            dependencies.add(dependency);
        }
        return dependencies;
    }

    private List<io.ballerina.projects.internal.bala.ModuleDependency> getModuleDependencies(Package pkg, PackageCache packageCache) {
        ArrayList<io.ballerina.projects.internal.bala.ModuleDependency> modules = new ArrayList<io.ballerina.projects.internal.bala.ModuleDependency>();
        for (ModuleId moduleId : pkg.moduleIds()) {
            Module module = pkg.module(moduleId);
            ArrayList<io.ballerina.projects.internal.bala.ModuleDependency> moduleDependencies = new ArrayList<io.ballerina.projects.internal.bala.ModuleDependency>();
            for (ModuleDependency moduleDependency : module.moduleDependencies()) {
                if (moduleDependency.packageDependency().scope() == PackageDependencyScope.TEST_ONLY) continue;
                Package pkgDependency = packageCache.getPackageOrThrow(moduleDependency.packageDependency().packageId());
                Module moduleInPkgDependency = pkgDependency.module(moduleDependency.descriptor().name());
                moduleDependencies.add(this.createModuleDependencyEntry(pkgDependency, moduleInPkgDependency, Collections.emptyList()));
            }
            modules.add(this.createModuleDependencyEntry(pkg, module, moduleDependencies));
        }
        return modules;
    }

    private io.ballerina.projects.internal.bala.ModuleDependency createModuleDependencyEntry(Package pkg, Module module, List<io.ballerina.projects.internal.bala.ModuleDependency> moduleDependencies) {
        return new io.ballerina.projects.internal.bala.ModuleDependency(pkg.packageOrg().value(), pkg.packageName().value(), pkg.packageVersion().toString(), module.moduleName().toString(), moduleDependencies);
    }

    private Path getIconPath(String icon) {
        Path iconPath = Path.of(icon, new String[0]);
        if (!iconPath.isAbsolute()) {
            iconPath = this.packageContext.project().sourceRoot().resolve(iconPath);
        }
        return iconPath;
    }

    protected void putZipEntry(ZipOutputStream balaOutputStream, Path fileName, InputStream in) throws IOException {
        ZipEntry entry = new ZipEntry(this.convertPathSeperator(fileName));
        balaOutputStream.putNextEntry(entry);
        IOUtils.copy((InputStream)in, (OutputStream)balaOutputStream);
        IOUtils.closeQuietly((Closeable)in);
    }

    protected void putDirectoryToZipFile(Path sourceDir, Path pathInZipFile, ZipOutputStream out) throws IOException {
        File[] files;
        if (sourceDir.toFile().exists() && (files = new File(sourceDir.toString()).listFiles()) != null && files.length > 0) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.putDirectoryToZipFile(sourceDir.resolve(file.getName()), pathInZipFile, out);
                    continue;
                }
                Path fileNameInBala = pathInZipFile.resolve(sourceDir.relativize(Path.of(file.getPath(), new String[0])));
                this.putZipEntry(out, fileNameInBala, new FileInputStream(String.valueOf(sourceDir) + File.separator + file.getName()));
            }
        }
    }

    protected abstract Optional<JsonArray> addPlatformLibs(ZipOutputStream var1) throws IOException;

    protected abstract void addCompilerPlugin(ZipOutputStream var1) throws IOException;

    protected abstract void addBalTool(ZipOutputStream var1) throws IOException;

    private String convertPathSeperator(Path file) {
        if (file == null) {
            return null;
        }
        if (File.separatorChar == '\\') {
            Object replaced = Optional.ofNullable(file.getFileName()).orElse(Path.of("", new String[0])).toString();
            for (Path parent = file.getParent(); parent != null; parent = parent.getParent()) {
                replaced = String.valueOf(parent.getFileName()) + UNIX_FILE_SEPARATOR + (String)replaced;
            }
            return replaced;
        }
        return file.toString();
    }
}

