/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.Package;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.environment.PackageResolver;
import io.ballerina.projects.environment.ResolutionOptions;
import io.ballerina.projects.environment.ResolutionRequest;
import io.ballerina.projects.environment.ResolutionResponse;
import java.util.Collection;
import java.util.Collections;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class Bootstrap {
    private final PackageResolver packageResolver;
    private boolean langLibLoaded = false;

    public Bootstrap(PackageResolver packageResolver) {
        this.packageResolver = packageResolver;
    }

    void loadLangLib(CompilerContext compilerContext, PackageID langLib) {
        if (this.langLibLoaded) {
            return;
        }
        this.langLibLoaded = true;
        if (langLib.equals(PackageID.ANNOTATIONS)) {
            return;
        }
        SymbolResolver symResolver = SymbolResolver.getInstance(compilerContext);
        SymbolTable symbolTable = SymbolTable.getInstance(compilerContext);
        symbolTable.langAnnotationModuleSymbol = this.loadLangLibFromBala(PackageID.ANNOTATIONS, compilerContext);
        symResolver.bootstrapJsonType();
        symResolver.bootstrapAnydataType();
        symResolver.boostrapErrorType();
        symResolver.defineOperators();
        if (langLib.equals(PackageID.JAVA)) {
            return;
        }
        symbolTable.langJavaModuleSymbol = this.loadLangLibFromBala(PackageID.JAVA, compilerContext);
        if (langLib.equals(PackageID.INTERNAL)) {
            symbolTable.langObjectModuleSymbol = this.loadLangLibFromBala(PackageID.OBJECT, compilerContext);
            symResolver.bootstrapIterableType();
            return;
        }
        if (langLib.equals(PackageID.OBJECT)) {
            return;
        }
        symbolTable.langObjectModuleSymbol = this.loadLangLibFromBala(PackageID.OBJECT, compilerContext);
        symbolTable.langInternalModuleSymbol = this.loadLangLibFromBala(PackageID.INTERNAL, compilerContext);
        symResolver.bootstrapIntRangeType();
        symResolver.bootstrapIterableType();
        if (langLib.equals(PackageID.QUERY)) {
            symbolTable.langXmlModuleSymbol = this.loadLangLibFromBala(PackageID.XML, compilerContext);
            symbolTable.langTableModuleSymbol = this.loadLangLibFromBala(PackageID.TABLE, compilerContext);
            symbolTable.langStreamModuleSymbol = this.loadLangLibFromBala(PackageID.STREAM, compilerContext);
            symbolTable.updateStringSubtypeOwners();
            symbolTable.updateXMLSubtypeOwners();
        }
        if (langLib.equals(PackageID.TRANSACTION)) {
            symbolTable.langErrorModuleSymbol = this.loadLangLibFromBala(PackageID.ERROR, compilerContext);
            symbolTable.langObjectModuleSymbol = this.loadLangLibFromBala(PackageID.OBJECT, compilerContext);
        }
        if (langLib.equals(PackageID.STRING)) {
            symbolTable.langRegexpModuleSymbol = this.loadLangLibFromBala(PackageID.REGEXP, compilerContext);
        }
        if (langLib.equals(PackageID.TRANSACTION) || langLib.equals(PackageID.QUERY)) {
            symbolTable.langArrayModuleSymbol = this.loadLangLibFromBala(PackageID.ARRAY, compilerContext);
            symbolTable.langMapModuleSymbol = this.loadLangLibFromBala(PackageID.MAP, compilerContext);
            symbolTable.langValueModuleSymbol = this.loadLangLibFromBala(PackageID.VALUE, compilerContext);
            symbolTable.langRegexpModuleSymbol = this.loadLangLibFromBala(PackageID.REGEXP, compilerContext);
            symbolTable.langStringModuleSymbol = this.loadLangLibFromBala(PackageID.STRING, compilerContext);
            symbolTable.updateStringSubtypeOwners();
        }
        if (langLib.equals(PackageID.ERROR)) {
            symbolTable.langArrayModuleSymbol = this.loadLangLibFromBala(PackageID.ARRAY, compilerContext);
            symbolTable.langValueModuleSymbol = this.loadLangLibFromBala(PackageID.VALUE, compilerContext);
        }
        if (langLib.equals(PackageID.RUNTIME)) {
            symbolTable.langArrayModuleSymbol = this.loadLangLibFromBala(PackageID.ARRAY, compilerContext);
            symbolTable.langValueModuleSymbol = this.loadLangLibFromBala(PackageID.VALUE, compilerContext);
        }
        if (langLib.equals(PackageID.REGEXP)) {
            symbolTable.langArrayModuleSymbol = this.loadLangLibFromBala(PackageID.ARRAY, compilerContext);
        }
        if (langLib.equals(PackageID.INT)) {
            symbolTable.langValueModuleSymbol = this.loadLangLibFromBala(PackageID.VALUE, compilerContext);
            symbolTable.langMapModuleSymbol = this.loadLangLibFromBala(PackageID.MAP, compilerContext);
        }
        symResolver.bootstrapCloneableType();
        symResolver.defineOperators();
    }

    public void loadLangLibSymbols(CompilerContext compilerContext) {
        SymbolResolver symResolver = SymbolResolver.getInstance(compilerContext);
        SymbolTable symbolTable = SymbolTable.getInstance(compilerContext);
        symbolTable.langAnnotationModuleSymbol = this.loadLangLibFromBala(PackageID.ANNOTATIONS, compilerContext);
        symbolTable.langJavaModuleSymbol = this.loadLangLibFromBala(PackageID.JAVA, compilerContext);
        symbolTable.langRegexpModuleSymbol = this.loadLangLibFromBala(PackageID.REGEXP, compilerContext);
        symbolTable.langInternalModuleSymbol = this.loadLangLibFromBala(PackageID.INTERNAL, compilerContext);
        symbolTable.langValueModuleSymbol = this.loadLangLibFromBala(PackageID.VALUE, compilerContext);
        symResolver.bootstrapJsonType();
        symResolver.bootstrapAnydataType();
        symResolver.boostrapErrorType();
        symResolver.bootstrapCloneableType();
        symResolver.bootstrapIntRangeType();
        symbolTable.langArrayModuleSymbol = this.loadLangLibFromBala(PackageID.ARRAY, compilerContext);
        symbolTable.langDecimalModuleSymbol = this.loadLangLibFromBala(PackageID.DECIMAL, compilerContext);
        symbolTable.langErrorModuleSymbol = this.loadLangLibFromBala(PackageID.ERROR, compilerContext);
        symbolTable.langFloatModuleSymbol = this.loadLangLibFromBala(PackageID.FLOAT, compilerContext);
        symbolTable.langFunctionModuleSymbol = this.loadLangLibFromBala(PackageID.FUNCTION, compilerContext);
        symbolTable.langFutureModuleSymbol = this.loadLangLibFromBala(PackageID.FUTURE, compilerContext);
        symbolTable.langMapModuleSymbol = this.loadLangLibFromBala(PackageID.MAP, compilerContext);
        symbolTable.langIntModuleSymbol = this.loadLangLibFromBala(PackageID.INT, compilerContext);
        symbolTable.langObjectModuleSymbol = this.loadLangLibFromBala(PackageID.OBJECT, compilerContext);
        symResolver.loadRawTemplateType();
        symResolver.bootstrapIterableType();
        symbolTable.langStreamModuleSymbol = this.loadLangLibFromBala(PackageID.STREAM, compilerContext);
        symbolTable.langTableModuleSymbol = this.loadLangLibFromBala(PackageID.TABLE, compilerContext);
        symbolTable.langRegexpModuleSymbol = this.loadLangLibFromBala(PackageID.REGEXP, compilerContext);
        symbolTable.langStringModuleSymbol = this.loadLangLibFromBala(PackageID.STRING, compilerContext);
        symbolTable.langTypedescModuleSymbol = this.loadLangLibFromBala(PackageID.TYPEDESC, compilerContext);
        symbolTable.langXmlModuleSymbol = this.loadLangLibFromBala(PackageID.XML, compilerContext);
        symbolTable.langBooleanModuleSymbol = this.loadLangLibFromBala(PackageID.BOOLEAN, compilerContext);
        symbolTable.langQueryModuleSymbol = this.loadLangLibFromBala(PackageID.QUERY, compilerContext);
        symbolTable.langTransactionModuleSymbol = this.loadLangLibFromBala(PackageID.TRANSACTION, compilerContext);
        symbolTable.langRuntimeModuleSymbol = this.loadLangLibFromBala(PackageID.RUNTIME, compilerContext);
        symbolTable.loadPredeclaredModules();
        symResolver.bootstrapIntRangeType();
        symbolTable.updateBuiltinSubtypeOwners();
        symResolver.defineOperators();
    }

    private BPackageSymbol loadLangLibFromBala(PackageID langLib, CompilerContext compilerContext) {
        this.loadLangLibFromBala(this.toResolutionRequest(langLib));
        return this.getSymbolFromCache(compilerContext, langLib);
    }

    private void loadLangLibFromBala(ResolutionRequest resolutionRequest) {
        Collection<ResolutionResponse> resolutionResponses = this.packageResolver.resolvePackages(Collections.singletonList(resolutionRequest), ResolutionOptions.builder().setOffline(true).build());
        resolutionResponses.forEach(resolutionResponse -> {
            Package pkg = resolutionResponse.resolvedPackage();
            PackageCompilation compilation = pkg.getCompilation();
            if (compilation.diagnosticResult().hasErrors()) {
                throw new ProjectException("Error while bootstrapping :" + pkg.packageId().toString() + " diagnostics: " + String.valueOf(compilation.diagnosticResult()));
            }
        });
    }

    private ResolutionRequest toResolutionRequest(PackageID packageID) {
        PackageOrg pkgOrg = PackageOrg.from(packageID.orgName.getValue());
        PackageName pkgName = PackageName.from(packageID.name.getValue());
        PackageVersion pkgVersion = PackageVersion.from(packageID.getPackageVersion().toString());
        PackageDescriptor pkgDesc = PackageDescriptor.from(pkgOrg, pkgName, pkgVersion);
        return ResolutionRequest.from(pkgDesc);
    }

    private BPackageSymbol getSymbolFromCache(CompilerContext context, PackageID packageID) {
        PackageCache pkgCache = PackageCache.getInstance(context);
        BLangPackage bLangPackage = pkgCache.get(packageID);
        if (bLangPackage != null) {
            return bLangPackage.symbol;
        }
        return pkgCache.getSymbol(packageID);
    }
}

