/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.Package;
import io.ballerina.projects.TomlDocument;
import io.ballerina.projects.TomlDocumentContext;
import io.ballerina.toml.semantic.ast.TomlTableNode;

public class CloudToml {
    private final TomlDocumentContext cloudTomlContext;
    private final Package packageInstance;

    private CloudToml(Package aPackage, TomlDocumentContext cloudTomlContext) {
        this.packageInstance = aPackage;
        this.cloudTomlContext = cloudTomlContext;
    }

    public static CloudToml from(TomlDocumentContext cloudTomlContext, Package pkg) {
        return new CloudToml(pkg, cloudTomlContext);
    }

    TomlDocumentContext cloudTomlContext() {
        return this.cloudTomlContext;
    }

    public Package packageInstance() {
        return this.packageInstance;
    }

    public String name() {
        return "Cloud.toml";
    }

    public TomlTableNode tomlAstNode() {
        return this.tomlDocument().toml().rootNode();
    }

    public TomlDocument tomlDocument() {
        return this.cloudTomlContext.tomlDocument();
    }

    public Modifier modify() {
        return new Modifier(this);
    }

    public static class Modifier {
        private TomlDocument tomlDocument;
        private final Package oldPackage;

        private Modifier(CloudToml oldDocument) {
            this.tomlDocument = oldDocument.tomlDocument();
            this.oldPackage = oldDocument.packageInstance();
        }

        public Modifier withContent(String content) {
            this.tomlDocument = TomlDocument.from("Cloud.toml", content);
            return this;
        }

        public CloudToml apply() {
            CloudToml cloudToml = CloudToml.from(TomlDocumentContext.from(this.tomlDocument), this.oldPackage);
            Package newPackage = this.oldPackage.modify().updateCloudToml(cloudToml).apply();
            return newPackage.cloudToml().get();
        }
    }
}

