/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.CompilerPluginContextIml;
import io.ballerina.projects.CompilerPluginInfo;
import io.ballerina.projects.CompilerPluginKind;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageProvidedCompilerPluginInfo;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.SyntaxNodeAnalysisTask;
import io.ballerina.projects.SyntaxNodeAnalysisTaskRunner;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.CodeAnalysisContext;
import io.ballerina.projects.plugins.CodeAnalyzer;
import io.ballerina.projects.plugins.CompilationAnalysisContext;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class CodeAnalyzerManager {
    private final Package currentPackage;
    private final PackageCompilation compilation;
    private final CodeAnalyzerTasks codeAnalyzerTasks;

    public CodeAnalyzerManager(PackageCompilation compilation, CodeAnalyzerTasks codeAnalyzerTasks) {
        this.currentPackage = compilation.packageContext().project().currentPackage();
        this.compilation = compilation;
        this.codeAnalyzerTasks = codeAnalyzerTasks;
    }

    static CodeAnalyzerManager from(PackageCompilation compilation, List<CompilerPluginContextIml> compilerPluginContexts) {
        CodeAnalyzerTasks codeAnalyzerContexts = CodeAnalyzerManager.initCodeAnalyzers(compilerPluginContexts);
        return new CodeAnalyzerManager(compilation, codeAnalyzerContexts);
    }

    List<Diagnostic> runCodeAnalyzerTasks() {
        ArrayList<Diagnostic> reportedDiagnostics = new ArrayList<Diagnostic>();
        this.runSyntaxNodeAnalysisTasks(reportedDiagnostics);
        this.runCompilationAnalysisTasks(reportedDiagnostics);
        return reportedDiagnostics;
    }

    private static CodeAnalyzerTasks initCodeAnalyzers(List<CompilerPluginContextIml> compilerPluginContexts) {
        CodeAnalyzerTasks codeAnalyzerTasks = new CodeAnalyzerTasks();
        for (CompilerPluginContextIml compilerPluginContext : compilerPluginContexts) {
            for (CodeAnalyzerInfo codeAnalyzerInfo : compilerPluginContext.codeAnalyzers()) {
                CodeAnalysisContextImpl codeAnalysisContext = new CodeAnalysisContextImpl(codeAnalyzerInfo, codeAnalyzerTasks);
                codeAnalyzerInfo.codeAnalyzer().init(codeAnalysisContext);
            }
        }
        return codeAnalyzerTasks;
    }

    private void runCompilationAnalysisTasks(List<Diagnostic> reportedDiagnostics) {
        for (Map.Entry<CodeAnalyzerInfo, List<CompilationAnalysisTask>> codeAnalyzerListEntry : this.codeAnalyzerTasks.compAnalysisTaskMap.entrySet()) {
            this.runCompilationAnalysisTask(codeAnalyzerListEntry.getValue(), reportedDiagnostics);
        }
    }

    private void runCompilationAnalysisTask(List<CompilationAnalysisTask> compilationAnalysisTasks, List<Diagnostic> reportedDiagnostics) {
        for (CompilationAnalysisTask compilationAnalysisTask : compilationAnalysisTasks) {
            CompilationAnalysisContextIml analysisContext = new CompilationAnalysisContextIml(this.currentPackage, this.compilation);
            compilationAnalysisTask.perform(analysisContext);
            reportedDiagnostics.addAll(analysisContext.reportedDiagnostics());
        }
    }

    private void runSyntaxNodeAnalysisTasks(List<Diagnostic> reportedDiagnostics) {
        Map<SyntaxKind, List<SyntaxNodeAnalysisTask>> syntaxNodeAnalysisTaskMap = this.populateSyntaxNodeTaskMap();
        if (syntaxNodeAnalysisTaskMap.isEmpty()) {
            return;
        }
        SyntaxNodeAnalysisTaskRunner taskRunner = new SyntaxNodeAnalysisTaskRunner(syntaxNodeAnalysisTaskMap, this.currentPackage, this.compilation);
        reportedDiagnostics.addAll(taskRunner.runTasks());
    }

    private Map<SyntaxKind, List<SyntaxNodeAnalysisTask>> populateSyntaxNodeTaskMap() {
        HashMap<SyntaxKind, List<SyntaxNodeAnalysisTask>> syntaxNodeAnalysisTaskMap = new HashMap<SyntaxKind, List<SyntaxNodeAnalysisTask>>();
        for (List<SyntaxNodeAnalysisTask> syntaxNodeAnalysisTasks : this.codeAnalyzerTasks.syntaxNodeAnalysisTaskMap.values()) {
            this.populateSyntaxNodeTaskMap(syntaxNodeAnalysisTaskMap, syntaxNodeAnalysisTasks);
        }
        return syntaxNodeAnalysisTaskMap;
    }

    private void populateSyntaxNodeTaskMap(Map<SyntaxKind, List<SyntaxNodeAnalysisTask>> syntaxNodeAnalysisTaskMap, List<SyntaxNodeAnalysisTask> syntaxNodeAnalysisTasks) {
        for (SyntaxNodeAnalysisTask syntaxNodeTask : syntaxNodeAnalysisTasks) {
            this.populateSyntaxNodeTaskMap(syntaxNodeAnalysisTaskMap, syntaxNodeTask);
        }
    }

    private void populateSyntaxNodeTaskMap(Map<SyntaxKind, List<SyntaxNodeAnalysisTask>> syntaxNodeAnalysisTaskMap, SyntaxNodeAnalysisTask syntaxNodeAnalysisTask) {
        for (SyntaxKind syntaxKind : syntaxNodeAnalysisTask.syntaxKinds()) {
            List syntaxNodeAnalysisTasks = syntaxNodeAnalysisTaskMap.computeIfAbsent(syntaxKind, syntaxKind1 -> new ArrayList());
            syntaxNodeAnalysisTasks.add(syntaxNodeAnalysisTask);
        }
    }

    static class CodeAnalyzerTasks {
        private final Map<CodeAnalyzerInfo, List<CompilationAnalysisTask>> compAnalysisTaskMap = new HashMap<CodeAnalyzerInfo, List<CompilationAnalysisTask>>();
        private final Map<CodeAnalyzerInfo, List<SyntaxNodeAnalysisTask>> syntaxNodeAnalysisTaskMap = new HashMap<CodeAnalyzerInfo, List<SyntaxNodeAnalysisTask>>();

        CodeAnalyzerTasks() {
        }

        void addCompilationAnalysisTask(CodeAnalyzerInfo codeAnalyzerInfo, CompilationAnalysisTask analysisTask) {
            this.addTask(codeAnalyzerInfo, this.compAnalysisTaskMap, analysisTask);
        }

        void addSyntaxNodeAnalysisTask(CodeAnalyzerInfo codeAnalyzerInfo, SyntaxNodeAnalysisTask analysisTask) {
            this.addTask(codeAnalyzerInfo, this.syntaxNodeAnalysisTaskMap, analysisTask);
        }

        <T> void addTask(CodeAnalyzerInfo codeAnalyzerInfo, Map<CodeAnalyzerInfo, List<T>> map, T task) {
            List tasks = map.computeIfAbsent(codeAnalyzerInfo, key -> new ArrayList());
            tasks.add(task);
        }
    }

    static class CodeAnalyzerInfo {
        private final CodeAnalyzer codeAnalyzer;
        private final CompilerPluginInfo compilerPluginInfo;

        CodeAnalyzerInfo(CodeAnalyzer codeAnalyzer, CompilerPluginInfo compilerPluginInfo) {
            this.codeAnalyzer = codeAnalyzer;
            this.compilerPluginInfo = compilerPluginInfo;
        }

        CodeAnalyzer codeAnalyzer() {
            return this.codeAnalyzer;
        }

        CompilerPluginInfo compilerPluginInfo() {
            return this.compilerPluginInfo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CodeAnalyzerInfo that = (CodeAnalyzerInfo)o;
            return Objects.equals(this.codeAnalyzer, that.codeAnalyzer) && Objects.equals(this.compilerPluginInfo, that.compilerPluginInfo);
        }

        public int hashCode() {
            return Objects.hash(this.codeAnalyzer, this.compilerPluginInfo);
        }
    }

    static class CodeAnalysisContextImpl
    implements CodeAnalysisContext {
        private final CodeAnalyzerTasks codeAnalyzerTasks;
        private final CodeAnalyzerInfo codeAnalyzerInfo;

        CodeAnalysisContextImpl(CodeAnalyzerInfo codeAnalyzerInfo, CodeAnalyzerTasks codeAnalyzerTasks) {
            this.codeAnalyzerInfo = codeAnalyzerInfo;
            this.codeAnalyzerTasks = codeAnalyzerTasks;
        }

        @Override
        public void addCompilationAnalysisTask(AnalysisTask<CompilationAnalysisContext> analysisTask) {
            this.codeAnalyzerTasks.addCompilationAnalysisTask(this.codeAnalyzerInfo, new CompilationAnalysisTask(analysisTask, this.codeAnalyzerInfo));
        }

        @Override
        public void addSyntaxNodeAnalysisTask(AnalysisTask<SyntaxNodeAnalysisContext> analysisTask, SyntaxKind syntaxKind) {
            this.addSyntaxNodeAnalysisTask(analysisTask, Collections.singletonList(syntaxKind));
        }

        @Override
        public void addSyntaxNodeAnalysisTask(AnalysisTask<SyntaxNodeAnalysisContext> analysisTask, Collection<SyntaxKind> syntaxKinds) {
            this.codeAnalyzerTasks.addSyntaxNodeAnalysisTask(this.codeAnalyzerInfo, new SyntaxNodeAnalysisTask(analysisTask, syntaxKinds, this.codeAnalyzerInfo.compilerPluginInfo));
        }
    }

    static class CompilationAnalysisTask {
        private final AnalysisTask<CompilationAnalysisContext> analysisTask;
        private final CodeAnalyzerInfo codeAnalyzerInfo;

        CompilationAnalysisTask(AnalysisTask<CompilationAnalysisContext> analysisTask, CodeAnalyzerInfo codeAnalyzerInfo) {
            this.analysisTask = analysisTask;
            this.codeAnalyzerInfo = codeAnalyzerInfo;
        }

        void perform(CompilationAnalysisContext compilationAnalysisContext) {
            try {
                this.analysisTask.perform(compilationAnalysisContext);
            }
            catch (Throwable e) {
                String message;
                if (this.codeAnalyzerInfo.compilerPluginInfo().kind().equals((Object)CompilerPluginKind.PACKAGE_PROVIDED)) {
                    PackageProvidedCompilerPluginInfo compilerPluginInfo = (PackageProvidedCompilerPluginInfo)this.codeAnalyzerInfo.compilerPluginInfo();
                    PackageDescriptor pkgDesc = compilerPluginInfo.packageDesc();
                    message = "The compiler extension in package '" + String.valueOf(pkgDesc.org()) + ":" + String.valueOf(pkgDesc.name()) + ":" + String.valueOf(pkgDesc.version()) + "' failed to complete. ";
                } else {
                    message = "The compiler extension '" + this.codeAnalyzerInfo.compilerPluginInfo().compilerPlugin().getClass().getName() + "' failed to complete. ";
                }
                throw new ProjectException(message + e.getMessage(), e);
            }
        }
    }

    static class CompilationAnalysisContextIml
    implements CompilationAnalysisContext {
        private final Package currentPackage;
        private final PackageCompilation compilation;
        private final List<Diagnostic> diagnostics = new ArrayList<Diagnostic>();

        public CompilationAnalysisContextIml(Package currentPackage, PackageCompilation compilation) {
            this.currentPackage = currentPackage;
            this.compilation = compilation;
        }

        @Override
        public Package currentPackage() {
            return this.currentPackage;
        }

        @Override
        public PackageCompilation compilation() {
            return this.compilation;
        }

        @Override
        public void reportDiagnostic(Diagnostic diagnostic) {
            this.diagnostics.add(diagnostic);
        }

        List<Diagnostic> reportedDiagnostics() {
            return this.diagnostics;
        }
    }
}

