/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.BalCommand;
import io.ballerina.projects.CompilerPluginContextIml;
import io.ballerina.projects.CompilerPluginInfo;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.plugins.CompilerLifecycleContext;
import io.ballerina.projects.plugins.CompilerLifecycleEventContext;
import io.ballerina.projects.plugins.CompilerLifecycleListener;
import io.ballerina.projects.plugins.CompilerLifecycleTask;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

class CompilerLifecycleManager {
    private final Package currentPackage;
    private final PackageCompilation compilation;
    private final LifecycleTasks lifecycleTasks;

    public CompilerLifecycleManager(PackageCompilation compilation, LifecycleTasks lifecycleTasks) {
        this.currentPackage = compilation.packageContext().project().currentPackage();
        this.compilation = compilation;
        this.lifecycleTasks = lifecycleTasks;
    }

    static CompilerLifecycleManager from(PackageCompilation compilation, List<CompilerPluginContextIml> compilerPluginContexts) {
        LifecycleTasks lifecycleTasks = CompilerLifecycleManager.initLifecycleListeners(compilerPluginContexts);
        return new CompilerLifecycleManager(compilation, lifecycleTasks);
    }

    private static LifecycleTasks initLifecycleListeners(List<CompilerPluginContextIml> compilerPluginContexts) {
        LifecycleTasks lifecycleTasks = new LifecycleTasks();
        for (CompilerPluginContextIml compilerPluginContext : compilerPluginContexts) {
            for (LifecycleListenerInfo lifecycleListenerInfo : compilerPluginContext.getLifecycleListeners()) {
                LifecycleContextImpl lifecycleListenerContext = new LifecycleContextImpl(lifecycleListenerInfo, lifecycleTasks);
                lifecycleListenerInfo.getLifecycleListener().init(lifecycleListenerContext);
            }
        }
        return lifecycleTasks;
    }

    public List<Diagnostic> runCodeGeneratedTasks(Path binaryPath, BalCommand balCommand) {
        CompilerLifecycleEventContextImpl lifecycleEventContext = new CompilerLifecycleEventContextImpl(this.currentPackage, this.compilation, balCommand);
        lifecycleEventContext.setBinaryPath(binaryPath);
        for (List<CodeGenerationCompletedTask> taskList : this.lifecycleTasks.codeGenerationCompletedTasks.values()) {
            for (CodeGenerationCompletedTask codeGenerationCompletedTask : taskList) {
                codeGenerationCompletedTask.lifecycleTask.perform(lifecycleEventContext);
            }
        }
        ArrayList<Diagnostic> reportedDiagnostics = new ArrayList<Diagnostic>(lifecycleEventContext.reportedDiagnostics());
        return reportedDiagnostics;
    }

    static class LifecycleTasks {
        private final Map<LifecycleListenerInfo, List<CodeGenerationCompletedTask>> codeGenerationCompletedTasks = new HashMap<LifecycleListenerInfo, List<CodeGenerationCompletedTask>>();

        LifecycleTasks() {
        }

        public void addCodeGenerationCompletedTask(LifecycleListenerInfo lifecycleListenerInfo, CodeGenerationCompletedTask codeGenerationCompletedTask) {
            List tasks = this.codeGenerationCompletedTasks.computeIfAbsent(lifecycleListenerInfo, key -> new ArrayList());
            tasks.add(codeGenerationCompletedTask);
        }
    }

    static class LifecycleListenerInfo {
        private final CompilerLifecycleListener lifecycleListener;
        private final CompilerPluginInfo compilerPluginInfo;

        public LifecycleListenerInfo(CompilerLifecycleListener lifecycleListener, CompilerPluginInfo compilerPluginInfo) {
            this.lifecycleListener = lifecycleListener;
            this.compilerPluginInfo = compilerPluginInfo;
        }

        public CompilerLifecycleListener getLifecycleListener() {
            return this.lifecycleListener;
        }

        public CompilerPluginInfo getCompilerPluginInfo() {
            return this.compilerPluginInfo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LifecycleListenerInfo that = (LifecycleListenerInfo)o;
            return Objects.equals(this.lifecycleListener, that.lifecycleListener) && Objects.equals(this.compilerPluginInfo, that.compilerPluginInfo);
        }

        public int hashCode() {
            return Objects.hash(this.lifecycleListener, this.compilerPluginInfo);
        }
    }

    static class LifecycleContextImpl
    implements CompilerLifecycleContext {
        private final LifecycleListenerInfo lifecycleListenerInfo;
        private final LifecycleTasks lifecycleTasks;

        public LifecycleContextImpl(LifecycleListenerInfo lifecycleListenerInfo, LifecycleTasks lifecycleTasks) {
            this.lifecycleListenerInfo = lifecycleListenerInfo;
            this.lifecycleTasks = lifecycleTasks;
        }

        @Override
        public void addCodeGenerationCompletedTask(CompilerLifecycleTask<CompilerLifecycleEventContext> lifecycleTask) {
            this.lifecycleTasks.addCodeGenerationCompletedTask(this.lifecycleListenerInfo, new CodeGenerationCompletedTask(lifecycleTask, this.lifecycleListenerInfo));
        }
    }

    private static class CompilerLifecycleEventContextImpl
    implements CompilerLifecycleEventContext {
        private final Package currentPackage;
        private final PackageCompilation compilation;
        private final BalCommand balCommand;
        private Path binaryPath;
        private final List<Diagnostic> diagnostics = new ArrayList<Diagnostic>();

        public CompilerLifecycleEventContextImpl(Package currentPackage, PackageCompilation compilation, BalCommand balCommand) {
            this.currentPackage = currentPackage;
            this.compilation = compilation;
            this.balCommand = balCommand;
        }

        @Override
        public Package currentPackage() {
            return this.currentPackage;
        }

        @Override
        public PackageCompilation compilation() {
            return this.compilation;
        }

        @Override
        public void reportDiagnostic(Diagnostic diagnostic) {
            this.diagnostics.add(diagnostic);
        }

        @Override
        public BalCommand balCommand() {
            return this.balCommand;
        }

        void setBinaryPath(Path binaryPath) {
            this.binaryPath = binaryPath;
        }

        @Override
        public Optional<Path> getGeneratedArtifactPath() {
            return Optional.ofNullable(this.binaryPath);
        }

        List<Diagnostic> reportedDiagnostics() {
            return this.diagnostics;
        }
    }

    static class CodeGenerationCompletedTask {
        private final CompilerLifecycleTask<CompilerLifecycleEventContext> lifecycleTask;
        private final LifecycleListenerInfo lifecycleListenerInfo;

        public CodeGenerationCompletedTask(CompilerLifecycleTask<CompilerLifecycleEventContext> lifecycleTask, LifecycleListenerInfo lifecycleListenerInfo) {
            this.lifecycleTask = lifecycleTask;
            this.lifecycleListenerInfo = lifecycleListenerInfo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o != null && this.getClass() == o.getClass()) {
                CodeGenerationCompletedTask that = (CodeGenerationCompletedTask)o;
                return Objects.equals(this.lifecycleTask, that.lifecycleTask) && Objects.equals(this.lifecycleListenerInfo, that.lifecycleListenerInfo);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.lifecycleTask, this.lifecycleListenerInfo);
        }
    }
}

