/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class DependencyGraph<T> {
    private static final DependencyGraph EMPTY_GRAPH = new DependencyGraph<Object>(null, new HashMap());
    private final T rootNode;
    private final Map<T, Set<T>> dependencies;
    private List<T> topologicallySortedNodes;
    private Set<List<T>> cyclicDependencies;

    public static <T> DependencyGraph<T> emptyGraph() {
        return EMPTY_GRAPH;
    }

    public static <T> DependencyGraph<T> from(Map<T, Set<T>> dependencies) {
        if (dependencies.isEmpty()) {
            return EMPTY_GRAPH;
        }
        return new DependencyGraph<Object>(null, dependencies);
    }

    private DependencyGraph(T rootNode, Map<T, Set<T>> dependencies) {
        this.rootNode = rootNode;
        this.dependencies = Collections.unmodifiableMap(dependencies);
    }

    public Set<List<T>> findCycles() {
        if (this.cyclicDependencies == null) {
            this.toTopologicallySortedList();
        }
        return this.cyclicDependencies;
    }

    Set<T> difference(DependencyGraph<T> other) {
        HashSet<T> diff = new HashSet<T>(this.getNodes());
        diff.removeAll(other.getNodes());
        return diff;
    }

    public DependencyGraph<T> add(T node) {
        HashMap<T, Set<T>> newDependencies = new HashMap<T, Set<T>>(this.dependencies);
        newDependencies.put(node, new HashSet());
        return new DependencyGraph<T>(this.rootNode, newDependencies);
    }

    public DependencyGraph<T> addAll(Collection<T> nodes) {
        throw new UnsupportedOperationException();
    }

    public DependencyGraph<T> addDependencies(T dependent, Collection<T> dependencies) {
        throw new UnsupportedOperationException();
    }

    public Collection<T> getNodes() {
        return this.dependencies.keySet();
    }

    public Collection<T> getDirectDependents(T node) {
        HashSet<T> deps = new HashSet<T>();
        for (Map.Entry<T, Set<T>> depNode : this.dependencies.entrySet()) {
            if (depNode.equals(node) || !this.dependencies.get(depNode.getKey()).contains(node)) continue;
            deps.add(depNode.getKey());
        }
        return deps;
    }

    public Collection<T> getDirectDependencies(T node) {
        Set<T> deps = this.dependencies.get(node);
        if (deps == null) {
            return Collections.emptySet();
        }
        return deps;
    }

    public T getRoot() {
        return this.rootNode;
    }

    public Collection<T> getAllDependents(T node) {
        HashSet allDependents = new HashSet();
        HashSet visited = new HashSet();
        this.getAllDependentsRecursive(node, allDependents, visited);
        return allDependents;
    }

    public Collection<T> getAllDependencies(T node) {
        HashSet allDependencies = new HashSet();
        HashSet visited = new HashSet();
        this.getAllDependenciesRecursive(node, allDependencies, visited);
        return allDependencies;
    }

    public boolean contains(T node) {
        return this.dependencies.containsKey(node);
    }

    public List<T> toTopologicallySortedList() {
        if (this.topologicallySortedNodes != null) {
            return this.topologicallySortedNodes;
        }
        this.cyclicDependencies = new LinkedHashSet<List<T>>();
        ArrayList visited = new ArrayList();
        ArrayList ancestors = new ArrayList();
        ArrayList sorted = new ArrayList();
        for (T node : new TreeSet<T>(this.dependencies.keySet())) {
            if (visited.contains(node) || ancestors.contains(node)) continue;
            this.sortTopologically(node, visited, ancestors, sorted);
        }
        this.topologicallySortedNodes = Collections.unmodifiableList(sorted);
        this.cyclicDependencies.forEach(cycle -> cycle.add(cycle.get(0)));
        return this.topologicallySortedNodes;
    }

    public boolean isEmpty() {
        return this == EMPTY_GRAPH;
    }

    private void sortTopologically(T vertex, List<T> visited, List<T> ancestors, List<T> sorted) {
        ancestors.add(vertex);
        for (Object node : new TreeSet(this.dependencies.get(vertex))) {
            if (ancestors.contains(node)) {
                ArrayList<T> newCycle = new ArrayList<T>(ancestors.subList(ancestors.indexOf(node), ancestors.size()));
                if (newCycle.size() == 1) continue;
                boolean contains = false;
                for (List<T> cycle : this.cyclicDependencies) {
                    if (!new HashSet<T>(cycle).equals(new HashSet<T>(newCycle))) continue;
                    contains = true;
                    break;
                }
                if (!contains) {
                    this.cyclicDependencies.add(newCycle);
                }
                this.topologicallySortedNodes = null;
                continue;
            }
            if (visited.contains(node) && this.cyclicDependencies.isEmpty()) continue;
            this.sortTopologically(node, visited, ancestors, sorted);
        }
        if (!visited.contains(vertex)) {
            sorted.add(vertex);
            visited.add(vertex);
        }
        ancestors.remove(vertex);
    }

    private void getAllDependentsRecursive(T node, Set<T> allDependents, Set<T> visited) {
        visited.add(node);
        Collection<T> directDependents = this.getDirectDependents(node);
        allDependents.addAll(directDependents);
        for (T dependent : directDependents) {
            if (visited.contains(dependent)) continue;
            this.getAllDependentsRecursive(dependent, allDependents, visited);
        }
    }

    private void getAllDependenciesRecursive(T node, Set<T> allDependencies, Set<T> visited) {
        visited.add(node);
        Collection<T> directDependencies = this.getDirectDependencies(node);
        allDependencies.addAll(directDependencies);
        for (T dependency : directDependencies) {
            if (visited.contains(dependency)) continue;
            this.getAllDependenciesRecursive(dependency, allDependencies, visited);
        }
    }

    public static class DependencyGraphBuilder<T> {
        private final T rootNode;
        private final Map<T, Set<T>> dependenciesMap;

        private DependencyGraphBuilder(T rootNode, Map<T, Set<T>> dependencies) {
            this.rootNode = rootNode;
            this.dependenciesMap = dependencies;
        }

        public static <T> DependencyGraphBuilder<T> getBuilder() {
            return new DependencyGraphBuilder<Object>(null, new HashMap());
        }

        public static <T> DependencyGraphBuilder<T> getBuilder(T rootNode) {
            return new DependencyGraphBuilder<T>(rootNode, new HashMap());
        }

        public DependencyGraphBuilder<T> add(T node) {
            if (!this.dependenciesMap.containsKey(node)) {
                this.dependenciesMap.put(node, new HashSet());
            }
            return this;
        }

        public DependencyGraphBuilder<T> addDependency(T dependent, T dependency) {
            this.getCurrentDependencies(dependent).add(dependency);
            return this.add(dependency);
        }

        public DependencyGraphBuilder<T> addDependencies(T dependent, Collection<T> dependencies) {
            this.getCurrentDependencies(dependent).addAll(dependencies);
            dependencies.forEach(this::add);
            return this;
        }

        public DependencyGraphBuilder<T> mergeGraph(DependencyGraph<T> theirGraph) {
            Map<T, Set<T>> ourDependenciesMap = this.dependenciesMap;
            for (Map.Entry theirDependencyEntry : theirGraph.dependencies.entrySet()) {
                if (ourDependenciesMap.containsKey(theirDependencyEntry.getKey())) {
                    Set<T> ourCurrentDependencies = ourDependenciesMap.get(theirDependencyEntry.getKey());
                    ourCurrentDependencies.addAll(theirDependencyEntry.getValue());
                    continue;
                }
                ourDependenciesMap.put(theirDependencyEntry.getKey(), theirDependencyEntry.getValue());
            }
            return this;
        }

        public DependencyGraph<T> build() {
            return new DependencyGraph<T>(this.rootNode, this.dependenciesMap);
        }

        private Set<T> getCurrentDependencies(T dependent) {
            Set<Object> currentDependencies;
            if (this.dependenciesMap.containsKey(dependent)) {
                currentDependencies = this.dependenciesMap.get(dependent);
            } else {
                currentDependencies = new HashSet();
                this.dependenciesMap.put(dependent, currentDependencies);
            }
            return currentDependencies;
        }
    }
}

