/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.util.Collection;
import java.util.function.Predicate;

public final class Diagnostics {
    private Diagnostics() {
    }

    public static Collection<Diagnostic> filterErrors(Collection<Diagnostic> diagnostics) {
        return Diagnostics.filterDiagnostics(diagnostics, DiagnosticSeverity.ERROR);
    }

    public static boolean hasErrors(Collection<Diagnostic> diagnostics) {
        return Diagnostics.hasDiagnosticsWithSeverity(diagnostics, DiagnosticSeverity.ERROR);
    }

    public static Collection<Diagnostic> filterWarnings(Collection<Diagnostic> diagnostics) {
        return Diagnostics.filterDiagnostics(diagnostics, DiagnosticSeverity.WARNING);
    }

    public static Collection<Diagnostic> filterHints(Collection<Diagnostic> diagnostics) {
        return Diagnostics.filterDiagnostics(diagnostics, DiagnosticSeverity.HINT);
    }

    public static Collection<Diagnostic> excludeInternal(Collection<Diagnostic> diagnostics) {
        return Diagnostics.filterDiagnostics(diagnostics, (Diagnostic diagnostic) -> diagnostic.diagnosticInfo().severity() != DiagnosticSeverity.INTERNAL);
    }

    public static boolean hasWarnings(Collection<Diagnostic> diagnostics) {
        return Diagnostics.hasDiagnosticsWithSeverity(diagnostics, DiagnosticSeverity.WARNING);
    }

    public static boolean hasHints(Collection<Diagnostic> diagnostics) {
        return Diagnostics.hasDiagnosticsWithSeverity(diagnostics, DiagnosticSeverity.HINT);
    }

    private static Collection<Diagnostic> filterDiagnostics(Collection<Diagnostic> diagnostics, DiagnosticSeverity severity) {
        return Diagnostics.filterDiagnostics(diagnostics, (Diagnostic diagnostic) -> diagnostic.diagnosticInfo().severity() == severity);
    }

    private static Collection<Diagnostic> filterDiagnostics(Collection<Diagnostic> diagnostics, Predicate<Diagnostic> predicate) {
        return diagnostics.stream().filter(predicate).toList();
    }

    private static boolean hasDiagnosticsWithSeverity(Collection<Diagnostic> diagnostics, DiagnosticSeverity severity) {
        return diagnostics.stream().anyMatch(diagnostic -> diagnostic.diagnosticInfo().severity() == severity);
    }
}

