/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.BalCommand;
import io.ballerina.projects.CompilationCache;
import io.ballerina.projects.CompilerBackend;
import io.ballerina.projects.DiagnosticResult;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.EmitResult;
import io.ballerina.projects.JBallerinaBalaWriter;
import io.ballerina.projects.JarLibrary;
import io.ballerina.projects.JarResolver;
import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.ModuleContext;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.PackageContext;
import io.ballerina.projects.PackageDependencyScope;
import io.ballerina.projects.PackageId;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.PackageResolution;
import io.ballerina.projects.PlatformLibrary;
import io.ballerina.projects.PlatformLibraryScope;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.TestEmitArgs;
import io.ballerina.projects.environment.PackageCache;
import io.ballerina.projects.environment.ProjectEnvironment;
import io.ballerina.projects.internal.DefaultDiagnosticResult;
import io.ballerina.projects.internal.PackageDiagnostic;
import io.ballerina.projects.internal.ProjectDiagnosticErrorCode;
import io.ballerina.projects.internal.model.Target;
import io.ballerina.projects.util.FileUtils;
import io.ballerina.projects.util.ProjectUtils;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntryPredicate;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.ballerinalang.maven.Dependency;
import org.ballerinalang.maven.MavenResolver;
import org.ballerinalang.maven.Utils;
import org.ballerinalang.maven.exceptions.MavenResolverException;
import org.wso2.ballerinalang.compiler.bir.codegen.CodeGenerator;
import org.wso2.ballerinalang.compiler.bir.codegen.CompiledJarFile;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropValidator;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.util.Lists;

public class JBallerinaBackend
extends CompilerBackend {
    private static final String JAR_FILE_EXTENSION = ".jar";
    private static final String TEST_JAR_FILE_NAME_SUFFIX = "-testable";
    private static final String JAR_FILE_NAME_SUFFIX = "";
    private static final HashSet<String> excludeExtensions = new HashSet<String>(Lists.of("DSA", "SF"));
    private static final String OS = System.getProperty("os.name").toLowerCase(Locale.getDefault());
    public static final String JAR_NAME_SEPARATOR = "-";
    private final PackageResolution pkgResolution;
    private final JvmTarget jdkVersion;
    private final PackageContext packageContext;
    private final PackageCache packageCache;
    private final CompilerContext compilerContext;
    private final CodeGenerator jvmCodeGenerator;
    private final InteropValidator interopValidator;
    private final JarResolver jarResolver;
    private final PackageCompilation packageCompilation;
    private DiagnosticResult diagnosticResult;
    private boolean codeGenCompleted;
    private final List<JarConflict> conflictedJars;
    List<Diagnostic> conflictedResourcesDiagnostics = new ArrayList<Diagnostic>();

    public static JBallerinaBackend from(PackageCompilation packageCompilation, JvmTarget jdkVersion) {
        return JBallerinaBackend.from(packageCompilation, jdkVersion, true);
    }

    public static JBallerinaBackend from(PackageCompilation packageCompilation, JvmTarget jdkVersion, boolean shrink) {
        if (packageCompilation.packageContext().project().kind().equals((Object)ProjectKind.BUILD_PROJECT)) {
            try {
                new Target(packageCompilation.packageContext().project().targetDir());
            }
            catch (IOException e) {
                throw new ProjectException("error while checking permissions of target directory", e);
            }
        }
        return packageCompilation.getCompilerBackend(jdkVersion, targetPlatform -> new JBallerinaBackend(packageCompilation, jdkVersion, shrink));
    }

    private JBallerinaBackend(PackageCompilation packageCompilation, JvmTarget jdkVersion, boolean shrink) {
        this.jdkVersion = jdkVersion;
        this.packageCompilation = packageCompilation;
        this.packageContext = packageCompilation.packageContext();
        this.pkgResolution = this.packageContext.getResolution();
        this.jarResolver = new JarResolver(this, this.packageContext.getResolution());
        ProjectEnvironment projectEnvContext = this.packageContext.project().projectEnvironmentContext();
        this.packageCache = projectEnvContext.getService(PackageCache.class);
        this.compilerContext = projectEnvContext.getService(CompilerContext.class);
        this.interopValidator = InteropValidator.getInstance(this.compilerContext);
        this.jvmCodeGenerator = CodeGenerator.getInstance(this.compilerContext);
        this.conflictedJars = new ArrayList<JarConflict>();
        this.performCodeGen(shrink);
    }

    PackageContext packageContext() {
        return this.packageContext;
    }

    private void performCodeGen(boolean shrink) {
        if (this.codeGenCompleted) {
            return;
        }
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        diagnostics.addAll(this.packageContext.getResolution().diagnosticResult().allDiagnostics);
        diagnostics.addAll(this.packageContext.packageManifest().diagnostics().diagnostics());
        ArrayList<Diagnostic> moduleDiagnostics = new ArrayList<Diagnostic>();
        for (ModuleContext moduleContext : this.pkgResolution.topologicallySortedModuleList()) {
            if (shrink) {
                ModuleContext.shrinkDocuments(moduleContext);
            }
            if (moduleContext.moduleId().packageId().equals(this.packageContext.packageId()) && this.packageCompilation.diagnosticResult().hasErrors()) {
                for (Diagnostic diagnostic : moduleContext.diagnostics()) {
                    moduleDiagnostics.add(new PackageDiagnostic(diagnostic, moduleContext.descriptor(), moduleContext.project()));
                }
                continue;
            }
            if (!this.packageContext.getResolution().diagnosticResult().hasErrors() && !this.hasErrors(moduleDiagnostics)) {
                moduleContext.generatePlatformSpecificCode(this.compilerContext, this);
            }
            for (Diagnostic diagnostic : moduleContext.diagnostics()) {
                if (!this.packageContext.project().buildOptions().showDependencyDiagnostics() && ProjectKind.BALA_PROJECT.equals((Object)moduleContext.project().kind()) && diagnostic.diagnosticInfo().severity() != DiagnosticSeverity.ERROR) continue;
                moduleDiagnostics.add(new PackageDiagnostic(diagnostic, moduleContext.descriptor(), moduleContext.project()));
            }
            if (moduleContext.project().kind() != ProjectKind.BALA_PROJECT) continue;
            moduleContext.cleanBLangPackage();
        }
        diagnostics.addAll(moduleDiagnostics);
        diagnostics.addAll(this.packageContext.getPackageCompilation().pluginDiagnostics());
        diagnostics.addAll(this.conflictedResourcesDiagnostics);
        this.diagnosticResult = new DefaultDiagnosticResult(diagnostics);
        this.codeGenCompleted = true;
    }

    private boolean hasErrors(List<Diagnostic> diagnostics) {
        for (Diagnostic diagnostic : diagnostics) {
            if (diagnostic.diagnosticInfo().severity() != DiagnosticSeverity.ERROR) continue;
            return true;
        }
        return false;
    }

    public DiagnosticResult diagnosticResult() {
        return this.diagnosticResult;
    }

    public EmitResult emit(OutputType outputType, Path filePath) {
        if (this.diagnosticResult.hasErrors()) {
            return new EmitResult(false, new DefaultDiagnosticResult(new ArrayList<Diagnostic>()), null);
        }
        ArrayList<Diagnostic> emitResultDiagnostics = new ArrayList<Diagnostic>();
        Path generatedArtifact = switch (outputType.ordinal()) {
            case 2 -> this.emitGraalExecutable(filePath, emitResultDiagnostics);
            case 0 -> this.emitExecutable(filePath, emitResultDiagnostics);
            case 1 -> this.emitBala(filePath);
            default -> throw new RuntimeException("Unexpected output type: " + String.valueOf((Object)outputType));
        };
        return this.getEmitResult(filePath, generatedArtifact, BalCommand.BUILD, emitResultDiagnostics);
    }

    public EmitResult emit(TestEmitArgs testEmitArgs) {
        Path generatedArtifact = null;
        if (this.diagnosticResult.hasErrors()) {
            return new EmitResult(false, new DefaultDiagnosticResult(new ArrayList<Diagnostic>()), null);
        }
        if (testEmitArgs.outputType() != OutputType.TEST) {
            throw new RuntimeException("Unexpected output type: " + String.valueOf((Object)testEmitArgs.outputType()));
        }
        generatedArtifact = this.emitTestExecutable(testEmitArgs.filePath(), testEmitArgs.jarDependencies(), testEmitArgs.testSuiteJsonPath(), testEmitArgs.jsonCopyPath(), testEmitArgs.excludedClasses(), testEmitArgs.classPathTextCopyPath());
        return this.getEmitResult(testEmitArgs.filePath(), generatedArtifact, BalCommand.TEST, new ArrayList<Diagnostic>());
    }

    private EmitResult getEmitResult(Path filePath, Path generatedArtifact, BalCommand balCommand, List<Diagnostic> emitDiagnostics) {
        List<Diagnostic> pluginDiagnostics;
        if (filePath != null && !(pluginDiagnostics = this.notifyCompilationCompletion(filePath, balCommand)).isEmpty()) {
            emitDiagnostics.addAll(pluginDiagnostics);
        }
        ArrayList<Diagnostic> allDiagnostics = new ArrayList<Diagnostic>(this.diagnosticResult.allDiagnostics);
        emitDiagnostics.addAll(this.jarResolver().diagnosticResult().diagnostics());
        allDiagnostics.addAll(emitDiagnostics);
        this.diagnosticResult = new DefaultDiagnosticResult(allDiagnostics);
        return new EmitResult(true, new DefaultDiagnosticResult(emitDiagnostics), generatedArtifact);
    }

    public List<Diagnostic> notifyCompilationCompletion(Path filePath, BalCommand balCommand) {
        return this.packageCompilation.notifyCompilationCompletion(filePath, balCommand);
    }

    private Path emitBala(Path filePath) {
        JBallerinaBalaWriter writer = new JBallerinaBalaWriter(this);
        return writer.write(filePath);
    }

    @Override
    public Collection<PlatformLibrary> platformLibraryDependencies(PackageId packageId) {
        return this.getPlatformLibraries(packageId);
    }

    @Override
    public Collection<PlatformLibrary> platformLibraryDependencies(PackageId packageId, PlatformLibraryScope scope) {
        return this.getPlatformLibraries(packageId).stream().filter(platformLibrary -> platformLibrary.scope() == scope).toList();
    }

    private List<PlatformLibrary> getPlatformLibraries(PackageId packageId) {
        Package pkg = this.packageCache.getPackageOrThrow(packageId);
        Map<String, PackageManifest.Platform> platforms = pkg.manifest().platforms();
        ArrayList<PlatformLibrary> platformLibraries = new ArrayList<PlatformLibrary>();
        for (Map.Entry<String, PackageManifest.Platform> entry : platforms.entrySet()) {
            PackageManifest.Platform javaPlatform = entry.getValue();
            String platform = entry.getKey();
            if (javaPlatform == null || javaPlatform.dependencies().isEmpty()) continue;
            for (Map<String, Object> dependency : javaPlatform.dependencies()) {
                Path jarPath;
                String artifactId = (String)dependency.get("artifactId");
                String version = (String)dependency.get("version");
                String groupId = (String)dependency.get("groupId");
                String dependencyFilePath = (String)dependency.get("path");
                PlatformLibraryScope dependencyScope = this.getPlatformLibraryScope(dependency);
                if (dependencyFilePath == null || dependencyFilePath.isEmpty()) {
                    if (Objects.equals((Object)dependencyScope, (Object)PlatformLibraryScope.PROVIDED) && !Objects.equals(packageId, this.packageContext().packageId())) {
                        dependencyFilePath = this.getPlatformLibPathFromProvided(platform, groupId, artifactId, version);
                        jarPath = Path.of(dependencyFilePath, new String[0]);
                        if (!jarPath.isAbsolute()) {
                            jarPath = this.packageContext().project().sourceRoot().resolve(jarPath);
                        }
                        dependencyFilePath = jarPath.toString();
                    } else {
                        dependencyFilePath = this.getPlatformLibPath(groupId, artifactId, version);
                    }
                    dependency.put("path", dependencyFilePath);
                }
                if (!(jarPath = Path.of(dependencyFilePath, new String[0])).isAbsolute()) {
                    jarPath = pkg.project().sourceRoot().resolve(jarPath);
                }
                platformLibraries.add(new JarLibrary(jarPath, dependencyScope, artifactId, groupId, version, pkg.packageOrg().value() + "/" + pkg.packageName().value()));
            }
        }
        return platformLibraries;
    }

    @Override
    public PlatformLibrary codeGeneratedLibrary(PackageId packageId, ModuleName moduleName) {
        return this.codeGeneratedLibrary(packageId, moduleName, PlatformLibraryScope.DEFAULT, JAR_FILE_NAME_SUFFIX);
    }

    @Override
    public PlatformLibrary codeGeneratedTestLibrary(PackageId packageId, ModuleName moduleName) {
        return this.codeGeneratedLibrary(packageId, moduleName, PlatformLibraryScope.DEFAULT, TEST_JAR_FILE_NAME_SUFFIX);
    }

    @Override
    public PlatformLibrary codeGeneratedResourcesLibrary(PackageId packageId) {
        return this.codeGeneratedResourcesLibrary(packageId, PlatformLibraryScope.DEFAULT);
    }

    @Override
    public PlatformLibrary runtimeLibrary() {
        return new JarLibrary(ProjectUtils.getBallerinaRTJarPath(), PlatformLibraryScope.DEFAULT);
    }

    @Override
    public CompilerBackend.TargetPlatform targetPlatform() {
        return this.jdkVersion;
    }

    @Override
    public void performCodeGen(ModuleContext moduleContext, CompilationCache compilationCache) {
        BLangPackage bLangPackage = moduleContext.bLangPackage();
        this.interopValidator.validate(moduleContext.moduleId(), this, bLangPackage);
        if (bLangPackage.getErrorCount() > 0) {
            return;
        }
        boolean isRemoteMgtEnabled = moduleContext.project().buildOptions().compilationOptions().remoteManagement();
        CompiledJarFile compiledJarFile = this.jvmCodeGenerator.generate(bLangPackage, isRemoteMgtEnabled);
        String jarFileName = this.getJarFileName(moduleContext);
        try {
            ByteArrayOutputStream byteStream = compiledJarFile.toByteArrayStream();
            compilationCache.cachePlatformSpecificLibrary(this, jarFileName, byteStream);
        }
        catch (IOException e) {
            throw new ProjectException("Failed to cache generated jar, module: " + String.valueOf(moduleContext.moduleName()));
        }
        if (moduleContext.project().currentPackage().packageContext() == this.packageContext && moduleContext.isDefaultModule()) {
            this.cacheResources(compilationCache, moduleContext.project().buildOptions().skipTests());
        }
        if (moduleContext.project().buildOptions().skipTests()) {
            return;
        }
        if (!bLangPackage.hasTestablePackage()) {
            return;
        }
        String testJarFileName = jarFileName + TEST_JAR_FILE_NAME_SUFFIX;
        CompiledJarFile compiledTestJarFile = this.jvmCodeGenerator.generateTestModule(bLangPackage.testablePkgs.get(0), isRemoteMgtEnabled);
        try {
            ByteArrayOutputStream byteStream = compiledTestJarFile.toByteArrayStream();
            compilationCache.cachePlatformSpecificLibrary(this, testJarFileName, byteStream);
        }
        catch (IOException e) {
            throw new ProjectException("Failed to cache generated test jar, module: " + String.valueOf(moduleContext.moduleName()));
        }
    }

    @Override
    public String libraryFileExtension() {
        return JAR_FILE_EXTENSION;
    }

    public JarResolver jarResolver() {
        return this.jarResolver;
    }

    public List<JarConflict> conflictedJars() {
        return this.conflictedJars;
    }

    private String getJarFileName(ModuleContext moduleContext) {
        String jarName;
        if (moduleContext.project().kind() == ProjectKind.SINGLE_FILE_PROJECT) {
            DocumentId documentId = moduleContext.srcDocumentIds().iterator().next();
            String documentName = moduleContext.documentContext(documentId).name();
            jarName = FileUtils.getFileNameWithoutExtension(documentName);
        } else {
            jarName = ProjectUtils.getThinJarFileName(moduleContext.descriptor().org(), moduleContext.moduleName().toString(), moduleContext.descriptor().version());
        }
        return jarName;
    }

    private void assembleExecutableJar(Path executableFilePath, Manifest manifest, Collection<JarLibrary> jarLibraries) throws IOException {
        HashMap<String, JarLibrary> copiedEntries = new HashMap<String, JarLibrary>();
        HashMap<String, StringBuilder> serviceEntries = new HashMap<String, StringBuilder>();
        try (ZipArchiveOutputStream outStream = new ZipArchiveOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(executableFilePath.toString())));){
            this.writeManifest(manifest, outStream);
            this.sortAndCopyJars(jarLibraries, outStream, copiedEntries, serviceEntries);
            JBallerinaBackend.copyMergedSpiServices(serviceEntries, outStream);
        }
    }

    private void assembleTestExecutableJar(Path executableFilePath, Manifest manifest, Collection<JarLibrary> jarLibraries, Path testSuiteJsonPath, String jsonCopyPath, List<String> excludedClasses, String classPathTextCopyPath) throws IOException {
        HashMap<String, JarLibrary> copiedEntries = new HashMap<String, JarLibrary>();
        HashMap<String, StringBuilder> serviceEntries = new HashMap<String, StringBuilder>();
        try (ZipArchiveOutputStream outStream = new ZipArchiveOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(executableFilePath.toString())));){
            this.writeManifest(manifest, outStream);
            this.sortAndCopyJars(jarLibraries, outStream, copiedEntries, serviceEntries);
            JBallerinaBackend.copyMergedSpiServices(serviceEntries, outStream);
            JarArchiveEntry testSuiteJsonEntry = new JarArchiveEntry(jsonCopyPath);
            outStream.putArchiveEntry((ZipArchiveEntry)testSuiteJsonEntry);
            outStream.write(Files.readAllBytes(testSuiteJsonPath));
            outStream.closeArchiveEntry();
            JarArchiveEntry classPathTextEntry = new JarArchiveEntry(classPathTextCopyPath);
            outStream.putArchiveEntry((ZipArchiveEntry)classPathTextEntry);
            for (String path : excludedClasses) {
                outStream.write((path + "\n").getBytes(StandardCharsets.UTF_8));
            }
            outStream.closeArchiveEntry();
        }
    }

    private static void copyMergedSpiServices(HashMap<String, StringBuilder> serviceEntries, ZipArchiveOutputStream outStream) throws IOException {
        for (Map.Entry<String, StringBuilder> entry : serviceEntries.entrySet()) {
            String s = entry.getKey();
            StringBuilder service = entry.getValue();
            JarArchiveEntry e = new JarArchiveEntry(s);
            outStream.putArchiveEntry((ZipArchiveEntry)e);
            outStream.write(service.toString().getBytes(StandardCharsets.UTF_8));
            outStream.closeArchiveEntry();
        }
    }

    private void sortAndCopyJars(Collection<JarLibrary> jarLibraries, ZipArchiveOutputStream outStream, HashMap<String, JarLibrary> copiedEntries, HashMap<String, StringBuilder> serviceEntries) throws IOException {
        List<JarLibrary> sortedJarLibraries = jarLibraries.stream().sorted(Comparator.comparing(jarLibrary -> jarLibrary.path().getFileName())).toList();
        for (JarLibrary library : sortedJarLibraries) {
            this.copyJar(outStream, library, copiedEntries, serviceEntries);
        }
    }

    private void writeManifest(Manifest manifest, ZipArchiveOutputStream outStream) throws IOException {
        JarArchiveEntry e = new JarArchiveEntry("META-INF/MANIFEST.MF");
        outStream.putArchiveEntry((ZipArchiveEntry)e);
        manifest.write(new BufferedOutputStream((OutputStream)outStream));
        outStream.closeArchiveEntry();
    }

    private Manifest createManifest() {
        String mainClassName;
        PlatformLibrary rootModuleJarFile = this.codeGeneratedLibrary(this.packageContext.packageId(), this.packageContext.defaultModuleContext().moduleName());
        try (JarInputStream jarStream = new JarInputStream(Files.newInputStream(rootModuleJarFile.path(), new OpenOption[0]));){
            Manifest mf = jarStream.getManifest();
            mainClassName = (String)mf.getMainAttributes().get(Attributes.Name.MAIN_CLASS);
        }
        catch (IOException e) {
            throw new RuntimeException("Generated jar file cannot be found for the module: " + String.valueOf(this.packageContext.defaultModuleContext().moduleName()));
        }
        Manifest manifest = new Manifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        mainAttributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        mainAttributes.put(Attributes.Name.MAIN_CLASS, mainClassName);
        return manifest;
    }

    private Manifest createTestManifest() {
        String mainClassName = "org.ballerinalang.test.runtime.BTestMain";
        Manifest manifest = new Manifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        mainAttributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        mainAttributes.put(Attributes.Name.MAIN_CLASS, mainClassName);
        return manifest;
    }

    private void copyJar(ZipArchiveOutputStream outStream, JarLibrary jarLibrary, HashMap<String, JarLibrary> copiedEntries, HashMap<String, StringBuilder> services) throws IOException {
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        try (ZipFile zipFile = new ZipFile(jarLibrary.path().toFile());){
            ZipArchiveEntryPredicate predicate = entry -> {
                String entryName = entry.getName();
                if (entryName.equals("META-INF/MANIFEST.MF")) {
                    return false;
                }
                if (entryName.equals("module-info.class")) {
                    return false;
                }
                if (entryName.startsWith("META-INF/services")) {
                    StringBuilder s = (StringBuilder)services.get(entryName);
                    if (s == null) {
                        s = new StringBuilder();
                        services.put(entryName, s);
                    }
                    char c = '\n';
                    try (BufferedInputStream inStream = new BufferedInputStream(zipFile.getInputStream(entry));){
                        int len;
                        while ((len = inStream.read()) != -1) {
                            c = (char)len;
                            s.append(c);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    if (c != '\n') {
                        s.append('\n');
                    }
                    return false;
                }
                if (JBallerinaBackend.isCopiedEntry(entryName, copiedEntries)) {
                    this.addConflictedJars(jarLibrary, copiedEntries, entryName);
                    return false;
                }
                if (JBallerinaBackend.isExcludedEntry(entryName)) {
                    return false;
                }
                copiedEntries.put(entryName, jarLibrary);
                return true;
            };
            zipFile.copyRawEntries(outStream, predicate);
        }
    }

    private static boolean isCopiedEntry(String entryName, HashMap<String, JarLibrary> copiedEntries) {
        return copiedEntries.containsKey(entryName);
    }

    private static boolean isExcludedEntry(String entryName) {
        return excludeExtensions.contains(entryName.substring(entryName.lastIndexOf(46) + 1));
    }

    private PlatformLibrary codeGeneratedLibrary(PackageId packageId, ModuleName moduleName, PlatformLibraryScope scope, String fileNameSuffix) {
        Package pkg = this.packageCache.getPackageOrThrow(packageId);
        ProjectEnvironment projectEnvironment = pkg.project().projectEnvironmentContext();
        CompilationCache compilationCache = projectEnvironment.getService(CompilationCache.class);
        String jarFileName = this.getJarFileName(pkg.packageContext().moduleContext(moduleName)) + fileNameSuffix;
        Optional<Path> platformSpecificLibrary = compilationCache.getPlatformSpecificLibrary(this, jarFileName);
        return new JarLibrary(platformSpecificLibrary.orElseThrow(() -> new IllegalStateException("Cannot find the generated jar library for module: " + String.valueOf(moduleName))), scope);
    }

    private Path emitExecutable(Path executableFilePath, List<Diagnostic> emitResultDiagnostics) {
        Manifest manifest = this.createManifest();
        Collection<JarLibrary> jarLibraries = this.jarResolver.getJarFilePathsRequiredForExecution();
        this.addProvidedDependencyWarning(emitResultDiagnostics);
        try {
            this.assembleExecutableJar(executableFilePath, manifest, jarLibraries);
        }
        catch (IOException e) {
            throw new ProjectException("error while creating the executable jar file for package '" + this.packageContext.packageName().toString() + "' : " + e.getMessage(), e);
        }
        return executableFilePath;
    }

    private Path emitTestExecutable(Path executableFilePath, HashSet<JarLibrary> jarDependencies, Path testSuiteJsonPath, String jsonCopyPath, List<String> excludedClasses, String classPathTextCopyPath) {
        Manifest manifest = this.createTestManifest();
        try {
            this.assembleTestExecutableJar(executableFilePath, manifest, jarDependencies, testSuiteJsonPath, jsonCopyPath, excludedClasses, classPathTextCopyPath);
        }
        catch (IOException e) {
            throw new ProjectException("error while creating the test executable jar file for package '" + this.packageContext.packageName().toString() + "' : " + e.getMessage(), e);
        }
        return executableFilePath;
    }

    private Path emitGraalExecutable(Path executableFilePath, List<Diagnostic> emitResultDiagnostics) {
        this.emitExecutable(executableFilePath, emitResultDiagnostics);
        Project project = this.packageContext().project();
        Object nativeImageCommand = System.getenv("GRAALVM_HOME");
        if (nativeImageCommand == null) {
            throw new ProjectException("GraalVM installation directory not found. Set GRAALVM_HOME as an environment variable\nHINT: To install GraalVM, follow the link: https://ballerina.io/learn/build-the-executable-locally/#configure-graalvm");
        }
        File commandExecutable = Path.of((String)(nativeImageCommand = (String)nativeImageCommand + File.separator + "bin" + File.separator + (OS.contains("win") ? "native-image.cmd" : "native-image")), new String[0]).toFile();
        if (!commandExecutable.exists()) {
            throw new ProjectException("cannot find '" + commandExecutable.getName() + "' in the GRAALVM_HOME/bin directory. Install it using: gu install native-image");
        }
        String graalVMBuildOptions = project.buildOptions().graalVMBuildOptions();
        ArrayList<String> nativeArgs = new ArrayList<String>();
        Path nativeConfigPath = this.packageContext.project().targetDir().resolve("cache");
        if (project.kind().equals((Object)ProjectKind.SINGLE_FILE_PROJECT)) {
            String fileName = project.sourceRoot().toFile().getName();
            String nativeImageName = fileName.substring(0, fileName.lastIndexOf("."));
            nativeArgs.addAll(Arrays.asList(graalVMBuildOptions, "-jar", executableFilePath.toString(), "-o " + String.valueOf(executableFilePath.getParent()) + "/" + nativeImageName, "--no-fallback"));
        } else {
            String nativeImageName = project.currentPackage().packageName().toString();
            nativeArgs.addAll(Arrays.asList(graalVMBuildOptions, "-jar", executableFilePath.toString(), "-o " + String.valueOf(executableFilePath.getParent()) + "/" + nativeImageName, "--no-fallback"));
        }
        if (!Files.exists(nativeConfigPath, new LinkOption[0])) {
            try {
                Files.createDirectories(nativeConfigPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ProjectException("error while generating the necessary graalvm argument file", e);
            }
        }
        try (FileWriter nativeArgumentWriter = new FileWriter(nativeConfigPath.resolve("native-image-args.txt").toString(), Charset.defaultCharset());){
            nativeArgumentWriter.write(String.join((CharSequence)" ", nativeArgs));
            nativeArgumentWriter.flush();
        }
        catch (IOException e) {
            throw new ProjectException("error while generating the necessary graalvm argument file", e);
        }
        String[] command = new String[]{nativeImageCommand, "@" + String.valueOf(nativeConfigPath.resolve("native-image-args.txt"))};
        try {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.command(command);
            builder.inheritIO();
            Process process = builder.start();
            if (process.waitFor() != 0) {
                throw new ProjectException("unable to create native image");
            }
        }
        catch (IOException e) {
            throw new ProjectException("unable to create native image : " + e.getMessage());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return Path.of(FilenameUtils.removeExtension((String)executableFilePath.toString()), new String[0]);
    }

    private PlatformLibraryScope getPlatformLibraryScope(Map<String, Object> dependency) {
        PlatformLibraryScope scope;
        String scopeValue = (String)dependency.get("scope");
        if (scopeValue == null || scopeValue.isEmpty()) {
            scope = PlatformLibraryScope.DEFAULT;
        } else if (PlatformLibraryScope.TEST_ONLY.getStringValue().equals(scopeValue)) {
            scope = PlatformLibraryScope.TEST_ONLY;
        } else if (PlatformLibraryScope.PROVIDED.getStringValue().equals(scopeValue)) {
            scope = PlatformLibraryScope.PROVIDED;
        } else {
            throw new ProjectException("Invalid scope '" + scopeValue + "' is defined with the platform-specific library path: " + String.valueOf(dependency.get("path")));
        }
        return scope;
    }

    private String getPlatformLibPath(String groupId, String artifactId, String version) {
        String targetRepo = String.valueOf(this.packageContext.project().targetDir().resolve("target")) + File.separator + "platform-libs";
        MavenResolver resolver = new MavenResolver(targetRepo);
        try {
            Dependency dependency = resolver.resolve(groupId, artifactId, version, false);
            return Utils.getJarPath((String)targetRepo, (Dependency)dependency);
        }
        catch (MavenResolverException e) {
            throw new ProjectException("cannot resolve " + artifactId + ": " + e.getMessage());
        }
    }

    private String getPlatformLibPathFromProvided(String platform, String groupId, String artifactId, String version) {
        PackageManifest.Platform currentPlatform = this.packageContext().packageManifest().platform(platform);
        if (currentPlatform != null) {
            for (Map<String, Object> platformDep : currentPlatform.dependencies()) {
                String depArtifactId = (String)platformDep.get("artifactId");
                String depVersion = (String)platformDep.get("version");
                String depGroupId = (String)platformDep.get("groupId");
                String depFilepath = (String)platformDep.get("path");
                if (!artifactId.equals(depArtifactId) || !groupId.equals(depGroupId) || !version.equals(depVersion) || depFilepath == null || depFilepath.isEmpty()) continue;
                return depFilepath;
            }
        }
        throw new ProjectException(String.format("cannot resolve '%s:%s:%s'. Dependencies with '%s' scope need to be manually added to Ballerina.toml.", groupId, artifactId, version, PlatformLibraryScope.PROVIDED.getStringValue()));
    }

    JvmTarget jdkVersion() {
        return this.jdkVersion;
    }

    private void addConflictedJars(JarLibrary jarLibrary, HashMap<String, JarLibrary> copiedEntries, String entryName) {
        if (entryName.endsWith(".class") && !entryName.endsWith("module-info.class")) {
            JarLibrary conflictingJar = copiedEntries.get(entryName);
            Path jarFileName = jarLibrary.path().getFileName();
            Path conflictingJarFileName = conflictingJar.path().getFileName();
            if (jarFileName != null && conflictingJarFileName != null && !jarFileName.toString().equals(conflictingJarFileName.toString())) {
                JarConflict jarConflict = this.getJarConflict(conflictingJar);
                if (jarConflict != null) {
                    jarConflict.addClasses(entryName);
                } else {
                    this.conflictedJars.add(new JarConflict(conflictingJar, jarLibrary, new ArrayList<String>(Collections.singletonList(entryName))));
                }
            }
        }
    }

    private JarConflict getJarConflict(JarLibrary conflictingJar) {
        for (JarConflict jarConflict : this.conflictedJars) {
            if (jarConflict.firstJarLibrary().path() != conflictingJar.path()) continue;
            return jarConflict;
        }
        return null;
    }

    private void addProvidedDependencyWarning(List<Diagnostic> emitResultDiagnostics) {
        if (!this.jarResolver.providedPlatformLibs().isEmpty()) {
            DiagnosticInfo diagnosticInfo = new DiagnosticInfo(ProjectDiagnosticErrorCode.PROVIDED_PLATFORM_JAR_IN_EXECUTABLE.diagnosticId(), String.format("Detected platform dependencies with '%s' scope. Redistribution is discouraged due to potential license restrictions%n", PlatformLibraryScope.PROVIDED.getStringValue()), DiagnosticSeverity.WARNING);
            emitResultDiagnostics.add(new PackageDiagnostic(diagnosticInfo, this.packageContext().descriptor().name().toString()));
        }
    }

    private PlatformLibrary codeGeneratedResourcesLibrary(PackageId packageId, PlatformLibraryScope scope) {
        Package pkg = this.packageCache.getPackageOrThrow(packageId);
        CompilationCache compilationCache = pkg.project().projectEnvironmentContext().getService(CompilationCache.class);
        return compilationCache.getPlatformSpecificLibrary(this, "resources").map(path -> new JarLibrary((Path)path, scope)).orElse(null);
    }

    private Map<String, byte[]> getPackageResources(PackageContext packageContext) {
        HashMap<String, byte[]> resourceMap = new HashMap<String, byte[]>();
        for (DocumentId documentId : packageContext.resourceIds()) {
            String resourceName = "resources/" + packageContext.resourceContext(documentId).name();
            resourceMap.put(resourceName, packageContext.resourceContext(documentId).content());
        }
        return resourceMap;
    }

    private Map<String, byte[]> getPackageAndTestResources(PackageContext packageContext) {
        Map<String, byte[]> resourceMap = this.getPackageResources(packageContext);
        for (DocumentId documentId : packageContext.testResourceIds()) {
            String resourceName = "resources/" + packageContext.resourceContext(documentId).name();
            if (resourceMap.containsKey(resourceName)) {
                this.addConflictingTestResourceDiag(packageContext.descriptor().toString(), resourceName);
            }
            resourceMap.put(resourceName, packageContext.resourceContext(documentId).content());
        }
        return resourceMap;
    }

    private void cacheResources(CompilationCache compilationCache, boolean skipTests) {
        HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
        HashMap<String, String> resourceToPkgMap = new HashMap<String, String>();
        ArrayList<String> conflictingResourceFiles = new ArrayList<String>();
        this.pkgResolution.allDependencies().stream().filter(pkgDep -> pkgDep.scope() != PackageDependencyScope.TEST_ONLY).filter(pkgDep -> !pkgDep.packageInstance().descriptor().isLangLibPackage()).map(pkgDep -> pkgDep.packageInstance().packageContext()).forEach(pkgContext -> {
            Map<String, byte[]> depResources = this.getPackageResources((PackageContext)pkgContext);
            for (Map.Entry<String, byte[]> entry : depResources.entrySet()) {
                if (resources.containsKey(entry.getKey())) {
                    this.addConflictingDepResourceDiag(pkgContext.descriptor().toString(), (String)resourceToPkgMap.get(entry.getKey()), entry.getKey());
                }
                resources.put(entry.getKey(), entry.getValue());
                resourceToPkgMap.put(entry.getKey(), pkgContext.descriptor().toString());
            }
        });
        Map<String, byte[]> packageResources = skipTests ? this.getPackageResources(this.packageContext) : this.getPackageAndTestResources(this.packageContext);
        for (Map.Entry<String, byte[]> entry : packageResources.entrySet()) {
            if (resources.containsKey(entry.getKey())) {
                this.addConflictingDepResourceDiag(this.packageContext.descriptor().toString(), (String)resourceToPkgMap.get(entry.getKey()), (String)entry.getKey());
            }
            resources.put(entry.getKey(), entry.getValue());
            resourceToPkgMap.put((String)entry.getKey(), this.packageContext.descriptor().toString());
        }
        if (!this.packageContext().project().kind().equals((Object)ProjectKind.BALA_PROJECT)) {
            Map<String, byte[]> generatedResources = ProjectUtils.getAllGeneratedResources(this.packageContext.project().generatedResourcesDir());
            for (Map.Entry entry : generatedResources.entrySet()) {
                if (resources.containsKey(entry.getKey())) {
                    if (packageResources.containsKey(entry.getKey())) {
                        conflictingResourceFiles.add((String)entry.getKey());
                        continue;
                    }
                    this.addConflictingGenResourceDiag((String)resourceToPkgMap.get(entry.getKey()), this.packageContext.descriptor().toString(), (String)entry.getKey());
                }
                resources.put((String)entry.getKey(), (byte[])entry.getValue());
            }
            if (!conflictingResourceFiles.isEmpty()) {
                throw new ProjectException(ProjectUtils.getConflictingResourcesMsg(this.packageContext.descriptor().toString(), conflictingResourceFiles));
            }
        }
        if (!resources.isEmpty()) {
            try {
                String resourceJarName = "resources";
                CompiledJarFile resourceJar = new CompiledJarFile(JAR_FILE_NAME_SUFFIX);
                resourceJar.jarEntries.putResourceEntries(resources);
                try (ByteArrayOutputStream byteArrayOutputStream = resourceJar.toByteArrayStream();){
                    compilationCache.cachePlatformSpecificLibrary(this, resourceJarName, byteArrayOutputStream);
                }
            }
            catch (IOException e) {
                throw new ProjectException("Failed to cache resources jar, package: " + String.valueOf(this.packageContext.packageName()), e);
            }
        }
    }

    private void addConflictingDepResourceDiag(String packageDesc, String existingPackageDesc, String resourceName) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(ProjectDiagnosticErrorCode.CONFLICTING_RESOURCE_FILE.diagnosticId(), String.format("detected conflicting resource files. The packages '" + existingPackageDesc + "' and '" + packageDesc + "' both export a resource with the same name '" + resourceName + "'. Picking the resource exported by '" + packageDesc + "'.", new Object[0]), DiagnosticSeverity.WARNING);
        this.conflictedResourcesDiagnostics.add(new PackageDiagnostic(diagnosticInfo, this.packageContext.descriptor().name().toString()));
    }

    private void addConflictingGenResourceDiag(String existingPackageDesc, String packageDesc, String resourceName) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(ProjectDiagnosticErrorCode.CONFLICTING_RESOURCE_FILE.diagnosticId(), String.format("detected conflicting resource files. The package " + existingPackageDesc + "  and the generated resources for the current package '" + packageDesc + "' both export a resource with the same name '" + resourceName + "'. Picking the generated resource file.", new Object[0]), DiagnosticSeverity.WARNING);
        this.conflictedResourcesDiagnostics.add(new PackageDiagnostic(diagnosticInfo, this.packageContext.descriptor().name().toString()));
    }

    private void addConflictingTestResourceDiag(String packageDesc, String resourceName) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(ProjectDiagnosticErrorCode.CONFLICTING_RESOURCE_FILE.diagnosticId(), String.format("detected conflicting resource files. The test specific resources and package resources for '" + packageDesc + "' both export a resource with the same name '" + resourceName + "'. Picking the test specific resource.", new Object[0]), DiagnosticSeverity.WARNING);
        this.conflictedResourcesDiagnostics.add(new PackageDiagnostic(diagnosticInfo, this.packageContext.descriptor().name().toString()));
    }

    public static enum OutputType {
        EXEC("exec"),
        BALA("bala"),
        GRAAL_EXEC("graal_exec"),
        TEST("test");

        private final String value;

        private OutputType(String value) {
            this.value = value;
        }
    }

    public static class JarConflict {
        JarLibrary firstJarLibrary;
        JarLibrary secondJarLibrary;
        List<String> classes;

        JarConflict(JarLibrary firstJarLibrary, JarLibrary secondJarLibrary, List<String> classes) {
            this.firstJarLibrary = firstJarLibrary;
            this.secondJarLibrary = secondJarLibrary;
            this.classes = classes;
        }

        JarLibrary firstJarLibrary() {
            return this.firstJarLibrary;
        }

        void addClasses(String entry) {
            this.classes.add(entry);
        }

        public String getWarning(boolean listClasses) {
            Object conflictedJarPkg1 = JBallerinaBackend.JAR_FILE_NAME_SUFFIX;
            Object conflictedJarPkg2 = JBallerinaBackend.JAR_FILE_NAME_SUFFIX;
            if (this.firstJarLibrary.packageName().isPresent()) {
                conflictedJarPkg1 = " dependency of '" + this.firstJarLibrary.packageName().get() + "'";
            }
            if (this.secondJarLibrary.packageName().isPresent()) {
                conflictedJarPkg2 = " dependency of '" + this.secondJarLibrary.packageName().get() + "'";
            }
            StringBuilder warning = new StringBuilder("\t\t'" + String.valueOf(this.firstJarLibrary.path().getFileName()) + "'" + (String)conflictedJarPkg1 + " conflict with '" + String.valueOf(this.secondJarLibrary.path().getFileName()) + "'" + (String)conflictedJarPkg2);
            if (listClasses) {
                for (String conflictedClass : this.classes) {
                    warning.append("\n\t\t\t").append(conflictedClass);
                }
            }
            return String.valueOf(warning);
        }
    }
}

