/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ballerina.projects.AnyTarget;
import io.ballerina.projects.BalToolToml;
import io.ballerina.projects.BalaWriter;
import io.ballerina.projects.CompilerBackend;
import io.ballerina.projects.CompilerPluginToml;
import io.ballerina.projects.JBallerinaBackend;
import io.ballerina.projects.JarLibrary;
import io.ballerina.projects.PackageDependencyScope;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.PackageResolution;
import io.ballerina.projects.PlatformLibrary;
import io.ballerina.projects.PlatformLibraryScope;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ResolvedPackageDependency;
import io.ballerina.projects.TomlDocument;
import io.ballerina.projects.internal.bala.BalToolJson;
import io.ballerina.projects.internal.bala.CompilerPluginJson;
import io.ballerina.projects.internal.bala.adaptors.JsonCollectionsAdaptor;
import io.ballerina.projects.internal.bala.adaptors.JsonStringsAdaptor;
import io.ballerina.projects.internal.model.BalToolDescriptor;
import io.ballerina.projects.internal.model.CompilerPluginDescriptor;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.zip.ZipOutputStream;
import org.wso2.ballerinalang.compiler.util.Names;

public class JBallerinaBalaWriter
extends BalaWriter {
    public static final String TOOL = "tool";
    public static final String LIBS = "libs";
    public static final String COMPILER_PLUGIN = "compiler-plugin";
    public static final String ANNON = "annon";
    private final JBallerinaBackend backend;

    public JBallerinaBalaWriter(JBallerinaBackend backend) {
        this.backend = backend;
        this.packageContext = backend.packageContext();
        this.compilerPluginToml = this.readCompilerPluginToml();
        this.balToolToml = this.readBalToolToml();
        this.target = this.getTargetPlatform(this.packageContext.getResolution()).code();
    }

    @Override
    protected Optional<JsonArray> addPlatformLibs(ZipOutputStream balaOutputStream) throws IOException {
        JarLibrary jar;
        Collection<PlatformLibrary> jars = this.backend.platformLibraryDependencies(this.packageContext.packageId(), PlatformLibraryScope.DEFAULT);
        Collection<PlatformLibrary> providedJars = this.backend.platformLibraryDependencies(this.packageContext.packageId(), PlatformLibraryScope.PROVIDED);
        if (jars.isEmpty() && providedJars.isEmpty()) {
            return Optional.empty();
        }
        JsonArray newPlatformLibs = new JsonArray();
        for (PlatformLibrary platformLibrary : jars) {
            jar = (JarLibrary)platformLibrary;
            Path libPath = jar.path();
            String fileName = Optional.ofNullable(libPath.getFileName()).map(Path::toString).orElse(ANNON);
            Path entryPath = Path.of("platform", new String[0]).resolve(this.target).resolve(fileName);
            this.putZipEntry(balaOutputStream, entryPath, new FileInputStream(libPath.toString()));
            JsonObject newDependency = new JsonObject();
            newDependency.addProperty("path", entryPath.toString());
            if (jar.artifactId().isPresent() && jar.groupId().isPresent() && jar.version().isPresent()) {
                newDependency.addProperty("artifactId", jar.artifactId().get());
                newDependency.addProperty("groupId", jar.groupId().get());
                newDependency.addProperty("version", jar.version().get());
            }
            newPlatformLibs.add((JsonElement)newDependency);
        }
        for (PlatformLibrary platformLibrary : providedJars) {
            jar = (JarLibrary)platformLibrary;
            JsonObject newDependency = new JsonObject();
            if (jar.artifactId().isPresent() && jar.groupId().isPresent() && jar.version().isPresent()) {
                newDependency.addProperty("artifactId", jar.artifactId().get());
                newDependency.addProperty("groupId", jar.groupId().get());
                newDependency.addProperty("version", jar.version().get());
            }
            newDependency.addProperty("scope", jar.scope().getStringValue());
            newPlatformLibs.add((JsonElement)newDependency);
        }
        return Optional.of(newPlatformLibs);
    }

    @Override
    protected void addCompilerPlugin(ZipOutputStream balaOutputStream) throws IOException {
        if (this.compilerPluginToml.isPresent()) {
            ArrayList<String> compilerPluginLibPaths = new ArrayList<String>();
            List<String> compilerPluginDependencies = ((CompilerPluginDescriptor)this.compilerPluginToml.get()).getCompilerPluginDependencies();
            if (compilerPluginDependencies.isEmpty()) {
                throw new ProjectException("No dependencies found in CompilerPlugin.toml file");
            }
            for (String compilerPluginLib : compilerPluginDependencies) {
                Path libPath = this.packageContext.project().sourceRoot().resolve(compilerPluginLib);
                String fileName = Optional.ofNullable(libPath.getFileName()).map(Path::toString).orElse(ANNON);
                Path entryPath = Path.of(COMPILER_PLUGIN, new String[0]).resolve(LIBS).resolve(fileName);
                this.putZipEntry(balaOutputStream, entryPath, new FileInputStream(libPath.toString()));
                compilerPluginLibPaths.add(entryPath.toString());
            }
            CompilerPluginJson compilerPluginJson = new CompilerPluginJson(((CompilerPluginDescriptor)this.compilerPluginToml.get()).plugin().getId(), ((CompilerPluginDescriptor)this.compilerPluginToml.get()).plugin().getClassName(), compilerPluginLibPaths);
            Gson gson = new GsonBuilder().registerTypeHierarchyAdapter(Collection.class, (Object)new JsonCollectionsAdaptor()).registerTypeHierarchyAdapter(String.class, (Object)new JsonStringsAdaptor()).setPrettyPrinting().create();
            try {
                this.putZipEntry(balaOutputStream, Path.of(COMPILER_PLUGIN, "compiler-plugin.json"), new ByteArrayInputStream(gson.toJson((Object)compilerPluginJson).getBytes(Charset.defaultCharset())));
            }
            catch (IOException e) {
                throw new ProjectException("Failed to write 'compiler-plugin.json' file: " + e.getMessage(), e);
            }
        }
    }

    @Override
    protected void addBalTool(ZipOutputStream balaOutputStream) throws IOException {
        if (this.balToolToml.isPresent()) {
            ArrayList<String> balToolLibPaths = new ArrayList<String>();
            List<String> balToolDependencies = ((BalToolDescriptor)this.balToolToml.get()).getBalToolDependencies();
            if (balToolDependencies.isEmpty()) {
                throw new ProjectException("No dependencies found in BalTool.toml file");
            }
            for (String balToolLib : balToolDependencies) {
                Path libPath = this.packageContext.project().sourceRoot().resolve(balToolLib);
                String fileName = Optional.ofNullable(libPath.getFileName()).map(Path::toString).orElse(ANNON);
                Path entryPath = Path.of(TOOL, new String[0]).resolve(LIBS).resolve(fileName);
                this.putZipEntry(balaOutputStream, entryPath, new FileInputStream(libPath.toString()));
                balToolLibPaths.add(entryPath.toString());
            }
            BalToolJson balToolJson = new BalToolJson(((BalToolDescriptor)this.balToolToml.get()).tool().getId(), balToolLibPaths);
            Gson gson = new GsonBuilder().registerTypeHierarchyAdapter(Collection.class, (Object)new JsonCollectionsAdaptor()).registerTypeHierarchyAdapter(String.class, (Object)new JsonStringsAdaptor()).setPrettyPrinting().create();
            try {
                this.putZipEntry(balaOutputStream, Path.of(TOOL, "bal-tool.json"), new ByteArrayInputStream(gson.toJson((Object)balToolJson).getBytes(Charset.defaultCharset())));
            }
            catch (IOException e) {
                throw new ProjectException("Failed to write 'bal-tool.json' file: " + e.getMessage(), e);
            }
        }
    }

    private CompilerBackend.TargetPlatform getTargetPlatform(PackageResolution pkgResolution) {
        ResolvedPackageDependency resolvedPackageDependency = new ResolvedPackageDependency(this.packageContext.project().currentPackage(), PackageDependencyScope.DEFAULT);
        Collection<ResolvedPackageDependency> resolvedPackageDependencies = pkgResolution.dependencyGraph().getDirectDependencies(resolvedPackageDependency);
        for (ResolvedPackageDependency dependency : resolvedPackageDependencies) {
            if (!dependency.packageInstance().packageOrg().value().equals(Names.BALLERINA_ORG.value) || !dependency.packageInstance().packageName().value().equals(Names.JAVA.value) || dependency.scope().equals((Object)PackageDependencyScope.TEST_ONLY)) continue;
            return this.backend.targetPlatform();
        }
        PackageManifest manifest = this.packageContext.project().currentPackage().manifest();
        if (this.hasPlatformDependencies(manifest.platforms())) {
            return this.backend.targetPlatform();
        }
        if (this.balToolToml.isPresent() || this.compilerPluginToml.isPresent()) {
            return this.backend.targetPlatform();
        }
        return AnyTarget.ANY;
    }

    private boolean hasPlatformDependencies(Map<String, PackageManifest.Platform> platforms) {
        for (PackageManifest.Platform value : platforms.values()) {
            if (value.dependencies().isEmpty() || this.isPlatformDependenciesTestOnly(value.dependencies())) continue;
            return true;
        }
        return false;
    }

    private Optional<CompilerPluginDescriptor> readCompilerPluginToml() {
        Optional<CompilerPluginToml> compilerPluginToml = this.backend.packageContext().project().currentPackage().compilerPluginToml();
        if (compilerPluginToml.isPresent()) {
            TomlDocument tomlDocument = compilerPluginToml.get().compilerPluginTomlContext().tomlDocument();
            return Optional.of(CompilerPluginDescriptor.from(tomlDocument));
        }
        return Optional.empty();
    }

    private Optional<BalToolDescriptor> readBalToolToml() {
        Optional<BalToolToml> balToolToml = this.backend.packageContext().project().currentPackage().balToolToml();
        if (balToolToml.isPresent()) {
            TomlDocument tomlDocument = balToolToml.get().balToolTomlContext().tomlDocument();
            Path sourceRoot = this.packageContext.project().sourceRoot();
            return Optional.of(BalToolDescriptor.from(tomlDocument, sourceRoot));
        }
        return Optional.empty();
    }

    private boolean isPlatformDependenciesTestOnly(List<Map<String, Object>> dependencies) {
        for (Map<String, Object> dependency : dependencies) {
            if (Objects.equals(PlatformLibraryScope.TEST_ONLY.getStringValue(), dependency.get("scope"))) continue;
            return false;
        }
        return true;
    }
}

