/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.PlatformLibrary;
import io.ballerina.projects.PlatformLibraryScope;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;

public class JarLibrary
extends PlatformLibrary {
    static final String KEY_PATH = "path";
    static final String KEY_SCOPE = "scope";
    static final String KEY_ARTIFACT_ID = "artifactId";
    static final String KEY_GROUP_ID = "groupId";
    static final String KEY_VERSION = "version";
    private final String artifactId;
    private final String version;
    private final String groupId;
    private final Path path;
    private final String packageName;

    public JarLibrary(Path path, PlatformLibraryScope scope) {
        super(scope);
        this.path = path;
        this.artifactId = null;
        this.groupId = null;
        this.version = null;
        this.packageName = null;
    }

    public JarLibrary(Path path, PlatformLibraryScope scope, String artifactId, String groupId, String version, String packageName) {
        super(scope);
        this.path = path;
        this.packageName = packageName == null || packageName.isEmpty() ? null : packageName;
        this.artifactId = artifactId == null || artifactId.isEmpty() ? null : artifactId;
        this.groupId = groupId == null || groupId.isEmpty() ? null : groupId;
        this.version = version == null || version.isEmpty() ? null : version;
    }

    public JarLibrary(Path path, PlatformLibraryScope scope, String packageName) {
        super(scope);
        this.path = path;
        this.packageName = packageName == null || packageName.isEmpty() ? null : packageName;
        this.artifactId = null;
        this.groupId = null;
        this.version = null;
    }

    @Override
    public Path path() {
        return this.path;
    }

    public Optional<String> packageName() {
        return Optional.ofNullable(this.packageName);
    }

    public Optional<String> artifactId() {
        return Optional.ofNullable(this.artifactId);
    }

    public Optional<String> version() {
        return Optional.ofNullable(this.version);
    }

    public Optional<String> groupId() {
        return Optional.ofNullable(this.groupId);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        JarLibrary that = (JarLibrary)other;
        if (this.groupId == null || this.artifactId == null || this.version == null) {
            return Optional.of(this.path().getFileName()).get().equals(Optional.of(that.path().getFileName()).get());
        }
        if (that.groupId == null || that.artifactId == null || that.version == null) {
            return Optional.of(this.path().getFileName()).get().equals(Optional.of(that.path().getFileName()).get());
        }
        return this.groupId.equals(that.groupId) && this.artifactId.equals(that.artifactId);
    }

    public int hashCode() {
        return Objects.hash(this.artifactId);
    }
}

