/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.CompilationOptions;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentConfig;
import io.ballerina.projects.DocumentContext;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.MdDocumentContext;
import io.ballerina.projects.ModuleCompilation;
import io.ballerina.projects.ModuleContext;
import io.ballerina.projects.ModuleDependency;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.ModuleMd;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.ModuleReadmeMd;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import io.ballerina.projects.Resource;
import io.ballerina.projects.ResourceConfig;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Module {
    private final ModuleContext moduleContext;
    private final Package packageInstance;
    private final Map<DocumentId, Document> srcDocs;
    private final Map<DocumentId, Document> testSrcDocs;
    private final Function<DocumentId, Document> populateDocumentFunc;
    private Optional<ModuleMd> moduleMd = Optional.empty();
    private ModuleReadmeMd readmeMd = null;

    Module(ModuleContext moduleContext, Package packageInstance) {
        this.moduleContext = moduleContext;
        this.packageInstance = packageInstance;
        this.srcDocs = new ConcurrentHashMap<DocumentId, Document>();
        this.testSrcDocs = new ConcurrentHashMap<DocumentId, Document>();
        this.populateDocumentFunc = documentId -> new Document(this.moduleContext.documentContext((DocumentId)documentId), this);
    }

    static Module from(ModuleContext moduleContext, Package packageInstance) {
        return new Module(moduleContext, packageInstance);
    }

    public Package packageInstance() {
        return this.packageInstance;
    }

    public ModuleId moduleId() {
        return this.moduleContext.moduleId();
    }

    public ModuleName moduleName() {
        return this.moduleContext.moduleName();
    }

    public ModuleDescriptor descriptor() {
        return this.moduleContext.descriptor();
    }

    public Collection<DocumentId> documentIds() {
        return this.moduleContext.srcDocumentIds();
    }

    public Collection<DocumentId> testDocumentIds() {
        return this.moduleContext.testSrcDocumentIds();
    }

    @Deprecated(since="2201.10.0", forRemoval=true)
    public Collection<DocumentId> resourceIds() {
        return this.moduleContext.project().currentPackage().resourceIds();
    }

    @Deprecated(since="2201.10.0", forRemoval=true)
    public Collection<DocumentId> testResourceIds() {
        return this.moduleContext.project().currentPackage().getDefaultModule().testResourceIds();
    }

    public Document document(DocumentId documentId) {
        if (this.documentIds().contains(documentId)) {
            return this.srcDocs.computeIfAbsent(documentId, this.populateDocumentFunc);
        }
        return this.testSrcDocs.computeIfAbsent(documentId, this.populateDocumentFunc);
    }

    @Deprecated(since="2201.10.0", forRemoval=true)
    public Resource resource(DocumentId documentId) {
        return this.packageInstance.resource(documentId);
    }

    public ModuleCompilation getCompilation() {
        return this.packageInstance.packageContext().getModuleCompilation(this.moduleContext);
    }

    public Collection<ModuleDependency> moduleDependencies() {
        return this.moduleContext.dependencies();
    }

    public boolean isDefaultModule() {
        return this.moduleContext.isDefaultModule();
    }

    public Project project() {
        return this.moduleContext.project();
    }

    public Modifier modify() {
        return new Modifier(this);
    }

    @Deprecated(forRemoval=true)
    ModuleContext moduleContext() {
        return this.moduleContext;
    }

    @Deprecated(forRemoval=true, since="2.11.0")
    public Optional<ModuleMd> moduleMd() {
        if (null == this.moduleMd) {
            this.moduleMd = this.moduleContext.moduleMdContext().map(c -> ModuleMd.from(c, this));
        }
        return this.moduleMd;
    }

    public Optional<ModuleReadmeMd> readmeMd() {
        if (null == this.readmeMd) {
            this.readmeMd = this.moduleContext.readmeMdContext().map(c -> ModuleReadmeMd.from(c, this)).orElse(null);
        }
        return Optional.ofNullable(this.readmeMd);
    }

    public static class Modifier {
        private final ModuleId moduleId;
        private final ModuleDescriptor moduleDescriptor;
        private Map<DocumentId, DocumentContext> srcDocContextMap;
        private Map<DocumentId, DocumentContext> testDocContextMap;
        private final boolean isDefaultModule;
        private final List<ModuleDescriptor> dependencies;
        private final Package packageInstance;
        private final Project project;
        private MdDocumentContext moduleMdContext;

        private Modifier(Module oldModule) {
            this.moduleId = oldModule.moduleId();
            this.moduleDescriptor = oldModule.descriptor();
            this.srcDocContextMap = this.copySrcDocs(oldModule, oldModule.moduleContext.srcDocumentIds());
            this.testDocContextMap = this.copySrcDocs(oldModule, oldModule.moduleContext.testSrcDocumentIds());
            this.isDefaultModule = oldModule.isDefaultModule();
            this.dependencies = oldModule.moduleContext().moduleDescDependencies();
            this.packageInstance = oldModule.packageInstance;
            this.project = oldModule.project();
            this.moduleMdContext = oldModule.moduleContext.readmeMdContext().orElse(null);
        }

        Modifier updateDocument(DocumentContext newDocContext) {
            if (this.srcDocContextMap.containsKey(newDocContext.documentId())) {
                this.srcDocContextMap.put(newDocContext.documentId(), newDocContext);
            } else {
                this.testDocContextMap.put(newDocContext.documentId(), newDocContext);
            }
            return this;
        }

        @Deprecated(since="2201.10.0", forRemoval=true)
        public Modifier addResource(ResourceConfig resourceConfig) {
            return this;
        }

        @Deprecated(since="2201.10.0", forRemoval=true)
        public Modifier addTestResource(ResourceConfig resourceConfig) {
            return this;
        }

        @Deprecated(since="2201.10.0", forRemoval=true)
        public Modifier removeResource(DocumentId documentId) {
            return this;
        }

        public Modifier addDocument(DocumentConfig documentConfig) {
            DocumentContext newDocumentContext = DocumentContext.from(documentConfig, false);
            this.srcDocContextMap.put(newDocumentContext.documentId(), newDocumentContext);
            this.srcDocContextMap = this.sortDocuments(this.srcDocContextMap);
            return this;
        }

        public Modifier addTestDocument(DocumentConfig documentConfig) {
            DocumentContext newDocumentContext = DocumentContext.from(documentConfig, false);
            this.testDocContextMap.put(newDocumentContext.documentId(), newDocumentContext);
            this.testDocContextMap = this.sortDocuments(this.testDocContextMap);
            return this;
        }

        public Modifier removeDocument(DocumentId documentId) {
            if (this.srcDocContextMap.containsKey(documentId)) {
                this.srcDocContextMap.remove(documentId);
            } else {
                this.testDocContextMap.remove(documentId);
            }
            return this;
        }

        public Modifier removeModuleMd() {
            this.moduleMdContext = null;
            return this;
        }

        public Module apply() {
            return this.createNewModule(this.srcDocContextMap, this.testDocContextMap);
        }

        private Map<DocumentId, DocumentContext> copySrcDocs(Module oldModule, Collection<DocumentId> documentIds) {
            LinkedHashMap<DocumentId, DocumentContext> srcDocContextMap = new LinkedHashMap<DocumentId, DocumentContext>();
            for (DocumentId documentId : documentIds) {
                srcDocContextMap.put(documentId, oldModule.moduleContext.documentContext(documentId));
            }
            return srcDocContextMap;
        }

        private Module createNewModule(Map<DocumentId, DocumentContext> srcDocContextMap, Map<DocumentId, DocumentContext> testDocContextMap) {
            HashSet<ModuleContext> moduleContextSet = new HashSet<ModuleContext>();
            ModuleContext newModuleContext = new ModuleContext(this.project, this.moduleId, this.moduleDescriptor, this.isDefaultModule, srcDocContextMap, testDocContextMap, this.moduleMdContext, this.dependencies);
            moduleContextSet.add(newModuleContext);
            Collection<ModuleDescriptor> dependants = this.getAllDependants(this.moduleDescriptor);
            for (ModuleDescriptor dependentDescriptor : dependants) {
                if (dependentDescriptor.equals(this.moduleDescriptor)) continue;
                Modifier module = this.packageInstance.module(dependentDescriptor.name()).modify();
                moduleContextSet.add(new ModuleContext(this.project, module.moduleId, dependentDescriptor, module.isDefaultModule, module.srcDocContextMap, module.testDocContextMap, module.moduleMdContext, module.dependencies));
            }
            Package newPackage = this.packageInstance.modify().updateModules(moduleContextSet).apply();
            return newPackage.module(this.moduleId);
        }

        Modifier updateModuleMd(MdDocumentContext moduleMd) {
            this.moduleMdContext = moduleMd;
            return this;
        }

        private Collection<ModuleDescriptor> getAllDependants(ModuleDescriptor updatedModuleDescriptor) {
            CompilationOptions offlineCompOptions = CompilationOptions.builder().setOffline(true).build();
            offlineCompOptions = offlineCompOptions.acceptTheirs(this.project.currentPackage().compilationOptions());
            this.packageInstance.packageContext().getResolution(offlineCompOptions, true);
            return this.getAllDependants(updatedModuleDescriptor, new HashSet<ModuleDescriptor>(), new HashSet<ModuleDescriptor>());
        }

        private Collection<ModuleDescriptor> getAllDependants(ModuleDescriptor updatedModuleDescriptor, HashSet<ModuleDescriptor> visited, HashSet<ModuleDescriptor> dependants) {
            if (!visited.contains(updatedModuleDescriptor)) {
                visited.add(updatedModuleDescriptor);
                Collection<ModuleDescriptor> directDependents = this.project.currentPackage().moduleDependencyGraph().getDirectDependents(updatedModuleDescriptor);
                if (!directDependents.isEmpty()) {
                    dependants.addAll(directDependents);
                    for (ModuleDescriptor directDependent : directDependents) {
                        this.getAllDependants(directDependent, visited, dependants);
                    }
                }
            }
            return dependants;
        }

        private Map<DocumentId, DocumentContext> sortDocuments(Map<DocumentId, DocumentContext> docContextMap) {
            return docContextMap.entrySet().stream().sorted(Comparator.comparing(entry -> ((DocumentContext)entry.getValue()).name())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        }
    }

    private static class DocumentIterable
    implements Iterable<Document> {
        private final Collection<Document> documentList;

        public DocumentIterable(Collection<Document> documentList) {
            this.documentList = documentList;
        }

        @Override
        public Iterator<Document> iterator() {
            return this.documentList.iterator();
        }

        @Override
        public Spliterator<Document> spliterator() {
            return this.documentList.spliterator();
        }
    }
}

