/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.CompilationCache;
import io.ballerina.projects.CompilerBackend;
import io.ballerina.projects.ModuleContext;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.PackageContext;
import io.ballerina.projects.PackageId;
import io.ballerina.projects.PlatformLibrary;
import io.ballerina.projects.PlatformLibraryScope;
import io.ballerina.projects.environment.ProjectEnvironment;
import io.ballerina.projects.internal.DefaultDiagnosticResult;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.ArrayList;
import java.util.Collection;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class NullBackend
extends CompilerBackend {
    private final PackageContext packageContext;
    private final CompilerContext compilerContext;
    private DefaultDiagnosticResult diagnosticResult;

    private NullBackend(PackageCompilation compilation) {
        this.packageContext = compilation.packageContext();
        ProjectEnvironment projectEnvContext = this.packageContext.project().projectEnvironmentContext();
        this.compilerContext = projectEnvContext.getService(CompilerContext.class);
    }

    public static NullBackend from(PackageCompilation compilation) {
        NullBackend nullBackend = new NullBackend(compilation);
        NullBackend.performBIRGen(compilation, nullBackend);
        return nullBackend;
    }

    private static void performBIRGen(PackageCompilation compilation, NullBackend nullBackend) {
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        for (ModuleContext moduleContext : compilation.getResolution().topologicallySortedModuleList()) {
            moduleContext.generatePlatformSpecificCode(nullBackend.compilerContext, nullBackend);
            diagnostics.addAll(moduleContext.diagnostics());
        }
        nullBackend.diagnosticResult = new DefaultDiagnosticResult(diagnostics);
    }

    @Override
    public Collection<PlatformLibrary> platformLibraryDependencies(PackageId packageId) {
        return null;
    }

    @Override
    public Collection<PlatformLibrary> platformLibraryDependencies(PackageId packageId, PlatformLibraryScope scope) {
        return null;
    }

    @Override
    public PlatformLibrary codeGeneratedLibrary(PackageId packageId, ModuleName moduleName) {
        return null;
    }

    @Override
    public PlatformLibrary codeGeneratedTestLibrary(PackageId packageId, ModuleName moduleName) {
        return null;
    }

    @Override
    public PlatformLibrary codeGeneratedResourcesLibrary(PackageId packageId) {
        return null;
    }

    @Override
    public PlatformLibrary runtimeLibrary() {
        return null;
    }

    @Override
    public CompilerBackend.TargetPlatform targetPlatform() {
        return null;
    }

    @Override
    public void performCodeGen(ModuleContext moduleContext, CompilationCache compilationCache) {
    }

    @Override
    public String libraryFileExtension() {
        return null;
    }

    public boolean hasErrors() {
        if (this.diagnosticResult != null) {
            return this.diagnosticResult.hasErrors();
        }
        return true;
    }
}

