/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.BalToolToml;
import io.ballerina.projects.BallerinaToml;
import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.BuildToolResolution;
import io.ballerina.projects.CloudToml;
import io.ballerina.projects.CodeGeneratorManager;
import io.ballerina.projects.CodeGeneratorResult;
import io.ballerina.projects.CodeModifierManager;
import io.ballerina.projects.CodeModifierResult;
import io.ballerina.projects.CompilationOptions;
import io.ballerina.projects.CompilerPluginManager;
import io.ballerina.projects.CompilerPluginToml;
import io.ballerina.projects.DependenciesToml;
import io.ballerina.projects.DependencyGraph;
import io.ballerina.projects.DependencyManifest;
import io.ballerina.projects.DiagnosticResult;
import io.ballerina.projects.DocumentConfig;
import io.ballerina.projects.DocumentContext;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.MdDocumentContext;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleConfig;
import io.ballerina.projects.ModuleContext;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.PackageConfig;
import io.ballerina.projects.PackageContext;
import io.ballerina.projects.PackageDependency;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageId;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.PackageMd;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageReadmeMd;
import io.ballerina.projects.PackageResolution;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.Project;
import io.ballerina.projects.ResolvedPackageDependency;
import io.ballerina.projects.Resource;
import io.ballerina.projects.ResourceConfig;
import io.ballerina.projects.ResourceContext;
import io.ballerina.projects.TomlDocumentContext;
import io.ballerina.projects.environment.PackageCache;
import io.ballerina.projects.environment.ResolutionOptions;
import io.ballerina.projects.internal.DefaultDiagnosticResult;
import io.ballerina.projects.internal.DependencyManifestBuilder;
import io.ballerina.projects.internal.ManifestBuilder;
import io.ballerina.projects.internal.model.CompilerPluginDescriptor;
import io.ballerina.projects.util.ProjectUtils;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class Package {
    private final Project project;
    private final PackageContext packageContext;
    private final Map<ModuleId, Module> moduleMap;
    private final Function<ModuleId, Module> populateModuleFunc;
    private Optional<PackageMd> packageMd = Optional.empty();
    private Optional<PackageReadmeMd> readmeMd = Optional.empty();
    private Optional<BallerinaToml> ballerinaToml = Optional.empty();
    private Optional<DependenciesToml> dependenciesToml = Optional.empty();
    private Optional<CloudToml> cloudToml = Optional.empty();
    private Optional<CompilerPluginToml> compilerPluginToml = Optional.empty();
    private Optional<BalToolToml> balToolToml = Optional.empty();
    private final Map<DocumentId, Resource> resources;
    private final Map<DocumentId, Resource> testResources;
    private final Function<DocumentId, Resource> populateResourceFunc;

    private Package(PackageContext packageContext, Project project) {
        this.packageContext = packageContext;
        this.project = project;
        this.moduleMap = new ConcurrentHashMap<ModuleId, Module>();
        this.populateModuleFunc = moduleId -> Module.from(this.packageContext.moduleContext((ModuleId)moduleId), this);
        this.resources = new ConcurrentHashMap<DocumentId, Resource>();
        this.testResources = new ConcurrentHashMap<DocumentId, Resource>();
        this.populateResourceFunc = documentId -> new Resource(this.packageContext.resourceContext((DocumentId)documentId), this);
    }

    static Package from(Project project, PackageConfig packageConfig, CompilationOptions compilationOptions) {
        PackageContext packageContext = PackageContext.from(project, packageConfig, compilationOptions);
        return new Package(packageContext, project);
    }

    PackageContext packageContext() {
        return this.packageContext;
    }

    public Project project() {
        return this.project;
    }

    public PackageId packageId() {
        return this.packageContext.packageId();
    }

    public PackageName packageName() {
        return this.packageContext.packageName();
    }

    public PackageOrg packageOrg() {
        return this.packageContext.packageOrg();
    }

    public PackageVersion packageVersion() {
        return this.packageContext.packageVersion();
    }

    public PackageDescriptor descriptor() {
        return this.packageContext.descriptor();
    }

    public Optional<CompilerPluginDescriptor> compilerPluginDescriptor() {
        return this.packageContext.compilerPluginDescriptor();
    }

    public PackageManifest manifest() {
        return this.packageContext.packageManifest();
    }

    public DependencyManifest dependencyManifest() {
        return this.packageContext.dependencyManifest();
    }

    public Collection<ModuleId> moduleIds() {
        return this.packageContext.moduleIds();
    }

    public Iterable<Module> modules() {
        ArrayList<Module> moduleList = new ArrayList<Module>();
        for (ModuleId moduleId : this.packageContext.moduleIds()) {
            moduleList.add(this.module(moduleId));
        }
        return new ModuleIterable(moduleList);
    }

    public Module module(ModuleId moduleId) {
        return this.moduleMap.computeIfAbsent(moduleId, this.populateModuleFunc);
    }

    public Module module(ModuleName moduleName) {
        for (Module module : this.moduleMap.values()) {
            if (!module.moduleName().equals(moduleName)) continue;
            return module;
        }
        ModuleContext moduleContext = this.packageContext.moduleContext(moduleName);
        if (moduleContext != null) {
            return this.module(moduleContext.moduleId());
        }
        return null;
    }

    public boolean containsModule(ModuleId moduleId) {
        return this.moduleMap.containsKey(moduleId);
    }

    public Module getDefaultModule() {
        return this.module(this.packageContext.defaultModuleContext().moduleId());
    }

    public PackageCompilation getCompilation() {
        return this.packageContext.getPackageCompilation();
    }

    PackageCompilation getCompilation(CompilationOptions compilationOptions) {
        return this.packageContext.getPackageCompilation(compilationOptions);
    }

    public PackageResolution getResolution() {
        return this.packageContext.getResolution();
    }

    public BuildToolResolution getBuildToolResolution() {
        return this.packageContext.getBuildToolResolution();
    }

    public PackageResolution getResolution(CompilationOptions compilationOptions) {
        return this.packageContext.getResolution(compilationOptions);
    }

    public DependencyGraph<ModuleDescriptor> moduleDependencyGraph() {
        return this.packageContext.moduleDependencyGraph();
    }

    public Collection<PackageDependency> packageDependencies() {
        return this.packageContext.packageDependencies();
    }

    public CompilationOptions compilationOptions() {
        return this.packageContext.compilationOptions();
    }

    public Optional<BallerinaToml> ballerinaToml() {
        if (this.ballerinaToml.isEmpty()) {
            this.ballerinaToml = this.packageContext.ballerinaTomlContext().map(c -> BallerinaToml.from(c, this));
        }
        return this.ballerinaToml;
    }

    public Optional<DependenciesToml> dependenciesToml() {
        if (this.dependenciesToml.isEmpty()) {
            this.dependenciesToml = this.packageContext.dependenciesTomlContext().map(c -> DependenciesToml.from(c, this));
        }
        return this.dependenciesToml;
    }

    public Optional<CloudToml> cloudToml() {
        if (this.cloudToml.isEmpty()) {
            this.cloudToml = this.packageContext.cloudTomlContext().map(c -> CloudToml.from(c, this));
        }
        return this.cloudToml;
    }

    public Optional<CompilerPluginToml> compilerPluginToml() {
        if (this.compilerPluginToml.isEmpty()) {
            this.compilerPluginToml = this.packageContext.compilerPluginTomlContext().map(c -> CompilerPluginToml.from(c, this));
        }
        return this.compilerPluginToml;
    }

    public Optional<BalToolToml> balToolToml() {
        if (this.balToolToml.isEmpty()) {
            this.balToolToml = this.packageContext.balToolTomlContext().map(c -> BalToolToml.from(c, this));
        }
        return this.balToolToml;
    }

    @Deprecated(forRemoval=true, since="2.11.0")
    public Optional<PackageMd> packageMd() {
        if (this.packageMd.isEmpty()) {
            this.packageMd = this.packageContext.packageMdContext().map(c -> PackageMd.from(c, this));
        }
        return this.packageMd;
    }

    public Optional<PackageReadmeMd> readmeMd() {
        if (this.readmeMd.isEmpty()) {
            this.readmeMd = this.packageContext.readmeMdContext().map(c -> PackageReadmeMd.from(c, this));
        }
        return this.readmeMd;
    }

    public Collection<DocumentId> resourceIds() {
        return this.packageContext.resourceIds();
    }

    public Collection<DocumentId> testResourceIds() {
        return this.packageContext.testResourceIds();
    }

    public Resource resource(DocumentId documentId) {
        if (this.resourceIds().contains(documentId)) {
            return this.resources.computeIfAbsent(documentId, this.populateResourceFunc);
        }
        return this.testResources.computeIfAbsent(documentId, this.populateResourceFunc);
    }

    Package duplicate(Project project) {
        return new Package(this.packageContext.duplicate(project), project);
    }

    public DiagnosticResult runCodeGenAndModifyPlugins() {
        CompilerPluginManager compilerPluginManager;
        Package pkg = this;
        PackageCompilation cachedCompilation = this.packageContext.cachedCompilation();
        if (cachedCompilation != null && (compilerPluginManager = cachedCompilation.compilerPluginManager()).engagedCodeGeneratorCount() == 0 && compilerPluginManager.engagedCodeModifierCount() == 0) {
            return new DefaultDiagnosticResult(Collections.emptyList());
        }
        CompilationOptions compOptions = CompilationOptions.builder().withCodeGenerators(true).withCodeModifiers(true).build();
        CompilerPluginManager compilerPluginManager2 = this.getCompilation(compOptions).compilerPluginManager();
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        if (compilerPluginManager2.engagedCodeGeneratorCount() > 0) {
            CodeGeneratorManager codeGeneratorManager = compilerPluginManager2.getCodeGeneratorManager();
            CodeGeneratorResult codeGeneratorResult = codeGeneratorManager.runCodeGenerators(pkg);
            diagnostics.addAll(codeGeneratorResult.reportedDiagnostics().allDiagnostics);
            if (codeGeneratorResult.updatedPackage().isPresent()) {
                pkg = codeGeneratorResult.updatedPackage().get();
            }
        }
        if (compilerPluginManager2.engagedCodeModifierCount() > 0) {
            compilerPluginManager2 = pkg.getCompilation(compOptions).compilerPluginManager();
            CodeModifierManager codeModifierManager = compilerPluginManager2.getCodeModifierManager();
            CodeModifierResult codeModifierResult = codeModifierManager.runCodeModifiers(pkg);
            diagnostics.addAll(codeModifierResult.reportedDiagnostics().allDiagnostics);
        }
        return new DefaultDiagnosticResult(diagnostics);
    }

    public CodeGeneratorResult runCodeGeneratorPlugins() {
        CompilerPluginManager compilerPluginManager;
        PackageCompilation cachedCompilation = this.packageContext.cachedCompilation();
        if (cachedCompilation != null && (compilerPluginManager = cachedCompilation.compilerPluginManager()).engagedCodeGeneratorCount() == 0) {
            return new CodeGeneratorResult(null, Collections.emptyList());
        }
        CompilationOptions compOptions = CompilationOptions.builder().withCodeGenerators(true).build();
        CompilerPluginManager compilerPluginManager2 = this.getCompilation(compOptions).compilerPluginManager();
        if (compilerPluginManager2.engagedCodeGeneratorCount() == 0) {
            return new CodeGeneratorResult(null, Collections.emptyList());
        }
        CodeGeneratorManager codeGeneratorManager = compilerPluginManager2.getCodeGeneratorManager();
        return codeGeneratorManager.runCodeGenerators(this);
    }

    public CodeModifierResult runCodeModifierPlugins() {
        CompilerPluginManager compilerPluginManager;
        PackageCompilation cachedCompilation = this.packageContext.cachedCompilation();
        if (cachedCompilation != null && (compilerPluginManager = cachedCompilation.compilerPluginManager()).engagedCodeModifierCount() == 0) {
            return new CodeModifierResult(null, Collections.emptyList());
        }
        CompilationOptions compOptions = CompilationOptions.builder().withCodeModifiers(true).build();
        CompilerPluginManager compilerPluginManager2 = this.getCompilation(compOptions).compilerPluginManager();
        if (compilerPluginManager2.engagedCodeModifierCount() == 0) {
            return new CodeModifierResult(null, Collections.emptyList());
        }
        CodeModifierManager codeModifierManager = compilerPluginManager2.getCodeModifierManager();
        return codeModifierManager.runCodeModifiers(this);
    }

    public Modifier modify() {
        return new Modifier(this);
    }

    public PackageResolution getResolution(ResolutionOptions resolutionOptions) {
        boolean offline = resolutionOptions.offline();
        boolean sticky = resolutionOptions.sticky();
        CompilationOptions newCompOptions = CompilationOptions.builder().setOffline(offline).setSticky(sticky).build();
        newCompOptions = newCompOptions.acceptTheirs(this.project.currentPackage().compilationOptions());
        return this.packageContext.getResolution(newCompOptions, true);
    }

    private static class ModuleIterable
    implements Iterable<Module> {
        private final Collection<Module> moduleList;

        public ModuleIterable(Collection<Module> moduleList) {
            this.moduleList = moduleList;
        }

        @Override
        public Iterator<Module> iterator() {
            return this.moduleList.iterator();
        }

        @Override
        public Spliterator<Module> spliterator() {
            return this.moduleList.spliterator();
        }
    }

    public static class Modifier {
        private final PackageId packageId;
        private PackageManifest packageManifest;
        private DependencyManifest dependencyManifest;
        private final Map<ModuleId, ModuleContext> moduleContextMap;
        private final Project project;
        private final DependencyGraph<ResolvedPackageDependency> dependencyGraph;
        private final CompilationOptions compilationOptions;
        private TomlDocumentContext ballerinaTomlContext;
        private TomlDocumentContext dependenciesTomlContext;
        private TomlDocumentContext cloudTomlContext;
        private TomlDocumentContext compilerPluginTomlContext;
        private TomlDocumentContext balToolTomlContext;
        private MdDocumentContext readmeMdContext;
        private final Map<DocumentId, ResourceContext> resourceContextMap;
        private final Map<DocumentId, ResourceContext> testResourceContextMap;

        public Modifier(Package oldPackage) {
            this.packageId = oldPackage.packageId();
            this.packageManifest = oldPackage.manifest();
            this.dependencyManifest = oldPackage.dependencyManifest();
            this.moduleContextMap = this.copyModules(oldPackage);
            this.project = oldPackage.project;
            this.dependencyGraph = oldPackage.getResolution().dependencyGraph();
            this.compilationOptions = oldPackage.compilationOptions();
            this.ballerinaTomlContext = oldPackage.packageContext.ballerinaTomlContext().orElse(null);
            this.dependenciesTomlContext = oldPackage.packageContext.dependenciesTomlContext().orElse(null);
            this.cloudTomlContext = oldPackage.packageContext.cloudTomlContext().orElse(null);
            this.compilerPluginTomlContext = oldPackage.packageContext.compilerPluginTomlContext().orElse(null);
            this.balToolTomlContext = oldPackage.packageContext.balToolTomlContext().orElse(null);
            this.readmeMdContext = oldPackage.packageContext.readmeMdContext().orElse(null);
            this.resourceContextMap = this.copyResources(oldPackage, oldPackage.packageContext.resourceIds());
            this.testResourceContextMap = this.copyResources(oldPackage, oldPackage.packageContext.testResourceIds());
        }

        Modifier updateModules(Set<ModuleContext> newModuleContexts) {
            for (ModuleContext newModuleContext : newModuleContexts) {
                this.moduleContextMap.put(newModuleContext.moduleId(), newModuleContext);
            }
            return this;
        }

        public Modifier addModule(ModuleConfig moduleConfig) {
            ModuleContext newModuleContext = ModuleContext.from(this.project, moduleConfig, false);
            this.moduleContextMap.put(newModuleContext.moduleId(), newModuleContext);
            return this;
        }

        public Modifier addDependenciesToml(DocumentConfig documentConfig) {
            this.dependenciesTomlContext = TomlDocumentContext.from(documentConfig);
            this.updateDependencyManifest();
            return this;
        }

        public Modifier removeDependenciesToml() {
            this.dependenciesTomlContext = null;
            return this;
        }

        public Modifier addCloudToml(DocumentConfig documentConfig) {
            this.cloudTomlContext = TomlDocumentContext.from(documentConfig);
            this.updatePackageManifest();
            return this;
        }

        public Modifier removeCloudToml() {
            this.cloudTomlContext = null;
            return this;
        }

        public Modifier addCompilerPluginToml(DocumentConfig documentConfig) {
            this.compilerPluginTomlContext = TomlDocumentContext.from(documentConfig);
            this.updatePackageManifest();
            return this;
        }

        public Modifier addBalToolToml(DocumentConfig documentConfig) {
            this.balToolTomlContext = TomlDocumentContext.from(documentConfig);
            this.updatePackageManifest();
            return this;
        }

        public Modifier removeCompilerPluginToml() {
            this.compilerPluginTomlContext = null;
            return this;
        }

        public Modifier removeBalToolToml() {
            this.balToolTomlContext = null;
            return this;
        }

        public Modifier addPackageMd(DocumentConfig documentConfig) {
            this.readmeMdContext = MdDocumentContext.from(documentConfig);
            return this;
        }

        public Modifier removePackageMd() {
            this.readmeMdContext = null;
            return this;
        }

        Modifier updateBallerinaToml(BallerinaToml ballerinaToml) {
            this.ballerinaTomlContext = ballerinaToml.ballerinaTomlContext();
            this.updatePackageManifest();
            this.updateModules();
            return this;
        }

        Modifier updateDependenciesToml(DependenciesToml dependenciesToml) {
            this.dependenciesTomlContext = dependenciesToml.dependenciesTomlContext();
            this.updateDependencyManifest();
            this.updateModules();
            return this;
        }

        Modifier updateCloudToml(CloudToml cloudToml) {
            this.cloudTomlContext = cloudToml.cloudTomlContext();
            return this;
        }

        Modifier updateCompilerPluginToml(CompilerPluginToml compilerPluginToml) {
            this.compilerPluginTomlContext = compilerPluginToml.compilerPluginTomlContext();
            return this;
        }

        Modifier updateBalToolToml(BalToolToml balToolToml) {
            this.balToolTomlContext = balToolToml.balToolTomlContext();
            return this;
        }

        Modifier updatePackageMd(MdDocumentContext packageMd) {
            this.readmeMdContext = packageMd;
            return this;
        }

        public Package apply() {
            return this.createNewPackage();
        }

        private Map<ModuleId, ModuleContext> copyModules(Package oldPackage) {
            HashMap<ModuleId, ModuleContext> moduleContextMap = new HashMap<ModuleId, ModuleContext>();
            for (ModuleId moduleId : oldPackage.packageContext.moduleIds()) {
                moduleContextMap.put(moduleId, oldPackage.packageContext.moduleContext(moduleId));
            }
            return moduleContextMap;
        }

        private Package createNewPackage() {
            Package oldPackage = this.project.currentPackage();
            PackageResolution oldResolution = oldPackage.getResolution();
            PackageContext newPackageContext = new PackageContext(this.project, this.packageId, this.packageManifest, this.dependencyManifest, this.ballerinaTomlContext, this.dependenciesTomlContext, this.cloudTomlContext, this.compilerPluginTomlContext, this.balToolTomlContext, this.readmeMdContext, this.compilationOptions, this.moduleContextMap, DependencyGraph.emptyGraph(), this.resourceContextMap, this.testResourceContextMap);
            this.project.setCurrentPackage(new Package(newPackageContext, this.project));
            if (Modifier.isOldDependencyGraphValid(oldPackage, this.project.currentPackage())) {
                this.project.currentPackage().packageContext().getResolution(oldResolution);
            } else {
                this.project.compilerPluginContexts().clear();
            }
            CompilationOptions offlineCompOptions = CompilationOptions.builder().setOffline(true).build();
            offlineCompOptions = offlineCompOptions.acceptTheirs(this.project.currentPackage().compilationOptions());
            DependencyGraph<ResolvedPackageDependency> newDepGraph = this.project.currentPackage().packageContext().getResolution(offlineCompOptions, true).dependencyGraph();
            this.cleanPackageCache(this.dependencyGraph, newDepGraph);
            return this.project.currentPackage();
        }

        private static boolean isOldDependencyGraphValid(Package oldPackage, Package currentPackage) {
            Set<String> oldPackageImports = ProjectUtils.getPackageImports(oldPackage);
            Set<String> currentPackageImports = ProjectUtils.getPackageImports(currentPackage);
            String oldDependencyTomlContent = oldPackage.packageContext.dependenciesTomlContext().map(d -> d.tomlDocument().textDocument().toString()).orElse("");
            String currentDependencyTomlContent = currentPackage.packageContext.dependenciesTomlContext().map(d -> d.tomlDocument().textDocument().toString()).orElse("");
            String oldBallerinaTomlContent = oldPackage.packageContext.ballerinaTomlContext().map(d -> d.tomlDocument().textDocument().toString()).orElse("");
            String currentBallerinaTomlContent = currentPackage.packageContext.ballerinaTomlContext().map(d -> d.tomlDocument().textDocument().toString()).orElse("");
            return oldPackageImports.equals(currentPackageImports) && oldDependencyTomlContent.equals(currentDependencyTomlContent) && oldBallerinaTomlContent.equals(currentBallerinaTomlContent);
        }

        private void cleanPackageCache(DependencyGraph<ResolvedPackageDependency> oldGraph, DependencyGraph<ResolvedPackageDependency> newGraph) {
            PackageCache environmentPackageCache = this.project.projectEnvironmentContext().environment().getService(PackageCache.class);
            CompilerContext compilerContext = this.project.projectEnvironmentContext().getService(CompilerContext.class);
            Set<ResolvedPackageDependency> diff = oldGraph.difference(newGraph);
            if (!diff.isEmpty()) {
                for (ResolvedPackageDependency dependency : diff) {
                    environmentPackageCache.removePackage(dependency.packageInstance().packageId());
                    this.deleteCaches(dependency, oldGraph, compilerContext);
                }
            }
            if (!(diff = newGraph.difference(oldGraph)).isEmpty()) {
                for (ResolvedPackageDependency dependency : diff) {
                    for (ResolvedPackageDependency directDependent : newGraph.getDirectDependents(dependency)) {
                        this.deleteCaches(directDependent, newGraph, compilerContext);
                    }
                }
            }
        }

        private void deleteCaches(ResolvedPackageDependency dependency, DependencyGraph<ResolvedPackageDependency> depGraph, CompilerContext compilerContext) {
            if (dependency.equals(depGraph.getRoot())) {
                return;
            }
            org.wso2.ballerinalang.compiler.PackageCache packageCache = org.wso2.ballerinalang.compiler.PackageCache.getInstance(compilerContext);
            for (ModuleId moduleId : dependency.packageInstance().moduleIds()) {
                if (dependency.packageInstance().descriptor().isLangLibPackage()) continue;
                Module module = dependency.packageInstance().module(moduleId);
                PackageID packageID = module.descriptor().moduleCompilationId();
                packageCache.remove(packageID);
                module.moduleContext().setCompilationState(null);
            }
            for (ResolvedPackageDependency directDependent : depGraph.getDirectDependents(dependency)) {
                this.deleteCaches(directDependent, depGraph, compilerContext);
            }
        }

        private void updatePackageManifest() {
            ManifestBuilder manifestBuilder = ManifestBuilder.from(this.ballerinaTomlContext.tomlDocument(), Optional.ofNullable(this.compilerPluginTomlContext).map(TomlDocumentContext::tomlDocument).orElse(null), Optional.ofNullable(this.balToolTomlContext).map(TomlDocumentContext::tomlDocument).orElse(null), this.project.sourceRoot());
            this.packageManifest = manifestBuilder.packageManifest();
            BuildOptions newBuildOptions = manifestBuilder.buildOptions() == null ? BuildOptions.builder().build() : manifestBuilder.buildOptions();
            this.project.setBuildOptions(newBuildOptions.acceptTheirs(this.project.buildOptions()));
        }

        private void updateDependencyManifest() {
            DependencyManifestBuilder manifestBuilder = DependencyManifestBuilder.from(Optional.ofNullable(this.dependenciesTomlContext).map(TomlDocumentContext::tomlDocument).orElse(null), this.project.currentPackage().descriptor());
            this.dependencyManifest = manifestBuilder.dependencyManifest();
        }

        private void updateModules() {
            HashSet<ModuleContext> moduleContextSet = new HashSet<ModuleContext>();
            for (Map.Entry<ModuleId, ModuleContext> moduleIdModuleContextEntry : this.moduleContextMap.entrySet()) {
                ModuleId moduleId = moduleIdModuleContextEntry.getKey();
                ModuleContext oldModuleContext = moduleIdModuleContextEntry.getValue();
                PackageDescriptor packageDescriptor = this.packageManifest.descriptor();
                ModuleName moduleName = ModuleName.from(packageDescriptor.name(), oldModuleContext.moduleName().moduleNamePart());
                ModuleDescriptor moduleDescriptor = ModuleDescriptor.from(moduleName, packageDescriptor);
                LinkedHashMap<DocumentId, DocumentContext> srcDocContextMap = new LinkedHashMap<DocumentId, DocumentContext>();
                for (DocumentId documentId : oldModuleContext.srcDocumentIds()) {
                    srcDocContextMap.put(documentId, oldModuleContext.documentContext(documentId));
                }
                LinkedHashMap<DocumentId, DocumentContext> testDocContextMap = new LinkedHashMap<DocumentId, DocumentContext>();
                for (DocumentId documentId : oldModuleContext.testSrcDocumentIds()) {
                    testDocContextMap.put(documentId, oldModuleContext.documentContext(documentId));
                }
                moduleContextSet.add(new ModuleContext(this.project, moduleId, moduleDescriptor, oldModuleContext.isDefaultModule(), srcDocContextMap, testDocContextMap, oldModuleContext.readmeMdContext().orElse(null), oldModuleContext.moduleDescDependencies()));
                org.wso2.ballerinalang.compiler.PackageCache.getInstance(this.project.projectEnvironmentContext().getService(CompilerContext.class)).remove(oldModuleContext.descriptor().moduleCompilationId());
            }
            this.updateModules(moduleContextSet);
        }

        private Map<DocumentId, ResourceContext> copyResources(Package oldPackage, Collection<DocumentId> documentIds) {
            HashMap<DocumentId, ResourceContext> resourceContextMap = new HashMap<DocumentId, ResourceContext>();
            for (DocumentId documentId : documentIds) {
                resourceContextMap.put(documentId, oldPackage.packageContext.resourceContext(documentId));
            }
            return resourceContextMap;
        }

        public Modifier addResource(ResourceConfig resourceConfig) {
            ResourceContext newResourceContext = ResourceContext.from(resourceConfig);
            this.resourceContextMap.put(newResourceContext.documentId(), newResourceContext);
            return this;
        }

        public Modifier addTestResource(ResourceConfig resourceConfig) {
            ResourceContext newResourceContext = ResourceContext.from(resourceConfig);
            this.testResourceContextMap.put(newResourceContext.documentId(), newResourceContext);
            return this;
        }

        public Modifier removeResource(DocumentId documentId) {
            if (this.resourceContextMap.containsKey(documentId)) {
                this.resourceContextMap.remove(documentId);
            } else {
                this.testResourceContextMap.remove(documentId);
            }
            return this;
        }
    }
}

