/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import java.util.Objects;

public class PackageOrg {
    private final String packageOrgStr;
    private static final String BALLERINA_ORG_NAME = "ballerina";
    private static final String BALLERINA_X_ORG_NAME = "ballerinax";
    public static final PackageOrg BALLERINA_ORG = new PackageOrg("ballerina");
    public static final PackageOrg BALLERINA_X_ORG = new PackageOrg("ballerinax");

    private PackageOrg(String packageOrgStr) {
        this.packageOrgStr = packageOrgStr;
    }

    public static PackageOrg from(String packageNameStr) {
        if (BALLERINA_ORG_NAME.equals(packageNameStr)) {
            return BALLERINA_ORG;
        }
        return new PackageOrg(packageNameStr);
    }

    public String value() {
        return this.packageOrgStr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageOrg that = (PackageOrg)o;
        return this.packageOrgStr.equals(that.packageOrgStr);
    }

    public int hashCode() {
        return Objects.hash(this.packageOrgStr);
    }

    public String toString() {
        return this.packageOrgStr;
    }

    public boolean anonymous() {
        return "$anon".equals(this.packageOrgStr);
    }

    public boolean isBallerinaOrg() {
        return this == BALLERINA_ORG;
    }

    public boolean isBallerinaxOrg() {
        return this == BALLERINA_X_ORG;
    }
}

