/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.CompilationOptions;
import io.ballerina.projects.DependencyGraph;
import io.ballerina.projects.DependencyResolutionType;
import io.ballerina.projects.DiagnosticResult;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleCompilationState;
import io.ballerina.projects.ModuleContext;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageContext;
import io.ballerina.projects.PackageDependencyScope;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.ResolvedPackageDependency;
import io.ballerina.projects.SemanticVersion;
import io.ballerina.projects.environment.ModuleLoadRequest;
import io.ballerina.projects.environment.PackageCache;
import io.ballerina.projects.environment.PackageLockingMode;
import io.ballerina.projects.environment.PackageResolver;
import io.ballerina.projects.environment.ProjectEnvironment;
import io.ballerina.projects.environment.ResolutionOptions;
import io.ballerina.projects.environment.ResolutionRequest;
import io.ballerina.projects.environment.ResolutionResponse;
import io.ballerina.projects.internal.BlendedManifest;
import io.ballerina.projects.internal.DefaultDiagnosticResult;
import io.ballerina.projects.internal.ImportModuleRequest;
import io.ballerina.projects.internal.ImportModuleResponse;
import io.ballerina.projects.internal.ModuleResolver;
import io.ballerina.projects.internal.PackageContainer;
import io.ballerina.projects.internal.PackageDiagnostic;
import io.ballerina.projects.internal.ProjectDiagnosticErrorCode;
import io.ballerina.projects.internal.ResolutionEngine;
import io.ballerina.projects.internal.repositories.CustomPkgRepositoryContainer;
import io.ballerina.projects.internal.repositories.LocalPackageRepository;
import io.ballerina.projects.internal.repositories.MavenPackageRepository;
import io.ballerina.projects.util.ProjectUtils;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.util.RepoUtils;

public class PackageResolution {
    private final PackageContext rootPackageContext;
    private final BlendedManifest blendedManifest;
    private final DependencyGraph<ResolvedPackageDependency> dependencyGraph;
    private final CompilationOptions compilationOptions;
    private final ResolutionOptions resolutionOptions;
    private final PackageResolver packageResolver;
    private final ModuleResolver moduleResolver;
    private final List<Diagnostic> diagnosticList;
    private DiagnosticResult diagnosticResult;
    private boolean autoUpdate;
    private String dependencyGraphDump;
    private List<ModuleContext> topologicallySortedModuleList;
    private Collection<ResolvedPackageDependency> dependenciesWithTransitives;
    private static final Boolean isWindows = System.getProperty("os.name").toLowerCase(Locale.getDefault()).contains("win");

    private PackageResolution(PackageContext rootPackageContext, CompilationOptions compilationOptions) {
        this.rootPackageContext = rootPackageContext;
        this.diagnosticList = new ArrayList<Diagnostic>();
        this.compilationOptions = compilationOptions;
        this.resolutionOptions = this.getResolutionOptions(rootPackageContext, compilationOptions);
        ProjectEnvironment projectEnvContext = rootPackageContext.project().projectEnvironmentContext();
        this.packageResolver = projectEnvContext.getService(PackageResolver.class);
        this.blendedManifest = this.createBlendedManifest(rootPackageContext, projectEnvContext, this.resolutionOptions.offline());
        this.diagnosticList.addAll(this.blendedManifest.diagnosticResult().allDiagnostics);
        this.moduleResolver = this.createModuleResolver(rootPackageContext, projectEnvContext);
        this.dependencyGraph = this.buildDependencyGraph();
        DependencyResolution dependencyResolution = new DependencyResolution(projectEnvContext.getService(PackageCache.class), this.moduleResolver, this.dependencyGraph);
        this.resolveDependencies(dependencyResolution);
        if (compilationOptions.optimizeDependencyCompilation()) {
            this.generateCaches();
        }
    }

    private void generateCaches() {
        ResolvedPackageDependency resolvedPackageDependency;
        Package packageInstance;
        PackageDescriptor packageDescriptor;
        Iterator<ResolvedPackageDependency> iterator = this.dependencyGraph.toTopologicallySortedList().iterator();
        while (iterator.hasNext() && (packageDescriptor = (packageInstance = (resolvedPackageDependency = iterator.next()).packageInstance()).descriptor()) != this.rootPackageContext.descriptor()) {
            if (packageInstance.getDefaultModule().moduleContext().currentCompilationState() != ModuleCompilationState.LOADED_FROM_SOURCES) continue;
            ArrayList<String> cmdArgs = new ArrayList<String>();
            String balExecutable = isWindows != false ? "bal.bat" : "bal";
            cmdArgs.add(Paths.get(System.getProperty("ballerina.home"), "bin", balExecutable).toString());
            cmdArgs.add("pull");
            cmdArgs.add("--sticky=" + this.resolutionOptions.sticky());
            cmdArgs.add("--offline=" + this.resolutionOptions.offline());
            Optional<BlendedManifest.Dependency> dependency = this.blendedManifest.userSpecifiedDependency(packageDescriptor.org(), packageDescriptor.name());
            if (dependency.isPresent() && dependency.get().repository() != null) {
                cmdArgs.add("--repository=" + dependency.get().repository());
            }
            cmdArgs.add(packageDescriptor.toString());
            ProcessBuilder processBuilder = new ProcessBuilder(cmdArgs);
            try {
                Process process = processBuilder.start();
                int i = process.waitFor();
                if (i != 0) {
                    Object errMessage = packageDescriptor.toString();
                    if (dependency.isPresent()) {
                        errMessage = (String)errMessage + " [repository=" + dependency.get().repository() + "]";
                    }
                    throw new ProjectException("failed to compile " + (String)errMessage);
                }
            }
            catch (IOException | InterruptedException e) {
                throw new ProjectException(e);
            }
            for (ModuleId moduleId : packageInstance.moduleIds()) {
                packageInstance.module(moduleId).moduleContext().setCompilationState(ModuleCompilationState.LOADED_FROM_CACHE);
            }
        }
    }

    private PackageResolution(PackageResolution packageResolution, PackageContext rootPackageContext, CompilationOptions compilationOptions) {
        this.rootPackageContext = rootPackageContext;
        this.diagnosticList = new ArrayList<Diagnostic>();
        this.compilationOptions = compilationOptions;
        this.resolutionOptions = this.getResolutionOptions(rootPackageContext, compilationOptions);
        ProjectEnvironment projectEnvContext = rootPackageContext.project().projectEnvironmentContext();
        this.packageResolver = projectEnvContext.getService(PackageResolver.class);
        this.blendedManifest = this.createBlendedManifest(rootPackageContext, projectEnvContext, this.resolutionOptions.offline());
        this.diagnosticList.addAll(this.blendedManifest.diagnosticResult().allDiagnostics);
        this.moduleResolver = this.createModuleResolver(rootPackageContext, projectEnvContext);
        LinkedHashSet<ModuleLoadRequest> moduleLoadRequests = this.getModuleLoadRequestsOfDirectDependencies();
        this.moduleResolver.resolveModuleLoadRequests(moduleLoadRequests);
        this.dependencyGraph = this.cloneDependencyGraphNewRoot(packageResolution.dependencyGraph, rootPackageContext.project().currentPackage());
        this.dependencyGraphDump = packageResolution.dependencyGraphDump;
        DependencyResolution dependencyResolution = new DependencyResolution(projectEnvContext.getService(PackageCache.class), this.moduleResolver, this.dependencyGraph);
        this.resolveDependencies(dependencyResolution);
    }

    private DependencyGraph<ResolvedPackageDependency> cloneDependencyGraphNewRoot(DependencyGraph<ResolvedPackageDependency> depGraph, Package rootPackage) {
        ResolvedPackageDependency oldRoot = depGraph.getRoot();
        ResolvedPackageDependency newRoot = new ResolvedPackageDependency(rootPackage, oldRoot.scope(), oldRoot.dependencyResolvedType());
        DependencyGraph.DependencyGraphBuilder<ResolvedPackageDependency> depGraphBuilder = DependencyGraph.DependencyGraphBuilder.getBuilder(newRoot);
        for (ResolvedPackageDependency depNode : depGraph.getNodes()) {
            if (depNode == oldRoot) {
                depGraphBuilder.add(newRoot);
            } else {
                depGraphBuilder.add(depNode);
            }
            List directPkgDependencies = depGraph.getDirectDependencies(depNode).stream().map(directDepNode -> directDepNode == oldRoot ? newRoot : directDepNode).collect(Collectors.toList());
            depGraphBuilder.addDependencies(depNode, directPkgDependencies);
        }
        return depGraphBuilder.build();
    }

    static PackageResolution from(PackageContext rootPackageContext, CompilationOptions compilationOptions) {
        return new PackageResolution(rootPackageContext, compilationOptions);
    }

    static PackageResolution from(PackageResolution packageResolution, PackageContext packageContext, CompilationOptions compilationOptions) {
        return new PackageResolution(packageResolution, packageContext, compilationOptions);
    }

    public DependencyGraph<ResolvedPackageDependency> dependencyGraph() {
        return this.dependencyGraph;
    }

    public Collection<ResolvedPackageDependency> allDependencies() {
        if (this.dependenciesWithTransitives != null) {
            return this.dependenciesWithTransitives;
        }
        this.dependenciesWithTransitives = this.dependencyGraph.toTopologicallySortedList().stream().filter(resolvedPkg -> resolvedPkg.packageId() != this.rootPackageContext.packageId()).toList();
        return this.dependenciesWithTransitives;
    }

    public void dumpGraphs(PrintStream printStream) {
        printStream.append(this.dependencyGraphDump);
    }

    PackageContext packageContext() {
        return this.rootPackageContext;
    }

    List<ModuleContext> topologicallySortedModuleList() {
        return this.topologicallySortedModuleList;
    }

    public DiagnosticResult diagnosticResult() {
        if (this.diagnosticResult == null) {
            this.diagnosticResult = new DefaultDiagnosticResult(this.diagnosticList);
        }
        return this.diagnosticResult;
    }

    void reportDiagnostic(String message, String diagnosticErrorCode, DiagnosticSeverity severity, Location location, ModuleDescriptor moduleDescriptor) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(diagnosticErrorCode, message, severity);
        Diagnostic diagnostic = DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)location, (Object[])new Object[0]);
        PackageDiagnostic packageDiagnostic = new PackageDiagnostic(diagnostic, moduleDescriptor, this.rootPackageContext.project());
        this.diagnosticList.add(packageDiagnostic);
        this.diagnosticResult = new DefaultDiagnosticResult(this.diagnosticList);
    }

    public boolean autoUpdate() {
        return this.autoUpdate;
    }

    private DependencyGraph<ResolvedPackageDependency> buildDependencyGraph() {
        if (this.rootPackageContext.project().kind() == ProjectKind.BALA_PROJECT && this.resolutionOptions.sticky()) {
            return this.resolveBALADependencies();
        }
        return this.resolveSourceDependencies();
    }

    private LinkedHashSet<ModuleLoadRequest> getModuleLoadRequestsOfDirectDependencies() {
        String moduleName;
        ModuleContext moduleContext;
        ModuleContext.OverwritableLinkedHashSet allModuleLoadRequests = new ModuleContext.OverwritableLinkedHashSet();
        for (ModuleId moduleId : this.rootPackageContext.moduleIds()) {
            moduleContext = this.rootPackageContext.moduleContext(moduleId);
            allModuleLoadRequests.addAll(moduleContext.populateModuleLoadRequests());
        }
        for (ModuleId moduleId : this.rootPackageContext.moduleIds()) {
            moduleContext = this.rootPackageContext.moduleContext(moduleId);
            allModuleLoadRequests.addAll(moduleContext.populateTestSrcModuleLoadRequests());
        }
        if (this.compilationOptions.observabilityIncluded()) {
            moduleName = Names.OBSERVE.getValue();
            ModuleLoadRequest observeModuleLoadReq = new ModuleLoadRequest(PackageOrg.from(Names.BALLERINA_INTERNAL_ORG.value), moduleName, PackageDependencyScope.DEFAULT, DependencyResolutionType.PLATFORM_PROVIDED);
            ((HashSet)allModuleLoadRequests).add(observeModuleLoadReq);
        }
        if ("k8s".equals(this.compilationOptions.getCloud()) || "docker".equals(this.compilationOptions.getCloud()) || "choreo".equals(this.compilationOptions.getCloud())) {
            moduleName = Names.CLOUD.getValue();
            ModuleLoadRequest c2cModuleLoadReq = new ModuleLoadRequest(PackageOrg.from(Names.BALLERINA_ORG.value), moduleName, PackageDependencyScope.DEFAULT, DependencyResolutionType.COMPILER_PLUGIN);
            ((HashSet)allModuleLoadRequests).add(c2cModuleLoadReq);
        }
        return allModuleLoadRequests;
    }

    private DependencyGraph<ResolvedPackageDependency> resolveBALADependencies() {
        DependencyGraph<ResolutionEngine.DependencyNode> dependencyNodeGraph = this.createDependencyNodeGraph(this.rootPackageContext.dependencyGraph());
        return this.buildPackageGraph(dependencyNodeGraph, this.rootPackageContext.project().currentPackage(), this.packageResolver);
    }

    private DependencyGraph<ResolvedPackageDependency> resolveSourceDependencies() {
        LinkedHashSet<ModuleLoadRequest> moduleLoadRequests = this.getModuleLoadRequestsOfDirectDependencies();
        ResolutionEngine resolutionEngine = new ResolutionEngine(this.rootPackageContext.descriptor(), this.blendedManifest, this.packageResolver, this.moduleResolver, this.resolutionOptions);
        DependencyGraph<ResolutionEngine.DependencyNode> dependencyNodeGraph = resolutionEngine.resolveDependencies(moduleLoadRequests);
        this.dependencyGraphDump = resolutionEngine.dumpGraphs();
        this.diagnosticList.addAll(resolutionEngine.diagnosticResult().allDiagnostics);
        return this.buildPackageGraph(dependencyNodeGraph, this.rootPackageContext.project().currentPackage(), this.packageResolver);
    }

    static Optional<ModuleContext> findModuleInPackage(PackageContext resolvedPackage, String moduleNameStr) {
        ModuleName moduleName;
        PackageName packageName = resolvedPackage.packageName();
        if (packageName.value().equals(moduleNameStr)) {
            moduleName = ModuleName.from(packageName);
        } else {
            String moduleNamePart = moduleNameStr.substring(packageName.value().length() + 1);
            if (moduleNamePart.isEmpty()) {
                moduleNamePart = null;
            }
            moduleName = ModuleName.from(packageName, moduleNamePart);
        }
        ModuleContext resolvedModule = resolvedPackage.moduleContext(moduleName);
        if (resolvedModule == null) {
            return Optional.empty();
        }
        return Optional.of(resolvedModule);
    }

    private DependencyGraph<ResolvedPackageDependency> buildPackageGraph(DependencyGraph<ResolutionEngine.DependencyNode> depGraph, Package rootPackage, PackageResolver packageResolver) {
        ResolvedPackageDependency resolvedPkg;
        PackageContainer<ResolvedPackageDependency> resolvedPkgContainer = new PackageContainer<ResolvedPackageDependency>();
        ResolutionEngine.DependencyNode rootNode = depGraph.getRoot();
        ResolvedPackageDependency rootResolvedPackage = new ResolvedPackageDependency(rootPackage, rootNode.scope(), rootNode.resolutionType());
        resolvedPkgContainer.add(rootNode.pkgDesc().org(), rootNode.pkgDesc().name(), rootResolvedPackage);
        List<ResolutionRequest> resolutionRequests = depGraph.getNodes().stream().filter(depNode -> !depNode.equals(rootNode) && !depNode.errorNode()).map(this::createFromDepNode).toList();
        Collection<ResolutionResponse> resolutionResponses = packageResolver.resolvePackages(resolutionRequests, this.resolutionOptions);
        for (ResolutionResponse resolutionResp : resolutionResponses) {
            if (!resolutionResp.resolutionStatus().equals((Object)ResolutionResponse.ResolutionStatus.RESOLVED)) continue;
            PackageDescriptor pkgDesc = resolutionResp.resolvedPackage().packageContext().packageManifest().descriptor();
            if (Optional.ofNullable(pkgDesc.getDeprecated()).orElse(false).booleanValue()) {
                this.addDeprecationDiagnostic(pkgDesc);
            }
            ResolutionRequest resolutionReq = resolutionResp.resolutionRequest();
            resolvedPkg = new ResolvedPackageDependency(resolutionResp.resolvedPackage(), resolutionReq.scope(), resolutionReq.resolutionType());
            resolvedPkgContainer.add(pkgDesc.org(), pkgDesc.name(), resolvedPkg);
        }
        DependencyGraph.DependencyGraphBuilder<ResolvedPackageDependency> depGraphBuilder = DependencyGraph.DependencyGraphBuilder.getBuilder(rootResolvedPackage);
        for (ResolutionEngine.DependencyNode depNode2 : depGraph.getNodes()) {
            Optional resolvedPkgOptional = resolvedPkgContainer.get(depNode2.pkgDesc().org(), depNode2.pkgDesc().name());
            if (!resolvedPkgOptional.isPresent()) continue;
            resolvedPkg = (ResolvedPackageDependency)resolvedPkgOptional.get();
            depGraphBuilder.add(resolvedPkg);
            List directPkgDependencies = depGraph.getDirectDependencies(depNode2).stream().map(directDepNode -> resolvedPkgContainer.get(directDepNode.pkgDesc().org(), directDepNode.pkgDesc().name())).flatMap(Optional::stream).toList();
            depGraphBuilder.addDependencies(resolvedPkg, directPkgDependencies);
        }
        return depGraphBuilder.build();
    }

    private void addDeprecationDiagnostic(PackageDescriptor pkgDesc) {
        String deprecationMsg = Optional.ofNullable(pkgDesc.getDeprecationMsg()).orElse("");
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(ProjectDiagnosticErrorCode.DEPRECATED_PACKAGE.diagnosticId(), pkgDesc.toString() + " is deprecated: " + deprecationMsg, DiagnosticSeverity.WARNING);
        PackageDiagnostic diagnostic = new PackageDiagnostic(diagnosticInfo, this.rootPackageContext.descriptor().name().toString());
        this.diagnosticList.add(diagnostic);
    }

    private ResolutionRequest createFromDepNode(ResolutionEngine.DependencyNode depNode) {
        return ResolutionRequest.from(depNode.pkgDesc(), depNode.scope(), depNode.resolutionType(), this.resolutionOptions.packageLockingMode());
    }

    private DependencyGraph<ResolutionEngine.DependencyNode> createDependencyNodeGraph(DependencyGraph<PackageDescriptor> pkgDescDepGraph) {
        ResolutionEngine.DependencyNode rootNode = new ResolutionEngine.DependencyNode(this.rootPackageContext.descriptor());
        DependencyGraph.DependencyGraphBuilder<ResolutionEngine.DependencyNode> graphBuilder = DependencyGraph.DependencyGraphBuilder.getBuilder(rootNode);
        for (PackageDescriptor pkgDesc : pkgDescDepGraph.getNodes()) {
            ResolutionEngine.DependencyNode dependencyNode = new ResolutionEngine.DependencyNode(pkgDesc);
            graphBuilder.add(dependencyNode);
            for (PackageDescriptor directDepPkgDesc : pkgDescDepGraph.getDirectDependencies(pkgDesc)) {
                graphBuilder.addDependency(dependencyNode, new ResolutionEngine.DependencyNode(directDepPkgDesc));
            }
        }
        return graphBuilder.build();
    }

    private void resolveDependencies(DependencyResolution dependencyResolution) {
        ArrayList<ModuleContext> sortedModuleList = new ArrayList<ModuleContext>();
        List<ResolvedPackageDependency> sortedPackages = this.dependencyGraph.toTopologicallySortedList();
        if (!this.dependencyGraph.findCycles().isEmpty()) {
            for (List list : this.dependencyGraph.findCycles()) {
                DiagnosticInfo diagnosticInfo = new DiagnosticInfo(DiagnosticErrorCode.CYCLIC_MODULE_IMPORTS_DETECTED.diagnosticId(), "cyclic module imports detected ''" + list.stream().map(dependency -> dependency.packageInstance().descriptor().toString()).collect(Collectors.joining(" -> ")) + "''", DiagnosticErrorCode.CYCLIC_MODULE_IMPORTS_DETECTED.severity());
                PackageDiagnostic diagnostic = new PackageDiagnostic(diagnosticInfo, this.rootPackageContext.descriptor().name().toString());
                this.diagnosticList.add(diagnostic);
            }
        }
        for (ResolvedPackageDependency resolvedPackageDependency : sortedPackages) {
            Package resolvedPackage = resolvedPackageDependency.packageInstance();
            resolvedPackage.packageContext().resolveDependencies(dependencyResolution);
            DependencyGraph<ModuleDescriptor> moduleDependencyGraph = resolvedPackage.moduleDependencyGraph();
            List<ModuleDescriptor> sortedModuleDescriptors = moduleDependencyGraph.toTopologicallySortedList();
            if (!moduleDependencyGraph.findCycles().isEmpty()) {
                for (List list : moduleDependencyGraph.findCycles()) {
                    DiagnosticInfo diagnosticInfo = new DiagnosticInfo(DiagnosticErrorCode.CYCLIC_MODULE_IMPORTS_DETECTED.diagnosticId(), "cyclic module imports detected ''" + list.stream().map(desc -> desc.org().toString() + "/" + desc.name().toString() + ":" + desc.version().toString()).collect(Collectors.joining(" -> ")) + "''", DiagnosticErrorCode.CYCLIC_MODULE_IMPORTS_DETECTED.severity());
                    PackageDiagnostic diagnostic = new PackageDiagnostic(diagnosticInfo, resolvedPackage.descriptor().name().toString());
                    this.diagnosticList.add(diagnostic);
                }
            }
            for (ModuleDescriptor moduleDescriptor : sortedModuleDescriptors) {
                ModuleContext moduleContext = resolvedPackage.module(moduleDescriptor.name()).moduleContext();
                sortedModuleList.add(moduleContext);
            }
        }
        this.topologicallySortedModuleList = Collections.unmodifiableList(sortedModuleList);
    }

    private ModuleResolver createModuleResolver(PackageContext rootPackageContext, ProjectEnvironment projectEnvContext) {
        List<ModuleName> moduleNames = rootPackageContext.moduleIds().stream().map(rootPackageContext::moduleContext).map(ModuleContext::moduleName).toList();
        return new ModuleResolver(rootPackageContext.descriptor(), moduleNames, this.blendedManifest, projectEnvContext.getService(PackageResolver.class), this.resolutionOptions);
    }

    private BlendedManifest createBlendedManifest(PackageContext rootPackageContext, ProjectEnvironment projectEnvContext, boolean offline) {
        Map<String, MavenPackageRepository> customPackageRepositoryMap = projectEnvContext.getService(CustomPkgRepositoryContainer.class).getCustomPackageRepositories();
        return BlendedManifest.from(rootPackageContext.dependencyManifest(), rootPackageContext.packageManifest(), projectEnvContext.getService(LocalPackageRepository.class), customPackageRepositoryMap, offline);
    }

    private ResolutionOptions getResolutionOptions(PackageContext rootPackageContext, CompilationOptions compilationOptions) {
        PackageLockingMode packageLockingMode;
        boolean sticky = ProjectUtils.getSticky(rootPackageContext.project());
        this.autoUpdate = !sticky;
        SemanticVersion prevDistributionVersion = rootPackageContext.dependencyManifest().distributionVersion();
        SemanticVersion currentDistributionVersion = SemanticVersion.from(RepoUtils.getBallerinaShortVersion());
        if ("soft".equals(rootPackageContext.project().buildOptions().compilationOptions().lockingMode())) {
            packageLockingMode = PackageLockingMode.SOFT;
            sticky = false;
        } else if (rootPackageContext.dependenciesTomlContext().isPresent()) {
            if (prevDistributionVersion == null) {
                this.addOlderSLUpdateDistributionDiagnostic(null, currentDistributionVersion);
                packageLockingMode = !sticky ? PackageLockingMode.SOFT : PackageLockingMode.MEDIUM;
            } else {
                boolean newUpdateDistribution = this.isNewUpdateDistribution(prevDistributionVersion, currentDistributionVersion);
                if (newUpdateDistribution) {
                    this.addOlderSLUpdateDistributionDiagnostic(prevDistributionVersion, currentDistributionVersion);
                    packageLockingMode = PackageLockingMode.SOFT;
                } else {
                    packageLockingMode = PackageLockingMode.MEDIUM;
                }
            }
        } else {
            packageLockingMode = !sticky ? PackageLockingMode.SOFT : PackageLockingMode.MEDIUM;
        }
        return ResolutionOptions.builder().setOffline(compilationOptions.offlineBuild()).setSticky(sticky).setDumpGraph(compilationOptions.dumpGraph()).setDumpRawGraphs(compilationOptions.dumpRawGraphs()).setPackageLockingMode(packageLockingMode).build();
    }

    private boolean isNewUpdateDistribution(SemanticVersion prevDistributionVersion, SemanticVersion currentDistributionVersion) {
        return currentDistributionVersion.major() == prevDistributionVersion.major() && currentDistributionVersion.minor() > prevDistributionVersion.minor();
    }

    private void addOlderSLUpdateDistributionDiagnostic(SemanticVersion prevDistributionVersion, SemanticVersion currentDistributionVersion) {
        Object prevVersionForDiagnostic;
        Object currentVersionForDiagnostic = String.valueOf(currentDistributionVersion.minor());
        if (currentDistributionVersion.patch() != 0) {
            currentVersionForDiagnostic = (String)currentVersionForDiagnostic + "." + currentDistributionVersion.patch();
        }
        if (null != prevDistributionVersion) {
            prevVersionForDiagnostic = String.valueOf(prevDistributionVersion.minor());
            if (prevDistributionVersion.patch() != 0) {
                prevVersionForDiagnostic = (String)prevVersionForDiagnostic + "." + prevDistributionVersion.patch();
            }
        } else {
            prevVersionForDiagnostic = "4 or an older Update";
        }
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(ProjectDiagnosticErrorCode.BUILT_WITH_OLDER_SL_UPDATE_DISTRIBUTION.diagnosticId(), "Detected an attempt to compile this package using Swan Lake Update " + (String)currentVersionForDiagnostic + ". However, this package was built using Swan Lake Update " + (String)prevVersionForDiagnostic + ". To ensure compatibility, execute `bal build` with Swan Lake Update " + (String)currentVersionForDiagnostic + " to update the dependencies with the latest compatible versions.", DiagnosticSeverity.WARNING);
        PackageDiagnostic diagnostic = new PackageDiagnostic(diagnosticInfo, this.rootPackageContext.descriptor().name().toString());
        this.diagnosticList.add(diagnostic);
    }

    static class DependencyResolution {
        private final PackageCache delegate;
        private final ModuleResolver moduleResolver;
        private final DependencyGraph<ResolvedPackageDependency> dependencyGraph;

        private DependencyResolution(PackageCache delegate, ModuleResolver moduleResolver, DependencyGraph<ResolvedPackageDependency> dependencyGraph) {
            this.delegate = delegate;
            this.moduleResolver = moduleResolver;
            this.dependencyGraph = dependencyGraph;
        }

        public Optional<Package> getPackage(PackageOrg packageOrg, PackageName packageName) {
            List<Package> resolvedPackages = this.delegate.getPackages(packageOrg, packageName);
            for (Package resolvedPackage : resolvedPackages) {
                if (!this.containsPackage(resolvedPackage)) continue;
                return Optional.of(resolvedPackage);
            }
            return Optional.empty();
        }

        public Optional<Module> getModule(PackageOrg packageOrg, PackageName packageName, ModuleName moduleName) {
            Optional<Package> resolvedPkg = this.getPackage(packageOrg, packageName);
            if (resolvedPkg.isEmpty()) {
                return Optional.empty();
            }
            Module resolvedModule = resolvedPkg.get().module(moduleName);
            if (resolvedModule == null) {
                return Optional.empty();
            }
            return Optional.of(resolvedModule);
        }

        public Optional<ModuleContext> getModule(PackageOrg packageOrg, String moduleNameStr) {
            ImportModuleRequest importModuleRequest = new ImportModuleRequest(packageOrg, moduleNameStr);
            ImportModuleResponse importModuleResponse = this.moduleResolver.getImportModuleResponse(importModuleRequest);
            if (importModuleResponse == null) {
                return Optional.empty();
            }
            PackageName packageName = importModuleResponse.packageDescriptor().name();
            Optional<Package> optionalPackage = this.getPackage(packageOrg, packageName);
            if (optionalPackage.isEmpty()) {
                return Optional.empty();
            }
            return PackageResolution.findModuleInPackage(optionalPackage.get().packageContext(), moduleNameStr);
        }

        private boolean containsPackage(Package pkg) {
            for (ResolvedPackageDependency graphNode : this.dependencyGraph.getNodes()) {
                if (graphNode.packageId() != pkg.packageId()) continue;
                return true;
            }
            return false;
        }
    }
}

