/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.DocumentId;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ResourceConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

class ResourceContext {
    private final DocumentId documentId;
    private final String name;
    private byte[] content;
    private final Path path;

    ResourceContext(DocumentId documentId, String name, byte[] content, Path path) {
        this.documentId = documentId;
        this.name = name;
        this.content = content;
        this.path = path;
    }

    static ResourceContext from(ResourceConfig documentConfig) {
        return new ResourceContext(documentConfig.documentId(), documentConfig.name(), documentConfig.content(), documentConfig.path());
    }

    String name() {
        return this.name;
    }

    byte[] content() {
        if (this.content == null) {
            try {
                this.content = Files.readAllBytes(this.path);
            }
            catch (IOException e) {
                throw new ProjectException("unable to read the resource file: " + String.valueOf(this.path), e);
            }
        }
        return this.content;
    }

    DocumentId documentId() {
        return this.documentId;
    }
}

