/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.CompilerPluginInfo;
import io.ballerina.projects.CompilerPluginKind;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageProvidedCompilerPluginInfo;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import java.util.Collection;

class SyntaxNodeAnalysisTask {
    private final AnalysisTask<SyntaxNodeAnalysisContext> analysisTask;
    private final Collection<SyntaxKind> syntaxKinds;
    private final CompilerPluginInfo compilerPluginInfo;

    SyntaxNodeAnalysisTask(AnalysisTask<SyntaxNodeAnalysisContext> analysisTask, Collection<SyntaxKind> syntaxKinds, CompilerPluginInfo compilerPluginInfo) {
        this.analysisTask = analysisTask;
        this.syntaxKinds = syntaxKinds;
        this.compilerPluginInfo = compilerPluginInfo;
    }

    void perform(SyntaxNodeAnalysisContext syntaxNodeAnalysisContext) {
        try {
            this.analysisTask.perform(syntaxNodeAnalysisContext);
        }
        catch (Throwable e) {
            String message;
            if (this.compilerPluginInfo.kind().equals((Object)CompilerPluginKind.PACKAGE_PROVIDED)) {
                PackageProvidedCompilerPluginInfo pkgProvidedCompilerPluginInfo = (PackageProvidedCompilerPluginInfo)this.compilerPluginInfo;
                PackageDescriptor pkgDesc = pkgProvidedCompilerPluginInfo.packageDesc();
                message = "The compiler extension in package '" + String.valueOf(pkgDesc.org()) + ":" + String.valueOf(pkgDesc.name()) + ":" + String.valueOf(pkgDesc.version()) + "' failed to complete. ";
            } else {
                message = "The compiler extension '" + this.compilerPluginInfo.compilerPlugin().getClass().getName() + "' failed to complete. ";
            }
            throw new ProjectException(message + e.getMessage(), e);
        }
    }

    Collection<SyntaxKind> syntaxKinds() {
        return this.syntaxKinds;
    }

    CompilerPluginInfo getCompilerPluginInfo() {
        return this.compilerPluginInfo;
    }
}

